#include <windows.h>
#include <bsp.h>
#include "oal.h"

#include <fmd.h>

#include <loader.h>
#include <bsp_args.h>
#include <delay.h>

#include "menu.h"
#include "Image_cfg.h"
#include "Pmplatform.h"


#include "dbgserial.h"


#include "drvmsg.h"

#include "fmd_LB.h"


#include "nand.h"


volatile GPIO_REG *g_VGPIOReg=NULL;


int EbootEnterSleep(DWORD dwSleepTime, BOOL bEbootChargingMode);

#define LCD_DELAY_1MS_BK    30000          // Sufficient under 1Ghz
#define SPI_DELAY_BK        100            // Sufficient under 1Ghz

MENU_ITEM m_menuGPIOTest[];
MENU_ITEM m_menuClockTest[];
MENU_ITEM m_menuPMICTest[];
MENU_ITEM m_menuBKLTest[];
MENU_ITEM m_menuLCDTest[];

void DelayLoop_spi_BK(int delay)
{
	volatile int j;
	for(j = 0; j < SPI_DELAY_BK*delay; j++)  ;
}

#define TEST_DRAM_VBASE      0x80020000
#define TEST_DRAM_VEND       0x87700000
#define TEST_DRAM_VSIZE      (TEST_DRAM_VEND - TEST_DRAM_VBASE)




static int MenuHandlerDRAMTest(void *arg)
{
    volatile UINT32 *bank_addr_start;
    UINT32 count;
    UINT32 fail = 0;
    UINT32 size = 0;

    bank_addr_start = 0;

    // check detail or not, and change to small char.

    
    size = TEST_DRAM_VSIZE/4;
    bank_addr_start = (UINT32 *)TEST_DRAM_VBASE;

    // reset as zero
    fail = 0;
	EdbgOutputDebugString("write zero to 0x%x\r\n", bank_addr_start);
    for (count = 0; count < size; count++)
    {
        *(bank_addr_start+count) = 0;
    }
    for (count = 0; count < size; count++)
    {
        if ( *(bank_addr_start+count) != 0 )
        {
            fail++;
            	EdbgOutputDebugString("err at 0x%x\r\n", *(bank_addr_start+count));
        }
    }
    if (fail)
    {
    	EdbgOutputDebugString("initial error 0x%x %d error\r\n", bank_addr_start, fail);
    }
    // reset as 0xFFFFFFFF
    fail = 0;
    EdbgOutputDebugString("write 0xFFFFFFFF to 0x%x\r\n", bank_addr_start);
    for (count = 0; count < size; count++)
    {
        *(bank_addr_start+count) = 0xFFFFFFFF;
    }
    for (count = 0; count < size; count++)
    {
        if ( *(bank_addr_start+count) != 0xFFFFFFFF )
        {
            fail++;
            	EdbgOutputDebugString("err at 0x%x\r\n", *(bank_addr_start+count));
        }
    }
    if (fail)
    {
    	EdbgOutputDebugString("initial error 0x%x %d error\r\n", bank_addr_start, fail);
    }


    // write data to each bank
    fail = 0;
	EdbgOutputDebugString("write data as each offset to 0x%x ~ 0x%x\r\n",
                            bank_addr_start, (UINT32)(bank_addr_start+size-1));
    for (count = 0; count < size; count++)
    {
        *(bank_addr_start+count) = count*sizeof(bank_addr_start);
    }
    // verify each bank
	EdbgOutputDebugString("verify data at 0x%x\r\n", bank_addr_start);
    for (count = 0; count < size; count++)
    {
        if ( *(bank_addr_start+count) != count*sizeof(bank_addr_start) )
        {
            fail++;
            	EdbgOutputDebugString("0x%x != 0x%x\r\n",
            	                      *(bank_addr_start+count),
            	                      count*sizeof(count));
        }
    }

    if (fail)
    {
    	EdbgOutputDebugString("0x%x %d error\r\n", bank_addr_start, fail);
    }
    else
    {
    	EdbgOutputDebugString("no error\r\n");
    }
    
	return 2;
}



void LDI_BKL_RGB_write(WORD data)
{
/*
    int j;

   g_VGPIOReg = (volatile GPIO_REG *)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
   
    LCD_nCS_HI_BK();
    LCD_SCL_LO_BK();

    DelayLoop_spi_BK(1);

    LCD_nCS_LO_BK();
    DelayLoop_spi_BK(1);

    //data write
    for (j = 15; j >= 0; j--)
    {
        LCD_SCL_LO_BK();

       if((0x01<<j) & data)
        {
           LCD_SDA_HI_BK();
        }
        else
        {
            LCD_SDA_LO_BK();
        }
        DelayLoop_spi_BK(1);
        LCD_SCL_HI_BK();
        DelayLoop_spi_BK(1);
    }

    LCD_SCL_LO_BK();
    DelayLoop_spi_BK(10);	

    LCD_nCS_HI_BK();	
    DelayLoop_spi_BK(1);
*/
}


static int MenuHandlerbkl_Test(void *arg)
{
/*
//,r.g,b gamma table
	LDI_BKL_RGB_write(0x7039);
	LDI_BKL_RGB_write(0x7211);
	LDI_BKL_RGB_write(0x7040);
	LDI_BKL_RGB_write( 0x720A);
	LDI_BKL_RGB_write(0x7041);
	LDI_BKL_RGB_write(0x7200);
	LDI_BKL_RGB_write(0x7042);
	LDI_BKL_RGB_write(0x7218);
	LDI_BKL_RGB_write(0x7043);
	LDI_BKL_RGB_write(0x7214);
	LDI_BKL_RGB_write(0x7044);
	LDI_BKL_RGB_write(0x721d);
	LDI_BKL_RGB_write(0x7045);
	LDI_BKL_RGB_write(0x7219);   //00
	LDI_BKL_RGB_write(0x7046);
	LDI_BKL_RGB_write(0x7226); //00//00:24BIT, 01:16BIT

	LDI_BKL_RGB_write(0x7050); //
	LDI_BKL_RGB_write(0x720a);
	LDI_BKL_RGB_write(0x7051);
	LDI_BKL_RGB_write(0x7200);
	LDI_BKL_RGB_write(0x7052);
	LDI_BKL_RGB_write(0x7200);
	LDI_BKL_RGB_write(0x7053);
	LDI_BKL_RGB_write(0x720f);
	LDI_BKL_RGB_write(0x7054);
	LDI_BKL_RGB_write(0x721d);
	LDI_BKL_RGB_write(0x7055); //
	LDI_BKL_RGB_write(0x721a);
	LDI_BKL_RGB_write(0x7056);
	LDI_BKL_RGB_write(0x7225);
	
	LDI_BKL_RGB_write(0x7060);
	LDI_BKL_RGB_write(0x720a);
	LDI_BKL_RGB_write(0x7061);
	LDI_BKL_RGB_write(0x7200);
	LDI_BKL_RGB_write(0x7062);
	LDI_BKL_RGB_write(0x721a);
	LDI_BKL_RGB_write(0x7063); //
	LDI_BKL_RGB_write(0x7212);
	LDI_BKL_RGB_write(0x7064);
	LDI_BKL_RGB_write(0x7221);
	LDI_BKL_RGB_write(0x7065);
	LDI_BKL_RGB_write(0x7215);
	LDI_BKL_RGB_write(0x7066);
	LDI_BKL_RGB_write(0x7236);
	
	RETAILMSG(1, (L"LDI_BKL_Brightness_level  by min01.oh \r\n"));
*/
	return 0;
}


////////////////////////////////////////////////////////////
///////////////LCD TEST IS added BY MIN01.OH 2008.11.24///////
static int MenuHandlerLCD_Test(void *arg)
{
/*
    
		int i,j;
		unsigned short *pFB;
		unsigned short set = (int) arg;
		unsigned short *temp;
		pFB = (unsigned short *)IMAGE_DISPLAY_BUFFER_UA;
//W|R
//B|G
	RETAILMSG(1, (L"MenuHandlerLCD_Test  by min01.oh \r\n"));
    switch(set)
    	{
    	case 1:
		temp = 0x07E0;
		break;
	case 2:
		temp= 0xf800;
		break;
	case 3:
		 temp =0x001f;
		break;
	case 4:
		temp=0xffff;
		break;
	case 5:
		temp=0x0000;
		break;	
	default:
		break;
	}
	for (i=0; i<LCD_HEIGHT; i++)
	{
		for (j=0; j<LCD_WIDTH; j++)
		{
			*pFB++ = temp;	// Green				
		}
	 }
*/
return 0;

}

static int MenuTimer_Test(void *arg)
{
    
	UINT16 InChar = 0;
	UINT32 mSec = SEC_TO_MSEC, time = 0;

	while(1)
	{
		//Get battery value
		EdbgOutputDebugString("Time is %ds('q' = Quit)\r\n", (time /SEC_TO_MSEC));	
		OALWaitUsec(200);
                OALWaitUsec(200);
		OALWaitUsec(200);
                OALWaitUsec(200);
		OALWaitUsec(200);
                OALWaitUsec(200);
		OALWaitUsec(200);
                OALWaitUsec(200);
		OALWaitUsec(200);
                OALWaitUsec(200);
		time += mSec;
		InChar=OEMReadDebugByte();
		if((InChar=='Q')||(InChar=='q'))
			break;
	}	

	return 0;
}


#ifndef SDMMC_BOOT
static int MenuNAND_Test(void *arg)
{
	BYTE pbMain[2048];
	BYTE pbSpare[64];

	BYTE pbMainWrite[2048];
	BYTE pbSpareWrite[64];
	
	int i, j;
	
	SectorInfo siWrite;
	SectorInfo siRead;

	UCHAR ucInput;

	DWORD dwSector;

	
	memset(g_DrvMsgMask, 0xFF, sizeof(g_DrvMsgMask));


	RETAILMSG(1, (TEXT("FMD_Init() = %X\r\n"), FMD_Init(NULL, NULL, NULL)));


	
	j = 0;
	for(i = 0;i < 2048;i++)
	{
		pbMainWrite[i] = (j++)*i / 3;
	}

	for(i = 0;i < 64;i++)
	{
		pbSpareWrite[i] = 63 - i;
	}
		
	//memset(pbMainWrite, 0x5A, 2048);
	//memset(pbSpareWrite, 0x39, 64);

	siWrite.dwReserved1 = 0x12345678;
	siWrite.bOEMReserved = 0xFC;
	siWrite.bBadBlock = 0xFF;
	siWrite.wReserved2 = 0x5A;
		


	while(1)
	{
		RETAILMSG(1, (TEXT("1] RAW READ a sector\r\n")));
		RETAILMSG(1, (TEXT("2] FMD READ a sector\r\n")));
		RETAILMSG(1, (TEXT("3] FMD WRITE a sector\r\n")));
		RETAILMSG(1, (TEXT("E] ECC test\r\n")));
		RETAILMSG(1, (TEXT("X] Exit\r\n")));
		
		do
		{
			ucInput = OEMReadDebugByte();
		}
		while
		(
			ucInput != '1' && ucInput != '2' && ucInput != '3' &&
			(ucInput != 'x' && ucInput != 'X') &&
			(ucInput != 'E' && ucInput != 'e')
		);
		
		
		switch(ucInput)
		{
			case '1':
			{
				RETAILMSG(1, (TEXT("sector = ")));

				dwSector = OEMReadNumber(FALSE);
				RETAILMSG(1, (TEXT("Sector number = %d\r\n"), dwSector));


				if(RAW_LB_ReadSector(dwSector, pbMain, pbSpare) == FALSE)
				{
					RETAILMSG(1, (TEXT("Failed to RAW_LB_ReadSector\r\n")));
				}
				else
				{
					RETAILMSG(1, (TEXT("--------------------- MAIN ---------------------\r\n")));
					
					for(i = 1;i <= 2048;i++)
					{
						//EdbgOutputDebugString("%X ", pbMain[i - 1]);
						RETAILMSG(1, (TEXT("%02X "), pbMain[i - 1]));
			
						if((i % 0x10) == 0)
						{
							RETAILMSG(1, (TEXT("\r\n")));
						}
					}
			
					RETAILMSG(1, (TEXT("--------------------- SPARE ---------------------\r\n")));
					for(i = 1;i <= 64;i++)
					{
						RETAILMSG(1, (TEXT("%02X "), pbSpare[i - 1]));
			
						if((i % 0x10) == 0)
						{
							RETAILMSG(1, (TEXT("\r\n")));
						}
					}
				}

				break;
			}

			case '2':
			{
				RETAILMSG(1, (TEXT("sector = ")));

				dwSector = OEMReadNumber(FALSE);
				RETAILMSG(1, (TEXT("Sector number = %d\r\n"), dwSector));


				if(FMD_LB_ReadSector(dwSector, pbMain, &siRead, 1) == FALSE)
				{
					RETAILMSG(1, (TEXT("Failed to FMD_LB_ReadSector\r\n")));
				}
				else
				{
					RETAILMSG(1, (TEXT("--------------------- MAIN ---------------------\r\n")));
					
					for(i = 1;i <= 2048;i++)
					{
						RETAILMSG(1, (TEXT("%02X "), pbMain[i - 1]));
			
						if((i % 0x10) == 0)
						{
							RETAILMSG(1, (TEXT("\r\n")));
						}
					}
			
					RETAILMSG(1, (TEXT("--------------------- SPARE ---------------------\r\n")));
					RETAILMSG(1, (TEXT("dwReserved1 = 0x%X\r\n"), siRead.dwReserved1));
					RETAILMSG(1, (TEXT("bOEMReserved = 0x%X\r\n"), siRead.bOEMReserved));
					RETAILMSG(1, (TEXT("bBadBlock = 0x%X\r\n"), siRead.bBadBlock));
					RETAILMSG(1, (TEXT("wReserved2 = 0x%X\r\n"), siRead.wReserved2));					}			

				break;
			}

			case '3':
			{
				RETAILMSG(1, (TEXT("sector = ")));

				dwSector = OEMReadNumber(FALSE);
				RETAILMSG(1, (TEXT("Sector number = %d\r\n"), dwSector));


				if(FMD_WriteSector(dwSector, pbMainWrite, &siWrite, 1) == FALSE)
				{
					RETAILMSG(1, (TEXT("Failed to FMD_WriteSector\r\n")));
				}
				else
				{
					RETAILMSG(1, (TEXT("Write success\r\n")));
				}


				break;
			}			

			case 'E':
			case 'e':
			{
				volatile NAND_REG *v_pNFCONregs = (NAND_REG *)0xB9400000;
				volatile NAND_ECC_REG *v_pECCregs = (NAND_ECC_REG *)0xB9420000;

				DWORD dwECC1ErrorResult;
				DWORD dwECC1MainErrorNo;
				DWORD dwECC1MainErrorByte;
				DWORD dwECC1MainErrorBit;				
				
				DWORD dwECC8[4];
				DWORD dwECC8ErrorNo;
				DWORD dwECC8ErrorByte[8];
				DWORD dwECC8ErrorBit[8];

				DWORD dwECC1;
				
				BYTE pbData[100];

				int i;

				memset(pbData, 0x5A, 100);
				
				RETAILMSG(1, (TEXT("ECC8 encode\r\n")));
				
				NF_ECC8_SETUP(10);
				NF_ECC8_ENCODE();

				NF_MECC_UnLock();
				

				for(i = 0;i < 10;i++)
				{
					NF_WRDATA_BYTE(pbData[i]);
				}		

				NF_MECC_Lock();


				NF_ECC8_WAIT_ENCODE_DONE();
				NF_ECC8_CLEAR_DONE();
				
				dwECC8[0] = (v_pECCregs->NFECCPRGECC0);
				dwECC8[1] = (v_pECCregs->NFECCPRGECC1);
				dwECC8[2] = (v_pECCregs->NFECCPRGECC2);
				dwECC8[3] = (v_pECCregs->NFECCPRGECC3);
	
				// -- write done

				RETAILMSG(1, (TEXT("ECC8 decode\r\n")));
				
				NF_ECC8_SETUP(10);
				NF_ECC8_DECODE();

				NF_MECC_UnLock();

				pbData[0] = 0x47;
				pbData[4] = 0x1B;
				for(i = 0;i < 10;i++)
				{
					NF_WRDATA_BYTE(pbData[i]);
				}				

				NF_WRDATA_WORD(dwECC8[0]);
				NF_WRDATA_WORD(dwECC8[1]);
				NF_WRDATA_WORD(dwECC8[2]);
				NF_WRDATA_BYTE(dwECC8[3]);
	
				NF_MECC_Lock();

				NF_ECC8_WAIT_DECODE_DONE();
				NF_ECC8_CLEAR_DONE();



				dwECC8ErrorNo = NF_ECC8_ERROR();
				
				if(dwECC8ErrorNo == 0)
				{
					RETAILMSG(1, (TEXT("[SPARE] No ECC error : sector %d\r\n"), dwSector));
				}
				else if(dwECC8ErrorNo <= 8)
				{
					RETAILMSG(1, (TEXT("[SPARE] Correctable ECC error : sector %d\r\n"), dwSector));
							
					dwECC8ErrorByte[0] = (v_pECCregs->NFECCERL0 >> 0) & 0x3FF;
					dwECC8ErrorByte[1] = (v_pECCregs->NFECCERL0 >> 16) & 0x3FF;
					dwECC8ErrorByte[2] = (v_pECCregs->NFECCERL1 >> 0) & 0x3FF;
					dwECC8ErrorByte[3] = (v_pECCregs->NFECCERL1 >> 16) & 0x3FF;
					dwECC8ErrorByte[4] = (v_pECCregs->NFECCERL2 >> 0) & 0x3FF;
					dwECC8ErrorByte[5] = (v_pECCregs->NFECCERL2 >> 16) & 0x3FF;
					dwECC8ErrorByte[6] = (v_pECCregs->NFECCERL3 >> 0) & 0x3FF;
					dwECC8ErrorByte[7] = (v_pECCregs->NFECCERL3 >> 16) & 0x3FF;
				
					dwECC8ErrorBit[0] = (v_pECCregs->NFECCERP0 >> 0) & 0xFF;
					dwECC8ErrorBit[1] = (v_pECCregs->NFECCERP0 >> 8) & 0xFF;
					dwECC8ErrorBit[2] = (v_pECCregs->NFECCERP0 >> 16) & 0xFF;
					dwECC8ErrorBit[3] = (v_pECCregs->NFECCERP0 >> 24) & 0xFF;
					dwECC8ErrorBit[4] = (v_pECCregs->NFECCERP1 >> 0) & 0xFF;
					dwECC8ErrorBit[5] = (v_pECCregs->NFECCERP1 >> 8) & 0xFF;
					dwECC8ErrorBit[6] = (v_pECCregs->NFECCERP1 >> 16) & 0xFF;
					dwECC8ErrorBit[7] = (v_pECCregs->NFECCERP1 >> 24) & 0xFF;

					for(i = 0;i < dwECC8ErrorNo;i++)
					{
						RETAILMSG(1, (TEXT("%d  %d\r\n"), dwECC8ErrorByte[i], dwECC8ErrorBit[i]));
					}

					for(i = 0;i < dwECC8ErrorNo;i++)
					{
						pbData[dwECC8ErrorByte[i]] ^= dwECC8ErrorBit[i];
					}
				}
				else
				{
					RETAILMSG(1, (TEXT("[SPARE] Uncorrectable ECC error : sector %d\r\n"), dwSector));
				}


				for(i = 0;i < 10;i++)
				{
					RETAILMSG(1, (TEXT("%02X "), pbData[i]));
				}
				RETAILMSG(1, (TEXT("\r\n")));

				// ---- 1bit
				NF_ECC1_SETUP();
				NF_RSTECC();

				NF_MECC_UnLock();
				
				for(i = 0;i < 10;i++)
				{
					NF_WRDATA_BYTE(pbData[i]);
				}		

				NF_MECC_Lock();

				dwECC1 = NF_RDMECC0();




				// -- 1bit decode
				NF_RSTECC();

				NF_MECC_UnLock();

				pbData[1] = 0x5B;
				for(i = 0;i < 10;i++)
				{
					NF_WRDATA_BYTE(pbData[i]);
				}

				NF_MECC_Lock();
						

			    NF_WRMECCD0((((dwECC1 >> 8) & 0xFF) << 16) | (dwECC1 & 0xff));
			    NF_WRMECCD1((((dwECC1 >> 24) & 0xFF) << 16) | (dwECC1 >> 16) & 0xFF);
	

				dwECC1ErrorResult = NF_ECC_ERR0;

				dwECC1MainErrorNo = dwECC1ErrorResult & 0x3;
				dwECC1MainErrorByte = (dwECC1ErrorResult >> 7) & 0x7FF;
				dwECC1MainErrorBit = (dwECC1ErrorResult >> 4) & 0x7;

				switch(dwECC1MainErrorNo)
				{
					case 0:
						RETAILMSG(1, (TEXT("[MAIN] No ECC error : sector %d\r\n"), dwSector));
						break;

					case 1:
						RETAILMSG(1, (TEXT("[MAIN] Correctable ECC error : sector %d\r\n"), dwSector));
						pbData[dwECC1MainErrorByte] ^= (1 << dwECC1MainErrorBit);
						break;

					case 2:
						RETAILMSG(1, (TEXT("[MAIN] Uncorrectable ECC error : sector %d\r\n"), dwSector));
						break;

					case 3:
						RETAILMSG(1, (TEXT("[MAIN] Uncorrectable ECC area error : sector %d\r\n"), dwSector));
						break;
				}
			

				for(i = 0;i < 10;i++)
				{
					RETAILMSG(1, (TEXT("%02X "), pbData[i]));
				}
				RETAILMSG(1, (TEXT("\r\n")));

				break;
			}

				
			case 'X':
			case 'x':
				return TRUE;
				break;
		
		}
	}					

}
#endif

MENU_ITEM m_menuBKLTest[] =
{
	{ '1', "BACKLIGHT TEST", NULL,MenuHandlerbkl_Test ,NULL, NULL, NULL,NULL},
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuLCDTest[] =
{
	{ '1', "LCD TEST_GREEN!", NULL,MenuHandlerLCD_Test ,NULL, NULL, NULL, (void *)1},
	{ '2', "LCD TEST_RED!", NULL,MenuHandlerLCD_Test ,NULL, NULL, NULL, (void *)2},
	{ '3', "LCD TEST_BLUE!", NULL,MenuHandlerLCD_Test ,NULL, NULL, NULL, (void *)3},
	{ '4', "LCD TEST_WHITE!", NULL,MenuHandlerLCD_Test ,NULL, NULL, NULL, (void *)4},
	{ '5', "LCD TEST_BLACK!", NULL,MenuHandlerLCD_Test ,NULL, NULL, NULL, (void *)5},
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

/// MicroUSB Test		hyosun	2008.12.23
int MicroUSB_Test(void *args)
{
/*
	unsigned char WordAddr[3]={0x02,0x03,0x01};
	unsigned char Data9480=0;
	unsigned char DataAddr[4]={0x1E,0x02,0x4A,0x1A};
	BYTE control_write = 0x00;
	BYTE control_read = 0x00;
	BYTE device_type = 0x00;
	BYTE interrupt_read = 0x00;
	BYTE interrupt_mask_read = 0x00;

	BOOL Jack_INTR_gpio_level = FALSE;

	EdbgOutputDebugString ( "\r\n[MicroUSB_Test] Init()\r\n");

	g_VGPIOReg = (volatile GPIO_REG *)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);

	Set_PinFunction(g_VGPIOReg, JACK_nINT);
	Set_PinPullUD(g_VGPIOReg, JACK_nINT, sgip_PULL_UP);



 	I2C_EMUL_Init(MICROUSB_GROUP, (PVOID)g_VGPIOReg, (PVOID)g_pBSPArgs, MICROUSB_FSA9480_SLAVEADDR, 200);
	control_write = 0x1E;
	
    	I2C_EMUL_Write(MICROUSB_GROUP, WordAddr[0],control_write);
    	I2C_EMUL_Read(MICROUSB_GROUP, WordAddr[0],&control_read);
    	EdbgOutputDebugString("[MicroUSB_Test] 0x02 = 0x%x\r\n", control_read);

	msWait(100);


	I2C_EMUL_Read(MICROUSB_GROUP, WordAddr[1],&control_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x03 = 0x%x\r\n", control_read);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_Interrupt2, &interrupt_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x04 = 0x%x\r\n", interrupt_read);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_InterruptMask1, &interrupt_mask_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x05 = 0x%x\r\n", interrupt_mask_read);

	
	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_InterruptMask2, &interrupt_mask_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x06 = 0x%x\r\n", interrupt_mask_read);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_ADC, &interrupt_mask_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x07 = 0x%x\r\n", interrupt_mask_read);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_TimingSet1, &interrupt_mask_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x08 = 0x%x\r\n", interrupt_mask_read);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_TimingSet2, &interrupt_mask_read);
	EdbgOutputDebugString("[MicroUSB_Test] 0x09 = 0x%x\r\n", interrupt_mask_read);


	
	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_DeviceType1, &device_type);
	// check Device Type	
	switch(device_type)
	{
		case MICROUSB_AudioType1:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A Audio Type 1 Detected\r\n");
			break;
			
		case MICROUSB_AudioType2:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A Audio Type 2 Detected\r\n");
			break;
			
		case MICROUSB_USB:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A USB Detected\r\n");
			break;
			
		case MICROUSB_UART:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A UART Detected\r\n");
			break;
			
		case MICROUSB_Carkit:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A Car Kit Detected\r\n");
			break;
			
		case MICROUSB_USBCharger:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A USB Charger Detected\r\n");
			break;
			
		case MICROUSB_DedicatedCharger:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A Dedicated Charger Detected\r\n");
			break;
			
		case MICROUSB_USBOTG:
			EdbgOutputDebugString ("[MicroUSB_Test] 0x0A USB OTG Detected\r\n");
			break;
	}

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_DeviceType2, &device_type);
	EdbgOutputDebugString("[MicroUSB_Test] 0x0B = 0x%x\r\n", device_type);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_CarKitInt1, &device_type);
	EdbgOutputDebugString("[MicroUSB_Test] 0x0F = 0x%x\r\n", device_type);

	msWait(100);
	I2C_EMUL_Read(MICROUSB_GROUP, MICROUSB_CarKitInt2, &device_type);
	EdbgOutputDebugString("[MicroUSB_Test] 0x10 = 0x%x\r\n", device_type);
*/
	return 0;
}
///

DWORD GetReadDECSerial()
{
	DWORD getValue = 0;
/*
	int InChar, cntChar = 0;

	while(1)
{
		InChar=OEMReadDebugByte();
		if(InChar != -1)
		{
			if((InChar >= '0') && (InChar <= '9'))
			{
				EdbgOutputDebugString("%c", InChar);
				getValue = (getValue*10) + (InChar - '0');
				cntChar++;
}
			else if(InChar == 0x08)
{
				OEMWriteDebugByte((BYTE)0x08);
				getValue /= 10;
				cntChar--;			
			}
			else if((InChar == 0x0D)&&(cntChar > 0))
	{		
				EdbgOutputDebugString("\r\n");
			break;
	}	
}
	}
*/
	return getValue;
}

/////////////////////////////  Power Management Test /////////////////////////////////
static int MenuHandlerSleepWakeupTest(void *args)
{ 
/*
	EdbgOutputDebugString ("** Sleep test!! (Press PWR button to wake up) **\r\n");	
	EbootEnterSleep(0, FALSE);

	//Re-Init Display
	InitDisplay();
*/
    return 0;        
}

void MenuTitleSetDeepIdle(void *arg)
{
/*
	EdbgOutputDebugString("Deep Idle Top Block On : (%s)", (g_EbootCFG.bDeepIdleTopOn== TRUE? "Yes":"No"));
*/
}

int MenuSetDeepIdle(void *arg)
{
/*
    g_EbootCFG.bDeepIdleTopOn = g_pBSPArgs->bDeepIdleTopOn = !g_EbootCFG.bDeepIdleTopOn;
    StoreEBootCFG(&g_EbootCFG);
*/
    return 0;
}
static int MenuDeepIdleTest(void *args)
{
/*
    EdbgOutputDebugString ("** Deep Idle !! (Press PWR button to wake up) **\r\n");
    EdbgOutputDebugString("Deep Idle Top Block On : (%s)", (g_EbootCFG.bDeepIdleTopOn== TRUE? "Yes":"No"));

    EbootEnterDeepIdle(g_pBSPArgs->bDeepIdleTopOn);
    //Re-Init Display
    InitDisplay();
*/
    return 0;
}

static int MenuHandlerIdleTest(void *args)
{
/*
	volatile GPIO_REG *pGPIOReg;
	volatile VIC_REG *pINTRReg;
    	volatile SYSCON_PM_REG *pSysConPMReg;
    	pGPIOReg = (volatile GPIO_REG *)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
    	pINTRReg = (volatile VIC_REG *)OALPAtoVA(BASE_REG_PA_VIC0, FALSE);
    	pSysConPMReg     = (SYSCON_PM_REG *)OALPAtoVA(BASE_REG_PA_SYSCON_PM, FALSE);		

//	EdbgOutputDebugString ("++VIC0INTENABLE = 0x%X, VIC0INTSELECT = 0x%X, VIC0INTENCLEAR = 0x%X\r\n"
//		, pINTRReg->VICINTENABLE, pINTRReg->VICINTSELECT, pINTRReg->VICINTENCLEAR);	

	//Setting for WEINT of PowerButton
	SetMaskWEINT(pGPIOReg, nPOWER_WEINT, 1);
	SetConWEINT(pGPIOReg, nPOWER_WEINT, FALLING_EDGE);
	ClearPendWEINT(pGPIOReg, nPOWER_WEINT);
	SetMaskWEINT(pGPIOReg, nPOWER_WEINT, 0);
	
#if(BSP_HW_ID >=4)
	//temp
	SetConWEINT(pGPIOReg, DET_35_WEINT, RISING_EDGE);
	ClearPendWEINT(pGPIOReg, DET_35_WEINT);
#endif
	
	//Enable for Interrupt of PowerButton
    	pINTRReg->VICINTENABLE |= (1<<PHYIRQ_EINT16_31);
	pINTRReg->VICINTENABLE |= (1<<PHYIRQ_BATF);
	pSysConPMReg->PWR_CFG |= (1 << 3);

//	EdbgOutputDebugString ("--VIC0INTENABLE = 0x%X, VIC0INTSELECT = 0x%X, VIC0INTENCLEAR = 0x%X\r\n"
//		, pINTRReg->VICINTENABLE, pINTRReg->VICINTSELECT, pINTRReg->VICINTENCLEAR);	
	
	//Turn off LCD
	Charging_DisplayDeinit();

	//enter Idle mode
	EdbgOutputDebugString ("\r\n** Idle Mode test!! (Press PWR button to wake up) **\r\n");	
	System_WaitForInterrupt();
	EdbgOutputDebugString ("\r\n** Exit Idle Mode !!\r\n");	

	//Disable for Interrupt of PowerButton
	pINTRReg->VICINTENCLEAR |= (1<<PHYIRQ_EINT16_31);
	pINTRReg->VICINTENCLEAR |= (1<<PHYIRQ_BATF);
	pSysConPMReg->PWR_CFG &= ~(1 << 3);

	//Re-Init Display
	InitDisplay();
*/
    return 0;        
}


const char * powerBlockList[5] = {"MFC", "G3D", "LCD", "TV", "AUDIO"};	
void MenuTitlePowerOnOff(void *arg)
{
/*
	volatile SYSCON_PM_REG *pSysConPMReg = (SYSCON_PM_REG*)OALPAtoVA(BASE_REG_PA_SYSCON_PM, FALSE);
	
	BYTE bitOffset = (BYTE) arg;
	if(bitOffset == 6)
		EdbgOutputDebugString("Power Block Value[0x%x], Status[0x%x] ", (pSysConPMReg->NORMAL_CFG & 0x3F), pSysConPMReg->BLK_PWR_STAT);		
	else
		EdbgOutputDebugString("On/Off %s Power Block: (%s)", powerBlockList[bitOffset-1], ((pSysConPMReg->NORMAL_CFG) & (0x1<<bitOffset))?"On":"Off");
*/
}


int MenuControlPowerOnOff(void *arg)
{
/*
	volatile SYSCON_PM_REG *pSysConPMReg = (SYSCON_PM_REG*)OALPAtoVA(BASE_REG_PA_SYSCON_PM, FALSE);

	BYTE bitOffset = (BYTE) arg;

	if(pSysConPMReg->NORMAL_CFG & (0x1<<bitOffset))
		pSysConPMReg->NORMAL_CFG &= ~(0x1<<bitOffset);
	else
		pSysConPMReg->NORMAL_CFG |= (0x1<<bitOffset);
*/			
	return 0;        
}
			

void MenuTitleDVFSLevel(void *arg)
{
//	EdbgOutputDebugString("DVFS Level is (%s)", DVFSLevelList[g_currentDVFSLevel]);
}


void MenuTitleChangeDVFSLevel(void *arg)
{
/*
	int selectedDVFSLevel = (int) arg;
	EdbgOutputDebugString("Set DVFS %s", DVFSLevelList[selectedDVFSLevel]);
*/
}


int MenuChangeDVFSLevel(void *arg)
{
/*
	int newDVFSLevel = (int) arg;

	ChangePowerLevel(newDVFSLevel, TRUE);
	g_currentDVFSLevel = newDVFSLevel;
	EdbgOutputDebugString("Set DVFS Level => %s\r\n", DVFSLevelList[g_currentDVFSLevel]);
*/
	return 0;        
}


int MenuTestDVFSLevel(void *arg)
{
/*
	int InChar;
	BOOL bDownDVFSLevel = TRUE;
	
	EdbgOutputDebugString("Repeat DVFS level('q' = Quit)\r\n");	
	while(1)
	{		
		if(g_currentDVFSLevel == SYS_L0)
		{
			g_currentDVFSLevel = SYS_L3;
		}
		else if(g_currentDVFSLevel == SYS_L3)
		{
			g_currentDVFSLevel = SYS_L0;
		}		

		EdbgOutputDebugString("Test to change %s\r\n", DVFSLevelList[g_currentDVFSLevel]);
		ChangePowerLevel(g_currentDVFSLevel, TRUE);
		OALWaitUsec(10);

		InChar=OEMReadDebugByte();
		if((InChar=='Q')||(InChar=='q'))
			break;			
	}	
*/
    return 0;        
}


void MenuEnterDVFSLevel(void *arg)
{
/*
	volatile GPIO_REG *pGPIOReg = (GPIO_REG*)OALPAtoVA(BASE_REG_PA_IOPORT, FALSE);
        I2C_EMUL_Init(PMIC_GROUP, (PVOID)pGPIOReg, (PVOID)g_pBSPArgs, PMIC_SLAVE_ADDR, 200);
	
	ChangePowerLevel(SYS_L0, TRUE);
	g_currentDVFSLevel = SYS_L0;
*/
}


void MenuTitleUSBPowerTest(void *arg)
{
/*
	volatile SYSCON_PM_REG *pSYS_PMReg = (SYSCON_PM_REG*)OALPAtoVA(BASE_REG_PA_SYSCON_PM, FALSE);
	volatile OTG_PHY_REG *pUSBOTGReg = (OTG_PHY_REG*)OALPAtoVA(BASE_REG_PA_USBOTG_PHY, FALSE);

	int para = (int)arg;
	switch(para)
	{
		case 0:
			EdbgOutputDebugString("On/Off USB_PHY_EN : (%s)", (pSYS_PMReg->OTHERS&(0x1<<16))? "On":"Off");
			break;
		case 1:
			EdbgOutputDebugString("On/Off OTG Block Power : (%s)", (pUSBOTGReg->OPHYPWR&(0x1<<4))? "Off":"On");
			break;
		case 2:
			EdbgOutputDebugString("On/Off Analog Block Power : (%s)", (pUSBOTGReg->OPHYPWR&(0x1<<3))? "Off":"On");
			break;
		case 3:
			EdbgOutputDebugString("Force Suspend Signal : (%s)", (pUSBOTGReg->OPHYPWR&(0x1<<0))? "En":"Dis");
			break;
	}
*/
}


int MenuUSBPowerTest(void *arg)
{
/*
	volatile SYSCON_PM_REG *pSYS_PMReg = (SYSCON_PM_REG*)OALPAtoVA(BASE_REG_PA_SYSCON_PM, FALSE);
	volatile OTG_PHY_REG *pUSBOTGReg = (OTG_PHY_REG*)OALPAtoVA(BASE_REG_PA_USBOTG_PHY, FALSE);

	int para = (int)arg;
	switch(para)
	{
		case 0:
			EdbgOutputDebugString("pSYS_PMReg->OTHERS = 0x%X", pSYS_PMReg->OTHERS);
			if(pSYS_PMReg->OTHERS & (1<<16))
				pSYS_PMReg->OTHERS &= ~(1<<16);
			else
				pSYS_PMReg->OTHERS |= (1<<16);
			EdbgOutputDebugString(" => 0x%X\r\n", pSYS_PMReg->OTHERS);
			break;
		case 1:
			EdbgOutputDebugString("pUSBOTGReg->OPHYPWR = 0x%X", pUSBOTGReg->OPHYPWR);
			if(pUSBOTGReg->OPHYPWR & (1<<4))
				pUSBOTGReg->OPHYPWR &= ~(1<<4);
			else
				pUSBOTGReg->OPHYPWR |= (1<<4);
			EdbgOutputDebugString(" => 0x%X\r\n", pUSBOTGReg->OPHYPWR);
			break;
		case 2:
			EdbgOutputDebugString("pUSBOTGReg->OPHYPWR = 0x%X", pUSBOTGReg->OPHYPWR);
			if(pUSBOTGReg->OPHYPWR & (1<<3))
				pUSBOTGReg->OPHYPWR &= ~(1<<3);
			else
				pUSBOTGReg->OPHYPWR |= (1<<3);
			EdbgOutputDebugString(" => 0x%X\r\n", pUSBOTGReg->OPHYPWR);
			break;
		case 3:
			EdbgOutputDebugString("pUSBOTGReg->OPHYPWR = 0x%X", pUSBOTGReg->OPHYPWR);
			if(pUSBOTGReg->OPHYPWR & (1<<0))
				pUSBOTGReg->OPHYPWR &= ~(1<<0);
			else
				pUSBOTGReg->OPHYPWR |= (1<<0);
			EdbgOutputDebugString(" => 0x%X\r\n", pUSBOTGReg->OPHYPWR);
			break;
	}
*/
	return 0;
}


int USBInitTest(void *arg)
{
/*
	int para = (int)arg;
	if(para ==1)
		USBInit();
	else
		USBDeInit();
*/
	return 0;
}


void MenuTitleDumpPower_Sleep(void *arg)
{
//	EdbgOutputDebugString("Display Power Value before Sleep : (%s)", (g_EbootCFG.bEnableDumpPower== TRUE? "Yes":"No"));
}


int MenuDumpPower_Sleep(void *arg)
{
/*
	g_EbootCFG.bEnableDumpPower = g_pBSPArgs->bEnableDumpPower = !g_EbootCFG.bEnableDumpPower;
	StoreEBootCFG(&g_EbootCFG);
*/
	return 0;
}


void MenuTitleSetPowerSave(void *arg)
{
//	EdbgOutputDebugString("Set Temporary Power-Save Mode : (%s)", (g_pBSPArgs->bTempPowerSaveMode == TRUE? "Yes":"No"));
}


int MenuSetPowerSave(void *arg)
{
//	g_pBSPArgs->bTempPowerSaveMode = !g_pBSPArgs->bTempPowerSaveMode;
	return 0;
}
///////////////////////////// End of Power Management Test /////////////////////////////////


///////////////////////////// Aging Test /////////////////////////////////
void MenuTitleEnableAgingTest(void *arg)
{
/*
	int para = (int)arg;

	switch(para)
	{
		case 0:
			EdbgOutputDebugString("Enable Power On/Off Test : (%s)", (g_EbootCFG.bEnableOnOffTest == TRUE? "Yes":"No"));
			break;
		case 1:
			EdbgOutputDebugString("Enable Sleep/Wakeup Test : (%s)", (g_EbootCFG.bEnableSleepWakeupTest == TRUE? "Yes":"No"));
			break;
	}
*/
}


int MenuEnableAgingTest(void *arg)
{
/*
	int para = (int)arg;
	switch(para)
	{
		case 0:
			g_EbootCFG.bEnableOnOffTest = g_pBSPArgs->bEnableOnOffTest = !g_EbootCFG.bEnableOnOffTest;
			break;
		case 1:
			g_EbootCFG.bEnableSleepWakeupTest = g_pBSPArgs->bEnableSleepWakeupTest = !g_EbootCFG.bEnableSleepWakeupTest;
			break;
	}
	StoreEBootCFG(&g_EbootCFG);
*/
	return 0;
}
///////////////////////////// End of Aging Test /////////////////////////////////

int JustTest(void *arg)
{
/*
	volatile SYSCON_PM_REG *pSYS_PMReg = (SYSCON_PM_REG*)OALPAtoVA(BASE_REG_PA_GPIO, FALSE);
	volatile OTG_PHY_REG *pUSBOTGReg = (OTG_PHY_REG*)OALPAtoVA(BASE_REG_PA_USBOTG_PHY, FALSE);

	EdbgOutputDebugString("+pUSBOTGReg->OPHYPWR = 0x%X[0x%X]\r\n", pUSBOTGReg->OPHYPWR, pSYS_PMReg);
	if(pUSBOTGReg->OPHYPWR == 0)
	{
		EdbgOutputDebugString("USB is Enabled, so Disable\r\n");
		pUSBOTGReg->OPHYPWR |= (0x19);
	}
	else
	{
		EdbgOutputDebugString("USB is Disabled, so Enable\r\n");
		pUSBOTGReg->OPHYPWR = 0x0;
	}
	EdbgOutputDebugString("-pUSBOTGReg->OPHYPWR = 0x%X[0x%X]\r\n", pUSBOTGReg->OPHYPWR, pUSBOTGReg);
*/
	return 0;

}

MENU_ITEM m_menuPowerBlockTest[] =
{	
	{ ' ', "Power Block Value ", MenuTitlePowerOnOff, NULL, NULL, NULL, NULL, (void *)6},
	{ '0', "On/Off MFC Power Block", MenuTitlePowerOnOff, MenuControlPowerOnOff, NULL, NULL, NULL, (void *)1},
	{ '1', "On/Off G3D Power Block", MenuTitlePowerOnOff, MenuControlPowerOnOff, NULL, NULL, NULL, (void *)2},
	{ '2', "On/Off LCD Power Block", MenuTitlePowerOnOff, MenuControlPowerOnOff, NULL, NULL, NULL, (void *)3},
	{ '3', "On/Off TV Power Block", MenuTitlePowerOnOff, MenuControlPowerOnOff, NULL, NULL, NULL, (void *)4},
	{ '4', "On/Off AUDIO Power Block", MenuTitlePowerOnOff, MenuControlPowerOnOff, NULL, NULL, NULL, (void *)5},

	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuDVFSTest[] =
{	
	{ ' ', "DVFS Level is", MenuTitleDVFSLevel, NULL, NULL, NULL, NULL, NULL},
	{ '0', "Set DVFS SYS_L0", MenuTitleChangeDVFSLevel, MenuChangeDVFSLevel, NULL, NULL, NULL, (void *)0},
	{ '1', "Set DVFS SYS_L1", MenuTitleChangeDVFSLevel, MenuChangeDVFSLevel, NULL, NULL, NULL, (void *)1},
	{ '2', "Set DVFS SYS_L2", MenuTitleChangeDVFSLevel, MenuChangeDVFSLevel, NULL, NULL, NULL, (void *)2},
	{ '3', "Set DVFS SYS_L3", MenuTitleChangeDVFSLevel, MenuChangeDVFSLevel, NULL, NULL, NULL, (void *)3},
	{ 'T', "Test to repeat DVFS Level", NULL, MenuTestDVFSLevel, NULL, NULL, NULL, NULL},
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuUSBPowerTest[] =
{	
	{ '0', "On/Off USB_PHY_EN", MenuTitleUSBPowerTest, MenuUSBPowerTest, NULL, NULL, NULL, (void *)0},
	{ '1', "On/Off OTG Block Power", MenuTitleUSBPowerTest, MenuUSBPowerTest, NULL, NULL, NULL, (void *)1},
	{ '2', "On/Off Analog Block Power", MenuTitleUSBPowerTest, MenuUSBPowerTest, NULL, NULL, NULL, (void *)2},
	{ '3', "Force Suspend Signal", MenuTitleUSBPowerTest, MenuUSBPowerTest, NULL, NULL, NULL, (void *)3},
	{ '4', "USB Init", NULL, USBInitTest, NULL, NULL, NULL, (void *)1},
	{ '5', "USB DeInit", NULL, USBInitTest, NULL, NULL, NULL, (void *)0},
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuPowerManTest[] =
{	
//	{ 'M', "PMIC(MAX8698) Test", NULL, NULL, m_menuPMICTest, NULL, NULL, NULL},
   	{ 'M', "PMIC(MAX8698) Test", NULL, NULL, NULL, NULL, NULL, NULL},
	{ 'P', "Power Block Test", NULL, NULL, m_menuPowerBlockTest, NULL, NULL, NULL},
//	{ 'C', "Clock Gating Test", NULL, NULL, m_menuClockTest, NULL, NULL, NULL},
    { 'C', "Clock Gating Test", NULL, NULL, NULL, NULL, NULL, NULL},
	{ 'D', "DVFS Test", NULL, NULL, m_menuDVFSTest, MenuEnterDVFSLevel, NULL, NULL},
	{ 'U', "USB Power Test", NULL, NULL, m_menuUSBPowerTest, NULL, NULL, NULL},
	{ 'S', "Enter the Sleep Mode", NULL, MenuHandlerSleepWakeupTest,NULL, NULL, NULL},
	{ 'I', "Enter the Idle Mode", NULL, MenuHandlerIdleTest,NULL, NULL, NULL},
	{ 'J', "Enter the Deep Idle Mode", NULL, MenuDeepIdleTest,NULL, NULL, NULL},
	{ 'K', "Set Top On/Off on Deep Idle mode", MenuTitleSetDeepIdle, MenuSetDeepIdle,NULL, NULL, NULL},
	{ 'E', "Set to display all value of Power before sleep", MenuTitleDumpPower_Sleep, MenuDumpPower_Sleep, NULL, NULL, NULL, NULL},	
	{ 'T', "Set Temporary Power-Save Mode", MenuTitleSetPowerSave, MenuSetPowerSave, NULL, NULL, NULL, NULL},	
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuAgingTest[] =
{
	{ '0', "Enable Power On/Off Test", MenuTitleEnableAgingTest, MenuEnableAgingTest, NULL, NULL, NULL, (void *)0},
	{ '1', "Enable Sleep/Wakeup Test", MenuTitleEnableAgingTest, MenuEnableAgingTest, NULL, NULL, NULL, (void *)1},	
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};

MENU_ITEM m_menuDMCode[] =
{
	{ 'R', "DRAM R/W TEST", NULL, MenuHandlerDRAMTest, NULL, NULL, NULL},
/*
	{ 'G', "GPIO Test", NULL, NULL, m_menuGPIOTest, NULL, NULL, NULL},		
	{ 'P', "Power Management Test", NULL, NULL, m_menuPowerManTest, NULL, NULL, NULL},
	{ 'B', "BKL_Test", NULL, NULL,m_menuBKLTest, NULL, NULL, NULL},	
	{ 'L', "LCD_Test", NULL, NULL,m_menuLCDTest, NULL, NULL, NULL},
	{ 'T', "Timer Test", NULL, MenuTimer_Test, NULL, NULL, NULL, NULL},
	{ 'U', "MicroUSB Test", NULL, MicroUSB_Test, NULL, NULL, NULL, NULL},	
	{ 'E', "Enable Aging Test", NULL, NULL, m_menuAgingTest, NULL, NULL, NULL},	
*/
	{ 'G', "GPIO Test", NULL, NULL, NULL, NULL, NULL, NULL},		
	{ 'P', "Power Management Test", NULL, NULL, NULL, NULL, NULL, NULL},
	{ 'B', "BKL_Test", NULL, NULL,NULL, NULL, NULL, NULL},	
	{ 'L', "LCD_Test", NULL, NULL,NULL, NULL, NULL, NULL},
	{ 'T', "Timer Test", NULL, MenuTimer_Test, NULL, NULL, NULL, NULL},
	{ 'U', "MicroUSB Test", NULL, MicroUSB_Test, NULL, NULL, NULL, NULL},	
	{ 'E', "Enable Aging Test", NULL, NULL, NULL, NULL, NULL, NULL},	
#ifndef SDMMC_BOOT
	{ 'N', "NAND flash memory test", NULL, MenuNAND_Test, NULL, NULL, NULL, NULL},
#endif	
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};
