#include <windows.h>
#include <bsp_args.h>
#include <log.h>
#include <oal_log.h>

#include "menu.h"
#include <Bsp.h>
#include <loader.h>

extern PBOOT_CFG       g_pBootCfg;


static void MenuTitleOALLog(void *arg)
{
	switch((int)arg) 
	{
		case 0:
			EdbgOutputDebugString("OAL_ERROR      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_ERROR))? "SET":"");
			break;
		case 1:
			EdbgOutputDebugString("OAL_WARN       : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_WARN))? "SET":""); 
			break;
		case 2:
			EdbgOutputDebugString("OAL_FUNC       : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_FUNC))? "SET":""); 
			break;
		case 3:
			EdbgOutputDebugString("OAL_INFO       : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_INFO))? "SET":""); 
			break;
		case 4:
			EdbgOutputDebugString("OAL_STUB       : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_STUB))? "SET":""); 
			break;
		case 5:
			EdbgOutputDebugString("OAL_CACHE      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_CACHE))? "SET":""); 
			break;
		case 6:
			EdbgOutputDebugString("OAL_RTC        : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_RTC))? "SET":""); 
			break;
		case 7:
			EdbgOutputDebugString("OAL_POWER      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_POWER))? "SET":""); 
			break;
		case 8:
			EdbgOutputDebugString("OAL_PCI        : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_PCI))? "SET":""); 
			break;
		case 9:
			EdbgOutputDebugString("OAL_MEMORY     : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_MEMORY))? "SET":"");
			break;
		case 10:
			EdbgOutputDebugString("OAL_IO         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_IO))? "SET":"");
			break;
		case 11:
			EdbgOutputDebugString("OAL_TIMER      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_TIMER))? "SET":"");
			break;
		case 12:
			EdbgOutputDebugString("OAL_IOCTL      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_IOCTL))? "SET":""); 
			break;
		case 13:
			EdbgOutputDebugString("OAL_FLASH      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_FLASH))? "SET":""); 
			break;
		case 14:
			EdbgOutputDebugString("OAL_INTR       : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_INTR))? "SET":""); 
			break;
		case 15:
			EdbgOutputDebugString("OAL_VERBOSE    : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_VERBOSE))? "SET":""); 
			break;
		case 16:
			EdbgOutputDebugString("OAL_OEM_FUNC   : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_OEM))? "SET":""); 
			break;
		case 17:
			EdbgOutputDebugString("OAL_DEBUG      : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_DEBUG))? "SET":""); 
			break;
		case 18:
			EdbgOutputDebugString("OAL_FMD        : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_FMD))? "SET":""); 
			break;
		case 19:
			EdbgOutputDebugString("OAL_19         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_19))? "SET":""); 
			break;
		case 20:
			EdbgOutputDebugString("OAL_20         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_20))? "SET":""); 
			break;
		case 21:
			EdbgOutputDebugString("OAL_21         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_21))? "SET":""); 
			break;
		case 22:
			EdbgOutputDebugString("OAL_22         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_22))? "SET":""); 
			break;
		case 23:
			EdbgOutputDebugString("OAL_23         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_23))? "SET":""); 
			break;
		case 24:
			EdbgOutputDebugString("OAL_24         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_24))? "SET":""); 
			break;
		case 25:
			EdbgOutputDebugString("OAL_25         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_25))? "SET":""); 
			break;
		case 26:
			EdbgOutputDebugString("OAL_26         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_26))? "SET":""); 
			break;
		case 27:
			EdbgOutputDebugString("OAL_27         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_27))? "SET":""); 
			break;
		case 28:
			EdbgOutputDebugString("OAL_28         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_28))? "SET":""); 
			break;
		case 29:
			EdbgOutputDebugString("OAL_29         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_29))? "SET":""); 
			break;
		case 30:
			EdbgOutputDebugString("OAL_30         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_30))? "SET":""); 
			break;
		case 31:
			EdbgOutputDebugString("OAL_31         : %s", (g_pBootCfg->dwLogMask & OALMASK(OAL_LOG_31))? "SET":""); 
			break;
	}
}

static int MenuHandlerOALLog(void *arg)
{
	int mask = (int) arg;
	
	if (g_pBootCfg->dwLogMask & (OALMASK(mask)))
		g_pBootCfg->dwLogMask &= ~(OALMASK(mask));
	else
		g_pBootCfg->dwLogMask |= (OALMASK(mask));

	return 0;
}

// Function to be called when exiting this menu
void MenuExitLogMask(void *arg)
{
	//if (g_oalLogMask != g_pBootCfg->dwLogMask) {      // Windows Mobile
	if (dpCurSettings.ulZoneMask != g_pBootCfg->dwLogMask) {        // WinCE 6.0
		TOC_Write();
		g_pBSPArgs->dwOALLogMask = g_pBootCfg->dwLogMask;
		OALLogSetZones(g_pBSPArgs->dwOALLogMask);
	}
}

MENU_ITEM m_menuLogMask[] =
{
	{ '0', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 0},
	{ '1', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 1},
	{ '2', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 2},
	{ '3', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 3},
	{ '4', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 4},
	{ '5', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 5},
	{ '6', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 6},
	{ '7', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 7},
	{ '8', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 8},
	{ '9', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 9},
	{ 'A', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 10},
	{ 'B', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 11},
	{ 'C', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 12},
	{ 'D', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 13},
	{ 'E', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 14},
	{ 'F', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 15},
	{ 'G', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 16},
	{ 'H', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 17},
	{ 'I', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 18},
	{ 'J', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 19},
	{ 'K', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 20},
	{ 'L', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 21},
	{ 'M', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 22},
	{ 'N', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 23},
	{ 'O', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 24},
	{ 'P', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 25},
	{ 'Q', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 26},
	{ 'R', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 27},
	{ 'S', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 28},
	{ 'T', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 29},
	{ 'U', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 30},
	{ 'V', "Menu Name", MenuTitleOALLog, MenuHandlerOALLog, NULL, NULL, NULL, (void *) 31},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};


