#include <windows.h>
#include <bsp_args.h>
#include "menu.h"
//#include "register_map.h"
#include <Bsp.h>
#include "loader.h"

extern PBOOT_CFG       g_pBootCfg;
extern DWORD           g_dwTocEntry;

static BOOL bBootConfigChanged = FALSE;

// Reset to Default
static int MenuHandlerResetDefault(void *arg)
{
    OALMSG(TRUE, (TEXT("Resetting default TOC...\r\n")));
    g_dwTocEntry = TOC_ENTRY_EBOOT;
    TOC_Init();
    if ( !TOC_Write() ) {
        OALMSG(OAL_WARN, (TEXT("TOC_Write Failed!\r\n")));
    }
    OALMSG(TRUE, (TEXT("...TOC complete\r\n")));

    g_dwTocEntry = TOC_ENTRY_NK; //default
	return 0;
}

void MenuEnterEbootConfig(void *arg)
{
	bBootConfigChanged = FALSE;
}

void MenuExitEbootConfig(void *arg)
{
    TOC_Print();
	if (bBootConfigChanged)
		TOC_Write();
}

// See Debug Serial Message
static void MenuTitleSetDbgSerailMsg(void *arg)
{
	EdbgOutputDebugString("Enable Serial Message : (%s)", (g_pBootCfg->bNoSerialMSG==FALSE? "Yes":"No"));
}

static int MenuHandlerSetDbgSerialMsg(void *arg)
{
	g_pBootCfg->bNoSerialMSG = !g_pBootCfg->bNoSerialMSG;
	g_pBSPArgs->bNoSerialMSG = g_pBootCfg->bNoSerialMSG;
	bBootConfigChanged = TRUE;
	return 0;	
}

static void MenuTitleUseLogmask(void *arg)
{
	EdbgOutputDebugString("Enable OALLOG : (%s)", (g_pBootCfg->bUseOALLOG? "Yes":"No"));

    if(g_pBootCfg->bUseOALLOG == FALSE)
        OALLogSetZones(0);      // All Mask OALLog
}

static int MenuHandlerUseLogmask(void *arg)
{
	g_pBootCfg->bUseOALLOG = !g_pBootCfg->bUseOALLOG;
	g_pBSPArgs->bUseOALLOG = g_pBootCfg->bUseOALLOG;
	bBootConfigChanged = TRUE;
	return 0;	
}

static void MenuTitleUseDrivermask(void *arg)
{
	EdbgOutputDebugString("Enable DBGMSG : (%s)", (g_pBootCfg->bUseDRVMSG? "Yes":"No"));
}

static int MenuHandlerUseDrivemask(void *arg)
{
	g_pBootCfg->bUseDRVMSG = !g_pBootCfg->bUseDRVMSG;
	g_pBSPArgs->bUseDRVMSG = g_pBootCfg->bUseDRVMSG;
	bBootConfigChanged = TRUE;
	return 0;	
}

// Sub Menu (menu_BootOpt.c)
extern void MenuExitBootOpt(void *arg);
extern MENU_ITEM m_menuBootOpt[];

// Sub Menu (menu_logmask.c)
extern void MenuExitLogMask(void *arg);
extern MENU_ITEM m_menuLogMask[];

// Sub Menu (menu_drvmsg.c)
extern void MenuExitDrvList(void *arg);
extern MENU_ITEM m_menuDrvList[];
extern void MenuExitCLKChange(void *arg);
extern MENU_ITEM m_menuClockChange[];
	
MENU_ITEM m_menuEbootConfig[] =
{
	{ '0', "Change booting options", NULL, NULL, m_menuBootOpt, NULL, MenuExitBootOpt},
	{ '1', "See DebugSerial Msg", MenuTitleSetDbgSerailMsg, MenuHandlerSetDbgSerialMsg, NULL, NULL, MenuExitBootOpt},
	{ '2', "OALMSG Enable", MenuTitleUseLogmask, MenuHandlerUseLogmask, NULL, NULL, NULL},
	{ '3', "Change OALMSG mask setting", NULL, NULL, m_menuLogMask, NULL, MenuExitLogMask},
	{ '4', "DBGMSG Enable", MenuTitleUseDrivermask, MenuHandlerUseDrivemask, NULL, NULL, NULL},
	{ '5', "Change DBGMSG mask setting", NULL, NULL, m_menuDrvList, NULL, MenuExitDrvList},
    { '6', "Reset to default Boot Configuration", NULL, MenuHandlerResetDefault, NULL, NULL, NULL},
//    { '7', "Change System Clocks for only debugging", NULL, NULL, m_menuClockChange, NULL, MenuExitCLKChange},
	{ '\0', "", NULL, NULL, NULL, NULL, NULL}
};




