#include <windows.h>
#include <oal_log.h>
#include <bsp_args.h>

#include "menu.h"
#include <Bsp.h>
#include <loader.h>

#define DRVMSG_STATIC_LIBRARY
#include <drvmsg.h>
#undef DRVMSG_STATIC_LIBRARY


static int g_SelectedPart = 0;
static int g_SelectedSect = 0;
extern PBOOT_CFG       g_pBootCfg;

const char MASK_NAME[8][7]= {"INFO ", "FUNC ", "DEBUG", "PM   ", "USER1", "USER2", "USER3", "USER4"};

static int MenuHandlerMaskSetClear(void *arg)
{
	int idx = (int) arg;
	int mask = g_pBSPArgs->dwDrvMsgMask[g_SelectedPart]& (1 << (g_SelectedSect*8+idx));
	if (mask)
		g_pBSPArgs->dwDrvMsgMask[g_SelectedPart] &= ~(1 << (g_SelectedSect*8+idx));
	else
		g_pBSPArgs->dwDrvMsgMask[g_SelectedPart] |= (1 << (g_SelectedSect*8+idx));
	return 0;
}

static void MenuTitleDrvMask(void *arg)
{
	int idx = (int) arg;
	int mask = g_pBSPArgs->dwDrvMsgMask[g_SelectedPart]& (1 << (g_SelectedSect*8+idx));
	
	EdbgOutputDebugString("%s : %s", MASK_NAME[(int)arg], mask? "Yes":"");
}

static void MenuEnterDrvMask(void *arg)
{
	g_SelectedSect = (int) arg;
}

MENU_ITEM m_menuDrvMask[] =
{
	{ '0', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 0},
	{ '1', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 1},
	{ '2', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 2},
	{ '3', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 3},
	{ '4', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 4},
	{ '5', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 5},
	{ '6', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 6},
	{ '7', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 7},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};

//-----------------------------------------------------------------------------------

//DBGMSG driver list
const char DRV_NAME[DRVLOG_PART_NUM*4][20]= {
						"Display   ", "Rotator   ", "POST      ", "TV Out    ",
						"ISM       ", "Camera-Meg", "Camera-CIF", "Camera-IF ",
						"AUDIO     ", "AC97      ", "SPI    ", "ECHO      ",
						"PM        ", "Power     ", "PWC       ", "Battery   ",
						"LED       ", "Keypad    ", "Touch     ", "Backlight ",
						"OneNAND   ", "Flash     ", "SDHC      ", "PCMCIA    ",
						"DMA       ", "MFD       ", "MMI       ", "IIC       ",
						"UART      ", "BT Serial ", "Bluetooth ", "BT Profile",
						"RTC       ", "RIL       ", "RCD       ", "DPRAM     ",
						"SIM       ", "WiBro     ", "WLAN      ", "TDMB      ",
						"ACC       ", "GPS       ", "MFD       ", "JPG       ",
						"MITsMan   ", "USBFN     ", "USBH      ", "USB Modem ",
						"ProximitySensor  ", "SPKPhone  ", "Headset  ", "FMRADIO ",
						"PWRBTN  ", "DRVLIB  ", "INTERNAL  ", "NOT USED  ",
						"NOT USED  ", "NOT USED  ", "Reserved  ", "Reserved  "};

static void MenuTitlePartMask(void *arg)
{
	int i, idx = (int) arg;
	int mask = (g_pBSPArgs->dwDrvMsgMask[g_SelectedPart]&(0xFF<<(idx*8))) >> (idx*8);

	EdbgOutputDebugString("%s :", DRV_NAME[(g_SelectedPart*4+idx)]);
	for (i=0; i<8; i++) {
		if (mask & (0x1 << i))
			EdbgOutputDebugString(" %s", MASK_NAME[i]);
	}
}						

static int MenuHandlerPartClear(void *arg)
{
	g_pBSPArgs->dwDrvMsgMask[g_SelectedPart] = INITIAL_LOGMASK_VAL;
	return 0;
}

static void MenuEnterPartMask(void *arg)
{
	g_SelectedPart = (int) arg;
}

MENU_ITEM m_menuPartMask[] =
{
	{ '0', "", MenuTitlePartMask, NULL, m_menuDrvMask, MenuEnterDrvMask, NULL, (void *) 0},
	{ '1', "", MenuTitlePartMask, NULL, m_menuDrvMask, MenuEnterDrvMask, NULL, (void *) 1},
	{ '2', "", MenuTitlePartMask, NULL, m_menuDrvMask, MenuEnterDrvMask, NULL, (void *) 2},
	{ '3', "", MenuTitlePartMask, NULL, m_menuDrvMask, MenuEnterDrvMask, NULL, (void *) 3},
	{ 'C', "Reset to default value", NULL, MenuHandlerPartClear, NULL, NULL, NULL, (void *) NULL},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};

//-----------------------------------------------------------------------------------
static void MenuEnterGlobDrvMask(void *arg)
{
	g_SelectedPart = DRVLOG_PART_NUM-1;
	g_SelectedSect = 3;
}

static void MenuLeaveGlobDrvMask(void *arg)
{
	int mask = (g_pBSPArgs->dwDrvMsgMask[g_SelectedPart]&(0xFF<<(g_SelectedSect*8))) >> (g_SelectedSect*8);
	DWORD gloMask = (DWORD)(mask|(mask<<8)|(mask<<16)|(mask<<24));
	int i;

	for (i = 0; i<DRVLOG_PART_NUM; i++)
		g_pBSPArgs->dwDrvMsgMask[i] = gloMask;
}

MENU_ITEM m_menuGlobDrvMask[] =
{
	{ '0', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 0},
	{ '1', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 1},
	{ '2', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 2},
	{ '3', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 3},
	{ '4', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 4},
	{ '5', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 5},
	{ '6', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 6},
	{ '7', "", MenuTitleDrvMask, MenuHandlerMaskSetClear, NULL, NULL, NULL, (void *) 7},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};

#define DEFAULT_DEVELOPER_LOGMASK	(DEF_DEVELOPER_MASK|(DEF_DEVELOPER_MASK<<8)|(DEF_DEVELOPER_MASK<<16)|(DEF_DEVELOPER_MASK<<24))

static int MenuHandlerDrvListDeveloper(void *arg)
{
	int i;

	for (i = 0; i<DRVLOG_PART_NUM; i++)
		g_pBSPArgs->dwDrvMsgMask[i] = DEFAULT_DEVELOPER_LOGMASK;
	return 0;
}

static int MenuHandlerDrvListClear(void *arg)
{
	int i;

	for (i = 0; i<DRVLOG_PART_NUM; i++)
		g_pBSPArgs->dwDrvMsgMask[i] = INITIAL_LOGMASK_VAL;
	return 0;
}

// Function to be called when exiting this menu
void MenuExitDrvList(void *arg)
{
	int i, changed = FALSE;

	OALMSG(TRUE,(L"********** SAVE DBGMSG FLAG CHANGES **********\r\n"));
	for (i = 0; i<DRVLOG_PART_NUM; i++) {
		if (g_pBSPArgs->dwDrvMsgMask[i] != g_pBootCfg->dwDrvMsgMask[i]){
			changed = TRUE;
        }
		g_pBootCfg->dwDrvMsgMask[i] = g_pBSPArgs->dwDrvMsgMask[i];
		//OALMSG(TRUE, (L"PART%2d: dwDrvMSgMask[%02d]= 0x%08X\r\n", i, i, g_pBootCfg->dwDrvMsgMask[i]));
	}
	OALMSG(TRUE,(L"**********************************************\r\n\r\n"));
	if (changed)
            TOC_Write();

}

MENU_ITEM m_menuDrvList[] =
{
	{ '0', "DBGMSG[0] : Display     Rotator     POST        TV Out    ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 0},
	{ '1', "DBGMSG[1] : ISM         Camera-Mega Camera-CIF  Camera-IF ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 1},
	{ '2', "DBGMSG[2] : AUDIO       AC97        SPI      ECHO      ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 2},
	{ '3', "DBGMSG[3] : PM          Power       PWC         Battery   ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 3},
	{ '4', "DBGMSG[4] : LED         Keypad      Touch       Backlight ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 4},
	{ '5', "DBGMSG[5] : OneNAND     Flash       SDHC        PCMCIA    ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 5},
	{ '6', "DBGMSG[6] : DMA         MFD         MMI         IIC       ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 6},
	{ '7', "DBGMSG[7] : UART        BT Serial   Bluetooth   BT Profile", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 7},
	{ '8', "DBGMSG[8] : RTC         RIL         RCD         DPRAM     ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 8},
	{ '9', "DBGMSG[9] : SIM         WiBro       WLAN        TDMB      ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 9},
	{ 'A', "DBGMSG[A]: ACC         GPS         MFD         JPG       ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 10},
	{ 'B', "DBGMSG[B]: MITsMan     USBFN       USBH        USB Modem ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 11},
	{ 'C', "DBGMSG[C]: ProximitySensor    SPKPhone  Headset    FMRADIO  ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 12},
	{ 'D', "DBGMSG[D]: PWRBTN    DRVLIB    INTERNAL    NOT USED  \r\n", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 13},
#if 0 // reserved	
	{ 'E', "DBGMSG[14]: NOT USED    NOT USED    Reserved    Reserved  ", NULL, NULL, m_menuPartMask, MenuEnterPartMask, NULL, (void *) 10},
	{ ' ', "", NULL, NULL, NULL, NULL, NULL, (void *) NULL},
#endif	
	{ 'G', "Change driver mask globaly", NULL, NULL, m_menuGlobDrvMask, MenuEnterGlobDrvMask, MenuLeaveGlobDrvMask, (void *) NULL},
	{ 'I', "Reset to Developer value : INFO message only.", NULL, MenuHandlerDrvListDeveloper, NULL, NULL, NULL, (void *) NULL},
	{ 'R', "Reset to default value   : No message.", NULL, MenuHandlerDrvListClear, NULL, NULL, NULL, (void *) NULL},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};


