#include <windows.h>
#include <oal_log.h>
#include <bsp_args.h>

#include "menu.h"
#include <Bsp.h>
#include "loader.h"

extern PBOOT_CFG       g_pBootCfg;

BOOL bChanged = FALSE;

// Clean Boot
static void MenuTitleCleanBoot(void *arg)
{
	EdbgOutputDebugString("Clean Boot : (%s)", (g_pBSPArgs->bCleanBoot == TRUE? "Yes":"No"));
}

static int MenuHandlerCleanBoot(void *arg)
{
	//g_pBootCfg->bCleanBoot = !(g_pBootCfg->bCleanBoot);
	//g_pBSPArgs->bCleanBoot = g_pBootCfg->bCleanBoot;
    g_pBSPArgs->bCleanBoot = !(g_pBSPArgs->bCleanBoot);
	//bChanged = TRUE;
	return 0;
}

// ULDR Boot
static void MenuTitleULDRBoot(void *arg)
{
	EdbgOutputDebugString("ULDR Boot  : %s", (g_pBootCfg->fUpdateMode == TRUE? "(Yes)":"(No)"));
}

static int MenuHandlerULDRBoot(void *arg)
{
	g_pBootCfg->fUpdateMode = !(g_pBootCfg->fUpdateMode);
	g_pBSPArgs->fUpdateMode = g_pBootCfg->fUpdateMode;
	bChanged = TRUE;
	return 0;	
}

// KITL Boot
static void MenuTitleKitlBoot(void *arg)
{
	EdbgOutputDebugString("KITL Boot  : %s ", (g_pBootCfg->bKITLBoot == TRUE? "(Yes)" : "(No)"));

	if(g_pBootCfg->bKITLBoot)
	{
		if(g_pBootCfg->KITLType == OAL_KITL_TYPE_SERIAL)
			EdbgOutputDebugString("KITL DEV  : (USB SERIAL)");
		else if(g_pBootCfg->KITLType == OAL_KITL_TYPE_ETH)
			EdbgOutputDebugString("KITL DEV  : (USB RNDIS)");
		else
			EdbgOutputDebugString("KITL DEV  : (UNKNOWN)");
	}
	else
	{
		EdbgOutputDebugString("KITL DEV  : (No)");
	}
}

static int MenuHandlerKitlBoot(void *arg)
{
	if(g_pBootCfg->bKITLBoot)
	{
		if(g_pBootCfg->KITLType == OAL_KITL_TYPE_SERIAL) 
		{
			g_pBootCfg->bKITLBoot = TRUE;
			g_pBootCfg->KITLType = OAL_KITL_TYPE_ETH;
            g_pBootCfg->ConfigFlags = (g_pBootCfg->ConfigFlags ^ CONFIG_FLAGS_KITL);
		}
		else if(g_pBootCfg->KITLType == OAL_KITL_TYPE_ETH) 
		{
			g_pBootCfg->bKITLBoot = FALSE;
			g_pBootCfg->KITLType = OAL_KITL_TYPE_SERIAL;
		}
	}
	else
	{
		g_pBootCfg->bKITLBoot = TRUE;
		g_pBootCfg->KITLType = OAL_KITL_TYPE_SERIAL;
        g_pBootCfg->ConfigFlags = (g_pBootCfg->ConfigFlags ^ CONFIG_FLAGS_KITL);
	}

	g_pBSPArgs->bKITLBoot = g_pBootCfg->bKITLBoot;
	g_pBSPArgs->KITLType = g_pBootCfg->KITLType;
	
	bChanged = TRUE;
	
	return 0;
}



// Hive Clean
static void MenuTitleHiveClean(void *arg)
{
	EdbgOutputDebugString("Clean Hive : (%s)", (g_pBSPArgs->bCleanHive == TRUE? "Yes":"No"));
}

static int MenuHandlerHiveClean(void *arg)
{
	g_pBSPArgs->bCleanHive = !g_pBSPArgs->bCleanHive;
	g_pBSPArgs->bClearSystemHiveReg = g_pBSPArgs->bCleanHive;
	g_pBSPArgs->bClearUserHiveReg = g_pBSPArgs->bCleanHive;
	return 0;	
}


// Function to be called when exiting this menu
void MenuExitBootOpt(void *arg)
{
	if (bChanged)
	{
    	TOC_Write();
	}
}

MENU_ITEM m_menuBootOpt[] =
{
	{ '0', "Clean Boot", MenuTitleCleanBoot, MenuHandlerCleanBoot, NULL, NULL, NULL},
	{ '1', "Clean Hive", MenuTitleHiveClean, MenuHandlerHiveClean, NULL, NULL, NULL},
	{ '2', "KITL Boot", MenuTitleKitlBoot, MenuHandlerKitlBoot, NULL, NULL, NULL},
	{ '\0', "", NULL, NULL, NULL, (void *) NULL}
};
