//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:  
    blcommon.c
    
Abstract:  
    Bootloader common main module. This file contains the C BootloaderMain
    function for the boot loader.    NOTE: The firmware "entry" point (the real
    entry point) is _StartUp in init assembler file.

    The Windows CE boot loader is the code that is executed on a Windows CE
    development system at power-on reset and loads the Windows CE
    operating system. The boot loader also provides code that monitors
    the behavior of a Windows CE platform between the time the boot loader
    starts running and the time the full operating system debugger is 
    available. Windows CE OEMs are supplied with sample boot loader code 
    that runs on a particular development platform and CPU.
    
Functions:


Notes: 

--*/
#include <windows.h>
#include <halether.h>
#include <blcommon.h>

#include "bsp.h"
#include "loader.h"

//added ty terry 
//extern BOOL           bIsLogoBin;
extern DWORD          g_ImageType;
#ifndef IMAGE_TYPE_LOGO
#define IMAGE_TYPE_LOGO              0x00000010
#endif

#define EBOOT_VERSION_STRING " www.9tripod.com Bootloader (" __DATE__ ") (" __TIME__ ")"


#define SPIN_FOREVER        while (1)

ROMHDR * volatile const pTOC = (ROMHDR *)-1;     // Gets replaced by RomLoader with real address
static DownloadManifest g_DownloadManifest;
static BOOLEAN g_bBINDownload = TRUE;

static BOOL KernelRelocate (ROMHDR *const pTOC);
static BOOL DownloadImage (LPDWORD pdwImageStart, LPDWORD pdwImageLength, LPDWORD pdwLaunchAddr);
static BOOL IsKernelRegion(DWORD dwRegionStart, DWORD dwRegionLength);

#define CURRENT_VERSION_MAJOR       1
#define CURRENT_VERSION_MINOR       1

const unsigned char NKSignon[] = {
    "\nMicrosoft Windows CE Ethernet Bootloader Common Library Version %d.%d Built "
    __DATE__ " " __TIME__ "\r\n"
};

DWORD g_dwROMOffset;

PFN_OEMVERIFYMEMORY     g_pOEMVerifyMemory;
PFN_OEMREPORTERROR      g_pOEMReportError;
PFN_OEMCHECKSIGNATURE   g_pOEMCheckSignature;
PFN_OEMMULTIBINNOTIFY   g_pOEMMultiBINNotify;


extern BOOL bSDCardUpdata_AllOSImage;
extern BOOL bSDCardUpdata_Eboot;
extern BOOL bSDCardUpdata_Logo;	
extern BOOL bSDCardUpdata_NK;
extern BOOL g_bAutoDownload;  // form sd updata all os image
extern volatile UINT32 		readPtIndex;



static void HALT (DWORD dwReason)
{
    if (g_pOEMReportError)
    {
        g_pOEMReportError (dwReason, 0);
    }
    SPIN_FOREVER;
}


void BootloaderMain (void)
{
    DWORD dwAction;   
    DWORD dwpToc = 0;
    DWORD dwImageStart = 0, dwImageLength = 0, dwLaunchAddr = 0;
    BOOL bDownloaded = FALSE;

	DWORD i,ImageConut = 3; //added by terry 2012.07.27 defaule only support one image for down 

    // relocate globals to RAM
    if (!KernelRelocate (pTOC))
    {
        // spin forever
        HALT (BLERR_KERNELRELOCATE);
    }

    // (1) Init debug support. We can use OEMWriteDebugString afterward.
    if (!OEMDebugInit ())
    {
        // spin forever
        HALT (BLERR_DBGINIT);
    }

    // output banner
    	EdbgOutputDebugString (NKSignon, CURRENT_VERSION_MAJOR, CURRENT_VERSION_MINOR);

    // (3) initialize platform (clock, drivers, transports, etc)
    if (!OEMPlatformInit ())
    {
        // spin forever
        HALT (BLERR_PLATINIT);
    }

    // system ready, preparing for download
EdbgOutputDebugString ("System ready!\r\nPreparing for download...\r\n");




	//(4) added by terry 2012.07.31  
	if(g_bAutoDownload)
	{
		LcdDrawInit();
		
		LcdSetStringPosition(1,0);	//1У5
		LcdDrawString("--------------------------------------------");		
		
		LcdSetStringPosition(2,1);	//1У0
		LcdDrawString(EBOOT_VERSION_STRING);
		
			
		LcdSetStringPosition(1,2);	//1У1
		LcdDrawString("--------------------------------------------");
		
		LcdSetStringPosition(2,3);	//1У5	
		LcdDrawString("Start to update please wait for a moment.");
		
		
		LcdSetStringPosition(2,5);	//1У5	
		LcdDrawString("read config file from SD");
		
		if(bSDCardUpdata_AllOSImage)
		{
			bSDCardUpdata_Eboot = TRUE;
			bSDCardUpdata_Logo = TRUE;	
			bSDCardUpdata_NK = TRUE;
		}else
		{
			readPtIndex = EBOOT_USB_BUFFER_UA_START;
			ReadimageFromSD("updata", readPtIndex,4);
		}

						
		LcdSetStringPosition(2,6);	//1У3
		if(bSDCardUpdata_Eboot)
		{
			LcdDrawString("1) bSDCardUpdata_Eboot = TRUE");
		}else
		{
			LcdDrawString("1) bSDCardUpdata_Eboot = FALSE");

		}

		
		LcdSetStringPosition(2,7);	//1У3	
		if(bSDCardUpdata_Logo)
		{
			LcdDrawString("2) bSDCardUpdata_Logo = TRUE");
		}
		else
		{		
			LcdDrawString("2) bSDCardUpdata_Logo = FALSE");
		}

		
		LcdSetStringPosition(2,8);	//1У3	
		if(bSDCardUpdata_NK)
		{
			LcdDrawString("3) bSDCardUpdata_NK = TRUE");
		}
		else
		{
			LcdDrawString("3) bSDCardUpdata_NK = FALSE");

		}

		LcdSetStringPosition(1,10); //1У5	
		LcdDrawString("--------------------------------------");

		
		if(bSDCardUpdata_Eboot)
		{

			g_DownloadManifest.dwNumRegions = 0; //added by terry 
			//g_ImageType = IMAGE_TYPE_EBOOT;


			//EdbgOutputDebugString ("...........................eboot.nb0.....1...\r\n");


			LcdSetStringPosition(2,11); //1У5	
			LcdDrawString("read eboot.nb0...");

					readPtIndex = EBOOT_USB_BUFFER_UA_START;
	        ReadimageFromSD("eboot.nb0", readPtIndex,1);

			LcdSetStringPosition(2,12); //1У5	
			LcdDrawString("Writing eboot.nb0 to Media...");


			
	        if (!DownloadImage (&dwImageStart, &dwImageLength, &dwLaunchAddr))
	        {
	            SPIN_FOREVER;
	        }
	        bDownloaded = TRUE;

	        if (*(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET) == ROM_SIGNATURE)
	        {
	            dwpToc = *(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET + sizeof(ULONG));
	            // need to map the content again since the pointer is going to be in a fixup address
	            dwpToc = (DWORD) OEMMapMemAddr (dwImageStart, dwpToc + g_dwROMOffset);

	            KITLOutputDebugString ("ROMHDR at Address %Xh\r\n", dwImageStart + ROM_SIGNATURE_OFFSET + sizeof (DWORD)); // right after signature
	        }
	        if (g_bBINDownload && g_pOEMCheckSignature)
	        {
	            if (!g_pOEMCheckSignature(dwImageStart, g_dwROMOffset, dwLaunchAddr, bDownloaded))
	                HALT(BLERR_CAT_SIGNATURE);
	        }
	        OEMLaunch (dwImageStart, dwImageLength, dwLaunchAddr, (const ROMHDR *)dwpToc);      

			
			LcdSetStringPosition(2,13); //1У5	
			LcdDrawString("Writing eboot.nb0 to Media success");



		}

		if(bSDCardUpdata_Logo)  
		{
		g_DownloadManifest.dwNumRegions = 0; //added by terry 		
	
		//EdbgOutputDebugString ("..........................logo.bin......2...\r\n");		

			LcdSetStringPosition(2,15); //1У5	
			LcdDrawString("read logo.bin...");

			//added by zhoupeng 2008.12.05
			ReadimageFromSD("logo.bin", 0,2);

			LcdSetStringPosition(2,16); //1У5	
			LcdDrawString("Writing logo.bin to Media...");

			
			if (!DownloadImage (&dwImageStart, &dwImageLength, &dwLaunchAddr))
			{
				SPIN_FOREVER;
			}
			bDownloaded = TRUE;

			OEMLaunch (dwImageStart, dwImageLength, dwLaunchAddr, (const ROMHDR *)dwpToc);	

			LcdSetStringPosition(2,17); //1У5	
			LcdDrawString("Writing logo.bin to Media success");


		}	

		if(bSDCardUpdata_NK)
		{
				g_DownloadManifest.dwNumRegions = 0; //added by terry 
				//g_ImageType = IMAGE_TYPE_NK;
				
	//	EdbgOutputDebugString ("........................nk.bin........3...\r\n");	

			LcdSetStringPosition(2,19); //1У5	
			LcdDrawString("read nk.bin...");


	        ReadimageFromSD("nk.bin", 0,3);

			LcdSetStringPosition(2,20); //1У5	
			LcdDrawString("Writing nk.bin to Media...");

			
	        if (!DownloadImage (&dwImageStart, &dwImageLength, &dwLaunchAddr))
	        {
	            SPIN_FOREVER;
	        }
	        bDownloaded = TRUE;

	        if (*(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET) == ROM_SIGNATURE)
	        {
	            dwpToc = *(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET + sizeof(ULONG));
	            // need to map the content again since the pointer is going to be in a fixup address
	            dwpToc = (DWORD) OEMMapMemAddr (dwImageStart, dwpToc + g_dwROMOffset);

	            KITLOutputDebugString ("ROMHDR at Address %Xh\r\n", dwImageStart + ROM_SIGNATURE_OFFSET + sizeof (DWORD)); // right after signature
	        }
	        if (g_bBINDownload && g_pOEMCheckSignature)
	        {
	            if (!g_pOEMCheckSignature(dwImageStart, g_dwROMOffset, dwLaunchAddr, bDownloaded))
	                HALT(BLERR_CAT_SIGNATURE);
	        }

			OEMLaunch (dwImageStart, dwImageLength, dwLaunchAddr, (const ROMHDR *)dwpToc);

			LcdSetStringPosition(2,21); //1У5	
			LcdDrawString("Writing nk.bin to Media success");
	
		}

		// OK
		
		LcdSetStringPosition(1,23); //1У5	
		LcdDrawString("--------------------------------------");
		
		LcdSetStringPosition(2,24); //1У5	
		LcdDrawString("updata is succes ");

		if(!bSDCardUpdata_NK)
		{
			LcdSetStringPosition(2,25); //1У5	
			LcdDrawString("Please Reboot!!!! ");
		}


    }

else
{

    // (4) call OEM specific pre-download function
    switch (dwAction = OEMPreDownload ())
    {
    case BL_DOWNLOAD:
		//EdbgOutputDebugString ("DownloadImage!\r\n");
        // (5) download image
        if (!DownloadImage (&dwImageStart, &dwImageLength, &dwLaunchAddr))
        {
            // error already reported in DownloadImage
            SPIN_FOREVER;
        }
        bDownloaded = TRUE;

			// Check for pTOC signature ("CECE") here, after image in place
			if (*(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET) == ROM_SIGNATURE)
			{
				dwpToc = *(LPDWORD) OEMMapMemAddr (dwImageStart, dwImageStart + ROM_SIGNATURE_OFFSET + sizeof(ULONG));
				// need to map the content again since the pointer is going to be in a fixup address
				dwpToc = (DWORD) OEMMapMemAddr (dwImageStart, dwpToc + g_dwROMOffset);
				EdbgOutputDebugString ("ROMHDR at Address %Xh\r\n", dwImageStart + ROM_SIGNATURE_OFFSET + sizeof (DWORD)); // right after signature
			}
			//RETAILMSG(1,(TEXT("Download finished.! Spin Forever.!\r\n")));
			//while(1);
			// fall through
			case BL_JUMP:
			// Before jumping to the image, optionally check the image signature.
			// NOTE: if we haven't downloaded the image by now, we assume that it'll be loaded from local storage in OEMLaunch (or it
			// already resides in RAM from an earlier download), and in this case, the image start address might be 0.  This means 
			// that the image signature routine will need to find the image in storage or in RAM to validate it.  Since the OEM"s 
			// OEMLaunch function will need to do this anyways, we trust that it's within their abilities to do it here.
			//
			if (g_bBINDownload && g_pOEMCheckSignature)
			{
				if (!g_pOEMCheckSignature(dwImageStart, g_dwROMOffset, dwLaunchAddr, bDownloaded))
				HALT(BLERR_CAT_SIGNATURE);
			}
		EdbgOutputDebugString ("OEMLaunch!\r\n");			
			// (5) final call to launch the image. never returned
			OEMLaunch (dwImageStart, dwImageLength, dwLaunchAddr, (const ROMHDR *)dwpToc);
			// should never return
			// fall through		
			default:
			// ERROR! spin forever
			HALT (BLERR_INVALIDCMD);
		}

	
	}


}



//
// KernelRelocate: move global variables to RAM
//
static BOOL KernelRelocate (ROMHDR *const pTOC)
{
    ULONG loop;
    COPYentry *cptr;
    if (pTOC == (ROMHDR *const) -1)
    {
        return (FALSE); // spin forever!
    }
    // This is where the data sections become valid... don't read globals until after this
    for (loop = 0; loop < pTOC->ulCopyEntries; loop++)
    {
        cptr = (COPYentry *)(pTOC->ulCopyOffset + loop*sizeof(COPYentry));
        if (cptr->ulCopyLen)
            memcpy((LPVOID)cptr->ulDest,(LPVOID)cptr->ulSource,cptr->ulCopyLen);
        if (cptr->ulCopyLen != cptr->ulDestLen)
            memset((LPVOID)(cptr->ulDest+cptr->ulCopyLen),0,cptr->ulDestLen-cptr->ulCopyLen);
    }
    return (TRUE);
}

static BOOL VerifyChecksum (DWORD cbRecord, LPBYTE pbRecord, DWORD dwChksum)
{
    // Check the CRC
    DWORD dwCRC = 0;
    DWORD i;
    for (i = 0; i < cbRecord; i++)
        dwCRC += *pbRecord ++;

    if (dwCRC != dwChksum)
	{
		EdbgOutputDebugString ("ERROR: Checksum failure (expected=0x%x  computed=0x%x)\r\n", dwChksum, dwCRC);
//		if(bIsLogoBin)//LOGO.BIN   added by terry	 2012.06.19
		if(g_ImageType == IMAGE_TYPE_LOGO)
		{
			EdbgOutputDebugString ("[VerifyChecksum] LOGO.BIN...\r\n");
			return TRUE;
		}
	}
    return (dwCRC == dwChksum);


	
}

#define BL_HDRSIG_SIZE		7
static BOOL DownloadImage (LPDWORD pdwImageStart, LPDWORD pdwImageLength, LPDWORD pdwLaunchAddr)
{
    BYTE hdr[BL_HDRSIG_SIZE];
    DWORD dwRecLen, dwRecChk, dwRecAddr;
    BOOL fIsFlash = FALSE;
    LPBYTE lpDest = NULL;
    int nPkgNum = 0;
    BYTE nNumDownloadFiles = 1;
    DWORD dwImageStart = 0;
    DWORD dwImageLength = 0;
    RegionInfo *pCurDownloadFile;

    *pdwImageStart = *pdwImageLength = *pdwLaunchAddr = 0;

    do
    {

        // read the 7 byte "magic number"
        //
        if (!OEMReadData (BL_HDRSIG_SIZE, hdr))
        {
            EdbgOutputDebugString ("\r\nUnable to read image signature............\r\n");
            HALT (BLERR_MAGIC);
            return (FALSE);
        }

        // An N000FF packet is manufactured by Platform Builder when we're
        // downloading multiple files or when we're downloading a .nb0 file.
        //
        if (!memcmp (hdr, "N000FF\x0A", BL_HDRSIG_SIZE))
        {

			// read the packet checksum.
            //
            if (!OEMReadData (sizeof (DWORD), (LPBYTE) &dwRecChk))
            {
               EdbgOutputDebugString("\r\nUnable to read download manifest checksum.\r\n");
                HALT (BLERR_MAGIC);
                return (FALSE);
            }


			// read BIN region descriptions (start address and length).
			//
			if (!OEMReadData (sizeof (DWORD), (LPBYTE) &g_DownloadManifest.dwNumRegions) ||
			!OEMReadData ((g_DownloadManifest.dwNumRegions * sizeof(RegionInfo)), (LPBYTE) &g_DownloadManifest.Region[0]))
			{
				EdbgOutputDebugString("\r\nUnable to read download manifest information.\r\n");
				HALT (BLERR_MAGIC);
				return (FALSE);
			}
			// verify the packet checksum.
			//
			if (!VerifyChecksum((g_DownloadManifest.dwNumRegions * sizeof(RegionInfo)), (LPBYTE) &g_DownloadManifest.Region[0], dwRecChk))
			{
				EdbgOutputDebugString ("\r\nDownload manifest packet failed checksum verification.\r\n");
				HALT (BLERR_CHECKSUM);
				return (FALSE);
			}
			// Provide the download manifest to the OEM.  This gives the OEM the
			// opportunity to provide start addresses for the .nb0 files (which 
			// don't contain placement information like .bin files do).
			//
			if (g_pOEMMultiBINNotify)
			{
				g_pOEMMultiBINNotify((PDownloadManifest)&g_DownloadManifest);
			}
			// look for next download...
			nNumDownloadFiles = (BYTE)(g_DownloadManifest.dwNumRegions + 1);      // +1 to account for this packet.
			continue;
		}
		// Is this an old X000FF multi-bin packet header?  It's no longer supported.
		//
		else if (!memcmp (hdr, "X000FF\x0A", BL_HDRSIG_SIZE))
		{
			EdbgOutputDebugString ("ERROR: The X000FF packet is an old-style multi-bin download manifest and it's no longer supported. \
			                                      \r\nPlease update your Platform Builder installation in you want to download multiple files.\r\n");
			HALT (BLERR_MAGIC);
			return (FALSE);
		}
		// Is this a standard bin image?  Check for the usual bin file signature.
		//
		else if (!memcmp (hdr, "B000FF\x0A", BL_HDRSIG_SIZE))//lqm:xip.bin,nk.bin,eboot.binʱִ
		{
			g_bBINDownload = TRUE;

			if (!OEMReadData (sizeof (DWORD), (LPBYTE) &dwImageStart)
                || !OEMReadData (sizeof (DWORD), (LPBYTE) &dwImageLength))
            {
           	EdbgOutputDebugString ("Unable to read image start/length\r\n");
                HALT (BLERR_MAGIC);
                return (FALSE);
            }

	//	RETAILMSG(TRUE, (TEXT("+++dwStartAddr = 0x%x \r\n"), dwImageStart));
	//	RETAILMSG(TRUE, (TEXT("+++dwLength = 0x%x \r\n"), dwImageLength));


			
        }
        // If the header signature isn't recognized, we'll assume the
        // download file is a raw .nb0 file.
        //
        else
        {
            g_bBINDownload = FALSE;
        }

        // If Platform Builder didn't provide a download manifest (i.e., we're
        // only downloading a single .bin file), manufacture a manifest so we
        // can notify the OEM.
        //
        if (!g_DownloadManifest.dwNumRegions)
        {
            g_DownloadManifest.dwNumRegions             = 1;
            g_DownloadManifest.Region[0].dwRegionStart  = dwImageStart;
            g_DownloadManifest.Region[0].dwRegionLength = dwImageLength;

            // Provide the download manifest to the OEM.
            //
            if (g_pOEMMultiBINNotify)
            {
                g_pOEMMultiBINNotify((PDownloadManifest)&g_DownloadManifest);
            }
        }

        // Locate the current download manifest entry (current download file).
		
        pCurDownloadFile = &g_DownloadManifest.Region[g_DownloadManifest.dwNumRegions - nNumDownloadFiles];

        // give the OEM a chance to verify memory
        if (g_pOEMVerifyMemory && !g_pOEMVerifyMemory (pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionLength))
        {
           EdbgOutputDebugString ("!OEMVERIFYMEMORY: Invalid image\r\n");
            HALT (BLERR_OEMVERIFY);
            return (FALSE);
        }

        // check for flash image. Start erasing if it is.
        if ((fIsFlash = OEMIsFlashAddr (pCurDownloadFile->dwRegionStart)) 
            && !OEMStartEraseFlash (pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionLength))
        {
          EdbgOutputDebugString ("Invalid Flash Address/Length\r\n");
            HALT (BLERR_FLASHADDR);
            return (FALSE);
        }
		
        // if we're downloading a binary file, we've already downloaded part of the image when searching
        // for a file header.  copy what we've read so far to the destination buffer, then finish downloading.
        if (!g_bBINDownload)
        {

            lpDest = OEMMapMemAddr (pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionStart);
            memcpy(lpDest, hdr, BL_HDRSIG_SIZE);

            // complete the file download...
            // read data block
            if (!OEMReadData ((pCurDownloadFile->dwRegionLength - BL_HDRSIG_SIZE), (lpDest + BL_HDRSIG_SIZE)))
            {
                EdbgOutputDebugString ("ERROR: failed when reading raw binary file.\r\n");
                HALT (BLERR_CORRUPTED_DATA);
                return (FALSE);
            }
        }
        // we're downloading a .bin file - download each .bin record in turn...
        else
        {
            while (OEMReadData (sizeof (DWORD), (LPBYTE) &dwRecAddr) &&
                   OEMReadData (sizeof (DWORD), (LPBYTE) &dwRecLen)  &&
                   OEMReadData (sizeof (DWORD), (LPBYTE) &dwRecChk))
            {

                // last record of .bin file uses sentinel values for address and checksum.
                if (!dwRecAddr && !dwRecChk)
                {
                    break;
                }

                // map the record address (FLASH data is cached, for example)
                lpDest = OEMMapMemAddr (pCurDownloadFile->dwRegionStart, dwRecAddr);
				

                // read data block
                if (!OEMReadData (dwRecLen, lpDest))
                {
                 	EdbgOutputDebugString ("****** Data record %d corrupted, ABORT!!! ******\r\n", nPkgNum);
                    HALT (BLERR_CORRUPTED_DATA);
                    return (FALSE);
                }
				else if (!VerifyChecksum (dwRecLen, lpDest, dwRecChk))
                {
                    EdbgOutputDebugString ("****** Checksum failure on record %d, ABORT!!! ******\r\n", nPkgNum);
                    HALT (BLERR_CHECKSUM);
                    return (FALSE);
                }

                // Look for ROMHDR to compute ROM offset.  NOTE: romimage guarantees that the record containing
                // the TOC signature and pointer will always come before the record that contains the ROMHDR contents.
                //
                if (dwRecLen == sizeof(ROMHDR) && (*(LPDWORD) OEMMapMemAddr(pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionStart + ROM_SIGNATURE_OFFSET) == ROM_SIGNATURE))
                {
                    DWORD dwTempOffset = (dwRecAddr - *(LPDWORD)OEMMapMemAddr(pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionStart + ROM_SIGNATURE_OFFSET + sizeof(ULONG)));
                    ROMHDR *pROMHdr = (ROMHDR *)lpDest;

                    // Check to make sure this record really contains the ROMHDR.
                    //
                    if ((pROMHdr->physfirst == (pCurDownloadFile->dwRegionStart - dwTempOffset)) &&
                        (pROMHdr->physlast  == (pCurDownloadFile->dwRegionStart - dwTempOffset + pCurDownloadFile->dwRegionLength)) &&
                        (DWORD)(HIWORD(pROMHdr->dllfirst << 16) <= pROMHdr->dlllast) &&
                        (DWORD)(LOWORD(pROMHdr->dllfirst << 16) <= pROMHdr->dlllast))
                    {
                        g_dwROMOffset = dwTempOffset;
                       EdbgOutputDebugString("rom_offset=0x%x.\r\n", g_dwROMOffset); 
                    }
                }

                // verify partial checksum
                OEMShowProgress (nPkgNum ++);

                if (fIsFlash)
                {
                    OEMContinueEraseFlash ();
                }

				if(g_ImageType == IMAGE_TYPE_LOGO)

                    break;

				
            }
        }

        // The image start address and length are passed back to the OEM code (OEMLaunch) 
        // in the following circumstances:
        // 1. The file is a raw .nb0 file.
        // 2. The file is a .bin file with a TOC that contains the kernel executable.
        // 3. The file is a .bin file without a TOC.
        //
        // If the image is a .bin file with a TOC that doesn't contain the kernel exectuable,
        // then it's a multi-xip/mulit-bin image for a non-kernel region and we don't pass
        // the start address and length back to the OEM code.  OEMLaunch can then save the
        // start address and length with the assurance that if the values are non-zero, they
        // represent the values for the NK region.
        //
        if (g_bBINDownload)
        {
            // Does this .bin file contain a TOC?
            if (*(LPDWORD) OEMMapMemAddr(pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionStart + ROM_SIGNATURE_OFFSET) == ROM_SIGNATURE)
            {
                // Contain the kernel?
                if (IsKernelRegion(pCurDownloadFile->dwRegionStart, pCurDownloadFile->dwRegionLength))
                {
                    *pdwImageStart  = pCurDownloadFile->dwRegionStart;
                    *pdwImageLength = pCurDownloadFile->dwRegionLength;
                    *pdwLaunchAddr  = dwRecLen;
                }
            }
            // No TOC - not made by romimage.  However, if we're downloading more than one
            // .bin file, it's probably chain.bin which doesn't have a TOC (and which isn't
            // going to be downloaded on its own) and we should ignore it.
            //
            else if (g_DownloadManifest.dwNumRegions == 1)
                                        
            {
                *pdwImageStart  = pCurDownloadFile->dwRegionStart;
                *pdwImageLength = pCurDownloadFile->dwRegionLength;
                *pdwLaunchAddr  = dwRecLen;
            }
        }
        else    // Raw binary file.
        {
            *pdwImageStart  = pCurDownloadFile->dwRegionStart;
            *pdwLaunchAddr  = pCurDownloadFile->dwRegionStart;
            *pdwImageLength = pCurDownloadFile->dwRegionLength;
        }

        // write to flash if it's flash image
        if (fIsFlash)
        {
            // finish the flash erase
            if (!OEMFinishEraseFlash ())
            {
                HALT (BLERR_FLASH_ERASE);
                return (FALSE);
            }
            // Before writing the image to flash, optionally check the image signature.
            if (g_bBINDownload && g_pOEMCheckSignature)
            {
                if (!g_pOEMCheckSignature(pCurDownloadFile->dwRegionStart, g_dwROMOffset, *pdwLaunchAddr, TRUE))
                    HALT(BLERR_CAT_SIGNATURE);
            }
        }
    }
    while (--nNumDownloadFiles);


    if (fIsFlash)
    {
        nNumDownloadFiles = (BYTE)g_DownloadManifest.dwNumRegions;
        while (nNumDownloadFiles--)
        {
            if (!OEMWriteFlash (g_DownloadManifest.Region[nNumDownloadFiles].dwRegionStart, g_DownloadManifest.Region[nNumDownloadFiles].dwRegionLength))
            {
                HALT (BLERR_FLASH_WRITE);
                return (FALSE);
            }
        }
    }

    return (TRUE);
}


/*
    @func   BOOLEAN | IsKernelRegion | Determines if the expanded BIN file provided contains the kernel image.
    @rdesc  TRUE if the region contains the kernel image, FALSE if it doesn't.
    @comm   <l Download Image> 
    @xref   
    @notes  dwCurrentBase is the base address where the BIN records are currently stored (this can be a RAM, a RAM
            file cache, or flash).  dwImageStoreBase is the images base storage address (this is the base address of potentially
            multiple BIN regions and can be in RAM or flash) and is used to translate addresses to the file cache area.
            dwROMOffset is the difference between the address where the BIN records are stored versus where they're fixed-up
            to run from (for example, an image may be stored in flash, but fixed-up to run in RAM).
*/
static BOOL IsKernelRegion(DWORD dwRegionStart, DWORD dwRegionLength)
{
	DWORD dwCacheAddress = 0;
	ROMHDR *pROMHeader;
	DWORD dwNumModules = 0;
	TOCentry *plTOC;

    if (dwRegionStart == 0 || dwRegionLength == 0)
        return(FALSE);

    if (*(LPDWORD) OEMMapMemAddr (dwRegionStart, dwRegionStart + ROM_SIGNATURE_OFFSET) != ROM_SIGNATURE)
        return (FALSE);

    // A pointer to the ROMHDR structure lives just past the ROM_SIGNATURE (which is a longword value).  Note that
    // this pointer is remapped since it might be a flash address (image destined for flash), but is actually cached
    // in RAM.
    //
    dwCacheAddress = *(LPDWORD) OEMMapMemAddr (dwRegionStart, dwRegionStart + ROM_SIGNATURE_OFFSET + sizeof(ULONG));
    pROMHeader     = (ROMHDR *) OEMMapMemAddr (dwRegionStart, dwCacheAddress + g_dwROMOffset);

    // Make sure sure are some modules in the table of contents.
    //
    if ((dwNumModules = pROMHeader->nummods) == 0)
        return (FALSE);

	// Locate the table of contents and search for the kernel executable and the TOC immediately follows the ROMHDR.
	//
    plTOC = (TOCentry *)(pROMHeader + 1);

	while(dwNumModules--) {
		LPBYTE pFileName = OEMMapMemAddr(dwRegionStart, (DWORD)plTOC->lpszFileName + g_dwROMOffset);
		if (!strcmp(pFileName, "nk.exe")) {
			return TRUE;
		}
		++plTOC;
	}
	return FALSE;
}



BOOL Parsing (UINT32 BufSize, BYTE *strLSTFileBuffer )
{
	ULONG i,j;

		EdbgOutputDebugString("***************************************\n"); 
		EdbgOutputDebugString("updata file is:\r\n");
		EdbgOutputDebugString("***************************************\n\n"); 
		
		for(i=0,j=0;(j<3)&&(strLSTFileBuffer[i]!=0);i++)
		{
			if((strLSTFileBuffer[i] == 0xA))//⵽"update.txt"Ļб־
			{			
				if(  ((strLSTFileBuffer[i+1] =='e')||(strLSTFileBuffer[i+1] =='E')) &&
				((strLSTFileBuffer[i+2] =='b')||(strLSTFileBuffer[i+2] =='B')) &&
				((strLSTFileBuffer[i+3] =='o')||(strLSTFileBuffer[i+3] =='O')) &&
				((strLSTFileBuffer[i+4] =='o')||(strLSTFileBuffer[i+4] =='O')) &&
				((strLSTFileBuffer[i+5] =='t')||(strLSTFileBuffer[i+5] =='T')) 
				)	

				{
					j++;
					if((strLSTFileBuffer[i+7] =='t')||(strLSTFileBuffer[i+7] =='T'))
					{					
						bSDCardUpdata_Eboot = TRUE;
						EdbgOutputDebugString("bSDCardUpdata_Eboot = TRUE\n");					
					}
				}

				if(    ((strLSTFileBuffer[i+1] =='l')||(strLSTFileBuffer[i+1] =='L')) &&
				((strLSTFileBuffer[i+2] =='o')||(strLSTFileBuffer[i+2] =='O')) &&
				((strLSTFileBuffer[i+3] =='g')||(strLSTFileBuffer[i+3] =='G')) &&
				((strLSTFileBuffer[i+4] =='o')||(strLSTFileBuffer[i+4] =='O')) 
				)   
				{
					j++;
					if((strLSTFileBuffer[i+6] =='t')||(strLSTFileBuffer[i+6] =='T'))
					{
						bSDCardUpdata_Logo = TRUE;
						EdbgOutputDebugString("bSDCardUpdata_Logo = TRUE\n"); 	
					
					}
				}
				if(  ((strLSTFileBuffer[i+1] =='n')||(strLSTFileBuffer[i+1] =='N')) &&
				((strLSTFileBuffer[i+2] =='k')||(strLSTFileBuffer[i+2] =='K')) 
				)
				{
					j++;	
					if((strLSTFileBuffer[i+4] =='t')||(strLSTFileBuffer[i+4] =='T'))
					{
						bSDCardUpdata_NK = TRUE;
						EdbgOutputDebugString("bSDCardUpdata_NK = TRUE\n"); 
						break;
					}
				}
				

			}
		}  
		EdbgOutputDebugString("***************************************\r\n\n"); 
		
			
		if(j>=3)
			return TRUE;
		else
			return FALSE;
		
}



///const TCHAR *path,
BOOL ReadimageFromSD (TCHAR *filename, PVOID pBuf,UINT filetype)
{


	UINT i,SecNumber,br;
	pBuf = EBOOT_USB_BUFFER_UA_START;
	
	readPtIndex = pBuf;
	
	switch(filetype)
	{
		case 1:
			g_ImageType = IMAGE_TYPE_EBOOT;
		break;

		case 2:
			g_ImageType = IMAGE_TYPE_LOGO;
		break;

		case 3:
			g_ImageType = IMAGE_TYPE_NK;
		break;

		case 4: // g_ImageType = UpdataConfigFile;


		default:
			g_ImageType =IMAGE_TYPE_UNKNOWN;
		break;
	}


	if(ReadFileFromSD(filename,pBuf,br))
	{
		if(4==filetype)  //ְļ
			if(!Parsing (br, pBuf))
			{

			}


	}else
	{
			
		OALMSG(TRUE, (TEXT("retrun false.\r\n")));	
		return FALSE;

	}

	return TRUE;



}

