;------------------------------------------------------------------------------
;
;  Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
;  Use of this source code is subject to the terms of the Microsoft end-user
;  license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
;  If you did not accept the terms of the EULA, you are not authorized to use
;  this source code. For a copy of the EULA, please see the LICENSE.RTF on your
;  install media.
;
;------------------------------------------------------------------------------
;
;   File:  startup.s
;
;   Hardware startup routine for Samsung SMDKV210 board.
;
;------------------------------------------------------------------------------

    INCLUDE     kxarm.h
    INCLUDE     register_map.inc
    INCLUDE     image_cfg.inc
    INCLUDE		Option.inc

    IMPORT      main                    ; C entrypoint for Steppingstone loader.
    IMPORT      InitDMC
    IMPORT      InitClockCONforBL
    IMPORT      InitCache
    IMPORT		ASM_IsrHandler

	STARTUPTEXT
	
;------------------------------------------------------------------------------
;
;    StartUp Entry
;
;    Main entry point for CPU initialization.
;
;------------------------------------------------------------------------------

    LEAF_ENTRY    StartUp
;------------------------------------------------------------------------------
;   Real Startup Code
;------------------------------------------------------------------------------
        b        ResetHandler
        b        .                ; HandlerUndef     (0x00000004)
        b        .                ; HandlerSWI       (0x00000008)
        b        .                ; HandlerPabort    (0x0000000C)
        b        .                ; HandlerDabort    (0x00000010)
        b        .                ; HandlerReserved  (0x00000014)
        b        ASM_IsrHandler   ; HandlerIRQ       (0x00000018)
        b        ASM_IsrHandler   ; HandlerFIQ       (0x0000001C)

;------------------------------------------------------------------------------
;    End of StartUp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;
;    ResetHandler Function
;
;    Reset Exception Handler
;
;------------------------------------------------------------------------------

ResetHandler

;first
;		b        first
;------------------------------------
;    Interrupt Disable
;------------------------------------
        ldr     r1, =0xFFFFFFFF

        ldr     r0, =VIC0INTENCLEAR
        str     r1, [r0]

        ldr     r0, =VIC1INTENCLEAR
        str     r1, [r0]

        ldr     r0, =VIC2INTENCLEAR
        str     r1, [r0]
   
        ldr     r0, =VIC3INTENCLEAR
        str     r1, [r0]
        
;------------------------------------
;    Set Exception Vector Area to '0'
;------------------------------------
        ldr     r0, =VECTOR_TABLE_ADDRESS
        mcr     p15,0,r0,c12,c0,0		

;------------------------------------
;    Enable Coprocessors
;------------------------------------
        ldr     r0, =0xffffffff
        mcr     p15,0,r0,c1,c0,2		
   
;------------------------------------
;    Initialize Cache
;------------------------------------     
        bl	    InitCache

;---------------------------------------------------------------
;    Initialization TZPC (Must be non-secure in case of using DMA
;---------------------------------------------------------------
        ldr     r0, =TZPC0_R0SIZE
        mov     r1, #0x00
        str     r1, [r0]
        ldr     r0, =TZPC0_DECPROT0Set
        mov     r1, #0xff
        str     r1, [r0]
        ldr     r0, =TZPC0_DECPROT1Set
        str     r1, [r0]

        ldr     r0, =TZPC1_DECPROT0Set
        str     r1, [r0]
        ldr     r0, =TZPC1_DECPROT1Set
        str     r1, [r0]
        ldr     r0, =TZPC1_DECPROT2Set
        str     r1, [r0]

        ldr     r0, =TZPC2_DECPROT0Set
        str     r1, [r0]
        ldr     r0, =TZPC2_DECPROT1Set
        str     r1, [r0]
        ldr     r0, =TZPC2_DECPROT2Set
        str     r1, [r0]
        ldr     r0, =TZPC2_DECPROT3Set
        str     r1, [r0]
        ldr     r0, =TZPC3_DECPROT0Set
        str     r1, [r0]

;------------------------------------------------
;    Configuration ASYNC BRIDGE for Performance
;------------------------------------------------
        [{true}
        ldr     r0, =HALFSYNC0
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        ldr     r0, =ASYNC_INDEX0
        mov     r1, #INDEX_1_1  ;MFC:VSYS0=200:200
        str     r1, [r0]
        ldr     r0, =DMASTER0
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC1
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        ldr     r0, =ASYNC_INDEX1
        mov     r1, #INDEX_1_1  ;MFC:VSYS1=200:200
        str     r1, [r0]
        ldr     r0, =DMASTER1
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC2
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]

        ldr     r0, =ASYNC_INDEX2
        mov     r1, #INDEX_6_5  ;DSYS:MSYS0=166:200
        str     r1, [r0]
        
        ldr     r0, =DMASTER2
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC3
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        ldr     r0, =ASYNC_INDEX3
        mov     r1, #INDEX_6_5  ;DSYS:MSYS1=166:200
        str     r1, [r0]
        ldr     r0, =DMASTER3
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC4       ;MSFR:DSFR
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]

        ldr     r0, =HALFSYNC5       ;MSFR:PSFR
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]

        ldr     r0, =HALFSYNC6
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]

        ldr     r0, =HALFSYNC7       ;MSFR:MPERI
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]

        ldr     r0, =HALFSYNC8
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        ldr     r0, =ASYNC_INDEX8
        mov     r1, #INDEX_5_4  ;PSYS:DSYS=133:166
        str     r1, [r0]
        ldr     r0, =DMASTER8
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC9
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        ldr     r0, =ASYNC_INDEX9
        mov     r1, #INDEX_2_1  ;AUDIO:PSYS=24:133
        str     r1, [r0]
        ldr     r0, =DMASTER9
        mov     r1, #NON_DEFAULT_MASTER  
        str     r1, [r0]

        ldr     r0, =HALFSYNC10       ;PSFR:AUDIO
        mov     r1, #CYCLE_HALF_SYNC  ; using 1/2cycle synchronizer
        str     r1, [r0]
        
        ]


;--------------------------------------------------
;    Initialize Stack
;    Stack size and location information is in "image_cfg.inc"
;--------------------------------------------------
    mrs     r0, cpsr

    bic     r0, r0, #Mode_MASK
    orr     r1, r0, #Mode_IRQ | NOINT
    msr     cpsr_cxsf, r1		; IRQMode
    ldr     sp, =TOP_OF_IRQ_STACK	; IRQStack

    bic     r0, r0, #Mode_MASK | NOINT
    orr     r1, r0, #Mode_SVC
    msr     cpsr_cxsf, r1		; SVCMode
    ldr     sp, =TOP_OF_SVC_STACK	; SVCStack
      
;--------------------------------------------------
;    Set Clock Control 
;--------------------------------------------------
; Here we initialize the clock and PLL control registers.
; The initialization values are defined at 'InitSystem.h'

	bl      InitClockCONforBL

;--------------------------------------------------
;    Initialize DRAM Controller
;--------------------------------------------------
	bl      InitDMC

;------------------------------------
;	Clear IROM Loader RAM
;------------------------------------
    ldr     r0, =ILOADER_RAM_START_ADDR   	
    ldr     r10,=ILOADER_RAM_SIZE
loop
    mov     r1,#0
    mov     r2,#0
    mov     r3,#0
    mov     r4,#0
    mov     r5,#0
    mov     r6,#0
    mov     r7,#0
    mov     r8,#0

    stmia   r0!, {r1-r8}
    subs    r10, r10, #32
    bne     loop

;------------------------------------
;    Jump to Main() "C" Routine
;------------------------------------
;last
;	b         last
    bl        main
loop3
    b         loop3

    ENTRY_END


    END


