//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvd_api.h
//
//  Defines macros, structures, API functions, and etc for the TVout Driver.
//
#ifndef __TDV_API_H
#define __TDV_API_H

#if __cplusplus
    extern "C"
    {
#endif

/*============================================================================*/
// IOCTL
/*============================================================================*/

typedef enum
{
    // Resource Request/Release IOCTL
    STDA_RESOURCE_API_BASE = 100,
    STDA_RSC_REQUEST_TVOUT_INTERFACE,
    STDA_RSC_RELEASE_TVOUT_INTERFACE,
    STDA_RSC_REQUEST_VIDEO_PROCESSOR,
    STDA_RSC_RELEASE_VIDEO_PROCESSOR,
    STDA_RSC_REQUEST_GRAPHIC_0,
    STDA_RSC_RELEASE_GRAPHIC_0,
    STDA_RSC_REQUEST_GRAPHIC_1,
    STDA_RSC_RELEASE_GRAPHIC_1,
    STDA_RESOURCE_API_END,

    // TVOUT Function IOCTL
    STDA_TVOUT_FUNCTION_API_BASE = 200,
    STDA_TVOUT_INIT_INTERFACE_PARAM,
    STDA_TVOUT_START,
    STDA_TVOUT_STOP,
    STDA_TVOUT_GET_INFO,
    STDA_TVOUT_FUNCTION_API_END,

    // Video Layer Function IOCTL
    STDA_VL_FUNCTION_API_BASE = 300,
    STDA_VL_INIT_PROCESSING_PARAM,
    STDA_VL_INIT_BRIGHTNESS_OFFSET,
    STDA_VL_INIT_CONTRAST_BRIGHTNESS,
    STDA_VL_START,
    STDA_VL_STOP,
    STDA_VL_SET_PRIORITY,
    STDA_VL_SET_TOP_ADDRESS,
    STDA_VL_SET_BOTTOM_ADDRESS,
    STDA_VL_SET_FIELD_ID,
    STDA_VL_SET_IMG_SIZE,
    STDA_VL_SET_SRC_POSITION,
    STDA_VL_SET_DEST_POSITION,
    STDA_VL_SET_SRC_SIZE,
    STDA_VL_SET_DEST_SIZE,
    STDA_VL_SET_BRIGHTNESS_OFFSET,
    STDA_VL_SET_CONTRAST_BRIGHTNESS,
    STDA_VL_GET_PRIORITY,
    STDA_VL_FUNCTION_API_END,

    // Graphic x Function IOCTL
    STDA_GRP_FUNCTION_API_BASE = 400,
    STDA_GRP0_INIT_PROCESSING_PARAM,
    STDA_GRP0_START,
    STDA_GRP0_STOP,
    STDA_GRP0_SET_PRIORITY,
    STDA_GRP0_SET_BASE_ADDRESS,
    STDA_GRP0_SET_DEST_POSITION,
    STDA_GRP0_GET_PRIORITY,
    STDA_GRP1_INIT_PROCESSING_PARAM,
    STDA_GRP1_START,
    STDA_GRP1_STOP,
    STDA_GRP1_SET_PRIORITY,
    STDA_GRP1_SET_BASE_ADDRESS,
    STDA_GRP1_SET_DEST_POSITION,
    STDA_GRP1_GET_PRIORITY,
    STDA_GRP_FUNCTION_API_END,

    // Back Ground Function IOCTL
    STDA_BG_FUNCTION_API_BASE = 500,
    STDA_BG_INIT_COLOR,
    STDA_BG_FUNCTION_API_END,

    // Video Mixer Function IOCTL
    STDA_VM_FUNCTION_API_BASE = 600,
    STDA_VM_FUNCTION_API_END,

    // SDout Function IOCTL
    STDA_SDOUT_FUNCTION_API_BASE = 700,
    STDA_SDOUT_FUNCTION_API_END,

    // HDMI Function IOCTL
    STDA_HDMI_FUNCTION_API_BASE = 800,
    STDA_HDMI_INIT_SPD_INFOFRAME,
    STDA_HDMI_INIT_HDCP_EN,
    STDA_HDMI_INIT_AUDIO,
	STDA_HDMI_AUDIO_EN,
    STDA_HDMI_GET_HPD_STATUS,
    STDA_HDMI_WAIT_HPD_STATUS_CHANGE,
    STDA_HDMI_AVAILABLE_MODE,
    STDA_HDMI_FUNCTION_API_END,

    // Power Management IOCTL
    STDA_PM_POWER_API_BASE = 900,
    STDA_PM_SET_SLEEP,
    STDA_PM_SET_WAKEUP,
    STDA_PM_GET_POWER_STATUS,
    STDA_PM_POWER_API_END,

    STDA_API_ENUM_END
}STDA_API_FUNCTION_CODE;    // 0x0 ~ 0xFFF



#define    STDA_DEVICE_TYPE    (0xB000)        // STDA-unique device type

// Resource Request/Release IOCTL
#define    IOCTL_STDA_RSC_REQUEST_TVOUT_INTERFACE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_REQUEST_TVOUT_INTERFACE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_RELEASE_TVOUT_INTERFACE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_RELEASE_TVOUT_INTERFACE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_REQUEST_VIDEO_PROCESSOR    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_REQUEST_VIDEO_PROCESSOR, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_RELEASE_VIDEO_PROCESSOR    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_RELEASE_VIDEO_PROCESSOR, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_REQUEST_GRAPHIC_0    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_REQUEST_GRAPHIC_0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_RELEASE_GRAPHIC_0    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_RELEASE_GRAPHIC_0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_REQUEST_GRAPHIC_1    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_REQUEST_GRAPHIC_1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_RSC_RELEASE_GRAPHIC_1    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_RSC_RELEASE_GRAPHIC_1, METHOD_BUFFERED, FILE_ANY_ACCESS)

// TVOUT Function IOCTL
#define    IOCTL_STDA_TVOUT_INIT_INTERFACE_PARAM    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_TVOUT_INIT_INTERFACE_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_TVOUT_START    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_TVOUT_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_TVOUT_STOP    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_TVOUT_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_TVOUT_GET_INFO    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_TVOUT_GET_INFO, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Video Layer Function IOCTL
#define    IOCTL_STDA_VL_INIT_PROCESSING_PARAM    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_INIT_PROCESSING_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_INIT_BRIGHTNESS_OFFSET    \
				CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_INIT_BRIGHTNESS_OFFSET, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_INIT_CONTRAST_BRIGHTNESS    \
				CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_INIT_CONTRAST_BRIGHTNESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_START    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_STOP    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_TOP_ADDRESS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_TOP_ADDRESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_BOTTOM_ADDRESS    \
				CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_BOTTOM_ADDRESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_FIELD_ID    \
				CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_FIELD_ID, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_IMG_SIZE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_IMG_SIZE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_SRC_POSITION    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_SRC_POSITION, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_DEST_POSITION    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_DEST_POSITION, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_SRC_SIZE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_SRC_SIZE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_DEST_SIZE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_DEST_SIZE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_BRIGHTNESS_OFFSET    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_BRIGHTNESS_OFFSET, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_SET_CONTRAST_BRIGHTNESS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_SET_CONTRAST_BRIGHTNESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_VL_GET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_VL_GET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Graphic x Function IOCTL
#define    IOCTL_STDA_GRP0_INIT_PROCESSING_PARAM    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_INIT_PROCESSING_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_START    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_STOP    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_SET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_SET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_SET_BASE_ADDRESS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_SET_BASE_ADDRESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_SET_DEST_POSITION    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_SET_DEST_POSITION, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP0_GET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP0_GET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_INIT_PROCESSING_PARAM    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_INIT_PROCESSING_PARAM, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_START    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_START, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_STOP   \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_STOP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_SET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_SET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_SET_BASE_ADDRESS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_SET_BASE_ADDRESS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_SET_DEST_POSITION    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_SET_DEST_POSITION, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_GRP1_GET_PRIORITY    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_GRP1_GET_PRIORITY, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Back Ground Function IOCTL
#define    IOCTL_STDA_BG_INIT_COLOR    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_BG_INIT_COLOR, METHOD_BUFFERED, FILE_ANY_ACCESS)

// SDout Function IOCTL
#define    IOCTL_STDA_SDOUT_INIT_OUTPUT_ORDER    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_SDOUT_INIT_OUTPUT_ORDER, METHOD_BUFFERED, FILE_ANY_ACCESS)

// HDMI Function IOCTL
// Video
// etc
#define    IOCTL_STDA_HDMI_INIT_SPD_INFOFRAME    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_INIT_SPD_INFOFRAME, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_INIT_HDCP_EN    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_INIT_HDCP_EN, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_INIT_AUDIO    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_INIT_AUDIO, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_AUDIO_EN    \
					CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_AUDIO_EN, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_GET_HPD_STATUS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_GET_HPD_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_WAIT_HPD_STATUS_CHANGE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_WAIT_HPD_STATUS_CHANGE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_HDMI_AVAILABLE_MODE    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_HDMI_AVAILABLE_MODE, METHOD_BUFFERED, FILE_ANY_ACCESS)


// Power Management IOCTL
#define    IOCTL_STDA_PM_SET_SLEEP        \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_PM_SET_SLEEP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_PM_SET_WAKEUP        \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_PM_SET_WAKEUP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define    IOCTL_STDA_PM_GET_POWER_STATUS    \
        CTL_CODE(STDA_DEVICE_TYPE, STDA_PM_GET_POWER_STATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*============================================================================*/
// enum
/*============================================================================*/

// common

#define HDMI_START_NUM 0x1000

typedef enum
{
    TVOUT_LITTLE_ENDIAN_MODE = 0,
    TVOUT_BIG_ENDIAN_MODE = 1
}TVOUT_ENDIAN_FORMAT_TYPE;

typedef enum
{
    TVOUT_NTSC_M = 0,
	TVOUT_NTSC_J,
    TVOUT_PAL_BDGHI,
    TVOUT_PAL_M,
    TVOUT_PAL_N,
    TVOUT_PAL_NC,
    TVOUT_PAL_60,
    TVOUT_NTSC_443,
    TVOUT_480P_60_16_9 = HDMI_START_NUM,
    TVOUT_480P_60_4_3,
    TVOUT_576P_50_16_9,
    TVOUT_576P_50_4_3,
    TVOUT_720P_60,
    TVOUT_1080I_60,
    TVOUT_1080P_30,
    TVOUT_1080P_60    
}TVOUT_DISPLAY_MODE;

typedef enum
{
    TVOUT_OUTPUT_COMPOSITE,
    TVOUT_OUTPUT_HDMI,
    TVOUT_OUTPUT_DVI,
    TVOUT_OUTPUT_HDMI_YCBCR
}TVOUT_OUTPUT_MODE;

// power

typedef enum
{
    TVOUT_POWER_ERROR_NO_ERROR = 0,
    TVOUT_POWER_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x5000,
    TVOUT_POWER_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    TVOUT_POWER_ERROR_INVALID_PARAM
}TVOUT_POWER_ERROR;


// clock

typedef enum
{
    TVOUT_CLK_ERROR_NO_ERROR = 0,
    TVOUT_CLK_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x4000,
    TVOUT_CLK_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    TVOUT_CLK_ERROR_INVALID_PARAM
}TVOUT_CLK_ERROR;


// video processor

typedef enum
{
    VPROC_NO_ERROR = 0,
    VPROC_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x2000,
    VPROC_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    VPROC_ERROR_BASE_ADDRESS_MUST_DOUBLE_WORD_ALIGN,
    VPROC_ERROR_NOT_UPDATE_FOR_ANOTHER_UPDATE,
    VPROC_ERROR_INVALID_PARAM
}VPROC_ERROR;

typedef enum
{
    VPROC_SRC_COLOR_NV12  = 0,
    VPROC_SRC_COLOR_NV12IW  = 1,
    VPROC_SRC_COLOR_NV12IB  = 2,
    VPROC_SRC_COLOR_TILE_NV12  = 3,
    VPROC_SRC_COLOR_TILE_NV12IW  = 4,
    VPROC_SRC_COLOR_TILE_NV12IB  = 5
}VPROC_SRC_COLOR_FORMAT;

typedef enum
{
	VPROC_SRC_CODEC_PROGRESSIVE = 0,
	VPROC_SRC_CODEC_INTERLACE = 1,
	VPROC_SRC_CODEC_INTERLACE_2PLANE = 2
}VPROC_SRC_CODEC_FORMAT;

typedef enum
{
	VProc_LINE_EQ_0  = 0,
	VProc_LINE_EQ_1  = 1,
	VProc_LINE_EQ_2  = 2,
	VProc_LINE_EQ_3  = 3,
	VProc_LINE_EQ_4  = 4,
	VProc_LINE_EQ_5  = 5,
	VProc_LINE_EQ_6  = 6,
	VProc_LINE_EQ_7  = 7
}VPROC_LINE_EQ_NUM;


// video mixer

typedef enum
{
    VMIXER_NO_ERROR = 0,
    VMIXER_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x1000,
    VMIXER_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    VMIXER_ERROR_BASE_ADDRESS_MUST_WORD_ALIGN,
    VMIXER_ERROR_INVALID_PARAM
}VMIXER_ERROR;

typedef enum
{
    VM_DIRECT_RGB565  = 4,
    VM_DIRECT_RGB1555 = 5,
    VM_DIRECT_RGB4444 = 6,
    VM_DIRECT_RGB8888 = 7
}VMIXER_COLOR_FORMAT;


// TV encoder

typedef enum
{
    SDOUT_NO_ERROR = 0,
    SDOUT_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x3000,
    SDOUT_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    SDOUT_ERROR_INVALID_PARAM
}SDOUT_ERROR;

// HDMI

typedef enum
{
    HDMI_NO_ERROR = 0,
    HDMI_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x6000,
    HDMI_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    HDMI_ERROR_INVALID_PARAM
}HDMI_ERROR;

typedef enum
{
    HDMI_DO_NOT_TANS = 0,
    HDMI_TRANS_ONCE,
    HDMI_TRANS_EVERY_SYNC
}HDMI_TRANSMIT_TYPE;

typedef enum
{
    HDMI_AUDIO_NO,
    HDMI_AUDIO_PCM
}HDMI_AUDIO_TYPE;

typedef enum
{
	HDMI_EINT_MODE,
	HDMI_HPD_MODE
}HDMI_PIN_STATUS;

// STDA

typedef enum
{
    STDA_NO_ERROR = 0,
    STDA_ERROR_NOT_INIT_PARAMETERS_UNDER_RUNNING = 0x7000,
    STDA_ERROR_NOT_SET_PARAMETERS_UNDER_STOP,
    STDA_ERROR_INVALID_PARAM
}STDA_ERROR;


// Interrupt


/*============================================================================*/
// structure
/*============================================================================*/

typedef struct _TVOUT_OUTPUT_IF
{
    TVOUT_DISPLAY_MODE  dispMode;
    TVOUT_OUTPUT_MODE   outMode;
} TVOUT_OUTPUT_IF, *pTVOUT_OUTPUT_IF;

typedef struct _STDA_ARG_IMG_SIZE
{
    unsigned int uiImgWidth;
    unsigned int uiImgHeight;
}STDA_ARG_IMG_SIZE, *pSTDA_ARG_IMG_SIZE;

typedef struct _STDA_ARG_IMG_OFFSET
{
    unsigned int uiOffsetX;
    unsigned int uiOffsetY;
}STDA_ARG_IMG_OFFSET, *pSTDA_ARG_IMG_OFFSET;

typedef struct _TVOUT_OUTPUT_INFO
{
    TVOUT_DISPLAY_MODE  dispMode;
    TVOUT_OUTPUT_MODE   outMode;
    BOOL    bTVon;
    BOOL    bVPon;
    BOOL    bGRP0;
    BOOL    bGRP1;
} TVOUT_OUTPUT_INFO, *pTVOUT_OUTPUT_INFO;


/*============================================================================*/
// Video Layer Data

typedef struct _STDA_ARG_VIDEO_IMG_ADDRESS
{
    unsigned int uiYAddress;
    unsigned int uiCAddress;
}STDA_ARG_VIDEO_IMG_ADDRESS, *pSTDA_ARG_VIDEO_IMG_ADDRESS;

typedef struct _STDA_ARG_VIDEO_BASIC_PARAM
{
    BOOL bWinBlending;
    VPROC_SRC_COLOR_FORMAT srcColor;
    VPROC_SRC_CODEC_FORMAT srcCodec;	
    unsigned int uiAlpha;
    unsigned int uiPriority;
    unsigned int uiTopYAddress;
    unsigned int uiTopCAddress;
    TVOUT_ENDIAN_FORMAT_TYPE srcImgEndian;
    unsigned int uiImgWidth;
    unsigned int uiImgHeight;
    unsigned int uiSrcOffsetX;
    unsigned int uiSrcOffsetY;
    unsigned int uiSrcWidth;
    unsigned int uiSrcHeight;
    unsigned int uiDestOffsetX;
    unsigned int uiDestOffsetY;
    unsigned int uiDestWidth;
    unsigned int uiDestHeight;
}STDA_ARG_VIDEO_BASIC_PARAM, *pSTDA_ARG_VIDEO_BASIC_PARAM;

typedef struct _STDA_ARG_VIDEO_BRIGHTNESS_CONTRAST_CONTROL
{
	VPROC_LINE_EQ_NUM eqNum;
	unsigned int uiIntc;
	unsigned int uiSlope;
}STDA_ARG_VIDEO_BRIGHTNESS_CONTRAST_CONTROL, *PSTDA_ARG_VIDEO_BRIGHTNESS_CONTRAST_CONTROL;


/*============================================================================*/
// GRP Layer Data

typedef struct _STDA_ARG_GRP_IMG_ADDRESS
{
	unsigned int uiRGBAddress;
}STDA_ARG_GRP_IMG_ADDRESS, *pSTDA_ARG_GRP_IMG_ADDRESS;


typedef struct _STDA_ARG_GRP_BASIC_PARAM
{
    BOOL bWinBlending;
    unsigned int uiAlpha;
    unsigned int uiPriority;
    VMIXER_COLOR_FORMAT color;
    BOOL bBlankChange;
    BOOL bPixelBlending;
    BOOL bPreMul;
    unsigned int uiBlankColor;
    unsigned int uiBaseAddress;
    unsigned int uiSpan;
    unsigned int uiWidth;
    unsigned int uiHeight;
    unsigned int uiSrcOffsetX;
    unsigned int uiSrcOffsetY;
    unsigned int uiDestOffsetX;
    unsigned int uiDestOffsetY;
	unsigned int uiScaleEnH;
	unsigned int uiScaleEnV;
}STDA_ARG_GRP_BASIC_PARAM, *pSTDA_ARG_GRP_BASIC_PARAM;


/*============================================================================*/
// BG Layer Data

typedef struct _STDA_ARG_BG_COLOR
{
    unsigned int uiColorY;
    unsigned int uiColorCb;
    unsigned int uiColorCr;
}STDA_ARG_BG_COLOR, *pSTDA_ARG_BG_COLOR;


/*============================================================================*/
// Video Mixer Data


/*============================================================================*/
// HDMI video Data


/*============================================================================*/
// HDMI Data

typedef struct _STDA_ARG_HDMI_SPD_INFOFRAME
{
    HDMI_TRANSMIT_TYPE transType;
    unsigned char *pucSpdHeader;
    unsigned char *pucSpdData;
}STDA_ARG_HDMI_SPD_INFOFRAME, *pSTDA_ARG_HDMI_SPD_INFOFRAME;

typedef struct _STDA_ARG_HDMI_AVAILABLE_MODE
{
// HDMI_RGB Video Resolution
//-----------------------------------------------------------	
    BOOL bHDMI_480P_16_9;
    BOOL bHDMI_480P_4_3;
    BOOL bHDMI_576P_16_9;
    BOOL bHDMI_576P_4_3;
    BOOL bHDMI_720P_60_16_9;
	BOOL bHDMI_1080P_60_16_9;
	BOOL bHDMI_1080P_30_16_9;
	BOOL bHDMI_1080I_60_16_9;
//Audio
//-----------------------------------------------------------
    BOOL bLPCM2CH;
//Color Space
//-----------------------------------------------------------
	BOOL bHDMI_CS_RGB;
	BOOL bHDMI_CS_YCBCR444;
	BOOL bHDMI_CS_YCBCR422;
//Colorimetry	
//-----------------------------------------------------------
	// You do not need to parse if not extended colorimetry
	// So, If you query above value, always return TRUE.
	// HDMI_COLORIMETRY_NO_DATA, 
	// HDMI_COLORIMETRY_ITU601,
	// HDMI_COLORIMETRY_ITU709
	BOOL bHDMI_COLORIMETRY_EXTENDED_xvYCC601;
	BOOL bHDMI_COLORIMETRY_EXTENDED_xvYCC709;
//Color Depth
//-----------------------------------------------------------
	BOOL bHDMI_CD_36_HDMI_CS_RGB;
	BOOL bHDMI_CD_36_HDMI_CS_YCBCR444;
	BOOL bHDMI_CD_36_HDMI_CS_YCBCR422;
	
	BOOL bHDMI_CD_30_HDMI_CS_RGB;
	BOOL bHDMI_CD_30_HDMI_CS_YCBCR444;
	BOOL bHDMI_CD_30_HDMI_CS_YCBCR422;

	BOOL bHDMI_CD_24_HDMI_CS_RGB;
	BOOL bHDMI_CD_24_HDMI_CS_YCBCR444;
	BOOL bHDMI_CD_24_HDMI_CS_YCBCR422;
	
//-----------------------------------------------------------
//HDMI/DVI
	BOOL bHDMI_DVI; //TRUE HDMI and DVI, FALSE Only DVI
//-----------------------------------------------------------

}STDA_ARG_HDMI_AVAILABLE_MODE, *pSTDA_ARG_HDMI_AVAILABLE_MODE;


#if __cplusplus
    }
#endif

#endif    // __TDV_API_H


