//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Module: DeepIdle.h
//
//  Interface to Deep Idle for LP Mode.
//
//      History :
//              [2009.09.01 JUN] The sources are crated at first
//
#include <windows.h>
#include <ceddk.h>
#include <oal.h>
#include <register_map.h>
//#include <FSR.h>
//#include <FSR_LLD_OneNAND.h>
#include "soc_cfg.h"
#include "base_regs.h"
#include "bsp_gpio.h"
#include "bsp_args.h"

#ifndef __DEEPIDLE_H__
#define __DEEPIDLE_H__

void DeepIdle_Init(void);
BOOL DeepIdle_CheckEnterDeepIdle();
void PreConfigureDeepIdle();
void OALCPUDeepIdle();
BOOL DeepIdle_WakeupSrc(void * SharedArgs, DWORD PHYIRQ_ID);

#endif // __DEEPIDLE_H__

