//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: vmixer_reg.h
//
//  Defines the Video Mixer CPU register layout and definitions.
//
#ifndef __VMIXER_REG_H
#define __VMIXER_REG_H

#if __cplusplus
	extern "C"
	{
#endif

typedef struct
{
	// Mixer global setting
	UINT32 MIXER_STATUS;						//0x00,
	UINT32 MIXER_CFG;							//0x04,

	// Mixer int.
	UINT32 MIXER_INT_EN;						//0x08,
	UINT32 MIXER_INT_STATUS;					//0x0c,

	// Video & blender configuration
	UINT32 MIXER_LAYER_CFG;					//0x10,
	UINT32 MIXER_VIDEO_CFG;					//0x14,
	UINT32 MIXER_VIDEO_LIMITER_PA_RA_CFG;	//0x18,
	UINT32 PAD0[1];								//0x1c

	// Graphic0 layer configuration
	UINT32 MIXER_GRAPH0_CFG;					//0x20,
	UINT32 MIXER_GRAPH0_BASE;					//0x24,
	UINT32 MIXER_GRAPH0_SPAN;					//0x28,
	UINT32 MIXER_GRAPH0_SXY;					//0x2c,
	UINT32 MIXER_GRAPH0_WH;					//0x30,
	UINT32 MIXER_GRAPH0_DXY;					//0x34,
	UINT32 MIXER_GRAPH0_BLANK;				//0x38,
	UINT32 PAD1;								//0x3c

	// Graphic1 layer configuration
	UINT32 MIXER_GRAPH1_CFG;					//0x40,
	UINT32 MIXER_GRAPH1_BASE;					//0x44,
	UINT32 MIXER_GRAPH1_SPAN;					//0x48,
	UINT32 MIXER_GRAPH1_SXY;					//0x4c,
	UINT32 MIXER_GRAPH1_WH;					//0x50,
	UINT32 MIXER_GRAPH1_DXY;					//0x54,
	UINT32 MIXER_GRAPH1_BLANK;				//0x58,
	UINT32 PAD2;								//0x5c

	// Background layer configuration
	UINT32 PAD3;								//0x60,
	UINT32 MIXER_BG_COLOR0;					//0x64,
	UINT32 MIXER_BG_COLOR1;					//0x68,
	UINT32 MIXER_BG_COLOR2;					//0x6c,
	UINT32 PAD4[4];								//0x70, 0x74, 0x78, 0x7c

	// Color space conversion coefficient
	UINT32 MIXER_CM_COEFF_Y;					//0x80,
	UINT32 MIXER_CM_COEFF_CB;					//0x84,
	UINT32 MIXER_CM_COEFF_CR;					//0x88

	UINT32 PAD5[94];								//0x8C ~ 0x19C

	UINT32 MIXER_STATUS_S;						//0x200,
} VMIXER_REG, *PVMIXER_REG;

#if __cplusplus
	}
#endif

#endif    // __VMIXER_REG_H