//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  File:  soc_cfg.h
//
//  This file contains system constant specific for SMDKV210 board.
//
#ifndef __SOC_CFG_H
#define __SOC_CFG_H

#include "InitSystem.h"
#define LITTLE_ENDIAN

//------------------------------------------------------------------------------
// CLOCK settings.
// : Following values are pre-defined at "InitSystem.h"
//------------------------------------------------------------------------------
#define PCLKPSYS        PCLKPSYS_CLK_BL

//------------------------------------------------------------------------------
// System Tick Timer Definition
//------------------------------------------------------------------------------
// For Precision of System timer
// Use timer counter as large as possible. (32-bit Counter)
// Use timer divider as small as possible.
#define SYS_TIMER_PRESCALER	            1
#define SYS_TIMER_DIVIDER               1
#define OEM_CLOCK_FREQ					(FIN/(SYS_TIMER_PRESCALER+1)/SYS_TIMER_DIVIDER)	// 6,600,000

// Timer count for 1 ms
#define OEM_COUNT_1MS				    (OEM_CLOCK_FREQ / 1000)
#define RESCHED_PERIOD    				1	// Reschedule period in ms
 
#define PWM0_1_PRESCALER                ((int)(PCLKPSYS/1000000)-1)
#define PWM0_DIVIDER                    1   //PWM0 for backlight(1Count:2us)

#ifdef BSP_USEDVFS
#define SYSINTR_DVFS        0xDEADBABE
#endif

//------------------------------------------------------------------------------
// SMDKV210 TIMER(System Timer) GPIO-LED Display
//------------------------------------------------------------------------------
#define TIMER_LED_DISPLAY       1

//------------------------------------------------------------------------------
#define SYSINTR_ETH          (SYSINTR_FIRMWARE+19)   // for DM9000A

#ifdef BSP_ETH_EINT9 
#define ETH_EINT9 
#endif
//#define ETH_EINT9 

#endif  // !__SOC_CFG_H
