//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: sdout_reg.h
//
//  Defines the TVOUT & VIDEO DAC CPU register layout and definitions.
//
#ifndef __SDOUT_REG_H
#define __SDOUT_REG_H

#if __cplusplus
	extern "C"
	{
#endif

typedef struct
{
	UINT32 SDO_CLKCON;					//0X000,
	UINT32 PAD0;						//0x004
	UINT32 SDO_CONFIG;					//0X008,
	UINT32 SDO_SCALE;					//0X00C,

	UINT32 SDO_SYNC;					//0X010,
	UINT32 SDO_VBI;						//0X014,
	UINT32 PAD1;						//0x018
	UINT32 SDO_SCALE_CH0;				//0X01C,

	UINT32 SDO_SCALE_CH1;				//0X020,
	UINT32 SDO_SCALE_CH2;				//0X024,
	UINT32 PAD2[3];						//0x028
										//0x02c

										//0x030
	UINT32 SDO_YCDELAY;				//0X034,
	UINT32 SDO_SCHLOCK;				//0X038,
	UINT32 SDO_DAC;						//0X03C,

	UINT32 SDO_FINFO;					//0x040,  // Read only
	UINT32 SDO_Y0;						//0X044,
	UINT32 SDO_Y1;						//0X048,
	UINT32 SDO_Y2;						//0X04C,

	UINT32 SDO_Y3;						//0X050,
	UINT32 SDO_Y4;						//0X054,
	UINT32 SDO_Y5;						//0X058,
	UINT32 SDO_Y6;						//0X05C,

	UINT32 SDO_Y7;						//0X060,
	UINT32 SDO_Y8;						//0X064,
	UINT32 SDO_Y9;						//0X068,
	UINT32 SDO_Y10;						//0X06C,

	UINT32 SDO_Y11;						//0X070,
	UINT32 PAD3[3];						//0x074
										//0x078
										//0x07c

	UINT32 SDO_CB0;						//0X080,
	UINT32 SDO_CB1;						//0X084,
	UINT32 SDO_CB2;						//0X088,
	UINT32 SDO_CB3;						//0X08C,

	UINT32 SDO_CB4;						//0X090,
	UINT32 SDO_CB5;						//0X094,
	UINT32 SDO_CB6;						//0X098,
	UINT32 SDO_CB7;						//0X09C,

	UINT32 SDO_CB8;						//0X0A0,
	UINT32 SDO_CB9;						//0X0A4,
	UINT32 SDO_CB10;					//0X0A8,
	UINT32 SDO_CB11;					//0X0AC,

	UINT32 PAD4[4];						//0x0b0
										//0x0b4
										//0x0b8
										//0x0bc

	UINT32 SDO_CR0;						//0X0C0,
	UINT32 SDO_CR1;						//0X0C4,
	UINT32 SDO_CR2;						//0X0C8,
	UINT32 SDO_CR3;						//0X0CC,

	UINT32 SDO_CR4;						//0X0D0,
	UINT32 SDO_CR5;						//0X0D4,
	UINT32 SDO_CR6;						//0X0D8,
	UINT32 SDO_CR7;						//0X0DC,

	UINT32 SDO_CR8;						//0X0E0,
	UINT32 SDO_CR9;						//0X0E4,
	UINT32 SDO_CR10;					//0X0E8,
	UINT32 SDO_CR11;					//0X0EC,

	UINT32 PAD5[4];						//0x0f0
										//0x0f4
										//0x0f8
										//0x0fc
	UINT32 PAD6[24];						//0x100~0x160
	UINT32 PAD7[8];						//0x160
										//0x164
										//0x168
										//0x16c

										//0x170
										//0x174
										//0x178
										//0x17c

	UINT32 SDO_CCCON;					//0X180,
	UINT32 SDO_YSCALE;					//0X184,
	UINT32 SDO_CBSCALE;				//0X188,
	UINT32 SDO_CRSCALE;				//0X18C,

// ================================================================
	UINT32 SDO_CB_CR_OFFSET;			//0X190,
	UINT32 SDO_RGB_CC;					//0X194,
	UINT32 SDO_CVBS_CC_Y1;				//0X198,
	UINT32 SDO_CVBS_CC_Y2;				//0X19C,

	UINT32 SDO_CVBS_CC_C;				//0X1A0,
	UINT32 SDO_YC_CC_Y;				//0X1A4,
	UINT32 SDO_YC_CC_C;				//0X1A8,
	UINT32 PAD8;						//0x1ac

	UINT32 SDO_CSC_525_PORCH;			//0X1B0,
	UINT32 SDO_CSC_625_PORCH;			//0X1B4,
	UINT32 PAD9[2];						//0x1b8
										//0x1bc
// ================================================================

	UINT32 SDO_RGBSYNC;				//0X1C0,
	UINT32 PAD10[15];					//0x1c4
										//0x1c8
										//0x1cc

										//0x1d0
										//0x1d4
										//0x1d8
										//0x1dc

										//0x1e0
										//0x1e4
										//0x1e8
										//0x1ec

										//0x1f0
										//0x1f4
										//0x1f8
										//0x1fc

// ================================================================
	UINT32 SDO_OSFC00_0;				//0X200,
	UINT32 SDO_OSFC01_0;				//0X204,
	UINT32 SDO_OSFC02_0;				//0X208,
	UINT32 SDO_OSFC03_0;				//0X20C,

	UINT32 SDO_OSFC04_0;				//0X210,
	UINT32 SDO_OSFC05_0;				//0X214,
	UINT32 SDO_OSFC06_0;				//0X218,
	UINT32 SDO_OSFC07_0;				//0X21C,

	UINT32 SDO_OSFC08_0;				//0X220,
	UINT32 SDO_OSFC09_0;				//0X224,
	UINT32 SDO_OSFC10_0;				//0X228,
	UINT32 SDO_OSFC11_0;				//0X22C,

	UINT32 SDO_OSFC12_0;				//0X230,
	UINT32 SDO_OSFC13_0;				//0X234,
	UINT32 SDO_OSFC14_0;				//0X238,
	UINT32 SDO_OSFC15_0;				//0X23C,

	UINT32 SDO_OSFC16_0;				//0X240,
	UINT32 SDO_OSFC17_0;				//0X244,
	UINT32 SDO_OSFC18_0;				//0X248,
	UINT32 SDO_OSFC19_0;				//0X24C,

	UINT32 SDO_OSFC20_0;				//0X250,
	UINT32 SDO_OSFC21_0;				//0X254,
	UINT32 SDO_OSFC22_0;				//0X258,
	UINT32 SDO_OSFC23_0;				//0X25C,

	UINT32 SDO_XTALK0;					//0X260,
	UINT32 SDO_XTALK1;					//0X264,
	UINT32 SDO_XTALK2;					//0X268,
	UINT32 SDO_BB_CTRL;				//0X26C,

	UINT32 PAD11[4];						//0x270
										//0x274
										//0x278
										//0x27c
// ================================================================

	UINT32 SDO_IRQ;						//0X280,
	UINT32 SDO_IRQMASK;				//0X284,
	UINT32 PAD12[14];					//0x288
										//0x28c

										//0x290
										//0x294
										//0x298
										//0x29c

										//0x2a0
										//0x2a4
										//0x2a8
										//0x2ac

										//0x2b0
										//0x2b4
										//0x2b8
										//0x2bc

	// ================================================================
	UINT32 SDO_OSFC00_1;				//0X2C0,
	UINT32 SDO_OSFC01_1;				//0X2C4,
	UINT32 SDO_OSFC02_1;				//0X2C8,
	UINT32 SDO_OSFC03_1;				//0X2CC,

	UINT32 SDO_OSFC04_1;				//0X2D0,
	UINT32 SDO_OSFC05_1;				//0X2D4,
	UINT32 SDO_OSFC06_1;				//0X2D8,
	UINT32 SDO_OSFC07_1;				//0X2DC,

	UINT32 SDO_OSFC08_1;				//0X2E0,
	UINT32 SDO_OSFC09_1;				//0X2E4,
	UINT32 SDO_OSFC10_1;				//0X2E8,
	UINT32 SDO_OSFC11_1;				//0X2EC,

	UINT32 SDO_OSFC12_1;				//0X2F0,
	UINT32 SDO_OSFC13_1;				//0X2F4,
	UINT32 SDO_OSFC14_1;				//0X2F8,
	UINT32 SDO_OSFC15_1;				//0X2FC,

	UINT32 SDO_OSFC16_1;				//0X300,
	UINT32 SDO_OSFC17_1;				//0X304,
	UINT32 SDO_OSFC18_1;				//0X308,
	UINT32 SDO_OSFC19_1;				//0X30C,

	UINT32 SDO_OSFC20_1;				//0X310,
	UINT32 SDO_OSFC21_1;				//0X314,
	UINT32 SDO_OSFC22_1;				//0X318,
	UINT32 SDO_OSFC23_1;				//0X31C,

	UINT32 SDO_OSFC00_2;				//0X320,
	UINT32 SDO_OSFC01_2;				//0X324,
	UINT32 SDO_OSFC02_2;				//0X328,
	UINT32 SDO_OSFC03_2;				//0X32C,

	UINT32 SDO_OSFC04_2;				//0X330,
	UINT32 SDO_OSFC05_2;				//0X334,
	UINT32 SDO_OSFC06_2;				//0X338,
	UINT32 SDO_OSFC07_2;				//0X33C,

	UINT32 SDO_OSFC08_2;				//0X340,
	UINT32 SDO_OSFC09_2;				//0X344,
	UINT32 SDO_OSFC10_2;				//0X348,
	UINT32 SDO_OSFC11_2;				//0X34C,

	UINT32 SDO_OSFC12_2;				//0X350,
	UINT32 SDO_OSFC13_2;				//0X354,
	UINT32 SDO_OSFC14_2;				//0X358,
	UINT32 SDO_OSFC15_2;				//0X35C,

	UINT32 SDO_OSFC16_2;				//0X360,
	UINT32 SDO_OSFC17_2;				//0X364,
	UINT32 SDO_OSFC18_2;				//0X368,
	UINT32 SDO_OSFC19_2;				//0X36C,

	UINT32 SDO_OSFC20_2;				//0X370,
	UINT32 SDO_OSFC21_2;				//0X374,
	UINT32 SDO_OSFC22_2;				//0X378,
	UINT32 SDO_OSFC23_2;				//0X37C,

// ================================================================
// Shadow Registers

	UINT32 SDO_CC;						//0x380,
	UINT32 SDO_WSS525;					//0x384,
	UINT32 SDO_WSS625;					//0x388,
	UINT32 SDO_CGMS525;				//0x38C,

	UINT32 PAD13;						//0X390,
	UINT32 SDO_CGMS625;				//0x394,
// ================================================================

	UINT32 PAD14[10]; 
										//0x398
										//0x39c

										//0x3a0
										//0x3a4
										//0x3a8
										//0x3ac

										//0x3b0
										//0x3b4
										//0x3b8
										//0x3bc

// ================================================================
//
	UINT32 SDO_ARMCC;					//0x3C0,
	UINT32 SDO_ARMWSS525;				//0x3C4,
	UINT32 SDO_ARMWSS625;				//0x3C8,
	UINT32 SDO_ARMCGMS525;			//0x3CC,

	UINT32 PAD15;						//0X3D0,
	UINT32 SDO_ARMCGMS625;			//0x3D4,
	UINT32 SDO_VERSION;				//0X3D8
} SDOUT_REG, *PSDOUT_REG;

#if __cplusplus
}
#endif

#endif    // __SDOUT_REG_H