;
; Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
; Use of this source code is subject to the terms of the Microsoft end-user
; license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
; If you did not accept the terms of the EULA, you are not authorized to use
; this source code. For a copy of the EULA, please see the LICENSE.RTF on your
; install media.
;
;-------------------------------------------------------------------------------
;
;  Header: register_map.inc
;
;  This header file defines only those registers required by the startup
;  code. All addresses are based off the physical addresses (PA) defined
;  in base_reg.h (base_reg.inc).
;
;-------------------------------------------------------------------------------

    INCLUDE base_regs.inc



;---------------------------
; CPSR Mode Bit Definition
;---------------------------
Mode_USR    EQU    (0x10)
Mode_FIQ    EQU    (0x11)
Mode_IRQ    EQU    (0x12)
Mode_SVC    EQU    (0x13)
Mode_ABT    EQU    (0x17)
Mode_UND    EQU    (0x1B)
Mode_SYS    EQU    (0x1F)
Mode_MASK   EQU    (0x1F)
NOINT       EQU    (0xC0)
I_Bit       EQU    (0x80)
F_Bit       EQU    (0x40)

;---------------------------
; CP15 Mode Bit Definition
;---------------------------
R1_EV       EQU    (1<<30)      ; Exception Vector Selection
R1_I        EQU    (1<<12)      ; Enable Instruction Cache
R1_BP       EQU    (1<<11)      ; Enable Branch Prediction
R1_C        EQU    (1<<2)       ; Enable Data Cache
R1_A        EQU    (1<<1)       ; Enable Strict Alignment Checking
R1_M        EQU    (1<<0)       ; Enable MMU

;---------------------------
;  Miscellaneous defines
;---------------------------
DW8         EQU    (0x0)
DW16        EQU    (0x1)
DW32        EQU    (0x2)
WAIT        EQU    (0x1<<2)
UBLB        EQU    (0x1<<3)

;---------------------------
;    Macro for Sleep Code
;---------------------------
SYSCTL_SBZ_MASK     EQU     (0)
SYSCTL_SBO_MASK     EQU     (0)

MMUTTB_SBZ_MASK     EQU     (0)                             ; for 16KB Boundary Size of TTB0
PWR_STABLE_CNT_VAL  EQU     (85500)                         ; (85500 == 7.12ms)

;-----------------------------------
; OneNAND IF Register Offset
;-----------------------------------
REG_START_ADDR1         EQU	    (0x0001E200)
REG_START_ADDR8	        EQU	    (0x0001E20E)
REG_START_BUF           EQU	    (0x0001E400)
REG_INT	                EQU	    (0x0001E482)
REG_CMD	                EQU	    (0x0001E440)
PEND_READ               EQU	    (0x00008080)
DT_MB00_ADDR            EQU	    (0x00000400)

;---------------------------
;
;  SFR Address
;
;---------------------------

;---------------------------
;  PLL Lock
;---------------------------
APLL_LOCK           EQU        0xE0100000
MPLL_LOCK           EQU        0xE0100008
EPLL_LOCK           EQU        0xE0100010
VPLL_LOCK           EQU        0xE0100020 

; PLL Control
APLL_CON            EQU        0xE0100100
MPLL_CON            EQU        0xE0100108
EPLL_CON            EQU        0xE0100110 
VPLL_CON            EQU        0xE0100120 

; Clock Source
CLK_SRC0            EQU        0xE0100200 
CLK_SRC1            EQU        0xE0100204 
CLK_SRC2            EQU        0xE0100208 
CLK_SRC3            EQU        0xE010020c 
CLK_SRC4            EQU        0xE0100210 
CLK_SRC5            EQU        0xE0100214
CLK_SRC6            EQU        0xE0100218
CLK_SRC_MASK0       EQU        0xE0100280
CLK_SRC_MASK1       EQU        0xE0100284 

; Clock Divider
CLK_DIV0            EQU        0xE0100300
CLK_DIV1            EQU        0xE0100304
CLK_DIV2            EQU        0xE0100308
CLK_DIV3            EQU        0xE010030c
CLK_DIV4            EQU        0xE0100310
CLK_DIV5            EQU        0xE0100314
CLK_DIV6            EQU        0xE0100318
CLK_DIV7            EQU        0xE010031c

; Clock Gating 
CLK_GATE_IP0        EQU        0xE0100460
CLK_GATE_IP1        EQU        0xE0100464
CLK_GATE_IP2        EQU        0xE0100468
CLK_GATE_IP3        EQU        0xE010046c
CLK_GATE_IP4        EQU        0xE0100470


;Clock Out
CLK_OUT             EQU        0xE0100500

;IEM Control
DCGIDX_MAP0         EQU        0xE0103000
DCGIDX_MAP1         EQU        0xE0103004
DCGIDX_MAP2         EQU        0xE0103008
DCGPERF_MAP0        EQU        0xE0103020
DCGPERF_MAP1        EQU        0xE0103024
DVCIDX_MAP          EQU        0xE0103040
FREQ_CPU            EQU        0xE0103060
FREQ_DPM            EQU        0xE0103064
DVSEMCLK_EN         EQU        0xE0103080

APLL_CON_L8         EQU        0xE0103100
APLL_CON_L7         EQU        0xE0103104
APLL_CON_L6         EQU        0xE0103108
APLL_CON_L5         EQU        0xE010310C
APLL_CON_L4         EQU        0xE0103110
APLL_CON_L3         EQU        0xE0103114
APLL_CON_L2         EQU        0xE0103118
APLL_CON_L1         EQU        0xE010311C

CLKDIV_IEM_L8       EQU        0xE0103200
CLKDIV_IEM_L7       EQU        0xE0103204
CLKDIV_IEM_L6       EQU        0xE0103208
CLKDIV_IEM_L5       EQU        0xE010320C
CLKDIV_IEM_L4       EQU        0xE0103210
CLKDIV_IEM_L3       EQU        0xE0103214
CLKDIV_IEM_L2       EQU        0xE0103218
CLKDIV_IEM_L1       EQU        0xE010321C

; Power Manager
OSC_CON             EQU        0xE0108000
RST_STAT            EQU        0xE010A000
PWR_CFG             EQU        0xE010C000
EINT_MASK           EQU        0xE010C004
WAKEUP_MASK         EQU        0xE010C008
PWR_MODE            EQU        0xE010C00C
NORMAL_CFG          EQU        0xE010C010
IDLE_CFG            EQU        0xE010C020
STOP_CFG            EQU        0xE010C030
STOP_MEM_CFG        EQU        0xE010C034
SLEEP_CFG           EQU        0xE010C040

; Bit Field of RST_STAT register
BP_RST_STAT_ALL	EQU	(0xD000F)
BP_DIDLE_WAKEUP	EQU	(0x1<<19)
BP_DSTOP_WAKEUP	EQU	(0x1<<18)
BP_SLEEP_WAKEUP	EQU	(0x1<<16)
BP_SWRESET		EQU	(0x1<<3)
BP_WDTRESET		EQU	(0x1<<2)
BP_WRESET		EQU	(0x1<<1)
BP_RESET		EQU	(0x1<<0)

; Bit Field of IDLE_CFG register
BP_ARM_L2CACHE	    EQU        (0x3<<26)
ARM_L2CACHE_RET     EQU        (0x1<<26)

; Bit Field of APLLCON LOCKED
BP_APLL_LOCKED      EQU        (0x1<<29)
OSC_FREQ            EQU        0xE010C100
OSC_STABLE          EQU        0xE010C104
PWR_STABLE          EQU        0xE010C108
MTC_STABLE          EQU        0xE010C110
CLAMP_STABLE        EQU        0xE010C114

WAKEUP_STAT         EQU        0xE010C200
BLK_PWR_STAT        EQU        0xE010C204

BODY_BIAS_CON       EQU        0xE010C300
ION_SKEW_CON        EQU        0xE010C310
ION_SKEW_MON        EQU        0xE010C314
IOFF_SKEW_CON       EQU        0xE010C320
IOFF_SKEW_MON       EQU        0xE010C324

OTHERS              EQU        0xE010E000

OM_STAT             EQU        0xE010E100

MIE_CONTROL         EQU        0xE010E800
HDMI_CONTROL        EQU        0xE010E804
USB_PHY_CONTROL     EQU        0xE010E80C
DAC_CONTROL         EQU        0xE010E810
MIPI_DPHY_CONTROL   EQU        0xE010E814
ADC_CONTROL         EQU        0xE010E818
PS_HOLD_CONTROL     EQU        0xE010E81C

INFORM0             EQU        0xE010F000
INFORM1             EQU        0xE010F004
INFORM2             EQU        0xE010F008
INFORM3             EQU        0xE010F00C
INFORM4             EQU        0xE010F010
INFORM5             EQU        0xE010F014
INFORM6             EQU        0xE010F018
INFORM7             EQU        0xE010F01C

; Virtual address of PMU registers.
vOSC_CON            EQU        0xB0108000
vPWR_CFG            EQU        0xB010C000
vPWR_MODE           EQU        0xB010C00C
vSTOP_CFG           EQU        0xB010C030
vSLEEP_CFG          EQU        0xB010C040
vOSC_FREQ           EQU        0xB010C100
vOSC_STABLE         EQU        0xB010C104
vPWR_STABLE         EQU        0xB010C108
vCLAMP_STABLE       EQU        0xB010C114
vOTHERS             EQU        0xB010E000
vRST_STAT           EQU        0xB010A000
vINFORM0            EQU        0xB010F000
vINFORM1            EQU        0xB010F004
vINFORM2            EQU        0xB010F008
vINFORM3            EQU        0xB010F00C
vAPLL_CON           EQU        0xB0100100
vMPLL_CON           EQU        0xB0100108
vEPLL_CON           EQU        0xB0100110
vVPLL_CON           EQU        0xB0100120

; Physical Virtual addredd of GPIO register
GPH2CON             EQU        0xE0200C40
GPH2DAT             EQU        0xE0200C44
GPH2PUD             EQU        0xE0200C48
vGPH2CON            EQU        0xB0200C40
vGPH2DAT            EQU        0xB0200C44
vGPH2PUD            EQU        0xB0200C48
;------------------------------------------------------------------------------
; Bus (ASYNC BRIDGE)
;------------------------------------------------------------------------------
HALFSYNC0           EQU        0xF1800000
ASYNC_INDEX0        EQU        0xF1800004
DMASTER0            EQU        0xF1800008
HALFSYNC1           EQU        0xF1900000
ASYNC_INDEX1        EQU        0xF1900004
DMASTER1            EQU        0xF1900008
HALFSYNC2           EQU        0xF1A00000
ASYNC_INDEX2        EQU        0xF1A00004
DMASTER2            EQU        0xF1A00008
HALFSYNC3           EQU        0xF1B00000
ASYNC_INDEX3        EQU        0xF1B00004
DMASTER3            EQU        0xF1B00008
HALFSYNC4           EQU        0xF1C00000
HALFSYNC5           EQU        0xF1D00000
HALFSYNC6           EQU        0xF1E00000
SYNCMODE_REQ6       EQU        0xF1E0000C
SYNCMODE_ACK6       EQU        0xF1E00010
HALFSYNC7           EQU        0xF1F00000
HALFSYNC8           EQU        0xFAF00000
ASYNC_INDEX8        EQU        0xFAF00004
DMASTER8            EQU        0xFAF00008  
HALFSYNC9           EQU        0xE0F00000
ASYNC_INDEX9        EQU        0xE0F00004
DMASTER9            EQU        0xE0F00008 
HALFSYNC10          EQU        0xE1F00000 

CYCLE_ONE_SYNC      EQU        0x0<<0
CYCLE_HALF_SYNC     EQU        0x1<<0

INDEX_1_1           EQU        0x0<<0
INDEX_6_5           EQU        0x1<<0
INDEX_5_4           EQU        0x2<<0
INDEX_4_3           EQU        0x3<<0
INDEX_3_2           EQU        0x4<<0
INDEX_2_1           EQU        0x5<<0
 
NON_DEFAULT_MASTER  EQU        0x0
DEFAULT_MASTER      EQU        0x1

SYNC_NOREQUEST      EQU        0x0
SYNC_REQUEST        EQU        0x1

SYNC_NOACK          EQU        0x0
SYNC_ACK            EQU        0x1

;---------------------------
;  TZPC Registers
;---------------------------
TZPC0_R0SIZE        EQU        0xF1500000
TZPC0_DECPROT0Set   EQU        0xF1500804    
TZPC0_DECPROT1Set   EQU        0xF1500810    
TZPC0_DECPROT2Set   EQU        0xF150081C 
TZPC0_DECPROT3Set   EQU        0xF1500828 
TZPC1_DECPROT0Set   EQU        0xFAD00804    
TZPC1_DECPROT1Set   EQU        0xFAD00810
TZPC1_DECPROT2Set   EQU        0xFAD0081C    
TZPC1_DECPROT3Set   EQU        0xFAD00828 
TZPC2_DECPROT0Set   EQU        0xE0600804    
TZPC2_DECPROT1Set   EQU        0xE0600810  
TZPC2_DECPROT2Set   EQU        0xE060081C
TZPC2_DECPROT3Set   EQU        0xE0600828
TZPC3_DECPROT0Set   EQU        0xE1C00804    
TZPC3_DECPROT1Set   EQU        0xE1C00810     
TZPC3_DECPROT2Set   EQU        0xE1C0081C
TZPC3_DECPROT3Set   EQU        0xE1C00828


;---------------------------
;  VIC
;---------------------------
VIC0INTENCLEAR      EQU    (BASE_REG_PA_VIC0 + 0x14)
VIC1INTENCLEAR      EQU    (BASE_REG_PA_VIC1 + 0x14)
VIC2INTENCLEAR      EQU    (BASE_REG_PA_VIC2 + 0x14)
VIC3INTENCLEAR      EQU    (BASE_REG_PA_VIC3 + 0x14)

vVIC0INTENCLEAR      EQU    (BASE_REG_CA_VIC0 + 0x20000000 + 0x14)
vVIC1INTENCLEAR      EQU    (BASE_REG_CA_VIC1 + 0x20000000 + 0x14)
vVIC2INTENCLEAR      EQU    (BASE_REG_CA_VIC2 + 0x20000000 + 0x14)
vVIC3INTENCLEAR      EQU    (BASE_REG_CA_VIC3 + 0x20000000 + 0x14)

vVIC0IRQSTATUS      EQU    (BASE_REG_CA_VIC0 + 0x20000000)
vVIC1IRQSTATUS      EQU    (BASE_REG_CA_VIC1 + 0x20000000)
vVIC2IRQSTATUS      EQU    (BASE_REG_CA_VIC2 + 0x20000000)
vVIC3IRQSTATUS      EQU    (BASE_REG_CA_VIC3 + 0x20000000)

;-----------------------------------
; Watch Dog Timer
;-----------------------------------
WTCON        EQU     0xE2700000


    END

