//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//

/*++

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Notes:

--*/

#ifndef __OAL_I2CEMUL_H_
#define __OAL_I2CEMUL_H_


typedef enum {
	I2CEMUL_G0 = 0,
//    I2CEMUL_G1,
//	I2CEMUL_G2,
//	I2CEMUL_G3,
//	I2CEMUL_G4,
	I2C_MAX_GROUP
}Enum_I2C_EMUL_GROUP_NUMBR;

#if 0
#if (BSP_HW_ID>=04)
//-----GROUP1--------------------------------------------------------------------------------------
#define PMIC_GROUP			I2CEMUL_G0
#define MICROUSB_GROUP 	I2CEMUL_G0
//-----GROUP2--------------------------------------------------------------------------------------
#define COMPASS_GROUP 		I2CEMUL_G1	
#define CAMERA_GROUP 		I2CEMUL_G1
#define AMP_GROUP			I2CEMUL_G1
//-----GROUP3--------------------------------------------------------------------------------------
#define ISM2300_GROUP 		I2CEMUL_G2	//not used
#define FM2010_GROUP 		I2CEMUL_G2	//not used
#define CMC622_GROUP 		I2CEMUL_G2	//not used
#define HDMI_GROUP			I2CEMUL_G2	//G3-1.6V [rev04]
//-----GROUP4--------------------------------------------------------------------------------------
#define BACKLIGHT_GROUP 	I2CEMUL_G3
#define CODEC_GROUP 		I2CEMUL_G3
//-----GROUP5--------------------------------------------------------------------------------------
#define BATTERY_GROUP 		I2CEMUL_G4
#define FMRADIO_GROUP		I2CEMUL_G4


#else
//-----GROUP1--------------------------------------------------------------------------------------
#define PMIC_GROUP 		I2CEMUL_G0
#define MICROUSB_GROUP 	I2CEMUL_G0
//-----GROUP2--------------------------------------------------------------------------------------
#define COMPASS_GROUP 		I2CEMUL_G1
#define CAMERA_GROUP 		I2CEMUL_G1
#define AMP_GROUP			I2CEMUL_G1
//-----GROUP3--------------------------------------------------------------------------------------
#define ISM2300_GROUP 		I2CEMUL_G2	//G3-1.8v [rev03]
#define FM2010_GROUP 		I2CEMUL_G2
#define CMC622_GROUP 		I2CEMUL_G2
//-----GROUP4--------------------------------------------------------------------------------------
#define BATTERY_GROUP 		I2CEMUL_G3
#define CODEC_GROUP 		I2CEMUL_G3
//-----GROUP5--------------------------------------------------------------------------------------
#define BACKLIGHT_GROUP	I2CEMUL_G4
#define FMRADIO_GROUP		I2CEMUL_G4
#endif
#else
//-----GROUP1--------------------------------------------------------------------------------------
#define PMIC_GROUP			I2CEMUL_G0
#define MICROUSB_GROUP 	I2CEMUL_G0

#endif	//(BSP_HW_ID>=04)

#ifdef __cplusplus
extern "C" {
#endif

extern BYTE I2C_EMUL_Init(BYTE bGroup, PVOID pGpioBaseAddr, PVOID pBSPArgs, BYTE btSlaveAddress, DWORD dwSpeed);
extern BYTE I2C_EMUL_Deinit(BYTE bGroup);
extern BYTE I2C_EMUL_Write(BYTE btGroup, BYTE bRegAddr, BYTE bRegData );
extern BYTE I2C_EMUL_MWrite(BYTE btGroup, PBYTE pbtRegData , DWORD btWCount, BOOL bStop);
extern BYTE I2C_EMUL_Read(BYTE btGroup, BYTE bRegAddr, PBYTE pbRegData );
extern BYTE I2C_EMUL_MRead(BYTE btGroup, PBYTE pbtRegData, DWORD btRCount, BOOL bStop);
extern BOOL I2C_IsSlaveReady(VOID);
extern VOID GeneralBusyWaitForOneClock(DWORD dwArmClk, DWORD dwSpeed);
extern VOID GeneralBusyWaitForHalfClock(DWORD dwArmClk, DWORD dwSpeed);
extern VOID GeneralBusyWaitForQuarterClock(DWORD dwArmClk, DWORD dwSpeed);

/* NOT USE BELOW, ONLY FOR I2C EMULATION DRIVER*/
extern BYTE I2C_EMUL_SetSlaveAddr(BYTE btGroup, BYTE btSlaveAddress);
extern BYTE I2C_EMUL_SetSpeed(BYTE btGroup, DWORD dwSpeed);
extern VOID I2C_Start(BYTE btGroup);
extern VOID I2C_Stop(BYTE btGroup);
extern VOID I2C_WriteByte(BYTE btGroup, BYTE btData);
extern BYTE I2C_ReadByte(BYTE btGroup);
extern BYTE I2C_GetACK(BYTE btGroup);
extern BYTE I2C_SetACK(BYTE btGroup);
extern BYTE I2C_SetNAK(BYTE btGroup);

#ifdef __cplusplus
}
#endif

#endif __OAL_I2CEMUL_H_

