//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: nand_reg.h
//
//  Defines the NAND controller CPU register layout and definitions.
//
#ifndef __S5PV210_NAND_H
#define __S5PV210_NAND_H

#if __cplusplus
    extern "C"
    {
#endif


//------------------------------------------------------------------------------
//  Type: NAND_REG
//
//  NAND Flash controller register layout. This register bank is located
//  by the constant CPU_BASE_REG_XX_NAND in the configuration file
//  cpu_base_reg_cfg.h.
//

typedef struct
{
    UINT32    NFCONF;         //0x00   // configuration reg
    UINT32    NFCONT;         //0x04
    UINT8     NFCMD;          //0x08    // command set reg
    UINT8     PAD0[3];
    UINT8     NFADDR;         //0x0C    // address set reg
    UINT8     PAD1[3];
    UINT8     NFDATA;         //0x10    // data reg
    UINT8     PAD2[3];
    UINT32    NFMECCD0;       //0x14
    UINT32    NFMECCD1;       //0x18
    UINT32    NFSECCD;        //0x1C
    UINT32    NFSBLK;         //0x20
    UINT32    NFEBLK;         //0x24  // error correction code 2
    UINT32    NFSTAT;         //0x28  // operation status reg
    UINT32    NFECCERR0;      //0x2C
    UINT32    NFECCERR1;      //0x30
    UINT32    NFMECC0;        //0x34  // error correction code 0
    UINT32    NFMECC1;        //0x38  // error correction code 1
    UINT32    NFSECC;         //0x3C
    UINT32    NFMLCBITPT;     //0x40
} NAND_REG, *PNAND_REG;

typedef struct
{
    UINT32    NFECCCONF;         //0x00
    UINT32    PAD0[7];
    UINT32    NFECCCONT;         //0x20
    UINT32    PAD1[3];
    UINT32    NFECCSTAT;         //0x30
    UINT32    PAD2[3];
    UINT32    NFECCSECSTAT;      //0x40
    UINT32    PAD3[19];
    UINT32    NFECCPRGECC0;      //0x90
    UINT32    NFECCPRGECC1;      //0x94
    UINT32    NFECCPRGECC2;      //0x98
    UINT32    NFECCPRGECC3;      //0x9C
    UINT32    NFECCPRGECC4;      //0xA0
    UINT32    NFECCPRGECC5;      //0xA4
    UINT32    NFECCPRGECC6;      //0xA8
    UINT32    PAD4[5];
    UINT32    NFECCERL0;         //0xC0
    UINT32    NFECCERL1;         //0xC4
    UINT32    NFECCERL2;         //0xC8
    UINT32    NFECCERL3;         //0xCC  
    UINT32    NFECCERL4;         //0xD0
    UINT32    NFECCERL5;         //0xD4
    UINT32    NFECCERL6;         //0xD8
    UINT32    NFECCERL7;         //0xDC
    UINT32    PAD5[4];
    UINT32    NFECCERP0;         //0xF0
    UINT32    NFECCERP1;         //0xF4
    UINT32    NFECCERP2;         //0xF8
    UINT32    NFECCERP3;         //0xFC
    UINT32    PAD6[4];
    UINT32    NFECCCONECC0;      //0x110
    UINT32    NFECCCONECC1;      //0x114
    UINT32    NFECCCONECC2;      //0x118
    UINT32    NFECCCONECC3;      //0x11C
    UINT32    NFECCCONECC4;      //0x120                
    UINT32    NFECCCONECC5;      //0x124
    UINT32    NFECCCONECC6;      //0x128       
} NAND_ECC_REG, *PNAND_ECC_REG;


#if __cplusplus
    }
#endif

#endif

