//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  Mipidsi.h
//
//  Defines the MIPI DSI register layout and associated types
//  and constants.
//
#ifndef __MIPIDSI_H
#define __MIPIDSI_H

#if __cplusplus
extern "C" 
{
#endif

//------------------------------------------------------------------------------
//
//  Type:  MIPIDSI_REG
//
//  MIPI DISM control registers. This register bank is located by the
//  constant S5PV210_BASE_REG_XX_DSIM in the configuration file
//  S5PV210_reg_base_cfg.h.
//

typedef struct
{
	UINT32 rDSIM_STATUS;		//0x0,		//R		// DSIM Status
	UINT32 rDSIM_SWRST;			//0x4,		//R/W	// DSIM Software Reset Register
	UINT32 rDSIM_CLKCTRL; 		//0x8,		//R/W	// DSIM Clock control register
	UINT32 rDSIM_TIMEOUT; 		//0xc,      	//R/W	// DSIM Time-out Resgister
	UINT32 rDSIM_CONFIG; 		//0x10,		//R/W	// DSIM Configuration
	UINT32 rDSIM_ESCMODE;		//0x14,		//R/W	// DSIM Escape Mode Register
	UINT32 rDSIM_MDRESOL;		//0x18,		//R/W	// DSIM Main Display Resolution Register
	UINT32 rDSIM_MVPORCH; 		//0x1c,		//R/W	// DSIM Main Display Vertical Porch Register
	UINT32 rDSIM_MHPORCH; 		//0x20,		//R/W	// DSIM Main Display Horizontal Porch Register
	UINT32 rDSIM_MSYNC; 		//0x24,		//R/W	// DSIM Main Display Sync area Register
	UINT32 rDSIM_SDRESOL;		//0x28,		//R/W	// DSIM Sub Display Image Resolution Register
	UINT32 rDSIM_INTSRC;	 	//0x2c,		//R/W	// DSIM Interrupt Source Register
	UINT32 rDSIM_INTMASK;		//0x30,		//R/W	// DSIM Interrupt Mask Register
	UINT32 rDSIM_PKTHDR;		//0x34,		//W	    // DSIM Packet header FIFO Register
	UINT32 rDSIM_PAYLOAD;		//0x38,		//W	    // DSIM Payload FIFO Register
	UINT32 rDSIM_RXFIFO;	 	//0x3c,		//R		// DSIM Read FIFO Register
	UINT32 rDSIM_FIFOTHLD;		//HIDDEN	//0x40	//R/W	// Reserved	//not used this function										
	UINT32 rDSIM_FIFOCTRL;		//0x44,		//R/W	// DSIM FIFO Status & Control Register
	UINT32 rDSIM_MEMACCHR;	    //0x48,		//R/W	// DSIM FIFO Memory AC Characteristic Register
	UINT32 rDSIM_PLLCTRL;		//0x4c,		//R/W	// DSIM PLL Contorl Register
	UINT32 rDSIM_PLLTMR;		//0x50,		//R/W	// DSIM PLL Timer Register
	UINT32 uReserved00;		    //0x54
	UINT32 uReserved01;		    //0x58
} MIPIDSI_REG, *PMIPIDSI_REG;

//------------------------------------------------------------------------------

#if __cplusplus
    }
#endif

#endif
