/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (mfc_reg.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */

#ifndef __SAMSUNG_SYSLSI_MFC_SFR_H__
#define __SAMSUNG_SYSLSI_MFC_SFR_H__

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************************************************/
/*                              Common Register                                      */
/*                              0x0600 ~ 0x0800                                      */
/*************************************************************************************/

typedef struct tagMFC_COMMON
{
    // Memory Port A             
    unsigned int    MFC_COMMON_BASE_ADDR_0;                             // 0x0600
    unsigned int    MFC_COMMON_BASE_ADDR_1;                             // 0x0604
    unsigned int    MFC_COMMON_BASE_ADDR_2;                             // 0x0608
    unsigned int    MFC_COMMON_BASE_ADDR_3;                             // 0x060c
    unsigned int    MFC_COMMON_BASE_ADDR_4;                             // 0x0610
    unsigned int    MFC_COMMON_BASE_ADDR_5;                             // 0x0614
    unsigned int    MFC_COMMON_BASE_ADDR_6;                             // 0x0618
    unsigned int    MFC_COMMON_BASE_ADDR_7;                             // 0x061c
    unsigned int    MFC_COMMON_BASE_ADDR_8;                             // 0x0620
    unsigned int    MFC_COMMON_BASE_ADDR_9;                             // 0x0624
    unsigned int    MFC_COMMON_BASE_ADDR_10;                            // 0x0628
    unsigned int    MFC_COMMON_BASE_ADDR_11;                            // 0x062c
    unsigned int    MFC_COMMON_BASE_ADDR_12;                            // 0x0630
    unsigned int    MFC_COMMON_BASE_ADDR_13;                            // 0x0634 
    unsigned int    MFC_COMMON_BASE_ADDR_14;                            // 0x0638
    unsigned int    MFC_COMMON_BASE_ADDR_15;                            // 0x063c
    unsigned int    MFC_COMMON_BASE_ADDR_16;                            // 0x0640
    unsigned int    MFC_COMMON_BASE_ADDR_17;                            // 0x0644 
    unsigned int    MFC_COMMON_BASE_ADDR_18;                            // 0x0648 
    unsigned int    MFC_COMMON_BASE_ADDR_19;                            // 0x064c 
    unsigned int    MFC_COMMON_BASE_ADDR_20;                            // 0x0650
    unsigned int    MFC_COMMON_BASE_ADDR_21;                            // 0x0654
    unsigned int    MFC_COMMON_BASE_ADDR_22;                            // 0x0658
    unsigned int    MFC_COMMON_BASE_ADDR_23;                            // 0x065c
    unsigned int    MFC_COMMON_BASE_ADDR_24;                            // 0x0660
    unsigned int    MFC_COMMON_BASE_ADDR_25;                            // 0x0664
    unsigned int    MFC_COMMON_BASE_ADDR_26;                            // 0x0668
    unsigned int    MFC_COMMON_BASE_ADDR_27;                            // 0x066c
    unsigned int    MFC_COMMON_BASE_ADDR_28;                            // 0x0670
    unsigned int    MFC_COMMON_BASE_ADDR_29;                            // 0x0674
    unsigned int    MFC_COMMON_BASE_ADDR_30;                            // 0x0678
    unsigned int    MFC_COMMON_BASE_ADDR_31;                            // 0x067c
    unsigned int    MFC_COMMON_BASE_ADDR_32;                            // 0x0680
    unsigned int    MFC_COMMON_BASE_ADDR_33;                            // 0x0684
    unsigned int    MFC_COMMON_BASE_ADDR_34;                            // 0x0688
    unsigned int    MFC_COMMON_BASE_ADDR_35;                            // 0x068c
    unsigned int    MFC_COMMON_BASE_ADDR_36;                            // 0x0690
    unsigned int    MFC_COMMON_BASE_ADDR_37;                            // 0x0694
    unsigned int    MFC_COMMON_BASE_ADDR_38;                            // 0x0698
    unsigned int    MFC_COMMON_BASE_ADDR_39;                            // 0x069c
    unsigned int    MFC_COMMON_BASE_ADDR_40;                            // 0x06a0
    unsigned int    MFC_COMMON_BASE_ADDR_41;                            // 0x06a4
    unsigned int    MFC_COMMON_BASE_ADDR_42;                            // 0x06a8
    unsigned int    MFC_COMMON_BASE_ADDR_43;                            // 0x06ac
    unsigned int    MFC_COMMON_BASE_ADDR_44;                            // 0x06b0
    unsigned int    MFC_COMMON_BASE_ADDR_45;                            // 0x06b4
    unsigned int    MFC_COMMON_BASE_ADDR_46;                            // 0x06b8
    unsigned int    MFC_COMMON_BASE_ADDR_47;                            // 0x06bc
    unsigned int    MFC_COMMON_BASE_ADDR_48;                            // 0x06c0
    unsigned int    MFC_COMMON_BASE_ADDR_49;                            // 0x06c4
    unsigned int    MFC_COMMON_BASE_ADDR_50;                            // 0x06c8
    unsigned int    MFC_COMMON_BASE_ADDR_51;                            // 0x06cc
    unsigned int    MFC_COMMON_BASE_ADDR_52;                            // 0x06d0
    unsigned int    MFC_COMMON_BASE_ADDR_53;                            // 0x06d4
    unsigned int    MFC_COMMON_BASE_ADDR_54;                            // 0x06d8
    unsigned int    MFC_COMMON_BASE_ADDR_55;                            // 0x06dc
    unsigned int    MFC_COMMON_BASE_ADDR_56;                            // 0x06e0
    unsigned int    MFC_COMMON_BASE_ADDR_57;                            // 0x06e4
    unsigned int    MFC_COMMON_BASE_ADDR_58;                            // 0x06e8
    unsigned int    MFC_COMMON_BASE_ADDR_59;                            // 0x06ec
    unsigned int    MFC_COMMON_BASE_ADDR_60;                            // 0x06f0
    unsigned int    MFC_COMMON_BASE_ADDR_61;                            // 0x06f4
    unsigned int    MFC_COMMON_BASE_ADDR_62;                            // 0x06f8
    unsigned int    MFC_COMMON_BASE_ADDR_63;                            // 0x06fc
  
    // Memory Port B
    unsigned int    MFC_COMMON_BASE_ADDR_64;                            // 0x0700
    unsigned int    MFC_COMMON_BASE_ADDR_65;                            // 0x0704
    unsigned int    MFC_COMMON_BASE_ADDR_66;                            // 0x0708
    unsigned int    MFC_COMMON_BASE_ADDR_67;                            // 0x070c
    unsigned int    MFC_COMMON_BASE_ADDR_68;                            // 0x0710 
    unsigned int    MFC_COMMON_BASE_ADDR_69;                            // 0x0714
    unsigned int    MFC_COMMON_BASE_ADDR_70;                            // 0x0718
    unsigned int    MFC_COMMON_BASE_ADDR_71;                            // 0x071c 
    unsigned int    MFC_COMMON_BASE_ADDR_72;                            // 0x0720
    unsigned int    MFC_COMMON_BASE_ADDR_73;                            // 0x0724
    unsigned int    MFC_COMMON_BASE_ADDR_74;                            // 0x0728
    unsigned int    MFC_COMMON_BASE_ADDR_75;                            // 0x072c
    unsigned int    MFC_COMMON_BASE_ADDR_76;                            // 0x0730
    unsigned int    MFC_COMMON_BASE_ADDR_77;                            // 0x0734
    unsigned int    MFC_COMMON_BASE_ADDR_78;                            // 0x0738
    unsigned int    MFC_COMMON_BASE_ADDR_79;                            // 0x073c
    unsigned int    MFC_COMMON_BASE_ADDR_80;                            // 0x0740
    unsigned int    MFC_COMMON_BASE_ADDR_81;                            // 0x0744
    unsigned int    MFC_COMMON_BASE_ADDR_82;                            // 0x0748
    unsigned int    MFC_COMMON_BASE_ADDR_83;                            // 0x074c
    unsigned int    MFC_COMMON_BASE_ADDR_84;                            // 0x0750
    unsigned int    MFC_COMMON_BASE_ADDR_85;                            // 0x0754
    unsigned int    MFC_COMMON_BASE_ADDR_86;                            // 0x0758
    unsigned int    MFC_COMMON_BASE_ADDR_87;                            // 0x075c
    unsigned int    MFC_COMMON_BASE_ADDR_88;                            // 0x0760
    unsigned int    MFC_COMMON_BASE_ADDR_89;                            // 0x0764
    unsigned int    MFC_COMMON_BASE_ADDR_90;                            // 0x0768
    unsigned int    MFC_COMMON_BASE_ADDR_91;                            // 0x076c
    unsigned int    MFC_COMMON_BASE_ADDR_92;                            // 0x0770
    unsigned int    MFC_COMMON_BASE_ADDR_93;                            // 0x0774
    unsigned int    MFC_COMMON_BASE_ADDR_94;                            // 0x0778
    unsigned int    MFC_COMMON_BASE_ADDR_95;                            // 0x077c
    unsigned int    MFC_COMMON_BASE_ADDR_96;                            // 0x0780
    unsigned int    MFC_COMMON_BASE_ADDR_97;                            // 0x0784
    unsigned int    MFC_COMMON_BASE_ADDR_98;                            // 0x0788
    unsigned int    MFC_COMMON_BASE_ADDR_99;                            // 0x078c
    unsigned int    MFC_COMMON_BASE_ADDR_100;                           // 0x0790
    unsigned int    MFC_COMMON_BASE_ADDR_101;                           // 0x0794
    unsigned int    MFC_COMMON_BASE_ADDR_102;                           // 0x0798
    unsigned int    MFC_COMMON_BASE_ADDR_103;                           // 0x079c
    unsigned int    MFC_COMMON_BASE_ADDR_104;                           // 0x07a0
    unsigned int    MFC_COMMON_BASE_ADDR_105;                           // 0x07a4
    unsigned int    MFC_COMMON_BASE_ADDR_106;                           // 0x07a8
    unsigned int    MFC_COMMON_BASE_ADDR_107;                           // 0x07ac
    unsigned int    MFC_COMMON_BASE_ADDR_108;                           // 0x07b0
    unsigned int    MFC_COMMON_BASE_ADDR_109;                           // 0x07b4
    unsigned int    MFC_COMMON_BASE_ADDR_110;                           // 0x07b8
    unsigned int    MFC_COMMON_BASE_ADDR_111;                           // 0x07bc
    unsigned int    MFC_COMMON_BASE_ADDR_112;                           // 0x07c0
    unsigned int    MFC_COMMON_BASE_ADDR_113;                           // 0x07c4
    unsigned int    MFC_COMMON_BASE_ADDR_114;                           // 0x07c8
    unsigned int    MFC_COMMON_BASE_ADDR_115;                           // 0x07cc
    unsigned int    MFC_COMMON_BASE_ADDR_116;                           // 0x07d0
    unsigned int    MFC_COMMON_BASE_ADDR_117;                           // 0x07d4
    unsigned int    MFC_COMMON_BASE_ADDR_118;                           // 0x07d8
    unsigned int    MFC_COMMON_BASE_ADDR_119;                           // 0x07dc
    unsigned int    MFC_COMMON_BASE_ADDR_120;                           // 0x07e0
    unsigned int    MFC_COMMON_BASE_ADDR_121;                           // 0x07e4
    unsigned int    MFC_COMMON_BASE_ADDR_122;                           // 0x07e8
    unsigned int    MFC_COMMON_BASE_ADDR_123;                           // 0x07ec
    unsigned int    MFC_COMMON_BASE_ADDR_124;                           // 0x07f0
    unsigned int    MFC_COMMON_BASE_ADDR_125;                           // 0x07f4
    unsigned int    MFC_COMMON_BASE_ADDR_126;                           // 0x07f8
    unsigned int    MFC_COMMON_BASE_ADDR_127;                           // 0x07fc
    unsigned int    _reserved1;                                         // 0x0800
}MFC_COMMON;

/*************************************************************************************/
/*                              Buffer Register of H.264 decoder                     */
/*                              0x0600 ~ 0x0800                                      */
/*************************************************************************************/
typedef struct tagMFC_DPB_DEC_H264
{
    unsigned int    _reserved;                                          // 0x0600
    unsigned int    _reserved1[(0x068c - 0x0600)/4 -1];
    unsigned int    MFC_DBP_H264_VERT_NB_MV;                            // 0x068c
    unsigned int    MFC_DBP_H264_NB_PIXEL_INTRA;                        // 0x0690 
    unsigned int    _reserved2[(0x0800 - 0x0690)/4 -1];
    unsigned int    _reserved3;                                         // 0x0800
}MFC_DPB_DEC_H264;

/*************************************************************************************/
/*                              Buffer Register of decoder except H.264              */
/*                              0x0600 ~ 0x0800                                      */
/*************************************************************************************/
typedef struct tagMFC_DPB_DEC_EXCEPT_H264
{
    unsigned int    _reserved;                                          // 0x0600
    unsigned int    _reserved1[(0x068c - 0x0600)/4 -1];
    unsigned int    MFC_DBP_NB_ACDC_COEFF;                              // 0x068c
    unsigned int    MFC_DBP_UPPER_NB_MV;                                // 0x0690 
    unsigned int    MFC_DBP_ANCHOR_MV;                                  // 0x0694
    unsigned int    MFC_DBP_OVERLAP_TRANS;                              // 0x0698
    unsigned int    MFC_DBP_BITPLANE_3;                                 // 0x069c 
    unsigned int    MFC_DBP_BITPLANE_2;                                 // 0x06a0
    unsigned int    MFC_DBP_BITPLANE_1;                                 // 0x06a4
    unsigned int    MFC_DBP_SYNTAX_PARSER;                              // 0x06a8
    unsigned int    _reserved2[(0x0800 - 0x06a8)/4 -1];
    unsigned int    _reserved3;                                         // 0x0800
}MFC_DPB_DEC_EXCEPT_H264;

/*************************************************************************************/
/*                              Buffer Register of encoder                           */
/*                              0x0600 ~ 0x0800                                      */
/*************************************************************************************/
typedef struct tagMFC_DPB_ENC{

    unsigned int    MFC_ENC_DP_UPPER_MV_ADDR;                           // 0x0600
    unsigned int    MFC_ENC_DP_NBOR_INFO_MPENC_ADDR;                    // 0x0604
    unsigned int    MFC_ENC_DP_UPPER_INTRA_MD_ADDR;                     // 0x0608
    unsigned int    _reserved1;                                         // 0x060c
    unsigned int    MFC_ENC_DP_COZERO_FLAG_ADDR;                        // 0x0610
    unsigned int    _reserved2[(0x061c - 0x0610)/4 -1];

    unsigned int    MFC_ENC_DP_REF0_LUMA_ADDR;                          // 0x061c
    unsigned int    MFC_ENC_DP_REF1_LUMA_ADDR;                          // 0x0620
    unsigned int    _reserved3[(0x062c - 0x0620)/4 -1];

    unsigned int    MFC_ENC_DP_REF0_B_FRAME_CHROMA_ADDR;                // 0x062c
    unsigned int    MFC_ENC_DP_REF0_B_FRAME_LUMA_ADDR;                  // 0x0630
    unsigned int    _reserved4[(0x0700 - 0x0630)/4 -1];

    unsigned int    MFC_ENC_DP_REF0_CHROMA_ADDR;                        // 0x0700
    unsigned int    MFC_ENC_DP_REF1_CHROMA_ADDR;                        // 0x0704
    unsigned int    MFC_ENC_DP_REF2_CHROMA_ADDR;                        // 0x0708
    unsigned int    MFC_ENC_DP_REF3_CHROMA_ADDR;                        // 0x070c
    unsigned int    MFC_ENC_DP_REF2_LUMA_ADDR;                          // 0x0710
    unsigned int    MFC_ENC_DP_REF3_LUMA_ADDR;                          // 0x0714
    unsigned int    _reserved5[(0x0740 - 0x0714)/4 -1];  

    unsigned int    MFC_ENC_DP_UPPER_INTRA_PRED_ADDR;                   // 0x0740
    unsigned int    _reserved6[(0x0800 - 0x0740)/4 -1];
    unsigned int    _reserved7;                                         // 0x0800
}MFC_DPB_ENC;


/*************************************************************************************/
/*                              Command Register of Decoder                          */
/*                              0x2000 ~ 0x2100                                      */
/*************************************************************************************/
typedef struct tagMFC_CODEC_COMM_DEC{
    unsigned int    MFC_SI_RTN_CHID;                                    // 0x2000
    unsigned int    MFC_SI_VRESOL;                                      // 0x2004
    unsigned int    MFC_SI_HRESOL;                                      // 0x2008
    unsigned int    MFC_SI_BUF_NUMBER;                                  // 0x200c
    unsigned int    MFC_SI_DISPLAY_Y_ADR;                               // 0x2010
    unsigned int    MFC_SI_DISPLAY_C_ADR;                               // 0x2014
    unsigned int    MFC_DEC_FRM_SIZE;                                   // 0x2018
    unsigned int    MFC_SI_DISPLAY_STATUS;                              // 0x201c
    unsigned int    MFC_COMMON_SI_RG_8;                                 // 0x2020
    unsigned int    _reserved[(0x202c - 0x2020)/4 -1];
    
    unsigned int    MFC_SI_DECODE_STATUS;                               // 0x202c
    unsigned int    MFC_SI_CRC_DATA_1;                                  // 0x2030
    unsigned int    MFC_SI_CRC_DATA_2;                                  // 0x2034
    unsigned int    MFC_SI_CRC_DATA_3;                                  // 0x2038
    unsigned int    MFC_SI_CRC_DATA_4;                                  // 0x203c
    
    unsigned int    MFC_SI_CH1_INST_ID;                                 // 0x2040
    unsigned int    MFC_SI_CH1_SB_ST_ADDR;                              // 0x2044
    unsigned int    MFC_SI_CH1_SB_FRAME_SIZE;                           // 0x2048
    unsigned int    MFC_SI_CH1_DESC_ADDR;                               // 0x204c
   
    unsigned int    MFC_SI_DIVX311_HRESOL;                              // 0x2050
    unsigned int    MFC_SI_DIVX311_VRESOL;                              // 0x2054  
    unsigned int    MFC_SI_CH1_CPB_SIZE;                                // 0x2058
    unsigned int    MFC_SI_CH1_DESC_SIZE;                               // 0x205c
    unsigned int    MFC_SI_CH1_RELEASE_BUFFER;                          // 0x2060
    unsigned int    MFC_SI_CH1_HOST_WR_ADR;                             // 0x2064
    unsigned int    MFC_SI_CH1_DPB_CONFIG_CTRL;                         // 0x2068
    unsigned int    MFC_SI_CH1_ALLOCATED_DPB_SIZE;                      // 0x206c
    unsigned int    _reserved1[(0x2080 - 0x206c)/4 -1];
    unsigned int    MFC_SI_CH2_INST_ID;                                 // 0x2080
    unsigned int    _reserved2[(0x2100 - 0x2080)/4 -1];
    unsigned int    _reserved3;                                         // 0x2100
}MFC_CODEC_COMM_DEC;

/*************************************************************************************/
/*                              Command Register of Encoder                          */
/*                              0x2000 ~ 0x2100                                      */
/*************************************************************************************/
typedef struct tagMFC_CODEC_COMM_ENC{
    unsigned int    MFC_SI_RTN_CHID;                                    // 0x2000
    unsigned int    MFC_SI_STREAM_SIZE;                                 // 0x2004
    unsigned int    MFC_SI_PICTURE_CNT;                                 // 0x2008
    unsigned int    MFC_SI_WRITE_PTR;                                   // 0x200c
    unsigned int    MFC_SI_SLICE_TYPE;                                  // 0x2010
    unsigned int    _reserved[(0x2040 - 0x2010)/4 -1];

    unsigned int    MFC_SI_CH1_INST_ID;                                 // 0x2040
    unsigned int    MFC_SI_CH1_SB_U_ADDR;                               // 0x2044
    unsigned int    MFC_SI_CH1_SB_L_ADDR;                               // 0x2048
    unsigned int    MFC_SI_CH1_SB_SIZE;                                 // 0x204c
    unsigned int    MFC_SI_CH1_CURRENT_Y_ADDR;                          // 0x2050
    unsigned int    MFC_SI_CH1_CURRENT_C_ADDR;                          // 0x2054
    unsigned int    MFC_SI_CH1_FRAME_INSERT_TYPE;                       // 0x2058
    unsigned int    MFC_SI_CH1_SLICE_ARGUMENT;                          // 0x205c
    unsigned int    _reserved1;
    unsigned int    MFC_SI_CH1_HOST_WR_ADR;                             // 0x2064
    unsigned int    _reserved2[(0x2080 - 0x2064)/4 -1];
    unsigned int    MFC_SI_CH2_INST_ID;                                 // 0x2080
    unsigned int    _reserved3[(0x2100 - 0x2080)/4 -1];
    unsigned int    _reserved4;                                         // 0x2100
 }MFC_CODEC_COMM_ENC;


/*************************************************************************************/
/*                              MFC SFR                                              */
/*                              0x0000 ~ 0xe008                                      */
/*************************************************************************************/
typedef struct tagMFC_SFR{
    unsigned int    MFC_SW_RESET;                                       // 0x0000 
    unsigned int    _reserved;
    unsigned int    MFC_RISC_HOST_INT;                                  // 0x0008
    unsigned int    _reserved1[(0x0030 - 0x0008)/4 -1];
    unsigned int    MFC_HOST2RISC_CMD;                                  // 0x0030
    unsigned int    MFC_HOST2RISC_ARG1;                                 // 0x0034
    unsigned int    MFC_HOST2RISC_ARG2;                                 // 0x0038
    unsigned int    MFC_HOST2RISC_ARG3;                                 // 0x003c
    unsigned int    MFC_HOST2RISC_ARG4;                                 // 0x0040
    unsigned int    MFC_RISC2HOST_CMD;                                  // 0x0044
    unsigned int    MFC_RISC2HOST_ARG1;                                 // 0x0048
    unsigned int    MFC_RISC2HOST_ARG2;                                 // 0x004c
    unsigned int    MFC_RISC2HOST_ARG3;                                 // 0x0050
    unsigned int    MFC_RISC2HOST_ARG4;                                 // 0x0054
    unsigned int    MFC_FW_VERSION;                                     // 0x0058
    unsigned int    MFC_SYSTEM_MEM_SZ;                                  // 0x005c
    unsigned int    _reserved2[(0x0080 - 0x005c)/4 -1];
    unsigned int    MFC_FW_STATUS;                                      // 0x0080
    unsigned int    _reserved3[(0x0508 - 0x0080)/4 -1];

    // 2.Memory Controller Registers
    unsigned int    MFC_MC_DRAMBASE_ADDR_A;                             // 0x0508
    unsigned int    MFC_MC_DRAMBASE_ADDR_B;                             // 0x050c
    unsigned int    MFC_MC_STATUS;                                      // 0x0510
    unsigned int    MFC_MC_RS_IBASE;                                    // 0x0514
    unsigned int    _reserved4[(0x0600 - 0x0514)/4 -1];

    union{                                                              //0x0600 ~ 0x0800
        MFC_COMMON dec_common_buffer;
        MFC_DPB_DEC_H264 dec_h264_buffer;
        MFC_DPB_DEC_EXCEPT_H264 dec_except_h264_buffer;
        MFC_DPB_ENC enc_buffer;
    }dpb;

    unsigned int    _reserved5[(0x0818 - 0x0800)/4 -1];
    unsigned int    MFC_HSIZE_PX;                                       // 0x0818
    unsigned int    MFC_VSIZE_PX;                                       // 0x081c
    unsigned int    _reserved6[(0x0830 - 0x081c)/4 -1];
    unsigned int    MFC_PROFILE;                                        // 0x0830
    unsigned int    _reserved7[(0x083c - 0x0830)/4 -1];
    unsigned int    MFC_PICTURE_STRUCT;                                 // 0x083c
    unsigned int    _reserved8[(0x0848 - 0x083c)/4 -1];
    unsigned int    MFC_LF_CONTROL;                                     // 0x0848
    unsigned int    MFC_LF_ALPHA_OFF;                                   // 0x084c
    unsigned int    MFC_LF_BETA_OFF;                                    // 0x0850
    unsigned int    MFC_MR_BUSIF_CTRL;                                  // 0x0854
    unsigned int    _reserved9[(0x0a00 - 0x0854)/4 -1];

    unsigned int    MFC_PIXEL_CACHE_CTRL0;                              // 0x0a00
    unsigned int    _reserved10[(0x0b14 - 0x0a00)/4 -1];
    
    unsigned int    MFC_NUM_MASTER;                                     // 0x0b14 -- 0: One Master, 1: Two Masters
    unsigned int    MFC_CH0_HOST_WR_ADR;                                // 0x0b18
    unsigned int    MFC_CH0_HOST_RD_ADR;                                // 0x0b1c
    unsigned int    MFC_CH1_HOST_WR_ADR;                                // 0x0b20
    unsigned int    MFC_CH1_HOST_RD_ADR;                                // 0x0b24
    unsigned int    _reserved11[(0x2000 - 0x0b24)/4 -1];

    union{                                                              //0x2000 ~ 0x2100
        MFC_CODEC_COMM_DEC dec_comm;
        MFC_CODEC_COMM_ENC enc_comm;
    }codec_comm;

    unsigned int    _reserved12[(0xc004 - 0x2100)/4 -1];
    unsigned int    MFC_EDFU_STR_BF_U_FULL_0;                           // 0xc004
    unsigned int    MFC_EDFU_STR_BF_U_EMPTY_0;                          // 0xc008
    unsigned int    MFC_EDFU_STR_BF_L_FULL_0;                           // 0xc00c
    unsigned int    MFC_EDFU_STR_BF_L_EMPTY_0;                          // 0xc010
    unsigned int    _reserved13[(0xc054 - 0xc010)/4 -1];
    unsigned int    MFC_EDFU_SF_EPB_ON_CTRL;                            // 0xc054
    unsigned int    MFC_EDFU_SF_BF_CTRL;                                // 0xc058
    unsigned int    MFC_EDFU_STR_BF_MODE_CTRL;                          // 0xc05c
    unsigned int    _reserved14[(0xc504 - 0xc05c)/4 -1];

    unsigned int    MFC_ENC_PIC_TYPE_CTRL;                              // 0xc504
    unsigned int    MFC_ENC_B_RECON_WRITE_ON;                           // 0xc508
    unsigned int    MFC_ENC_MSLICE_CTRL;                                // 0xc50c
    unsigned int    MFC_ENC_MSLICE_MB;                                  // 0xc510
    unsigned int    MFC_ENC_MSLICE_BYTE;                                // 0xc514
    unsigned int    MFC_ENC_CIR_NUM;                                    // 0xc518
    unsigned int    MFC_ENC_MAP_FOR_CUR;                                // 0xc51c
    unsigned int    MFC_ENC_PADDIMG_CTRL;                               // 0xc520
    unsigned int    MFC_ENC_INT_STATUS;                                 // 0xc524
    unsigned int    MFC_ENC_INT_MASK;                                   // 0xc528
    unsigned int    MFC_ENC_INT_CLEAR;                                  // 0xc52c
    unsigned int    MFC_ENC_REF_NUM_SEL;                                // 0xc530
    unsigned int    _reserved15[(0xc5a0 - 0xc530)/4 -1];

    unsigned int    MFC_RC_CONFIG;                                      // 0xc5a0
    unsigned int    MFC_RC_FRAME_RATE;                                  // 0xc5a4
    unsigned int    MFC_RC_BIT_RATE;                                    // 0xc5a8
    unsigned int    MFC_RC_QBOUND;                                      // 0xc5ac
    unsigned int    MFC_RC_RPARA;                                       // 0xc5b0
    unsigned int    MFC_RC_MB_CTRL;                                     // 0xc5b4
    unsigned int    MFC_RC_QOUT;                                        // 0xc5b8
    unsigned int    _reserved16[(0xd004 - 0xc5b8)/4 -1];

    unsigned int    H264_ENC_ENTRP_MODE;                                // 0xd004
    unsigned int    H264_ENC_LF_ALPHA_OFFSET;                           // 0xd008
    unsigned int    H264_ENC_LF_BETA_OFFSET;                            // 0xd00c
    unsigned int    H264_ENC_NUM_OF_REF;                                // 0xd010
    unsigned int    H264_ENC_ACTIVE_NUM_OF_REF;                         // 0xd014
    unsigned int    _reserved17;
    unsigned int    H264_ENC_MDINTER_WEIGHT;                            // 0xd01c
    unsigned int    H264_ENC_MDINTRA_WEIGHT;                            // 0xd020
    unsigned int    H264_ENC_INTRAMV_EN;                                // 0xd024
    unsigned int    H264_ENC_DIREC8X8_INF_FLAG;                         // 0xd028
    unsigned int    H264_ENC_LIST0_TOP_FIELD;                           // 0xd02c
    unsigned int    H264_ENC_LIST1_TOP_FIELD;                           // 0xd030
    unsigned int    H264_ENC_TRANS_8X8_FLAG;                            // 0xd034
    unsigned int    _reserved18[(0xd044 - 0xd034)/4 -1];

    unsigned int    H264_ENC_I4X4_I8X8_WEIGHT;                          // 0xd044
    unsigned int    H264_ENC_I16X16_WEIGHT;                             // 0xd048
    unsigned int    _reserved19[(0xd0d8 - 0xd048)/4 -1];
    
    unsigned int    H264_ENC_PRED_MODE_CONTROL;                         // 0xd0d8
    unsigned int    _reserved20[(0xe008 - 0xd0d8)/4 -1];
    
    unsigned int    MPEG4_ENC_QUART_PXL;                                // 0xe008 
 }MFC_SFR;



/*************************************************************************************/
/*                              Shared Memory Area                                   */
/*                              0x0000 ~ 0x00A0                                      */
/*************************************************************************************/
typedef struct tagMFC_SHARED_MEM{
    unsigned int    EXTENEDED_DECODE_STATUS;                            // 0x0000
    unsigned int    SET_FRAME_TAG;                                      // 0x0004
    unsigned int    GET_FRAME_TAG_TOP;                                  // 0x0008
    unsigned int    GET_FRAME_TAG_BOT;                                  // 0x000C
    unsigned int    PIC_TIME_TOP;                                       // 0x0010
    unsigned int    PIC_TIME_BOT;                                       // 0x0014
    unsigned int    START_BYTE_NUM;                                     // 0x0018
    unsigned int    _reserved1;                                         // 0x001c
    unsigned int    CROP_INFO1;                                         // 0x0020
    unsigned int    CROP_INFO2;                                         // 0x0024
    unsigned int    EXT_ENC_CONTROL;                                    // 0x0028
    unsigned int    ENC_PARAM_CHANGE;                                   // 0x002C
    unsigned int    VOP_TIMING;                                         // 0x0030
    unsigned int    HEC_PERIOD;                                         // 0x0034
    unsigned int    METADATA_ENABLE;                                    // 0x0038
    unsigned int    METADATA_STATUS;                                    // 0x003C
    unsigned int    METADATA_DISPLAY_INDEX;                             // 0x0040
    unsigned int    EXT_METADATA_START_ADDR;                            // 0x0044
    unsigned int    PUT_EXTRADATA;                                      // 0x0048
    unsigned int    EXTRADATA_ADDR;                                     // 0x004C
    
    unsigned int    _reserved2[(0x0064 - 0x004C)/4 -1];
    
    unsigned int    ALLOCATED_LUMA_DPB_SIZE;                            // 0x0064
    unsigned int    ALLOCATED_CHROMA_DPB_SIZE;                          // 0x0068
    unsigned int    ALLOCATED_MV_SIZE;                                  // 0x006c
    unsigned int    P_B_FRAME_QP;                                       // 0x0070
    unsigned int    ASPECT_RATIO_IDC;                                   // 0x0074
    unsigned int    EXTENDED_SAR;                                       // 0x0078

    unsigned int    _reserved3[(0x0090 - 0x0078)/4 -1];
    
    unsigned int    NEW_RC_BIT_RATE;                                    // 0x0090
    unsigned int    NEW_RC_FRAME_RATE;                                  // 0x0094
    unsigned int    NEW_I_PERIOD;                                       // 0x0098
    unsigned int    H264_I_PERIOD;                                      // 0x009c
    unsigned int    RC_CONTROL_CONFIG;                                  // 0x00A0
 }MFC_SHARED_MEM;



#ifdef __cplusplus
}
#endif

#endif /* __SAMSUNG_SYSLSI_MFC_SFR_H__ */
