/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (mfc_reg.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2010/01/27
 */

#ifndef __SAMSUNG_SYSLSI_JPG_SFR_H__
#define __SAMSUNG_SYSLSI_JPG_SFR_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct tagJPG_SFR
{
    unsigned int JPGMOD;            // 0x000
    unsigned int JPGOPR;            // 0x004
    unsigned int JPGQTBL;           // 0x008
    unsigned int JPGHTBL;           // 0x00C

    unsigned int JPGDRI_U;          // 0x010
    unsigned int JPGDRI_L;          // 0x014
    unsigned int JPGY_U;            // 0x018
    unsigned int JPGY_L;            // 0x01C

    unsigned int JPGX_U;            // 0x020
    unsigned int JPGX_L;            // 0x024
    unsigned int JPGCNT_U;          // 0x028
    unsigned int JPGCNT_M;          // 0x02C

    unsigned int JPGCNT_L;          // 0x030
    unsigned int JPGINTSE;          // 0x034
    unsigned int JPGINTST;          // 0x038
    unsigned int _reserved1[(0x04C-0x038)/4-1];

    unsigned int JPGCOM;            // 0x04C

    unsigned int JPGIMGADR;          // 0x050
    unsigned int _reserved2;
    unsigned int JPGADR;             // 0x058
    unsigned int JPGCOEF1;          // 0x05C

    unsigned int JPGCOEF2;          // 0x060
    unsigned int JPGCOEF3;          // 0x064
    unsigned int JPGCMOD;           // 0x068
    unsigned int JPGCLKCON;         // 0x06C

    unsigned int JPGJSTART;         // 0x070
    unsigned int JPGFSTART;         // 0x074
    unsigned int JPGSW_RESET;       // 0x078
    unsigned int JPGTIME_SET;       // 0x07C

    unsigned int JPGTIME_ST;        // 0x080
    unsigned int JPGCOMSTAT;        // 0x084
    unsigned int JPGOUTFORM;        // 0x088
    unsigned int JPGVESION;         // 0x08C

    unsigned int _reserved3;
    unsigned int JPGDEC_STEAM_SIZE; // 0x094
    unsigned int JPGENC_STEAM_INTSE;// 0x098
    unsigned int JPGENC_STEAM_INTST;// 0x09C
    unsigned int _reserved4[(0x400-0x09C)/4-1];
    
    unsigned int JPGQTBL0[64];      // 0x400
    unsigned int JPGQTBL1[64];      // 0x500
    unsigned int JPGQTBL2[64];      // 0x600
    unsigned int JPGQTBL3[64];      // 0x700

    unsigned int JPGHDCTBL0[16];    // 0x800
    unsigned int JPGHDCTBLG0[16];   // 0x840
    unsigned int JPGHACTBL0[16];    // 0x880
    unsigned int JPGHACTBLG0[162];   // 0x8C0
    unsigned int _reserved5[(0xC00-0x8C0)/4-1];
    
    unsigned int JPGHDCTBL1[16];    // 0xC00
    unsigned int JPGHDCTBLG1[16];   // 0xC40
    unsigned int JPGHACTBL1[16];    // 0xC80
    unsigned int JPGHACTBLG1[16];   // 0xCC0

}JPG_SFR;


#ifdef __cplusplus
}
#endif

#endif /* __SAMSUNG_SYSLSI_JPG_SFR_H__ */
