//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  intr_reg.h
//
//  Defines the interrupt controller register layout and associated interrupt
//  sources and bit masks.
//
#ifndef __S5PV210_INTR_H
#define __S5PV210_INTR_H

#include <oal_intr.h>

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//
//  Type: VIC_REG
//
//  Interrupt control registers. This register bank is located by the constant
//  BASE_REG_XX_VICX in the configuration file base_reg_cfg.h.
//

typedef struct
{
    UINT32 VICIRQSTATUS;        // 0x00
    UINT32 VICFIQSTATUS;        // 0x04
    UINT32 VICRAWINTR;            // 0x08
    UINT32 VICINTSELECT;        // 0x0c

    UINT32 VICINTENABLE;        // 0x10
    UINT32 VICINTENCLEAR;        // 0x14
    UINT32 VICSOFTINT;            // 0x18
    UINT32 VICSOFTINTCLEAR;    // 0x1c

    UINT32 VICPROTECTION;        // 0x20
    UINT32 VICSWPRIORITYMASK;    // 0x24
    UINT32 VICPRIORITYDAISY;    // 0x28
    UINT32 PAD0;                // 0x2c

    UINT32 PAD1[52];                // 0x30~0xff

    UINT32 VICVECTADDR0;        // 0x100
    UINT32 VICVECTADDR1;        // 0x104
    UINT32 VICVECTADDR2;        // 0x108
    UINT32 VICVECTADDR3;        // 0x10c

    UINT32 VICVECTADDR4;        // 0x110
    UINT32 VICVECTADDR5;        // 0x114
    UINT32 VICVECTADDR6;        // 0x118
    UINT32 VICVECTADDR7;        // 0x11c

    UINT32 VICVECTADDR8;        // 0x120
    UINT32 VICVECTADDR9;        // 0x124
    UINT32 VICVECTADDR10;        // 0x128
    UINT32 VICVECTADDR11;        // 0x12c

    UINT32 VICVECTADDR12;        // 0x130
    UINT32 VICVECTADDR13;        // 0x134
    UINT32 VICVECTADDR14;        // 0x138
    UINT32 VICVECTADDR15;        // 0x13c

    UINT32 VICVECTADDR16;        // 0x140
    UINT32 VICVECTADDR17;        // 0x144
    UINT32 VICVECTADDR18;        // 0x148
    UINT32 VICVECTADDR19;        // 0x14c

    UINT32 VICVECTADDR20;        // 0x150
    UINT32 VICVECTADDR21;        // 0x154
    UINT32 VICVECTADDR22;        // 0x158
    UINT32 VICVECTADDR23;        // 0x15c

    UINT32 VICVECTADDR24;        // 0x160
    UINT32 VICVECTADDR25;        // 0x164
    UINT32 VICVECTADDR26;        // 0x168
    UINT32 VICVECTADDR27;        // 0x16c

    UINT32 VICVECTADDR28;        // 0x170
    UINT32 VICVECTADDR29;        // 0x174
    UINT32 VICVECTADDR30;        // 0x178
    UINT32 VICVECTADDR31;        // 0x17c

    UINT32 PAD2[32];                // 0x180~0x1ff

    UINT32 VICVECTPRIORITY0;    // 0x200
    UINT32 VICVECTPRIORITY1;    // 0x204
    UINT32 VICVECTPRIORITY2;    // 0x208
    UINT32 VICVECTPRIORITY3;    // 0x20c

    UINT32 VICVECTPRIORITY4;    // 0x210
    UINT32 VICVECTPRIORITY5;    // 0x214
    UINT32 VICVECTPRIORITY6;    // 0x218
    UINT32 VICVECTPRIORITY7;    // 0x21c

    UINT32 VICVECTPRIORITY8;    // 0x220
    UINT32 VICVECTPRIORITY9;    // 0x224
    UINT32 VICVECTPRIORITY10;    // 0x228
    UINT32 VICVECTPRIORITY11;    // 0x22c

    UINT32 VICVECTPRIORITY12;    // 0x230
    UINT32 VICVECTPRIORITY13;    // 0x234
    UINT32 VICVECTPRIORITY14;    // 0x238
    UINT32 VICVECTPRIORITY15;    // 0x23c

    UINT32 VICVECTPRIORITY16;    // 0x240
    UINT32 VICVECTPRIORITY17;    // 0x244
    UINT32 VICVECTPRIORITY18;    // 0x248
    UINT32 VICVECTPRIORITY19;    // 0x24c

    UINT32 VICVECTPRIORITY20;    // 0x250
    UINT32 VICVECTPRIORITY21;    // 0x254
    UINT32 VICVECTPRIORITY22;    // 0x258
    UINT32 VICVECTPRIORITY23;    // 0x25c

    UINT32 VICVECTPRIORITY24;    // 0x260
    UINT32 VICVECTPRIORITY25;    // 0x264
    UINT32 VICVECTPRIORITY26;    // 0x268
    UINT32 VICVECTPRIORITY27;    // 0x26c

    UINT32 VICVECTPRIORITY28;    // 0x270
    UINT32 VICVECTPRIORITY29;    // 0x274
    UINT32 VICVECTPRIORITY30;    // 0x278
    UINT32 VICVECTPRIORITY31;    // 0x27c

    UINT32 PAD3[800];            // 0x280~0xeff

    UINT32 VICADDRESS;            // 0xf00
    UINT32 PAD4[3];                // 0xf04~0xf0f

    UINT32 PAD5[52];                // 0xf10~0xfdf

    UINT32 VICPERIPHID0;        // 0xfe0
    UINT32 VICPERIPHID1;        // 0xfe4
    UINT32 VICPERIPHID2;        // 0xfe8
    UINT32 VICPERIPHID3;        // 0xfec

    UINT32 VICPCELLID0;            // 0xff0
    UINT32 VICPCELLID1;            // 0xff4
    UINT32 VICPCELLID2;            // 0xff8
    UINT32 VICPCELLID3;            // 0xffc
} VIC_REG, *PVIC_REG;

// Profiler ISR function pointer type.
//
typedef UINT32 (*PFN_PROFILER_ISR)(UINT32 ra);


//------------------------------------------------------------------------------
//
//  Define: IRQ_XXX
//
//  Virtual Interrupt Sources Numbers
//  Flatten Physical IRQ Numbers
//  
//  This IRQ will be tied up with SysIntr statically or dynamically.
//  Drivers and Application have to use this Virtual IRQ Numbers
//

//  IRQ definition:  Virtual Number / Physical Number

#define IRQ_EINT0            0          // 0
#define IRQ_EINT1            1          // 1
#define IRQ_EINT2            2          // 2
#define IRQ_EINT3            3          // 3
#define IRQ_EINT4            4          // 4
#define IRQ_EINT5            5          // 5
#define IRQ_EINT6            6          // 6
#define IRQ_EINT7            7          // 7
#define IRQ_EINT8            8          // 8
#define IRQ_EINT9            9          // 9
#define IRQ_EINT10           10         // 10
#define IRQ_EINT11           11         // 11
#define IRQ_EINT12           12         // 12
#define IRQ_EINT13           13         // 13
#define IRQ_EINT14           14         // 14
#define IRQ_EINT15           15         // 15
#define IRQ_EINT16           16         // 16
#define IRQ_EINT17           17         // 16
#define IRQ_EINT18           18         // 16
#define IRQ_EINT19           19         // 16
#define IRQ_EINT20           20         // 16
#define IRQ_EINT21           21         // 16
#define IRQ_EINT22           22         // 16
#define IRQ_EINT23           23         // 16
#define IRQ_EINT24           24         // 16
#define IRQ_EINT25           25         // 16
#define IRQ_EINT26           26         // 16
#define IRQ_EINT27           27         // 16
#define IRQ_EINT28           28         // 16
#define IRQ_EINT29           29         // 16
#define IRQ_EINT30           30         // 16
#define IRQ_EINT31           31         // 16
#define IRQ_RESERVED0        32         // 17  
#define IRQ_MDMA_CH0         33         // 18
#define IRQ_MDMA_CH1         34         // 18
#define IRQ_MDMA_CH2         35         // 18
#define IRQ_MDMA_CH3         36         // 18
#define IRQ_MDMA_CH4         37         // 18
#define IRQ_MDMA_CH5         38         // 18
#define IRQ_MDMA_CH6         39         // 18
#define IRQ_MDMA_CH7         40         // 18
#define IRQ_PDMA0_CH0        41         // 19
#define IRQ_PDMA0_CH1        42         // 19
#define IRQ_PDMA0_CH2        43         // 19
#define IRQ_PDMA0_CH3        44         // 19
#define IRQ_PDMA0_CH4        45         // 19
#define IRQ_PDMA0_CH5        46         // 19
#define IRQ_PDMA0_CH6        47         // 19
#define IRQ_PDMA0_CH7        48         // 19
#define IRQ_PDMA1_CH0        49         // 20
#define IRQ_PDMA1_CH1        50         // 20
#define IRQ_PDMA1_CH2        51         // 20
#define IRQ_PDMA1_CH3        52         // 20
#define IRQ_PDMA1_CH4        53         // 20
#define IRQ_PDMA1_CH5        54         // 20
#define IRQ_PDMA1_CH6        55         // 20
#define IRQ_PDMA1_CH7        56         // 20
#define IRQ_TIMER0           57         // 21
#define IRQ_TIMER1           58         // 22
#define IRQ_TIMER2           59         // 23
#define IRQ_TIMER3           60         // 24
#define IRQ_TIMER4           61         // 25
#define IRQ_SYSTIMER         62         // 26
#define IRQ_WDT              63         // 27
#define IRQ_RTC_ALARM        64         // 28
#define IRQ_RTC_TIC          65         // 29
#define IRQ_GPIO             66         // 30
#define IRQ_FIMC3            67         // 31
#define IRQ_CORTEX0          68         // 32
#define IRQ_CORTEX1          69         // 33
#define IRQ_CORTEX2          70         // 34
#define IRQ_CORTEX3          71         // 35
#define IRQ_CORTEX4          72         // 36
#define IRQ_IEMAPC           73         // 37
#define IRQ_IEMIEC           74         // 38
#define IRQ_RESERVED1        75         // 39  
#define IRQ_NFC              76         // 40
#define IRQ_CFC              77         // 41
#define IRQ_UART0            78         // 42
#define IRQ_UART1            79         // 43
#define IRQ_UART2            80         // 44
#define IRQ_UART3            81         // 45
#define IRQ_I2C              82         // 46
#define IRQ_SPI0             83         // 47
#define IRQ_SPI1             84         // 48
#define IRQ_SPI2             85         // 49
#define IRQ_AUDIO_SS         86         // 50
#define IRQ_I2C_PMIC_LINK    87         // 51
#define IRQ_I2C_HDMI_PHY     88         // 52
#define IRQ_HSIRX            89         // 53
#define IRQ_HSITX            90         // 54
#define IRQ_UHOST            91         // 55
#define IRQ_OTG              92         // 56
#define IRQ_MSM              93         // 57
#define IRQ_SDMMC0           94         // 58
#define IRQ_SDMMC1           95         // 59
#define IRQ_SDMMC2           96         // 60
#define IRQ_MIPI_CSI         97         // 61
#define IRQ_MIPI_DSI         98         // 62
#define IRQ_ONENAND_AUDI     99         // 63
#define IRQ_LCD0             100        // 64
#define IRQ_LCD1             101        // 65
#define IRQ_LCD2             102        // 66
#define IRQ_LCD3             103        // 67
#define IRQ_ROTATOR          104        // 68  
#define IRQ_FIMC0            105        // 69
#define IRQ_FIMC1            106        // 70
#define IRQ_FIMC2            107        // 71
#define IRQ_JPEG             108        // 72
#define IRQ_2D               109        // 73
#define IRQ_3D               110        // 74
#define IRQ_MIXER            111        // 75
#define IRQ_HDMI             112        // 76
#define IRQ_HDMI_I2C         113        // 77
#define IRQ_MFC              114        // 78
#define IRQ_TVENC            115        // 79
#define IRQ_I2S0             116        // 80
#define IRQ_I2S1             117        // 81
#define IRQ_RESERVED2        118        // 82  
#define IRQ_AC97             119        // 83
#define IRQ_PCM0             120        // 84
#define IRQ_PCM1             121        // 85
#define IRQ_SPDIF            122        // 86
#define IRQ_ADC              123        // 87
#define IRQ_PENDN            124        // 88
#define IRQ_KEYPAD           125        // 89
#define IRQ_SPG              126        // 90
#define IRQ_IntHash_SSS      127        // 91
#define IRQ_IntFeedCtrl_SSS  128        // 92
#define IRQ_RESERVED3        129        // 93  
#define IRQ_SDM_IRQ          130        // 94
#define IRQ_SDM_FIQ          131        // 95
#define IRQ_IPC              132        // 96
#define IRQ_HOSTIF           133        // 97
#define IRQ_SDMMC3           134        // 98
#define IRQ_CEC              135        // 99
#define IRQ_TSI              136        // 100
#define IRQ_MDNIE0           137        // 101
#define IRQ_MDNIE1           138        // 102
#define IRQ_MDNIE2           139        // 103
#define IRQ_MDNIE3           140        // 104
#define IRQ_ADC1             141		// 105
#define IRQ_PENDN1           142		// 106

#define IRQ_DIDLEWU             143


#ifdef MULTI_USBHOST
#define IRQ_EHCI            144
#define IRQ_OHCI            145

#ifdef BSP_USEDVFS
#define IRQ_DVFS             146
/* Add the Physical IRQ ID if needed.
        IRQ_GPIO is the sample code.
*/
#define IRQ_GPJ0_INT5        147    // For Sample in case of using GPJ0_5 interrupt 

#define IRQ_MAX_S5PV210      148        // 107
#else
/* Add the Physical IRQ ID if needed.
        IRQ_GPIO is the sample code.
        For examples, if you want to use the GPIO_INT13[3],
        you can define the IRQ_GPIO as the IRQ_GPIO13_2
*/
#define IRQ_GPJ0_INT5       146    // For Sample in case of using GPJ0_5 interrupt 

#define IRQ_MAX_S5PV210     147        // 107
#endif
#else
#define IRQ_EHCI            144

#ifdef BSP_USEDVFS
#define IRQ_DVFS             145
/* Add the Physical IRQ ID if needed.
        IRQ_GPIO is the sample code.
*/
#define IRQ_GPJ0_INT5        146    // For Sample in case of using GPJ0_5 interrupt 

#define IRQ_MAX_S5PV210      147        // 107
#else
/* Add the Physical IRQ ID if needed.
        IRQ_GPIO is the sample code.
        For examples, if you want to use the GPIO_INT13[3],
        you can define the IRQ_GPIO as the IRQ_GPIO13_2
*/
#define IRQ_GPJ0_INT5       145    // For Sample in case of using GPJ0_5 interrupt 

#define IRQ_MAX_S5PV210     146        // 107
#endif
#endif



//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//
//  Define:  IRQ_MAXIMUM
//
//  This value define maximum number of IRQs. Even if there isn't any
//  limitation for this number in OAL library, Windows CE resource manager
//  support only 64 IRQs currently.
//
#undef OAL_INTR_IRQ_MAXIMUM
#define OAL_INTR_IRQ_MAXIMUM        IRQ_MAX_S5PV210

//------------------------------------------------------------------------------
//
//  Define: PHYIRQ_XXX
//
//  Physical Interrupt Sources Numbers
//  Merged Vrtual IRQ Numbers
//
//  Drivers and Application have to use this Virtual IRQ Numbers
//  Virtual IRQ is defined in "oal_intr.h"

// VIC0
#define PHYIRQ_EINT0            0
#define PHYIRQ_EINT1            1
#define PHYIRQ_EINT2            2
#define PHYIRQ_EINT3            3
#define PHYIRQ_EINT4            4
#define PHYIRQ_EINT5            5
#define PHYIRQ_EINT6            6
#define PHYIRQ_EINT7            7
#define PHYIRQ_EINT8            8
#define PHYIRQ_EINT9            9
#define PHYIRQ_EINT10           10
#define PHYIRQ_EINT11           11
#define PHYIRQ_EINT12           12
#define PHYIRQ_EINT13           13
#define PHYIRQ_EINT14           14
#define PHYIRQ_EINT15           15
#define PHYIRQ_EINT16_31        16
#define PHYIRQ_RESERVED0        17  
#define PHYIRQ_MDMA             18
#define PHYIRQ_PDMA0            19
#define PHYIRQ_PDMA1            20
#define PHYIRQ_TIMER0           21
#define PHYIRQ_TIMER1           22
#define PHYIRQ_TIMER2           23
#define PHYIRQ_TIMER3           24
#define PHYIRQ_TIMER4           25
#define PHYIRQ_SYSTIMER         26
#define PHYIRQ_WDT              27
#define PHYIRQ_RTC_ALARM        28
#define PHYIRQ_RTC_TIC          29
#define PHYIRQ_GPIO             30
#define PHYIRQ_FIMC3            31
// VIC1
#define PHYIRQ_CORTEX0          32
#define PHYIRQ_CORTEX1          33
#define PHYIRQ_CORTEX2          34
#define PHYIRQ_CORTEX3          35
#define PHYIRQ_CORTEX4          36
#define PHYIRQ_IEMAPC           37
#define PHYIRQ_IEMIEC           38
#define PHYIRQ_RESERVED1        39  
#define PHYIRQ_NFC              40
#define PHYIRQ_CFC              41
#define PHYIRQ_UART0            42
#define PHYIRQ_UART1            43
#define PHYIRQ_UART2            44
#define PHYIRQ_UART3            45
#define PHYIRQ_I2C              46
#define PHYIRQ_SPI0             47
#define PHYIRQ_SPI1             48
#define PHYIRQ_SPI2             49
#define PHYIRQ_AUDIO_SS         50
#define PHYIRQ_I2C_PMIC_LINK    51
#define PHYIRQ_I2C_HDMI_PHY     52
#define PHYIRQ_HSIRX            53
#define PHYIRQ_HSITX            54
#define PHYIRQ_UHOST            55
#define PHYIRQ_OTG              56
#define PHYIRQ_MSM              57
#define PHYIRQ_SDMMC0           58
#define PHYIRQ_SDMMC1           59
#define PHYIRQ_SDMMC2           60
#define PHYIRQ_MIPI_CSI         61
#define PHYIRQ_MIPI_DSI         62
#define PHYIRQ_ONENAND_AUDI     63
// VIC2
#define PHYIRQ_LCD0             64
#define PHYIRQ_LCD1             65
#define PHYIRQ_LCD2             66
#define PHYIRQ_LCD3             67
#define PHYIRQ_ROTATOR          68  
#define PHYIRQ_FIMC0            69
#define PHYIRQ_FIMC1            70
#define PHYIRQ_FIMC2            71
#define PHYIRQ_JPEG             72
#define PHYIRQ_2D               73
#define PHYIRQ_3D               74
#define PHYIRQ_MIXER            75
#define PHYIRQ_HDMI             76
#define PHYIRQ_HDMI_I2C         77
#define PHYIRQ_MFC              78
#define PHYIRQ_TVENC            79
#define PHYIRQ_I2S0             80
#define PHYIRQ_I2S1             81
#define PHYIRQ_RESERVED2        82   
#define PHYIRQ_AC97             83
#define PHYIRQ_PCM0             84
#define PHYIRQ_PCM1             85
#define PHYIRQ_SPDIF            86
#define PHYIRQ_ADC              87
#define PHYIRQ_PENDN            88
#define PHYIRQ_KEYPAD           89
#define PHYIRQ_SPG              90
#define PHYIRQ_IntHash_SSS      91
#define PHYIRQ_IntFeedCtrl_SSS  92
#define PHYIRQ_RESERVED3        93
#define PHYIRQ_SDM_IRQ          94
#define PHYIRQ_SDM_FIQ          95
// VIC3
#define PHYIRQ_IPC              96
#define PHYIRQ_HOSTIF           97
#define PHYIRQ_SDMMC3           98
#define PHYIRQ_CEC              99
#define PHYIRQ_TSI              100
#define PHYIRQ_MDNIE0           101
#define PHYIRQ_MDNIE1           102
#define PHYIRQ_MDNIE2           103
#define PHYIRQ_MDNIE3           104
#define PHYIRQ_ADC1             105
#define PHYIRQ_PENDN1			106

#define PHYIRQ_MAX_S5PV210      107

#define VIC1_BIT_OFFSET         32
#define VIC2_BIT_OFFSET         64 
#define VIC3_BIT_OFFSET         96
//------------------------------------------------------------------------------

// For backward code compatibility 
// Following values are temporal...
#define PHYIRQ_LCD0_FIFO    PHYIRQ_LCD0
#define PHYIRQ_LCD1_FRAME   PHYIRQ_LCD1
#define PHYIRQ_LCD2_SYSIF   PHYIRQ_LCD2
#define PHYIRQ_LCD3_VP      PHYIRQ_LCD3
#define IRQ_LCD0_FIFO       IRQ_LCD0
#define IRQ_LCD1_FRAME      IRQ_LCD1
#define IRQ_LCD2_SYSIF      IRQ_LCD2
#define IRQ_LCD3_VP         IRQ_LCD3

#define PHYIRQ_POST         PHYIRQ_FIMC2
#define PHYIRQ_TVSCALER     PHYIRQ_FIMC1
#define IRQ_POST            IRQ_FIMC2
#define IRQ_TVSCALER        IRQ_FIMC1

#if __cplusplus
}
#endif

#endif    // __S5PV210_INTR_H
