//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  File:  image_cfg.h
//
//  Defines configuration parameters used to create the NK and Bootloader
//  program images.
//
#ifndef __IMAGE_CFG_H
#define __IMAGE_CFG_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//  RESTRICTION
//
//  This file is a configuration file. It should ONLY contain simple #define
//  directives defining constants. This file is included by other files that
//  only support simple substitutions.
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//  NAMING CONVENTION
//
//  The IMAGE_ naming convention ...
//
//  IMAGE_<NAME>_<SECTION>_<MEMORY_DEVICE>_[OFFSET|SIZE|START|END]
//
//      <NAME>          - WINCE, BOOT, SHARE
//      <SECTION>       - section name: user defined
//      <MEMORY_DEVICE> - the memory device the block resides on
//      OFFSET          - number of bytes from memory device start address
//      SIZE            - maximum size of the block
//      START           - start address of block    (device address + offset)
//      END             - end address of block      (start address  + size - 1)
//
//------------------------------------------------------------------------------


// DRAM1 Base Address
#define DRAM_BASE_PA_START					(0x40000000)
#define DRAM_BASE_CA_START					(0x80000000)
#define DRAM_BASE_UA_START					(0xA0000000)

#define DRAM_BASE_PA_LAST					(0x48000000)
#define DRAM_BASE_CA_LAST					(0x88000000)
#define DRAM_BASE_UA_LAST					(0xA8000000)

// Extra DRAM1 Base Address for V210
#define DRAM_EXTRA_BASE_PA_START			(0x48000000)
#define DRAM_EXTRA_BASE_CA_START			(0x99600000)
#define DRAM_EXTRA_BASE_UA_START			(0xB9600000)
#define DRAM_EXTRA_SIZE                     (0x04a00000) //(0x06A00000)  modified by terry 20120616
#define DRAM_EXTRA_BASE_UA_LAST				(DRAM_EXTRA_BASE_UA_START + DRAM_EXTRA_SIZE)

// DRAM0 Base Address
#define DRAM0_BASE_PA_START					(0x20000000)
#define DRAM0_BASE_CA_START					(0x88000000)
#define DRAM0_BASE_UA_START					(0xA8000000)

#define DRAM0_BASE_PA_LAST					(0x28000000)
#define DRAM0_BASE_CA_LAST					(0x90000000)
#define DRAM0_BASE_UA_LAST					(0xB0000000)

//------------------------------------------------------------------------------

// BSP ARGs Area
#define IMAGE_SHARE_ARGS_OFFSET				(0x00000800)
#define IMAGE_SHARE_ARGS_PA_START			(DRAM_BASE_PA_START+IMAGE_SHARE_ARGS_OFFSET)
#define IMAGE_SHARE_ARGS_CA_START			(DRAM_BASE_CA_START+IMAGE_SHARE_ARGS_OFFSET)
#define IMAGE_SHARE_ARGS_UA_START			(DRAM_BASE_UA_START+IMAGE_SHARE_ARGS_OFFSET)
#define IMAGE_SHARE_ARGS_SIZE				(0x00001000)

//------------------------------------------------------------------------------

/********************************************************************************/
/*                                                                              */
/*        BUFFERs Memory MAP                                                    */
/*                                                                              */
/********************************************************************************/
//DRAM_0
#if(S5PV210_EVT==0) // due to the restriction of 24bit boundary in FIMD buffer
#define IMAGE_CMM_0_BUFFER_SIZE                 (0x02180000)   // 33.5MB - MFC DPB, MFC FW, WriteBack, Camera, VDE
#define IMAGE_2D_FRAMEBUFFER_SIZE               (0x00C00000)   // 12MB - primary, overlay
#else
#define IMAGE_CMM_0_BUFFER_SIZE                 (0x01B80000)   // 27.5MB - MFC DPB, MFC FW, WriteBack, Camera, VDE
#define IMAGE_2D_FRAMEBUFFER_SIZE               (0x01000000)   // 16MB - 2D, primary, overlay
#endif

//DRAM_1 
#define IMAGE_DMA_CODE_SIZE                     (0x00100000)   // 1MB
#define IMAGE_CMM_1_BUFFER_SIZE                 (0x02000000)   // 32MB - MFC DPB, Camera


//----------------------------------- DMC_0 ------------------------------------
// Frame buffer
#define IMAGE_2D_FRAMEBUFFER_PA_START          (DRAM0_BASE_PA_LAST - IMAGE_2D_FRAMEBUFFER_SIZE)
#define IMAGE_2D_FRAMEBUFFER_UA_START          (DRAM0_BASE_UA_LAST - IMAGE_2D_FRAMEBUFFER_SIZE)


// CMM_0 memory
#define IMAGE_CMM_0_BUFFER_PA_START             (IMAGE_2D_FRAMEBUFFER_PA_START - IMAGE_CMM_0_BUFFER_SIZE)
#define IMAGE_CMM_0_BUFFER_UA_START             (IMAGE_2D_FRAMEBUFFER_UA_START - IMAGE_CMM_0_BUFFER_SIZE)

#define ONEDRAM_EXTSIZE_FOR_AP                  (IMAGE_CMM_0_BUFFER_PA_START - DRAM0_BASE_PA_START)


//----------------------------------- DMC_1 ------------------------------------
// DMA Code Area
#define IMAGE_DMA_CODE_PA_START                 (DRAM_BASE_PA_LAST - IMAGE_DMA_CODE_SIZE)
#define IMAGE_DMA_CODE_UA_START                 (DRAM_BASE_UA_LAST - IMAGE_DMA_CODE_SIZE)

// CMM_1 memory
#define IMAGE_CMM_1_BUFFER_PA_START             (IMAGE_DMA_CODE_PA_START - IMAGE_CMM_1_BUFFER_SIZE)
#define IMAGE_CMM_1_BUFFER_UA_START             (IMAGE_DMA_CODE_UA_START - IMAGE_CMM_1_BUFFER_SIZE)




/********************************************************************************/
/*                                                                              */
/*        Booting Sequence Memory Map                                           */
/*        STEPLDR, EBOOT, Kernel Load Memory Address                           */
/*                                                                              */
/********************************************************************************/
// Buffer Size
#define IMAGE_EBOOT_FRAMEBUFFER_SIZE            (0x00200000)
#define EBOOT_USB_BUFFER_SIZE			        (0x02000000)
#define EBOOT_USB_BUFFER_OFFSET			        (0x02000000)
#define EBOOT_USB_BUFFER_PA_START		        (DRAM_BASE_PA_START+EBOOT_USB_BUFFER_OFFSET)
#define EBOOT_USB_BUFFER_UA_START		        (DRAM_BASE_UA_START+EBOOT_USB_BUFFER_OFFSET)


// NBL1
#define IMAGE_NBL1_SIZE							(0x00004000)
#define IMAGE_NBL1_HEADER_SIZE                  (16)
#define HEADER_CHECKSUM_OFFSET                  (8)

// Eboot
#define IMAGE_EBOOT_OFFSET                      (0x07700000)
#define IMAGE_EBOOT_PA_START                    (DRAM_BASE_PA_START+IMAGE_EBOOT_OFFSET)
#define IMAGE_EBOOT_CA_START                    (DRAM_BASE_CA_START+IMAGE_EBOOT_OFFSET)
#define IMAGE_EBOOT_SIZE                        (0x80000)       // 512KB

// IPL
#define IMAGE_IPL_OFFSET                        (0x07780000)
#define IMAGE_IPL_ADDR_VA                       (DRAM_BASE_CA_START+IMAGE_IPL_OFFSET)
#define IMAGE_IPL_ADDR_PA                       (DRAM_BASE_PA_START+IMAGE_IPL_OFFSET)
#define IMAGE_IPL_SIZE                          (0x00080000)

//Eboot Frame Buffer : last 2MB
#define IMAGE_EBOOT_FRAMEBUFFER_PA_START	    (DRAM_BASE_PA_LAST - IMAGE_EBOOT_FRAMEBUFFER_SIZE)
#define IMAGE_EBOOT_FRAMEBUFFER_UA_START	    (DRAM_BASE_UA_LAST - IMAGE_EBOOT_FRAMEBUFFER_SIZE)

//BOOTPART buffer
#define BPART_BUFFER_OFFSET                     (0x07600000)
#define BPART_BUFFER_U_VIRTUAL                  (DRAM_BASE_UA_START + BPART_BUFFER_OFFSET)
#define BPART_BUFFER_LENGTH_BYTES               (0x00030000)

#define ONENAND_START_UA					    (UINT32)OALPAtoVA(BASE_REG_PA_ONDC, FALSE)
#define ONENAND_START_CA				    	(UINT32)OALPAtoVA(BASE_REG_PA_ONDC, TRUE)



#ifdef SDMMC_BOOT

//SDMMC BSP Definition
#define IMAGE_NK_SIZE  (0x040E0000)   //65M

#define FATFS_FOR_IMAGE		(0x1000000)   //16M
#define SECTOROFFATFS		(FATFS_FOR_IMAGE / SDMMC_SECTOR_SIZE)  //32k


#define IMAGESTARTSECTOR (MBRSTARTSECTOR+SECTOROFMBR) 
#define IMAGESIZE           (IMAGE_NK_SIZE)
//#define IMAGESIZE (0x10000000) // this value must be the same as Flash size in the memory.cfg.xml
#define SECTOROFIMAGE (IMAGESIZE/(SDMMC_SECTOR_SIZE))



#if 1// //added by terry for logo.bin 2012.06.27

#define LOGOSTARTSECTOR (TOCSTARTSECTOR+SECTOROFTOC)  //test
#define SECTORFORLOGO (0x600) // 800*480*2 = 768000 =(5DC) SECTOR

#define MBRSTARTSECTOR (LOGOSTARTSECTOR+SECTORFORLOGO) // to align 8KB
#define SECTOROFMBR         (0x100)

#else

#define MBRSTARTSECTOR (TOCSTARTSECTOR+SECTOROFTOC+7) // 7 sector means tocsector+7, to align 8KB
#define SECTOROFMBR         (0x100)
#endif

#define SECTOROFTOC (8)
#define TOCSTARTSECTOR (AISSTARTSECTOR+SECTOROFAIS) // to align 8KB

#define SECTOROFAIS (1) // Address Information Sector
#define AISSTARTSECTOR (BOOTIMAGESTARTSECTOR+SECTOROFBOOTIMAGE+15) // to align 8KB

//    modified by terry 2012.11.12     (0xA10) ->(0xA20)
#define SECTOROFBOOTIMAGE (0xA20) // bootimage means STEPLDR+IPL+EBOOT  

#define BOOTIMAGESTARTSECTOR (1)

//#define STEPLDRBUFFER 0x50200000
//#define STEPLDRSTARTADDRESS	0x50000000
#define SECTOROFSTEPLDR (0x20) //16K
#define STEPLDRSTARTSECTOR (1)

#define SECTOROFEBOOT (0x600)  //
#define EBOOTSTARTSECTOR (STEPLDRSTARTSECTOR+SECTOROFSTEPLDR)

#define SECTOROFIPL (0x400)
#define IPLSTARTSECTOR (EBOOTSTARTSECTOR+SECTOROFEBOOT)


//#define MBRSTARTSECTOR (FLASHIMAGESTARTSECTOR) // to align 4kb
//#define SECTOROFMBR (0x100)
#define BUF_TEMP_SIZE 0x40000

#define BUF_TEMP_SIZE 0x40000


typedef struct _ADDRESSINFOSECTOR{
	unsigned int dwSignature;
	unsigned int dwStepldrStartSector;
	unsigned int dwStepldrTotalSector;	
	unsigned int dwEbootStartSector;
	unsigned int dwEbootTotalSector;	
	unsigned int dwIPLStartSector;
	unsigned int dwIPLTotalSector;	
	unsigned int dwBootimageStartSector;
	unsigned int dwBootImageTotalSector;
	//added by terry for logo.bin  2012.06.27
	unsigned int dwLogoimageStartSector;
	unsigned int dwLogoImageTotalSector;
	
	unsigned int dwFlashImageStartSector;
	unsigned int dwFlashImageTotalSector;
	unsigned int dwTemp[(512/4)-5];
} ADDRESSINFOSECTOR, *PADDRESSINFOSECTOR;

#endif

#if __cplusplus
}
#endif

#endif
