//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: iis_reg.h
//
//  Defines the IIS bus control register layout and associated constants 
//  and types.
//
//------------------------------------------------------------------------------

#ifndef __S5PV210_IIS_H
#define __S5PV210_IIS_H

#if __cplusplus
    extern "C" 
    {
#endif


//------------------------------------------------------------------------------
//  Type: name    
//
//  Defines IIS bus control register layout. This register bank is located by
//  the constant CPU_BASE_REG_XX_IIS in the configuration file 
//  cpu_base_reg_cfg.h.
//

typedef struct 
{
    UINT32      IISCON;    // 0x00 - IIS interface control register
    UINT32      IISMOD;    // 0x04 - IIS interface mode register
    UINT32      IISFIC;    // 0x08 - IIS interface FIFO control register
    UINT32      IISPSR;    // 0x0c - IIS interface clock divider control register
    UINT32      IISTXD;    // 0x10 - IIS interface transmit data register
    UINT32      IISRXD;    // 0x14 - IIS interface receive data register
    UINT32      IISFICS;    //0x18 - IIS interface TXFIFO_S control register
    UINT32      IISTXDS;    //0x1C - IIS interface transmit data register for TXFIFO_S
    UINT32      IISAHB;        //0x20 - IIS AHB DMA control register
    UINT32      IISSTR0;        //0x24 - IIS AHB DMA start address register
    UINT32      IISSIZE;    //0x28 - IIS AHB DMA size register
    UINT32      IISTRNCNT;   //0x2C - IIS AHB DMA transfer count register
    UINT32      IISLVL0ADDR; //0x30 - IIS AHA DMA Interrupt level 0 register
    UINT32      IISLVL1ADDR; //0x34 - IIS AHA DMA Interrupt level 1 register
    UINT32      IISLVL2ADDR; //0x38 - IIS AHA DMA Interrupt level 2 register
    UINT32      IISLVL3ADDR; //0x3C - IIS AHA DMA Interrupt level 3 register
    UINT32      IISSTR1;
} IIS_REG, *PIIS_REG;

typedef struct 
{
    UINT32      ASS_CLK_SRC;    // 0x00 - IIS interface control register
    UINT32      ASS_CLK_DIV;    // 0x04 - IIS interface mode register
    UINT32      ASS_CLK_GATE;    // 0x08 - IIS interface FIFO control register
} ASS_CLK_REG, *PASS_CLK_REG;

typedef struct
{
    UINT32      ASS_INTR;
    UINT32      ASS_INTR_CODE;
    UINT32      ASS_INTR_INFO;
    UINT32      FRM_NUMBER;
    UINT32      ERR_CODE;
    UINT32      INST_START_ADDR;
    UINT32      DATA_START_ADDR;
} ASS_CBOX1_REG, *PASS_CBOX1_REG;    

typedef struct
{
    UINT32      RESET;
    UINT32      RP_PENDING;
    UINT32      FRM_SIZE;
    UINT32      NOTIFICATION;
    UINT32      GAIN_CTRL;
    UINT32      OBUF0_ADDR;
    UINT32      OBUF1_ADDR;
    UINT32      IBUF0_ADDR;
    UINT32      IBUF1_ADDR;
    UINT32      IBUF_SIZE;
    UINT32      TOT_BSTRM_SIZE;
    UINT32      RP_BOOT;
    UINT32      SRC_CTRL;
    UINT32      SW_DEFINE14;
    UINT32      SW_DEFINE15;
} ASS_CBOX2_REG, *PASS_CBOX2_REG;

typedef struct
{
    UINT32      PAD_PDN_CTRL;
    UINT32      MISC;
} ASS_CBOX3_REG, *PASS_CBOX3_REG;

typedef struct
{
    ASS_CBOX1_REG   CBox1;
    UINT32          PAD1[0x39];
    ASS_CBOX2_REG   CBox2;
    UINT32          PAD2[0x32];
    ASS_CBOX3_REG   CBox3;
} ASS_CBOX_REG, *PASS_CBOX_REG;

//3 ASS_CBOX1_REG.INTR_CODE
#define ASS_CBOX1_INTCODE_DONE      (1<<0)
#define ASS_CBOX1_INTCODE_ERROR     (1<<1)
#define ASS_CBOX1_INTCODE_REQUEST   (1<<2)
#define ASS_CBOX1_INTCODE_INFO      (1<<3)

//3 ASS_CBOX1_REG.INTR_INFO
//4 REQUEST PART
#define ASS_CBOX1_INTINFO_REQ_FILLING           (1<<0)
#define ASS_CBOX1_INTINFO_REQ_POSTPROCESSING0   (1<<1)
#define ASS_CBOX1_INTINFO_REQ_POSTPROCESSING1   (1<<2)
#define ASS_CBOX1_INTINFO_REQ_PREPROCESSING     (1<<3)

//4 ERROR PART
#define ASS_CBOX1_INTINFO_ERR_NONE              (0x000)
#define ASS_CBOX1_INTINFO_ERR_BUFLEN            (0x001)
#define ASS_CBOX1_INTINFO_ERR_BUFPTR            (0x002)
#define ASS_CBOX1_INTINFO_ERR_NOMEM             (0x031)
#define ASS_CBOX1_INTINFO_ERR_LOSTSYNC          (0x101)
#define ASS_CBOX1_INTINFO_ERR_BADLAYER          (0x102)
#define ASS_CBOX1_INTINFO_ERR_BADBITRATE        (0x103)
#define ASS_CBOX1_INTINFO_ERR_BADDAMPLERATE     (0x104)
#define ASS_CBOX1_INTINFO_ERR_BADEMPHASIS       (0x105)
#define ASS_CBOX1_INTINFO_ERR_BADCRC            (0x201)
#define ASS_CBOX1_INTINFO_ERR_BADBITALLOC       (0x211)
#define ASS_CBOX1_INTINFO_ERR_BADSCALEFACTOR    (0x221)
#define ASS_CBOX1_INTINFO_ERR_BADFRAMELEN       (0x231)
#define ASS_CBOX1_INTINFO_ERR_BADBIGVALUES      (0x232)
#define ASS_CBOX1_INTINFO_ERR_BADBLOCKTYPE      (0x233)
#define ASS_CBOX1_INTINFO_ERR_BADSCFSI          (0x234)
#define ASS_CBOX1_INTINFO_ERR_BADDATAPTR        (0x235)
#define ASS_CBOX1_INTINFO_ERR_BADPART3LEN       (0x236)
#define ASS_CBOX1_INTINFO_ERR_BADHUFFTABLE      (0x237)
#define ASS_CBOX1_INTINFO_ERR_BADHUFFDATA       (0x238)
#define ASS_CBOX1_INTINFO_ERR_BADSTEREO         (0x239)

//4 INFOMATION PART

//3 ASS_CBOX2_REG.NOTIFICATION
#define ASS_CBOX2_NOTIFY_SET_PPBYARM            (1<<0)
#define ASS_CBOX2_NOTIFY_SET_PPINT              (1<<1)

#if __cplusplus
    }
#endif

#endif 
