#ifndef __IIC_H
#define __IIC_H

#if __cplusplus
extern "C" 
{
#endif

//#define IOCTL_I2C_MAX_COUNT 4

#define IOCTL_I2C_GENERAL_READ_CODE     0
#define IOCTL_I2C_GENERAL_WRITE_CODE    1
#define IOCTL_I2C_SLOW_SLAVE_READ_CODE  2
#define IOCTL_I2C_SLOW_SLAVE_WRITE_CODE 3
#define IOCTL_I2C_VIRTUAL_READ_CODE     4
#define IOCTL_I2C_VIRTUAL_WRITE_CODE    5
#define IOCTL_I2C_GET_FASTCALL_CODE     6
#define IOCTL_I2C_CUSTOM1_READ_CODE     7
#define IOCTL_I2C_CUSTOM1_WRITE_CODE    8
#define IOCTL_I2C_INIT_CODE             10
#define IOCTL_I2C_EDIDSEGMENT_WRITE_CODE    11

#define IOCTL_I2C_INIT CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_INIT_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_INIT_DESC
{
	WORD 	IN_wSlaveAddr;
	DWORD 	IN_dwClockSpeed;
	DWORD 	OUT_dwActualSpeed;
} I2C_INIT_DESC, *PI2C_INIT_DESC;

#define IOCTL_I2C_GENERAL_READ CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_GENERAL_READ_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_I2C_GENERAL_WRITE CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_GENERAL_WRITE_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_RW_DESC
{
	PBYTE 	IO_pbtData;
	DWORD 	IN_dwData;
	BOOL	IN_bStop;
} I2C_READ_DESC, I2C_WRITE_DESC,  *PI2C_READ_DESC, *PI2C_WRITE_DESC;

#define IOCTL_I2C_SLOW_SLAVE_READ CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_SLOW_SLAVE_READ_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_I2C_SLOW_SLAVE_WRITE CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_SLOW_SLAVE_WRITE_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_SS_RW_DESC
{
	PBYTE 	IO_pbtData;
	DWORD 	IN_dwData;
	DWORD	IN_dwTime;	
	BOOL	IN_bStop;
} I2C_SS_READ_DESC, I2C_SS_WRITE_DESC,  *PI2C_SS_READ_DESC, *PI2C_SS_WRITE_DESC;

#define IOCTL_I2C_VIRTUAL_READ CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_VIRTUAL_READ_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_I2C_VIRTUAL_WRITE CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_VIRTUAL_WRITE_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_VT_RW_DESC
{
	DWORD 	IN_dwData;
	BOOL	IN_bStop;
	DWORD	OUT_dwFastCmd;
} I2C_VT_READ_DESC, I2C_VT_WRITE_DESC,  *PI2C_VT_READ_DESC, *PI2C_VT_WRITE_DESC;

#define IOCTL_I2C_GET_FASTCALL CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_GET_FASTCALL_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_FASTCALL {
    PVOID Context;   // opaque context
    BOOL (*I2CRead) (PVOID Context, PI2C_READ_DESC pReadDesc);
    BOOL (*I2CWrite)(PVOID Context, PI2C_WRITE_DESC pWriteDesc);
} I2C_FASTCALL, *PI2C_FASTCALL;

#define IOCTL_I2C_CUSTOM1_READ CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_CUSTOM2_READ_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_I2C_CUSTOM1_WRITE CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_CUSTOM2_WRITE_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
typedef struct _I2C_CUSTOM_DESC
{
	PBYTE	IO_pbtData;
	DWORD 	IN_dwData;
	DWORD	IN_dwTime;
	BOOL	IN_bStop;	
} I2C_CUSTOM_DESC, *PI2C_CUSTOM_DESC;

#define IOCTL_I2C_EDIDSEGMENT_WRITE CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_I2C_EDIDSEGMENT_WRITE_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)

#if __cplusplus
    }
#endif

#endif
