//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    clkinfo.h

Abstract:       System Clock definition

Functions:


Notes:


--*/

#ifndef _CLKINFO__H_
#define _CLKINFO__H_

typedef enum{
    SYS_CLK_DEF0 = 0,
    SYS_CLK_DEF1,  
    SYS_CLK_DEF2,
    SYS_CLK_DEF3,
    SYS_CLK_DEF_MAX
}SYS_CLK_DEF;


typedef struct{
    UINT32 SYS_CLK_DEF;
    UINT32 ARM_CLK;
    UINT32 HCLKMSYS_CLK;
    UINT32 PCLKMSYS_CLK;
    UINT32 HCLKDSYS_CLK;
    UINT32 PCLKDSYS_CLK;
    UINT32 HCLKPSYS_CLK;
    UINT32 PCLKPSYS_CLK;
    UINT32 APLLRATIO;
    UINT32 A2MRATIO;
    UINT32 HCLK_DSYSRATIO;
    UINT32 HCLK_PSYSRATIO;
    UINT32 DMC0RATIO;
    UINT32 ONENANDRATIO;
    UINT32 ARM_VOLTAGE;
    UINT32 INT_VOLTAGE;
}SYSTEM_CLOCK;

void ClockChange(void *pCMUCLKreg, void *pDMC0reg, void *pDMC1reg, void *pCLKInfo);

#endif _CLKINFO__H_
