;
; Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
; Use of this source code is subject to the terms of the Microsoft end-user
; license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
; If you did not accept the terms of the EULA, you are not authorized to use
; this source code. For a copy of the EULA, please see the LICENSE.RTF on your
; install media.
;

;;
;;  Header: base_regs.inc
;;
;;  This header file defines the Physical Addresses (PA) of
;;  the base registers for the System on Chip (SoC) components.
;;

;;
;;  NAMING CONVENTIONS
;;
;;  CPU_BASE_REG_ is the standard prefix for CPU base registers.
;;
;;  Memory ranges are accessed using physical, uncached, or cached addresses,
;;  depending on the system state. The following abbreviations are used for
;;  each addressing type:
;;
;;      PA - physical address
;;      UA - uncached virtual address
;;      CA - cached virtual address
;;
;;  The naming convention for CPU base registers is:
;;
;;      CPU_BASE_REG_<ADDRTYPE>_<SUBSYSTEM>
;;
;;

;---------------------------------------
; S5PV210 Register Physical Address 
;---------------------------------------

; - System -----------------------------
BASE_REG_PA_CHIPID          EQU     0xE0000000
BASE_REG_PA_CMU_CLK		    EQU     0xE0100000
BASE_REG_PA_CMU_SRST      	EQU     0xE0102000
BASE_REG_PA_CMU_IEM      	EQU     0xE0103000
BASE_REG_PA_CMU_SYS      	EQU     0xE0106200
BASE_REG_PA_CMU_MISC      	EQU     0xE0107000
BASE_REG_PA_PMU_OSC      	EQU     0xE0108000
BASE_REG_PA_PMU_RSTS      	EQU     0xE010A000
BASE_REG_PA_PMU_PM      	EQU     0xE010C000
BASE_REG_PA_PMU_MISC      	EQU     0xE010E000

BASE_REG_PA_GPIO            EQU     0xE0200000
BASE_REG_PA_IEM_APC         EQU     0xE0700000
BASE_REG_PA_IEM_IEC         EQU     0xE0800000                   
BASE_REG_PA_SECSS		    EQU 	0xEA000000
BASE_REG_PA_AXI_MSYS		EQU 	0xF1000000
BASE_REG_PA_AXI_LSYS		EQU 	0xFA400000
BASE_REG_PA_AXI_DSYS		EQU 	0xFA700000
BASE_REG_PA_ASYNC_MFC_VSYS0	EQU 	0xF1800000

; - VIC -----------------------------
BASE_REG_PA_VIC0            EQU     0xF2000000
BASE_REG_PA_VIC1            EQU     0xF2100000
BASE_REG_PA_VIC2            EQU     0xF2200000
BASE_REG_PA_VIC3            EQU     0xF2300000

; - TZIC -----------------------------
BASE_REG_PA_TZIC0            EQU     0xF2800000
BASE_REG_PA_TZIC1            EQU     0xF2900000
BASE_REG_PA_TZIC2            EQU     0xF2A00000
BASE_REG_PA_TZIC3            EQU     0xF2B00000

; - Memory -----------------------------
BASE_REG_PA_DMC0            EQU     0xF0000000
BASE_REG_PA_DMC1            EQU     0xF1400000
BASE_REG_PA_SROM            EQU     0xE8000000
BASE_REG_PA_CFCON           EQU     0xE8200000
BASE_REG_PA_ONENAND_IF      EQU     0xB0000000
BASE_REG_PA_ONENAND_MS      EQU     0xB0400000
BASE_REG_PA_ONENAND_CS      EQU     0xB0600000
BASE_REG_PA_ONENAND_RSV     EQU     0xB0800000
BASE_REG_PA_NFCON           EQU     0xB0E00000

; - DMA -----------------------------
BASE_REG_PA_MDMA            EQU     0xFA200000	; S5PV210 supports only Secure-MDMA.
BASE_REG_PA_PDMA0           EQU     0xE0900000	; S5PV210 supports only NonSecure-PDMA.
BASE_REG_PA_PDMA1           EQU     0xE0A00000


; - SDMMC -----------------------------
BASE_REG_PA_SDMMC0          EQU     0xEB000000
BASE_REG_PA_SDMMC1          EQU     0xEB100000
BASE_REG_PA_SDMMC2          EQU     0xEB200000
BASE_REG_PA_SDMMC3          EQU     0xEB300000

; - Modem -----------------------------
BASE_REG_PA_MSBM            EQU     0xED000000
BASE_REG_PA_MSMIF           EQU     0xED008000

; - USB -----------------------------
BASE_REG_PA_USBOTG_LINK     EQU     0xEC000000
BASE_REG_PA_USBOTG_PHY      EQU     0xEC100000
BASE_REG_PA_USBHOST_EHCI    EQU     0xEC200000
BASE_REG_PA_USBHOST_OHCI    EQU     0xEC300000

; - Multimedia -----------------------------
BASE_REG_PA_SDM	            EQU     0xF1600000
BASE_REG_PA_MFC             EQU     0xF1700000
BASE_REG_PA_FIMG_3DSE       EQU     0xF3000000
BASE_REG_PA_JPEG            EQU     0xFB600000
BASE_REG_PA_IPC             EQU     0xFB700000
;BASE_REG_PA_G2D            EQU     0x00000000
BASE_REG_PA_FIMD            EQU     0xF8000000
BASE_REG_PA_ROTATOR         EQU     0xFB100000
BASE_REG_PA_FIMC0           EQU     0xFB200000
BASE_REG_PA_FIMC1           EQU     0xFB300000 
BASE_REG_PA_FIMC2           EQU     0xFB400000
BASE_REG_PA_TVENC           EQU     0xF9000000
BASE_REG_PA_VP              EQU     0xF9100000
BASE_REG_PA_MIXER           EQU     0xF9200000
BASE_REG_PA_HDMISS          EQU     0xFA100000	; HDMI_LINK
BASE_REG_PA_MIE             EQU     0xF8100000
BASE_REG_PA_DSIM            EQU     0xFA500000
BASE_REG_PA_CSIS            EQU     0xFA600000
BASE_REG_PA_CEC             EQU     0xE1B00000

; - Timer -----------------------------
BASE_REG_PA_PWMTIMER        EQU     0xE2500000
BASE_REG_PA_SYSTIMER        EQU     0xE2600000
BASE_REG_PA_WATCHDOG        EQU     0xE2700000
BASE_REG_PA_RTC             EQU     0xE2800000

; - Connectivity -----------------------------
BASE_REG_PA_UART0           EQU     0xE2900000
BASE_REG_PA_UART1           EQU     0xE2900400
BASE_REG_PA_UART2           EQU     0xE2900800
BASE_REG_PA_UART3           EQU     0xE2900C00
BASE_REG_PA_I2C0            EQU     0xE1800000
BASE_REG_PA_I2C2            EQU     0xE1A00000
BASE_REG_PA_I2C_HDMI_PHY    EQU     0xFA900000
BASE_REG_PA_I2C_HDMI_DDC    EQU     0xFAB00000
BASE_REG_PA_SPI0            EQU     0xE1300000
BASE_REG_PA_SPI1            EQU     0xE1400000
BASE_REG_PA_SPI2            EQU     0xE1500000

; - Audio -----------------------------
BASE_REG_PA_AUDIO_SS		EQU     0xEE000000
BASE_REG_PA_SPDIF           EQU     0xE1100000
BASE_REG_PA_I2S0            EQU     0xEEE30000
BASE_REG_PA_I2S1            EQU     0xE2100000
BASE_REG_PA_I2S2            EQU     0xE2A00000

BASE_REG_PA_PCM2			EQU		0xE2B00000

; - Touch -----------------------------
BASE_REG_PA_TSADC0          EQU     0xE1700000
BASE_REG_PA_TSADC1          EQU     0xE1701000

;---------------------------------------
; S5PV210 Register Virtual Address 
;---------------------------------------
; - System -----------------------------
BASE_REG_CA_CHIPID          EQU     0x90000000

BASE_REG_CA_CMU_CLK		    EQU     0x90100000
BASE_REG_CA_CMU_SRST      	EQU     0x90102000
BASE_REG_CA_CMU_IEM      	EQU     0x90103000
BASE_REG_CA_CMU_SYS      	EQU     0x90106200
BASE_REG_CA_CMU_MISC      	EQU     0x90107000
BASE_REG_CA_PMU_OSC      	EQU     0x90108000
BASE_REG_CA_PMU_RSTS      	EQU     0x9010A000
BASE_REG_CA_PMU_PM      	EQU     0x9010C000
BASE_REG_CA_PMU_MISC      	EQU     0x9010E000

BASE_REG_CA_GPIO            EQU     0x90200000
BASE_REG_CA_IEM_IEC         EQU     0x90800000          
BASE_REG_CA_IEM_APC         EQU     0x90700000 
BASE_REG_CA_SECSS		    EQU 	0x92D00000
BASE_REG_CA_AXI_MSYS		EQU 	0x94A00000
BASE_REG_CA_AXI_LSYS		EQU 	0x97A00000
BASE_REG_CA_AXI_DSYS		EQU 	0x97D00000
BASE_REG_CA_ASYNC_MFC_VSYS0	EQU 	0x95100000

; - VIC -----------------------------
BASE_REG_CA_VIC0            EQU     0x95900000
BASE_REG_CA_VIC1             EQU     0x95A00000
BASE_REG_CA_VIC2             EQU     0x95B00000
BASE_REG_CA_VIC3             EQU     0x95C00000

; - TZIC -----------------------------
BASE_REG_CA_TZIC0           EQU     0x95D00000

; - Memory -----------------------------
BASE_REG_CA_DMC0            EQU     0x94900000
BASE_REG_CA_DMC1	    EQU	    0x94D00000
BASE_REG_CA_SROM	    EQU	    0x92B00000
BASE_REG_CA_CFCON           EQU     0x92C00000
BASE_REG_CA_ONENAND_IF      EQU     0x98C00000
BASE_REG_CA_ONENAND_MS      EQU     0x98E00000
BASE_REG_CA_ONENAND_CS      EQU     0x99000000
BASE_REG_CA_ONENAND_RSV     EQU     0x99200000
BASE_REG_CA_NFCON           EQU     0x99400000

; - DMA -----------------------------
BASE_REG_CA_MDMA            EQU     0x97800000
BASE_REG_CA_PDMA0           EQU     0x90900000
BASE_REG_CA_PDMA1           EQU     0x90A00000
BASE_REG_CA_SPDMA0          EQU     0x90B00000
BASE_REG_CA_SPDMA1          EQU     0x90C00000

; - SDMMC -----------------------------
BASE_REG_CA_SDMMC0          EQU     0x92E00000

; - Modem -----------------------------
BASE_REG_CA_MSBM		    EQU	    0x93700000

; - USB -----------------------------
BASE_REG_CA_USBOTG_LINK     EQU     0x93300000

; - Multimedia -----------------------------
BASE_REG_CA_SDM	            EQU     0x94F00000
BASE_REG_CA_MFC             EQU     0x95000000
BASE_REG_CA_FIMG_3DSE       EQU     0x96100000
BASE_REG_CA_JPEG            EQU     0x98A00000
BASE_REG_CA_IPC             EQU     0x98B00000
BASE_REG_CA_FIMD            EQU     0x97100000
BASE_REG_CA_MIE             EQU     0x97200000
BASE_REG_CA_ROTATOR         EQU     0x98600000
BASE_REG_CA_FIMC0           EQU     0x98700000
BASE_REG_CA_TVENC           EQU     0x97400000
BASE_REG_CA_HDMISS          EQU     0x97700000	; HDMI_LINK
BASE_REG_CA_DSIM            EQU     0x97B00000 ; MIPI
BASE_REG_CA_CSIS            EQU     0x97C00000 ; MIPI
BASE_REG_CA_CEC           EQU     0x91B00000

; - Timer -----------------------------
BASE_REG_CA_PWMTIMER        EQU     0x92500000

; - Connectivity -----------------------------
BASE_REG_CA_UART0           EQU     0x92900000
BASE_REG_CA_I2C0            EQU     0x91800000
BASE_REG_CA_I2C2            EQU     0x91A00000
BASE_REG_CA_I2C_HDMI_PHY    EQU     0x97F00000
BASE_REG_CA_I2C_HDMI_DDC    EQU     0x98100000
BASE_REG_CA_SPI0            EQU     0x91300000
BASE_REG_CA_SPI1            EQU     0x91400000
BASE_REG_CA_SPI2            EQU     0x91500000

; - Audio -----------------------------
BASE_REG_CA_AUDIO_SS		EQU	    0x93900000
BASE_REG_CA_SPDIF           EQU     0x91100000
BASE_REG_CA_I2S0            EQU     0x94730000
BASE_REG_CA_I2S1            EQU     0x92100000
BASE_REG_CA_I2S2            EQU     0x92A00000

BASE_REG_CA_PCM2			EQU		0x99500000

; - Touch -----------------------------
BASE_REG_CA_TSADC0          EQU     0x91701000
BASE_REG_CA_TSADC1          EQU     0x91701000
    END
