//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: cpu_base_reg.h
//
//  This header file defines the Physical Addresses (PA) of
//  the base registers for the System on Chip (SoC) components.
//
#ifndef __S5PV210_BASE_REG_H
#define __S5PV210_BASE_REG_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//  INFORMATION
//
//  The physical addresses for SoC registers are fixed, hence they are defined
//  in the CPU's common directory. The virtual addresses of the SoC registers
//  are defined by the OEM and are configured in the platform's configuration
//  directory by the file: .../PLATFORM/<NAME>/SRC/CONFIG/CPU_BASE_REG_CFG.H.
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//  NAMING CONVENTIONS
//
//  CPU_BASE_REG_ is the standard prefix for CPU base registers.
//
//  Memory ranges are accessed using physical, uncached, or cached addresses,
//  depending on the system state. The following abbreviations are used for
//  each addressing type:
//
//      PA - physical address
//      UA - uncached virtual address
//      CA - cached virtual address
//
//  The naming convention for CPU base registers is:
//
//      CPU_BASE_REG_<ADDRTYPE>_<SUBSYSTEM>
//
//------------------------------------------------------------------------------


#define BASE_REG_PA_ONENAND         0xB0000000

#define BASE_REG_PA_CHIPID          0xE0000000
#define BASE_REG_PA_CMU_CLK         0xE0100000
#define BASE_REG_PA_CMU_SRST        0xE0102000
#define BASE_REG_PA_CMU_IEM         0xE0103000
#define BASE_REG_PA_CMU_GCTRL       0xE0106100
#define BASE_REG_PA_CMU_SYS         0xE0106200
#define BASE_REG_PA_CMU_MISC        0xE0107000
#define BASE_REG_PA_PMU_OSC         0xE0108000
#define BASE_REG_PA_PMU_RSTS        0xE010A000
#define BASE_REG_PA_PMU_PM          0xE010C000
#define BASE_REG_PA_PMU_MISC        0xE010E000

#define BASE_REG_PA_GPIO            0xE0200000
#define BASE_REG_PA_IEM_IEC         0xE0800000
#define BASE_REG_PA_IEM_APC         0xE0700000

#define BASE_REG_PA_VIC0            0xF2000000
#define BASE_REG_PA_VIC1            0xF2100000
#define BASE_REG_PA_VIC2            0xF2200000
#define BASE_REG_PA_VIC3            0xF2300000

#define BASE_REG_PA_DMC0            0xF0000000
#define BASE_REG_PA_DMC1            0xF1400000
#define BASE_REG_PA_SROM            0xE8000000
#define BASE_REG_PA_ONDC            0xB0600000
#define BASE_REG_PA_NFCON           0xB0E00000
#define BASE_REG_PA_NFCON_ECC       0xB0E20000

#define BASE_REG_PA_MDMA            0xFA200000 
#define BASE_REG_PA_PDMA0           0xE0900000  
#define BASE_REG_PA_PDMA1           0xE0A00000  


#define BASE_REG_PA_SDMMC0          0xEB000000
#define BASE_REG_PA_SDMMC1          0xEB100000
#define BASE_REG_PA_SDMMC2          0xEB200000
#define BASE_REG_PA_SDMMC3          0xEB300000
#define BASE_REG_PA_CFCON           0xE8200000

#define BASE_REG_PA_MSBM            0xED000000  //< Modem Interface Internal SRAM Buffer memory (AP side)
#define BASE_REG_PA_MSMIF           0xED008000  //< Modem Interface SFR start address
#define BASE_REG_PA_USBOTG_LINK     0xEC000000
#define BASE_REG_PA_USBOTG_PHY      0xEC100000
#define BASE_REG_PA_USBHOST_EHCI    0xEC200000
#define BASE_REG_PA_USBHOST_OHCI    0xEC300000

#define BASE_REG_PA_FIMG_3DSE       0xF3000000
#define BASE_REG_PA_JPEG            0xFB600000
#define BASE_REG_PA_G2D             0xFA000000
#define BASE_REG_PA_LCDC            0xF8000000
#define BASE_REG_PA_ROTATOR         0xFB100000
#define BASE_REG_PA_CAMIF0          0xFB200000
#define BASE_REG_PA_CAMIF1          0xFB300000
#define BASE_REG_PA_CAMIF2          0xFB400000
#define BASE_REG_PA_TVENC           0xF9000000
#define BASE_REG_PA_VP              0xF9100000
#define BASE_REG_PA_MIXER           0xF9200000
#define BASE_REG_PA_HDMISS          0xFA100000
#define BASE_REG_PA_MFC             0xF1700000
#define BASE_REG_PA_MIE             0xF8100000
#define BASE_REG_PA_IPC             0xFB700000 //Interleave progressive converter
#define BASE_REG_PA_CEC             0xE1B00000


#define BASE_REG_PA_PWMTIMER        0xE2500000
#define BASE_REG_PA_SYSTIMER        0xE2600000
#define BASE_REG_PA_WATCHDOG        0xE2700000
#define BASE_REG_PA_RTC             0xE2800000
#define BASE_REG_PA_UART0           0xE2900000
#define BASE_REG_PA_UART1           0xE2900400
#define BASE_REG_PA_UART2           0xE2900800
#define BASE_REG_PA_UART3           0xE2900C00
#define BASE_REG_PA_I2C0            0xE1800000  //General IIC
#define BASE_REG_PA_I2C2            0xE1A00000  //PMIC IIC
#define BASE_REG_PA_I2C_HDMI_PHY    0xFA900000
#define BASE_REG_PA_I2C_HDMI_DDC    0xFAB00000
#define BASE_REG_PA_SPI0            0xE1300000
#define BASE_REG_PA_SPI1            0xE1400000
#define BASE_REG_PA_SPI2            0xE1500000

#define BASE_REG_PA_MIPI_DSIM       0xFA500000
#define BASE_REG_PA_MIPI_CSI_BASE   0xFA600000


#define BASE_REG_PA_SPDIF           0xE1100000
#define BASE_REG_PA_I2S0            0xEEE30000  //5.1ch
#define BASE_REG_PA_I2S1            0xE2100000
#define BASE_REG_PA_I2S2            0xE2A00000

#define BASE_REG_PA_PCM0            0xE2300000 
#define BASE_REG_PA_PCM1            0xE1200000
#define BASE_REG_PA_PCM2            0xE2B00000

#define BASE_REG_PA_KEYIF			0xE1600000

#define BASE_REG_PA_TSADC0			0xE1700000
#define BASE_REG_PA_TSADC1			0xE1701000


#define BASE_REG_PA_SEC             0x00000000
#define BASE_REG_PA_APBST           0x00000000
#define BASE_REG_PA_APBLMT          0x00000000


#define BASE_REG_UA_USBOTG_LINK     0xB3300000
#define BASE_REG_UA_USBOTG_PHY      0xB3400000


#if __cplusplus
}
#endif

#endif

