//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------

#pragma once

#include "windows.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define WAVE_NAME L"WAV1:"

#define IOCTL_WAVE_ULPA_SET_CODE        0
#define IOCTL_WAVE_ULPA_CLR_CODE        1
#define IOCTL_WAVE_SRAM_SET_CODE        2
#define IOCTL_WAVE_SRAM_CLR_CODE        3
#define IOCTL_WAVE_MEDIUM_INFO_GET_CODE 4

#define IOCTL_WAVE_ULPA_SET             CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_WAVE_ULPA_SET_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_ULPA_CLR             CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_WAVE_ULPA_CLR_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_SRAM_SET             CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_WAVE_SRAM_SET_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_SRAM_CLR             CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_WAVE_SRAM_CLR_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_MEDIUM_INFO_GET      CTL_CODE(FILE_DEVICE_CONTROLLER, IOCTL_WAVE_MEDIUM_INFO_GET_CODE, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_WAVE_CODEC_SET IOCTL_WAVE_ULPA_SET
#define IOCTL_WAVE_CODEC_CLR IOCTL_WAVE_ULPA_CLR

typedef enum
{
    MEDIUM_IIS,
    MEDIUM_SPDIF
} WAVE_MEDIUM;

typedef enum
{
    DFORMAT_IIS,
    DFORMAT_MSB,
    DFORMAT_LSB
} IIS_DFORMAT;

typedef enum
{
    LEFT_LOW,
    LEFT_HIGH
} IIS_LRP;

typedef enum
{
    BCLK_32,
    BCLK_48,
    BCLK_16,
    BCLK_24
} IIS_BCLK;

typedef enum
{
    BLENGTH_16,
    BLENGTH_8,
    BLENGTH_24
} IIS_BLENGTH;

typedef struct _MEDIUM_INFO
{
    WAVE_MEDIUM MediumClass;
    IIS_DFORMAT DataFormat;
    IIS_LRP     Polarity;
    IIS_BCLK    BitClk;
    IIS_BLENGTH BitLength;
    DWORD       dwLRClk; //Unit : Khz
} MEDIUM_INFO,*PMEDIUM_INFO;

#ifdef __cplusplus
}
#endif // __cplusplus