/*
**************************************************************************
*
*                                            SAMSUNG ELECTRONICS
*                                                 Copyright(C) 2006
*                                              ALL RIGHTS RESERVED
*
* This program is proprietary to Samsung Electronics,and is protected under International
* Copyright Act as an unpublished work.Its use and disclosure is limited by the terms and
* conditions of a license agreement.  It may not  be copied  or  otherwise   reproduced or
* disclosed  to persons  outside  the  licensee's   organization  except  in  accordance with
* the  terms and conditions  of such  an agreement. All copies and  reproductions shall be
* the property of  Samsung  Electronics  and  must bear this  notice in its entirety.
*
**************************************************************************
*/
/*
*
*    File name : sgip_GPIO.h
*
*    Descriptions : this file contains the Samsung General purpose IO port Primitives (SGIP).
*                              Main macros for GPIO Handling
*
*     History         :
*            Oct 18 2006 : First generated.
*            Mar 06 2007 : Modified for S3C6400 by jlpark
*            Jul 17 2009 : Modified for S5PV210 by JOHNLAY
*            Apr 12 2010 : Modified for S5PV210 by jungchul2.park
*/

#ifndef __SGIP_GPIO_H__
#define __SGIP_GPIO_H__

#include "sgip_Primitives.h"

// Main Pin Method  _______________________________________________________________
// GPIO Control Function
#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_PinFunction(BaseAddr, Attribute)    {                \
    DWORD       Confirm;                                                        \
    (sgipConRegAddr(BaseAddr, Attribute)) =                  \
    (sgipConRegAddr(BaseAddr, Attribute)) &                  \
    ~((sgipConMask(Attribute)) << (sgipConIdx(Attribute))) |  \
    ((sgipGetConVal(Attribute)) << (sgipConIdx(Attribute)));  \
    Confirm = (sgipConRegAddr(BaseAddr, Attribute));   \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif
#define Get_PinFunction(BaseAddr, Attribute)    (((sgipConRegAddr(BaseAddr,Attribute)) & ((sgipConMask(Attribute)) << (sgipConIdx(Attribute)))) >> (sgipConIdx(Attribute)))

#define sgip_HIGH    0x1
#define sgip_LOW     0x0

// GPIO Data Function
#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_PinData(BaseAddr, Attribute, val) {             \
    DWORD       Confirm;                                                 \
    (sgipDatRegAddr(BaseAddr, Attribute)) =                  \
    (sgipDatRegAddr(BaseAddr, Attribute)) &                  \
    ~(MASK_1 << (sgipGetPinIdx(Attribute))) |                   \
    ((val) << (sgipGetPinIdx(Attribute)));                   \
    Confirm = (sgipDatRegAddr(BaseAddr, Attribute));    \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif
#define Get_PinData(BaseAddr, Attribute) (((sgipDatRegAddr(BaseAddr, Attribute)) & (MASK_1 << (sgipGetPinIdx(Attribute)))) >> (sgipGetPinIdx(Attribute)))

// GPIO Pull Function
#define sgip_PULL_DISABLE    0x0
#define sgip_PULL_DOWN       0x1
#define sgip_PULL_UP         0x2

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_PinPullUD(BaseAddr, Attribute, val) {            \
    DWORD       Confirm;                                                    \
    (sgipPuRegAddr(BaseAddr, Attribute)) =                    \
    (sgipPuRegAddr(BaseAddr, Attribute)) &                    \
    ~(SGIP_PuMask << (sgipGetPuPinIdx(Attribute))) |            \
    ((val) << (sgipGetPuPinIdx(Attribute)));                    \
    Confirm = (sgipPuRegAddr(BaseAddr, Attribute)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif


// GPIO Drv Strength Function
#define sgip_DRV_1x            0x0
#define sgip_DRV_3x            0x1
#define sgip_DRV_2x            0x2
#define sgip_DRV_4x            0x3

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_PinDrv(BaseAddr, Attribute, val) {            \
    DWORD       Confirm;                                                        \
    (sgipDrvRegAddr(BaseAddr, Attribute)) =                    \
    (sgipDrvRegAddr(BaseAddr, Attribute)) &                    \
    ~(SGIP_PuMask << (sgipGetPuPinIdx(Attribute))) |            \
    ((val) << (sgipGetPuPinIdx(Attribute)));                    \
    Confirm = (sgipDrvRegAddr(BaseAddr, Attribute)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

// GPIO Power down configure Function
#define sgip_Output_0    0x0
#define sgip_Output_1    0x1
#define sgip_Input        0x2
#define    sgip_Prev_Val    0x3

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_PinConPD(BaseAddr, Attribute, val) {            \
    DWORD       Confirm;                                                        \
    (sgipConPDRegAddr(BaseAddr, Attribute)) =                    \
    (sgipConPDRegAddr(BaseAddr, Attribute)) &                    \
    ~(SGIP_PuMask << (sgipGetPuPinIdx(Attribute))) |            \
    ((val) << (sgipGetPuPinIdx(Attribute)));                    \
    Confirm = (sgipConPDRegAddr(BaseAddr, Attribute)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
// GPIO Power down Pull Function
#define Set_PinPullPD(BaseAddr, Attribute, val) {            \
    DWORD       Confirm;                                                        \
    (sgipPuPDRegAddr(BaseAddr, Attribute)) =                    \
    (sgipPuPDRegAddr(BaseAddr, Attribute)) &                    \
    ~(SGIP_PuMask << (sgipGetPuPinIdx(Attribute))) |            \
    ((val) << (sgipGetPuPinIdx(Attribute)));                    \
    Confirm = (sgipPuPDRegAddr(BaseAddr, Attribute)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif


// Wakeup EINT Method  _______________________________________________________________
#define sgip_LOW_LEVEL 		0x0
#define sgip_HIGH_LEVEL 		0x1
#define sgip_FALLING_EDGE 	0x2
#define sgip_RISING_EDGE 	0x3
#define sgip_BOTH_EDGE 		0x4

#define sgip_DELAY_FLT          0x0
#define sgip_DIGITAL_FLT       0x1

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_EXTINT_TRLVL(BaseAddr,Attr,TrType)  {            \
    DWORD       Confirm;                                                        \
    (sgipEINTConRegAddr(BaseAddr,Attr)) =                    \
    (sgipEINTConRegAddr(BaseAddr,Attr)) &                    \
    ~(0x7 << (sgipEINTCONOFT(Attr))) |            \
    ((TrType) << (sgipEINTCONOFT(Attr)));                    \
    Confirm = (sgipEINTConRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#define Get_EXTINT_TRLVL(BaseAddr,Attr)     ((sgipEINTConRegAddr(BaseAddr,Attr)) & (0x7 << (sgipEINTCONOFT(Attr))))

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Set_EXTINT_FILTER(BaseAddr,Attr,Fltype,FltWidth)  {            \
    DWORD       Confirm;                                                        \
    (sgipEINTFLTRegAddr(BaseAddr,Attr)) =                    \
    (sgipEINTFLTRegAddr(BaseAddr,Attr)) &                    \
    ~(0x7 << (sgipEINTFLTOFT(Attr))) |            \
    ((((FltWidth)&0x3f)|(((Fltype)&0x1)<<6)|(0x1<<7)) << (sgipEINTFLTOFT(Attr)));                    \
    Confirm = (sgipEINTFLTRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Clr_EXTINT_FILTER(BaseAddr,Attr)    {            \
    DWORD       Confirm;                                                        \
    (sgipEINTFLTRegAddr(BaseAddr,Attr)) =                    \
    (sgipEINTFLTRegAddr(BaseAddr,Attr)) &                    \
    ~(0x7 << (sgipEINTFLTOFT(Attr)));            \
    Confirm = (sgipEINTFLTRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Mask_EXTINT(BaseAddr,Attr)  {            \
    DWORD       Confirm;                                                        \
    (sgipEINTMSKRegAddr(BaseAddr,Attr)) =                    \
    (sgipEINTMSKRegAddr(BaseAddr,Attr)) |                    \
    ((0x1) << (sgipEINTMSKOFT(Attr)));                    \
    Confirm = (sgipEINTMSKRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Unmask_EXTINT(BaseAddr,Attr)  {            \
    DWORD       Confirm;                                                        \
    (sgipEINTMSKRegAddr(BaseAddr,Attr)) =                    \
    (sgipEINTMSKRegAddr(BaseAddr,Attr)) &                    \
    ~(0x1 << (sgipEINTMSKOFT(Attr)));            \
    Confirm = (sgipEINTMSKRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#if (S5PV210_EVT==0)
#pragma optimize ("",off)
#endif
#define Clear_EXTINT(BaseAddr,Attr)  {            \
    DWORD       Confirm;                                                        \
    (sgipEINTPNDRegAddr(BaseAddr,Attr)) = (0x1 << (sgipEINTPNDOFT(Attr)));            \
    Confirm = (sgipEINTPNDRegAddr(BaseAddr,Attr)); \
} while(0)
#if (S5PV210_EVT==0)
#pragma optimize ("",on)
#endif

#define Get_EXTINT(BaseAddr,Attr)  ((sgipEINTPNDRegAddr(BaseAddr,Attr)) & (0x1 << (sgipEINTPNDOFT(Attr))))

#endif  //__SGIP_GPIO_H__
