//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  PMUEntry_reg.h
//
//  Defines the Power management unit registers entries and associated
//  types and constants.
//
#ifndef __S5PV210_PMUENTRY_H
#define __S5PV210_PMUENTRY_H

#if __cplusplus
extern "C" {
#endif
//------------------------------------------------------------------------------
//  System PMU control registers

// For PMU Clock Controller : Clock control ____________________________Clock Controller___
typedef UINT32  _CLK_CON_REG;
// For PMU Reset Controller : Reset status _______________________________Reset status ___
typedef UINT32  _RST_STS_REG;

// For PMU Power Management : Power Configuration ______________ Power Management ____
typedef struct                          // 0xC000
{
    UINT32	PWR_CFG	;
    UINT32	EINT_WAKEUP_MASK	;
    UINT32	WAKEUP_MASK	;
    UINT32	RVD0	;    //0xC
    UINT32	NORMAL_CFG	;
    UINT32	RVD1[3]	;   // 0x14 ~ 0x1C
    UINT32	IDLE_CFG	;
    UINT32	RVD2[3]	;   // 0x24 ~ 0x2C
    UINT32	STOP_CFG	;
    UINT32	STOP_MEM_CFG	;
    UINT32	RVD3[2]	;   // 0x38 ~ 0x3C
    UINT32	SLEEP_CFG	;
    UINT32	RVD4[47]	;   // 0x44 ~ 0xFC
} _PWR_CFG_REG;

// For PMU Power Management :PLL setting register.
typedef struct                          // 0xC100
{
    UINT32	OSC_FREQ	;
    UINT32	OSC_STABLE	;
    UINT32	PWR_STABLE	;
    UINT32	RVD0	;
    UINT32	MTC_STABLE	;
    UINT32	CLAMP_STABLE	;
    UINT32	RVD1[58]	;   // 0x18 ~ 0xFC
} _PWR_STA_REG;

// For PMU Power Management :PLL setting register.
typedef struct                          // 0xC200
{
    UINT32	WAKEUP_STAT	;
    UINT32	BLK_PWR_STAT	;
    UINT32	RVD[62]	;   // 0x8 ~ 0xFC
} _PWR_STS_REG;

// For PMU Power Management :PLL setting register.
typedef struct                          // 0xC300
{
    UINT32	BODY_BIAS_CON	;
    UINT32	RVD0[3]	;   // 0x4 ~ 0xC
    UINT32	ION_SKEW_CON	;
    UINT32	ION_SKEW_MON	;
    UINT32	RVD1[2]	;   // 0x18 ~ 0x1C
    UINT32	IOFF_SKEW_CON	;
    UINT32	IOFF_SKEW_MON	;
//    UINT32	RVD2[822]	;   // 0x338 ~ 0xFFC
} _PWR_ABB_REG;

// For PMU System Control and MISC : System Controll _________________Clock Controller___
typedef struct              // 0xE000
{
    UINT32  OTHERS;
    UINT32  RVD[63];        //0x4 ~ 0xFC
} _SYS_CON_REG;
// For PMU System Control  : Clock control
typedef struct
{
    UINT32  OM_STAT;
    UINT32 RVD[447];             // 0x104 ~ 0x7FC
} _SYS_STS_REG;

// For PMU System Control and MISC : Status register
typedef struct                          // 0xE800
{
    UINT32	MIE_CONTROL	;
    UINT32	HDMI_CONTROL	;
    UINT32	RVD0	;               // 0x8
    UINT32	USB_PHY_CONTROL	;
    UINT32	DAC_CONTROL	;
    UINT32	MIPI_DPHY_CONTROL	;
    UINT32	ADC_CONTROL	;
    UINT32	PS_HOLD_CONTROL	;
    UINT32	RVD1[504]	;               // 0x820 ~ 0xFFC
} _SYS_IPC_REG;

// For PMU System Control and MISC :IP Control
typedef struct                          // 0xF000
{
    UINT32	INFORM0	;                   // CPU ID
    UINT32	INFORM1	;                   // Sleep/wakeup
    UINT32	INFORM2	;                   // Resest Reason
    UINT32	INFORM3	;
    UINT32	INFORM4	;
    UINT32	INFORM5	;
    UINT32	INFORM6	;
    UINT32	INFORM7	;
//    UINT32	RVD[1016]	;           // 0x20 ~ 0xFFC
} _SYS_MIS_REG;


#if __cplusplus
}
#endif

#endif // __S5PV210_PMUENTRY_H



