
/**************************************************************************

Module Name:  MAX8698.h

Abstract:


**************************************************************************/


#ifndef __MAX8698__
#define __MAX8698__

#define PMIC_SLAVE_ADDR 0x66

#define MAX_MAX8698_REG_NUM	16 

//I2C Control Register
#define ONOFF1			0x0
#define ONOFF2			0x1
#define ADISCHG_EN1		0x2
#define ADISCHG_EN2		0x3
#define DVSARM1_2		0x4
#define DVSARM3_4		0x5
#define DVSINT1_2		0x6
#define BUCK3			0x7
#define LDO2_3			0x8
#define LDO4			0x9
#define LDO5			0xA
#define LDO6			0xB
#define LDO7			0xC
#define LDO8			0xD
#define LDO9			0xE
#define LBCNFG			0xF

//ONOFF1 Reg bits
#define EN1				(0x01 << 7)
#define EN2				(0x01 << 6)
#define EN3				(0x01 << 5)
#define ELDO2			(0x01 << 4)
#define ELDO3			(0x01 << 3)
#define ELDO4			(0x01 << 2)
#define ELDO5			(0x01 << 1)

//ONOFF2 Reg bits
#define ELDO6			(0x01 << 7)
#define ELDO7			(0x01 << 6)
#define ELDO8			(0x01 << 5)
#define ELDO9			(0x01 << 4)
#define ELBCNFG			(0x01 << 0)

//ADISCHG_EN1 Reg bits
#define BUCK1_ADEN		(0x01 << 7)
#define BUCK2_ADEN		(0x01 << 6)
#define BUCK3_ADEN		(0x01 << 5)
#define LDO2_ADEN		(0x01 << 4)
#define LDO3_ADEN		(0x01 << 3)
#define LDO4_ADEN		(0x01 << 2)
#define LDO5_ADEN		(0x01 << 1)
#define LDO6_ADEN		(0x01 << 0)

//ADISCHG_EN2 Reg bits
#define LDO7_ADEN		(0x01 << 7)
#define LDO8_ADEN		(0x01 << 6)
#define LDO9_ADEN		(0x01 << 5)
#define RAMP_MASK		(0x0F << 0)
#define RAMP_1MV_US		(0x0)
#define RAMP_2MV_US		(0x1)
#define RAMP_3MV_US		(0x2)
#define RAMP_4MV_US		(0x3)
#define RAMP_5MV_US		(0x4)
#define RAMP_6MV_US		(0x5)
#define RAMP_7MV_US		(0x6)
#define RAMP_8MV_US		(0x7)
#define RAMP_9MV_US		(0x8)
#define RAMP_10MV_US	(0x9)
#define RAMP_11MV_US	(0xA)
#define RAMP_12MV_US	(0xB)


//DVSARM 1~4
#define DVSARM2_START	(4)
#define DVSARM2_MASK	(0x0F << DVSARM2_START)
#define DVSARM1_MASK	(0x0F << 0)
#define DVSARM4_START	(4)
#define DVSARM4_MASK	(0x0F << DVSARM4_START)
#define DVSARM3_MASK	(0x0F << 0)
#define DVSARM_0_75		(0x0)
#define DVSARM_0_80		(0x1)
#define DVSARM_0_85		(0x2)
#define DVSARM_0_90		(0x3)
#define DVSARM_0_95		(0x4)
#define DVSARM_1_00		(0x5)
#define DVSARM_1_05		(0x6)
#define DVSARM_1_10		(0x7)
#define DVSARM_1_15		(0x8)
#define DVSARM_1_20		(0x9)
#define DVSARM_1_25		(0xA)
#define DVSARM_1_30		(0xB)
#define DVSARM_1_35		(0xC)
#define DVSARM_1_40		(0xD)
#define DVSARM_1_45		(0xE)
#define DVSARM_1_50		(0xF)

//DVSINT 1~2
#define DVSINT2_START	(4)
#define DVSINT2_MASK	(0x0F << DVSINT2_START)
#define DVSINT1_MASK	(0x0F << 0)
#define DVSINT_0_75		(0x0)
#define DVSINT_0_80		(0x1)
#define DVSINT_0_85		(0x2)
#define DVSINT_0_90		(0x3)
#define DVSINT_0_95		(0x4)
#define DVSINT_1_00		(0x5)
#define DVSINT_1_05		(0x6)
#define DVSINT_1_10		(0x7)
#define DVSINT_1_15		(0x8)
#define DVSINT_1_20		(0x9)
#define DVSINT_1_25		(0xA)
#define DVSINT_1_30		(0xB)
#define DVSINT_1_35		(0xC)
#define DVSINT_1_40		(0xD)
#define DVSINT_1_45		(0xE)
#define DVSINT_1_50		(0xF)

//BUCK3
#define BUCK3_1_60		(0x00)
#define BUCK3_1_70		(0x01)
#define BUCK3_1_80		(0x02)
#define BUCK3_1_90		(0x03)
#define BUCK3_2_00		(0x04)
#define BUCK3_2_10		(0x05)
#define BUCK3_2_20		(0x06)
#define BUCK3_2_30		(0x07)
#define BUCK3_2_40		(0x08)
#define BUCK3_2_50		(0x09)
#define BUCK3_2_60		(0x0A)
#define BUCK3_2_70		(0x0B)
#define BUCK3_2_80		(0x0C)
#define BUCK3_2_90		(0x0D)
#define BUCK3_3_00		(0x0E)
#define BUCK3_3_10		(0x0F)
#define BUCK3_3_20		(0x10)
#define BUCK3_3_30		(0x11)
#define BUCK3_3_40		(0x12)
#define BUCK3_3_50		(0x13)
#define BUCK3_3_60		(0x14)

//LDO 2~3
#define LDO3_START		(4)
#define LDO3_MASK		(0x0F << LDO3_START)
#define LDO2_MASK		(0x0F << 0)
#define LDO2TO3_0_80	(0x0)
#define LDO2TO3_0_85	(0x1)
#define LDO2TO3_0_90	(0x2)
#define LDO2TO3_0_95	(0x3)
#define LDO2TO3_1_00	(0x4)
#define LDO2TO3_1_05	(0x5)
#define LDO2TO3_1_10	(0x6)
#define LDO2TO3_1_15	(0x7)
#define LDO2TO3_1_20	(0x8)
#define LDO2TO3_1_25	(0x9)
#define LDO2TO3_1_30	(0xA)

//LDO 4~7
#define LDO4TO7_1_60	(0x00)
#define LDO4TO7_1_70	(0x01)
#define LDO4TO7_1_80	(0x02)
#define LDO4TO7_1_90	(0x03)
#define LDO4TO7_2_00	(0x04)
#define LDO4TO7_2_10	(0x05)
#define LDO4TO7_2_20	(0x06)
#define LDO4TO7_2_30	(0x07)
#define LDO4TO7_2_40	(0x08)
#define LDO4TO7_2_50	(0x09)
#define LDO4TO7_2_60	(0x0A)
#define LDO4TO7_2_70	(0x0B)
#define LDO4TO7_2_80	(0x0C)
#define LDO4TO7_2_90	(0x0D)
#define LDO4TO7_3_00	(0x0E)
#define LDO4TO7_3_10	(0x0F)
#define LDO4TO7_3_20	(0x10)
#define LDO4TO7_3_30	(0x11)
#define LDO4TO7_3_40	(0x12)
#define LDO4TO7_3_50	(0x13)
#define LDO4TO7_3_60	(0x14)

//LDO8
#define LDO8_START		(4)
#define LDO8_MASK		(0x0F << LDO8_START)
#define BKCHR_MASK		(0x0F << 0)
#define LDO8_3_00		(0x0)
#define LDO8_3_10		(0x1)
#define LDO8_3_20		(0x2)
#define LDO8_3_30		(0x3)
#define LDO8_3_40		(0x4)
#define LDO8_3_50		(0x5)
#define LDO8_3_60		(0x6)
#define BKCHR_2_90		(0x0)
#define BKCHR_3_00		(0x1)
#define BKCHR_3_10		(0x2)
#define BKCHR_3_20		(0x3)
#define BKCHR_3_30		(0x4)

//LDO9
#define LDO9_1_60		(0x00)
#define LDO9_1_70		(0x01)
#define LDO9_1_80		(0x02)
#define LDO9_1_90		(0x03)
#define LDO9_2_00		(0x04)
#define LDO9_2_10		(0x05)
#define LDO9_2_20		(0x06)
#define LDO9_2_30		(0x07)
#define LDO9_2_40		(0x08)
#define LDO9_2_50		(0x09)
#define LDO9_2_60		(0x0A)
#define LDO9_2_70		(0x0B)
#define LDO9_2_80		(0x0C)
#define LDO9_2_90		(0x0D)
#define LDO9_3_00		(0x0E)
#define LDO9_3_10		(0x0F)
#define LDO9_3_20		(0x10)
#define LDO9_3_30		(0x11)
#define LDO9_3_40		(0x12)
#define LDO9_3_50		(0x13)
#define LDO9_3_60		(0x14)

//LBCNFG 
#define LBHYST_START 		(4)
#define LBHYST_MASK		(0x3 << LBHYST_START)
#define LBTH_START		(1)
#define LBTH_MASK		(0x7 << LBTH_START)
#define LBHYST_100MV	(0x0)
#define LBHYST_200MV	(0x1)
#define LBHYST_300MV	(0x2)
#define LBHYST_400MV	(0x3)
#define LBTH_2_80		(0x0)
#define LBTH_2_90		(0x1)
#define LBTH_3_00		(0x2)
#define LBTH_3_10		(0x3)
#define LBTH_3_20		(0x4)
#define LBTH_3_30		(0x5)
#define LBTH_3_40		(0x6)
#define LBTH_3_50		(0x7)

//S5PV210 LDO on/off setting value
//setting for Init and Wakeup
#define ONOFF1_REG_VALUE_INIT	(EN3|ELDO2|ELDO3|ELDO4|ELDO5)
#define ONOFF2_REG_VALUE_INIT	(ELDO6|ELDO7|ELDO8|ELDO9|ELBCNFG)

//setting for Sleep
#define ONOFF1_REG_VALUE_SLEEP	(EN3|ELDO2|ELDO4)
#define ONOFF2_REG_VALUE_SLEEP	(ELDO6|ELDO9)


#ifdef ENABLE_VOLTAGE_CONTROL
#if (S5PV210_EVT==0)
#define DVS_L0_ARM          (DVSARM_1_30)
#define DVS_L1_ARM          (DVSARM_1_20)
#define DVS_L2_ARM          (DVSARM_1_10)
#define DVS_L3_ARM          (DVSARM_1_00)
	
#define DVS_L0_INT          (DVSINT_1_20)
#define DVS_L1_INT          (DVSINT_1_00)
#else

#if 1
// Standard voltage setting
#define DVS_L0_ARM          (DVSARM_1_25)		// 1GHz
#define DVS_L1_ARM          (DVSARM_1_20)		// 800MHz
#define DVS_L2_ARM          (DVSARM_1_05)		// 400MHz
#define DVS_L3_ARM          (DVSARM_0_95)		// 200MHz / 100MHz

#define DVS_L0_INT          (DVSINT_1_10)		// 200MHz
#define DVS_L1_INT          (DVSINT_1_00)		// 100MHz
#else
// For debug
#define DVS_L0_ARM          (DVSARM_1_30)		// 1GHz
#define DVS_L1_ARM          (DVSARM_1_25)		// 800MHz
#define DVS_L2_ARM          (DVSARM_1_10)		// 400MHz
#define DVS_L3_ARM          (DVSARM_1_00)		// 200MHz / 100MHz

#define DVS_L0_INT          (DVSINT_1_20)		// 200MHz
#define DVS_L1_INT          (DVSINT_1_00)		// 100MHz
#endif
#endif
#else
#define DVS_L0_ARM          (DVSARM_1_30)
#define DVS_L1_ARM          (DVSARM_1_25)
#define DVS_L2_ARM          (DVSARM_1_10)
#define DVS_L3_ARM          (DVSARM_1_00)

#define DVS_L0_INT          (DVSINT_1_25)
#define DVS_L1_INT          (DVSINT_1_20)
#endif


#endif //__SYSTEM_FUNCTION__
