//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header:  CMUEntry_reg.h
//
//  Defines the Clock control/management unit registers entries and associated
//  types and constants.
//
#ifndef __S5PV210_CMUENTRY_H
#define __S5PV210_CMUENTRY_H

#if __cplusplus
extern "C" {
#endif
//------------------------------------------------------------------------------
//  System CMU control registers

// For CMU Clock Controller : PLL Lock _______________________________Clock Controller___
typedef struct                          // 0x0
{
    UINT32	APLL_LOCK;   // 0x0
    UINT32	RVD0;             // 0x4
    UINT32	MPLL_LOCK;   // 0x8
    UINT32	RVD1;             // 0xC
    UINT32	EPLL_LOCK;   // 0x10
    UINT32	RVD2[3];        // 0x14 ~ 0x1C
    UINT32	VPLL_LOCK;   // 0x20
    UINT32	RVD3[55];      // 0x24 ~ 0xFC
} _PLL_LCK_REG;

// For CMU Clock Controller : PLL Control
#if (S5PV210_EVT==0)
typedef struct                          // 0x100
{
    UINT32	APLL_CON;    // 0x0
    UINT32	RVD0;            // 0x4
    UINT32	MPLL_CON;    // 0x8
    UINT32	RVD1;            // 0xC
    UINT32	EPLL_CON;    // 0x10
    UINT32	RVD2[3];         // 0x14 ~ 0x1C
    UINT32	VPLL_CON;     // 0x20
    UINT32	RVD3[55];       // 0x24 ~ 0xFC
} _PLL_CON_REG;
#else
typedef struct                          // 0x100
{
    UINT32	APLL_CON0;    // 0x0
    UINT32	APLL_CON1;    // 0x4
    UINT32	MPLL_CON;    // 0x8
    UINT32	RVD1;         // 0xC
    UINT32	EPLL_CON0;    // 0x10
    UINT32	EPLL_CON1;    // 0x14
    UINT32	RVD2[2];      // 0x18 ~ 0x1C
    UINT32	VPLL_CON;     // 0x20
    UINT32	RVD3[55];       // 0x24 ~ 0xFC
} _PLL_CON_REG;
#endif

// For CMU Clock Controller : Clock source
typedef struct                          // 0X200
{
    UINT32	CLK_SRC0;    // 0X0
    UINT32	CLK_SRC1;
    UINT32	CLK_SRC2;
    UINT32	CLK_SRC3;
    UINT32	CLK_SRC4;
    UINT32	CLK_SRC5;
    UINT32	CLK_SRC6;
    UINT32	RVD0[25];      // 0x21C ~ 0x27C
    UINT32	CLK_SRC_MASK0;
    UINT32	CLK_SRC_MASK1;
    UINT32	RVD1[30];      // 0x288 ~ 0x2FC
} _CLK_SRC_REG;

// For CMU Clock Controller : Clock divider
typedef struct                          // 0X300
{
    UINT32	CLK_DIV0;    // 0X0
    UINT32	CLK_DIV1;
    UINT32	CLK_DIV2;
    UINT32	CLK_DIV3;
    UINT32	CLK_DIV4;
    UINT32	CLK_DIV5;
    UINT32	CLK_DIV6;
    UINT32	CLK_DIV7;
    UINT32	RVD[56];        // 0x320 ~ 0x3FC
} _CLK_DIV_REG;

// For CMU Clock Controller : Clock gating
typedef struct                          // 0x400
{
    UINT32  RVD0[24];               //0x0 ~ 0x5C
    UINT32	CLK_GATE_IP0;
    UINT32	CLK_GATE_IP1;
    UINT32	CLK_GATE_IP2;
    UINT32	CLK_GATE_IP3;
    UINT32	CLK_GATE_IP4;
    UINT32	RVD3[3];                 // 0x74 ~ 0x7C
    UINT32	CLK_GATE_BLOCK;
    UINT32	RVD4[31];                // 0x84 ~ 0xFC
} _CLK_GAT_REG;

// For CMU Clock Controller : Clock output
typedef  struct                         // 0x500
{
    UINT32      CLK_OUT;
    UINT32      RVD[703];                  // 0x504 ~ 0xFFC
} _CLK_OUT_REG;

// For CMU Clock Controller : Clock divider status
typedef struct                          // 0x1000
{
    UINT32	CLK_DIV_STAT0;   // 0x0
    UINT32	CLK_DIV_STAT1;   // 0x4
    UINT32	RVD[62];                 // 0x8 ~ 0xFC
} _CLK_GTS_REG;

// For CMU Clock Controller : Clock MUX status
typedef struct                          // 0x1100
{
    UINT32      CLK_MUX_STAT0;   // 0x0
    UINT32      CLK_MUX_STAT1;   // 0x4
//    UINT32      RVD[62];                 // 0x8 ~ 0xFC
} _CLK_MTS_REG;

typedef     UINT32  _SWRESET_REG;
// For CMU IEM Control :Configuration ________________________________IEM Controller____
typedef struct                          // 0x3000
{
    UINT32	DCGIDX_MAP0	;
    UINT32	DCGIDX_MAP1	;
    UINT32	DCGIDX_MAP2	;
    UINT32	RVD0[5]	;               // 0xC ~ 0x1C
    UINT32	DCGPERF_MAP0	;
    UINT32	DCGPERF_MAP1	;
    UINT32	RVD1[6]	;               // 0x28 ~ 0x3C
    UINT32	DVCIDX_MAP	;
    UINT32	RVD2[7]	;               // 0x44 ~ 0x5C
    UINT32	FREQ_CPU	;
    UINT32	FREQ_DPM	;
    UINT32	RVD3[6]	;               // 0x68 ~ 0x7C
    UINT32	DVSEMCLK_EN	;
    UINT32	MAXPERF	;
    UINT32	RVD4[30]	;        // 0x88 ~ 0xFC
} _IEM_CFG_REG;

// For CMU IEM Control :PLL setting register.
#if (S5PV210_EVT==0)
typedef struct                          // 0x3100
{
    UINT32	APLL_CON_L8	;
    UINT32	APLL_CON_L7	;
    UINT32	APLL_CON_L6	;
    UINT32	APLL_CON_L5	;
    UINT32	APLL_CON_L4	;
    UINT32	APLL_CON_L3	;
    UINT32	APLL_CON_L2	;
    UINT32	APLL_CON_L1	;
    UINT32	RVD[56]	;                       // 0x20 ~ 0xFC
} _IEM_PST_REG;
#else
typedef struct                          // 0x3100
{
    UINT32	APLL_CON0_L8	;
    UINT32	APLL_CON0_L7	;
    UINT32	APLL_CON0_L6	;
    UINT32	APLL_CON0_L5	;
    UINT32	APLL_CON0_L4	;
    UINT32	APLL_CON0_L3	;
    UINT32	APLL_CON0_L2	;
    UINT32	APLL_CON0_L1	;
    UINT32  IEM_CONTROL     ;
    UINT32	RVD[55]	;                       // 0x24 ~ 0xFC
} _IEM_PST_REG;
#endif
// For CMU IEM Control :PLL setting register.
typedef struct                          // 0x3200
{
    UINT32	CLKDIV_IEM_L8	;
    UINT32	CLKDIV_IEM_L7	;
    UINT32	CLKDIV_IEM_L6	;
    UINT32	CLKDIV_IEM_L5	;
    UINT32	CLKDIV_IEM_L4	;
    UINT32	CLKDIV_IEM_L3	;
    UINT32	CLKDIV_IEM_L2	;
    UINT32	CLKDIV_IEM_L1	;
    UINT32	RVD[56]	;                   // 0x20 ~ 0xFC
} _IEM_DST_REG;

#if (S5PV210_EVT>0)
typedef struct                          // 0x3300
{
    UINT32	APLL_CON1_L8	;
    UINT32	APLL_CON1_L7	;
    UINT32	APLL_CON1_L6	;
    UINT32	APLL_CON1_L5	;
    UINT32	APLL_CON1_L4	;
    UINT32	APLL_CON1_L3	;
    UINT32	APLL_CON1_L2	;
    UINT32	APLL_CON1_L1	;
} _IEM_PST2_REG;
#endif

//For CMU Voltage Control in DVFS scheme: General Control register 
typedef     UINT32  _GENERAL_CTRL;   //0x6100

#if (S5PV210_EVT==0)
// For CMU System Control :Memory register
typedef struct                          // 0x6200
{
    UINT32	RVD[2]  ;
    UINT32	DMC0_CFG	;
} _SYS_MEM_REG;
#endif

// For CMU Miscellaneous :Multimedia register _________________________ Miscellaneous ____
typedef struct                          // 0x7000
{
    UINT32	CAM_MUX_SEL	;
    UINT32	MIXER_OUT_SEL	;
    UINT32	DISPLAY_CONTROL	;
    UINT32	AUDIO_ENDIAN	;
    UINT32	RVD[124]	;   // 0x10 ~ 0x1FC
} _MISC_MTM_REG;

// For CMU Miscellaneous :Test register
typedef struct                          // 0x7200
{
    UINT32	MIPI_PHY_CON0	;
    UINT32	MIPI_PHY_CON1	;
    UINT32	HDMI_PHY_CON0	;
//    UINT32	RVD[61]	;           // 0xC ~ 0xFC
} _MISC_TST_REG;

#if __cplusplus
}
#endif

#endif // __S5PV210_CMUENTRY_H


