;
; Copyright (c) Microsoft Corporation.  All rights reserved.
;
;
; Use of this sample source code is subject to the terms of the Microsoft
; license agreement under which you licensed this sample source code. If
; you did not accept the terms of the license agreement, you are not
; authorized to use this sample source code. For the terms of the license,
; please see the license agreement between you and Microsoft or, if applicable,
; see the LICENSE.RTF on your install media or the root of your tools installation.
; THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
;
;-------------------------------------------------------------------------------
;
;  File:  clearitlbentry.s
;
;
        INCLUDE kxarm.h
        INCLUDE armmacros.s

        TEXTAREA

;-------------------------------------------------------------------------------
;
;  Function:  OALClearITLBEntry
;
;  Flush and invalidate an entry in the instruction TLB
;
        LEAF_ENTRY OALClearITLBEntry

        mcr     p15, 0, r0, c8, c5, 1   ; flush instruction TLB entry

        DCD     0xf57ff04f              ; DSB (Data Synchronization Barrier)
        DCD     0xf57ff06f              ; ISB (Instruction Synchronization Barrier 

        RETURN

;-------------------------------------------------------------------------------
;
;  Function:  OALClearITLBEntryAsid
;  Flush and invalidate an entry in the instruction TLB with Asid
;
        LEAF_ENTRY OALClearITLBEntryAsid
        
        mrc     p15, 0, r1, c13, c0, 1          ; Read Context ID Register
        orr     r0,  r0, r1                     ; r0 = MVA+ASID
        mcr     p15, 0, r0, c8, c5, 1           ; clear instruction TLB entry+ASID

        DCD     0xf57ff04f              ; DSB (Data Synchronization Barrier)
        DCD     0xf57ff06f              ; ISB (Instruction Synchronization Barrier 

        RETURN

        END

;-------------------------------------------------------------------------------

