#include "userkeywg.h"
#include <QApplication>
#include "QPictureButton.h"
#include "threadcheck.h"
#include <linux/input.h>

UserKeyWg::UserKeyWg(QWidget *parent)
    : QWidget(parent)
{
    m_SizeScreen = QApplication::desktop()->size();
    this->setWindowTitle("User Key Test");

    this->setAutoFillBackground(true);
    QPalette palette;
    palette.setColor(this->backgroundRole(), Qt::black);
    this->setPalette(palette);

    QWidget * pVlayoutWg = new QWidget(this);
    pVlayoutWg->setAutoFillBackground(true);
    palette.setColor(this->backgroundRole(), Qt::gray);
    pVlayoutWg->setPalette(palette);

    pVlayoutWg->setGeometry(0, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QGridLayout * pGLayout = new QGridLayout(pVlayoutWg);
    pGLayout->setAlignment(Qt::AlignCenter);
    pGLayout->setSpacing(30);
    pGLayout->setMargin(10);


    m_pBtnUp = new QPictureButton(pVlayoutWg);
    m_pBtnUp->setText("up");
    m_pBtnUp->setMinimumHeight(50);
    //m_pBtnUp->setMinimumWidth(80);
    m_pBtnUp->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnUp->setCheckable(true);
    m_pBtnUp->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnUp->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnUp, SIGNAL(clicked()), this, SLOT(OnBtnClickedUp()));

    m_pBtnDown = new QPictureButton(pVlayoutWg);
    m_pBtnDown->setText("down");
    m_pBtnDown->setMinimumHeight(50);
    //m_pBtnDown->setMinimumWidth(80);
    m_pBtnDown->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnDown->setCheckable(true);
    m_pBtnDown->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnDown->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnDown, SIGNAL(clicked()), this, SLOT(OnBtnClickedDown()));

    m_pBtnLeft = new QPictureButton(pVlayoutWg);
    m_pBtnLeft->setText("left");
    m_pBtnLeft->setMinimumHeight(50);
    //m_pBtnLeft->setMinimumWidth(80);
    m_pBtnLeft->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLeft->setCheckable(true);
    m_pBtnLeft->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnLeft->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnLeft, SIGNAL(clicked()), this, SLOT(OnBtnClickedLeft()));

    m_pBtnRight = new QPictureButton(pVlayoutWg);
    m_pBtnRight->setText("right");
    m_pBtnRight->setMinimumHeight(50);
    //m_pBtnRight->setMinimumWidth(80);
    m_pBtnRight->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnRight->setCheckable(true);
    m_pBtnRight->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnRight->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnRight, SIGNAL(clicked()), this, SLOT(OnBtnClickedRight()));

    m_pBtnMenu = new QPictureButton(pVlayoutWg);
    m_pBtnMenu->setText("menu");
    m_pBtnMenu->setMinimumHeight(50);
    //m_pBtnMenu->setMinimumWidth(80);
    m_pBtnMenu->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnMenu->setCheckable(true);
    m_pBtnMenu->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnMenu->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnMenu, SIGNAL(clicked()), this, SLOT(OnBtnClickedMenu()));

    m_pBtnBack  = new QPictureButton(pVlayoutWg);
    m_pBtnBack->setText("back");
    m_pBtnBack->setMinimumHeight(50);
    //m_pBtnBack->setMinimumWidth(80);
    m_pBtnBack->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnBack->setCheckable(true);
    m_pBtnBack->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnBack->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnBack, SIGNAL(clicked()), this, SLOT(OnBtnClickedBack()));

    QLabel * pLbl = new QLabel(QString::fromUtf8("***按键测试程序***"), pVlayoutWg);
    pLbl->setAlignment(Qt::AlignCenter);
    palette.setColor(QPalette::WindowText,Qt::white);
    pLbl->setPalette(palette);
    QSpacerItem * pSpase = new QSpacerItem(40,20);

    pGLayout->addWidget(pLbl, 0, 0, 1, 4);
    pGLayout->addItem(pSpase, 1, 0, 1, 4);
    pGLayout->addWidget(m_pBtnUp, 2, 1, 1, 1);
    pGLayout->addWidget(m_pBtnMenu, 2, 3, 1, 1);
    pGLayout->addWidget(m_pBtnLeft, 3, 0, 1, 1);
    pGLayout->addWidget(m_pBtnDown, 3, 1, 1, 1);
    pGLayout->addWidget(m_pBtnRight, 3, 2, 1, 1);
    pGLayout->addWidget(m_pBtnBack, 3, 3, 1, 1);


    QWidget * pRightWidget = new QWidget(this);

    pRightWidget->setGeometry(m_SizeScreen.width()/2, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QVBoxLayout * pRightGLayout = new QVBoxLayout(pRightWidget);
    pRightGLayout->setAlignment(Qt::AlignHCenter);
    pRightGLayout->setSpacing(30);
    pRightGLayout->setMargin(30);

    QLabel * m_pLblLogo = new QLabel(pRightWidget);
    m_pLblLogo->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed );
    m_pLblLogo->setGeometry(m_SizeScreen.width()/2 +40,(m_SizeScreen.height() - 186)/2,250,186);
    QPixmap pix;
    pix.load(QObject::tr(":/images/x210iilogo.png"));
    m_pLblLogo->setPixmap(pix);

    QPictureButton * m_pBtnClose = new QPictureButton(pVlayoutWg);
    m_pBtnClose->setMinimumHeight(50);
    m_pBtnClose->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed );
    m_pBtnClose->setText(QString::fromUtf8("退出"));
    m_pBtnClose->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnClose->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnClose, SIGNAL(clicked()), this, SLOT(OnBtnClickedClose()));


    pRightGLayout->addWidget(m_pLblLogo, 30);
    pRightGLayout->addWidget(m_pBtnClose, 30);


    m_pThreadCheck = new ThreadCheck(this);
    m_pThreadCheck->start();
}

UserKeyWg::~UserKeyWg()
{
    
}

//void UserKeyWg::keyPressEvent(QKeyEvent * event)
//{
//    qDebug() << event->key() << "keyPressEvent";
//    return QWidget::keyPressEvent(event);
//}



void UserKeyWg::customEvent(QEvent *event)
{
    qDebug() << "customEvent";
    if(event->type() != QEvent::User + 1)
        return;
    KeyEvent * pEvent = (KeyEvent*)event;
    int code = pEvent->getCode();
    bool value = pEvent->getValue();
    qDebug() << code << value;
    switch(code)
    {
    case KEY_UP:
        m_pBtnUp->setChecked(value);
        break;

    case KEY_DOWN:
        m_pBtnDown->setChecked(value);
        break;

    case KEY_LEFT:
        m_pBtnLeft->setChecked(value);
        break;

    case KEY_RIGHT:
        m_pBtnRight->setChecked(value);
        break;

    case KEY_MENU:
        m_pBtnMenu->setChecked(value);
        break;

    case KEY_BACK:
        m_pBtnBack->setChecked(value);
        break;

    default:
        break;
    }

}


void UserKeyWg::OnBtnClickedClose()
{
    m_pThreadCheck->m_bRun = false;
    m_pThreadCheck->exit();
    m_pThreadCheck->wait();
    delete m_pThreadCheck;

    close();
}

void UserKeyWg::OnBtnClickedUp()
{
}

void UserKeyWg::OnBtnClickedDown()
{
}

void UserKeyWg::OnBtnClickedLeft()
{
}

void UserKeyWg::OnBtnClickedRight()
{
}

void UserKeyWg::OnBtnClickedMenu()
{
}

void UserKeyWg::OnBtnClickedBack()
{
}


