#ifndef PWMWG_H
#define PWMWG_H

#include <QWidget>
class QScrollBar;
class QLabel;

class PWMWg : public QWidget
{
    Q_OBJECT
    
public:
    PWMWg(QWidget *parent = 0);
    ~PWMWg();

    void OpenBuzzer();
    void CloseBuzzer();
    void SetBuzzerFreq(int freq);
private:
    QSize m_SizeScreen;
    QScrollBar * m_pSlider;

    QLabel * pLblFre;
#ifdef Q_OS_LINUX
    int m_nDeviceId;
#endif
private slots:
    void OnValueChangedSlider(int value);
    void OnClickedBtnStart();
    void OnClickedBtnStop();
};

#endif // PWMWG_H
