#include "pwmwg.h"
#include <QApplication>
#include <QDesktopWidget>
#include <QtGui>
#include <QPictureButton.h>

#ifdef Q_OS_LINUX
#include <termios.h>
#include <fcntl.h>
#include <stdlib.h>
#include <linux/input.h>

#define PWM_IOCTL_SET_FREQ 1
#define PWM_IOCTL_CLOSE 0
#endif



PWMWg::PWMWg(QWidget *parent)
    : QWidget(parent)
    ,m_nDeviceId(-1)
{
    m_SizeScreen = QApplication::desktop()->size();
    this->setWindowTitle("PWD Test");

    this->setAutoFillBackground(true);
    QPalette palette;
    palette.setColor(this->backgroundRole(), Qt::black);
    this->setPalette(palette);

    //QApplication::setStyle(new NorwegianWoodStyle);

    QWidget * pVlayoutWg = new QWidget(this);
    //pVlayoutWg->setStyle(new NorwegianWoodStyle);
    pVlayoutWg->setAutoFillBackground(true);
    palette.setColor(this->backgroundRole(), Qt::gray);
    pVlayoutWg->setPalette(palette);

    pVlayoutWg->setGeometry(0, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QGridLayout * pGLayout = new QGridLayout(pVlayoutWg);
    pGLayout->setAlignment(Qt::AlignCenter);
    pGLayout->setSpacing(30);
    pGLayout->setMargin(30);

    m_pSlider = new QScrollBar(Qt::Horizontal, pVlayoutWg);
    m_pSlider->setMinimumHeight(50);
    //m_pSlider->setMinimumWidth(pVlayoutWg->width()- 20);
    m_pSlider->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed );
    m_pSlider->setSingleStep(10);
    m_pSlider->setRange(0, 10000);
    m_pSlider->setValue(1024);
    QObject::connect(m_pSlider, SIGNAL(valueChanged(int)), this, SLOT(OnValueChangedSlider(int)));


    QLabel * pLbl = new QLabel(QString::fromUtf8("***PWM测试程序***"), pVlayoutWg);
    pLbl->setAlignment(Qt::AlignCenter);
    palette.setColor(QPalette::WindowText,Qt::white);
    pLbl->setPalette(palette);

    pLblFre = new QLabel(QString::fromUtf8("当前频率:%1HZ").arg(m_pSlider->value()), pVlayoutWg);
    pLblFre->setAlignment(Qt::AlignCenter);
    pLblFre->setPalette(palette);

    QPictureButton * m_pBtnStart = new QPictureButton(pVlayoutWg);
    m_pBtnStart->setMinimumHeight(50);
    m_pBtnStart->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed );
    m_pBtnStart->setText(QString::fromUtf8("开始"));
    m_pBtnStart->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnStart->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnStart, SIGNAL(clicked()), this, SLOT(OnClickedBtnStart()));

    QPictureButton * m_pBtnStop = new QPictureButton(pVlayoutWg);
    m_pBtnStop->setMinimumHeight(50);
    m_pBtnStop->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed );
    m_pBtnStop->setText(QString::fromUtf8("停止"));
    m_pBtnStop->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnStop->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnStop, SIGNAL(clicked()), this, SLOT(OnClickedBtnStop()));

    pGLayout->addWidget(pLbl, 0, 0, 1, 4);
    //pGLayout->setRowStretch(1, 1);
    pGLayout->addWidget(pLblFre, 1, 0, 1, 4);
    pGLayout->addWidget(m_pSlider, 2, 0, 1, 4);
    pGLayout->addWidget(m_pBtnStart, 3, 0, 1, 2);
    pGLayout->addWidget(m_pBtnStop, 3, 2, 1, 2);




    QWidget * pRightWidget = new QWidget(this);

    pRightWidget->setGeometry(m_SizeScreen.width()/2, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QVBoxLayout * pRightGLayout = new QVBoxLayout(pRightWidget);
    pRightGLayout->setAlignment(Qt::AlignHCenter);
    pRightGLayout->setSpacing(30);
    pRightGLayout->setMargin(30);

    QLabel * m_pLblLogo = new QLabel(pRightWidget);
    m_pLblLogo->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed );
    m_pLblLogo->setGeometry(m_SizeScreen.width()/2 +40,(m_SizeScreen.height() - 186)/2,250,186);
    QPixmap pix;
    pix.load(QObject::tr(":/images/x210iilogo.png"));
    m_pLblLogo->setPixmap(pix);

    QPictureButton * m_pBtnClose = new QPictureButton(pVlayoutWg);
    m_pBtnClose->setMinimumHeight(50);
    m_pBtnClose->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed );
    m_pBtnClose->setText(QString::fromUtf8("退出"));
    m_pBtnClose->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnClose->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnClose, SIGNAL(clicked()), this, SLOT(close()));


    pRightGLayout->addWidget(m_pLblLogo, 30);
    pRightGLayout->addWidget(m_pBtnClose, 30);



}

PWMWg::~PWMWg()
{

}

void PWMWg::OnValueChangedSlider(int value)
{
    pLblFre->setText(QString::fromUtf8("当前频率:%1HZ").arg(value));
    if(m_nDeviceId > 0)
        SetBuzzerFreq(m_pSlider->value());
}

void PWMWg::OnClickedBtnStart()
{
    OpenBuzzer();
    SetBuzzerFreq(m_pSlider->value());
}

void PWMWg::OnClickedBtnStop()
{
    CloseBuzzer();
}

void PWMWg::OpenBuzzer()
{
#ifdef Q_OS_LINUX
    if(m_nDeviceId > 0)
        return;
  m_nDeviceId = open("/dev/buzzer", 0);
  qDebug() << "deviceid" << m_nDeviceId;
  if(m_nDeviceId < 0)
  {
    qDebug() << ("open pwm_buzzer device");
    close();
  }
#endif
}

void PWMWg::CloseBuzzer()
{
#ifdef Q_OS_LINUX
    if (m_nDeviceId >= 0)
    {
        ioctl(m_nDeviceId, PWM_IOCTL_CLOSE);
        ::close(m_nDeviceId);
        m_nDeviceId = -1;
  }
#endif
}

void PWMWg::SetBuzzerFreq(int freq)
{
#ifdef Q_OS_LINUX
    int ret = ioctl(m_nDeviceId, PWM_IOCTL_SET_FREQ, freq);
    if(ret < 0)
    {
      qDebug() << ("set the frequency of the buzzer");
      close();
    }
#endif
}
