.ifdef S5PV210
.equ CONFIG_SMDKV210,		0x1
.else
.equ CONFIG_SMDKC110B,		0x1
.endif
.equ SYNC_16BURST_83M,		0x1

@;.equ CONFIG_CLK_533_133_100_100,	0x1
@;.equ CONFIG_CLK_667_166_166_133,	0x1
.equ CONFIG_CLK_800_200_166_133,	0x1
@;.equ CONFIG_CLK_1000_200_166_133,	0x1

.ifdef CONFIG_CLK_533_133_100_100
	.equ APLL_MDIV,			0x215
	.equ APLL_PDIV,			0x18
	.equ APLL_SDIV,			0x1
.endif

.ifdef CONFIG_CLK_667_166_166_133
	.equ APLL_MDIV,			0xfa
	.equ APLL_PDIV,			0x6
	.equ APLL_SDIV,			0x1
.endif

.ifdef CONFIG_CLK_800_200_166_133
	.equ APLL_MDIV,			0xc8
	.equ APLL_PDIV,			0x6
	.equ APLL_SDIV,			0x1
.endif

.ifdef CONFIG_CLK_1000_200_166_133
	.equ APLL_MDIV,			0xfa
	.equ APLL_PDIV,			0x6
	.equ APLL_SDIV,			0x1
.endif

.ifdef CONFIG_CLK_533_133_100_100
	.equ MPLL_MDIV,			0x190
	.equ MPLL_PDIV,			0x6
	.equ MPLL_SDIV,			0x2
.else
	.equ MPLL_MDIV,			0x29b
	.equ MPLL_PDIV,			0xc
	.equ MPLL_SDIV,			0x1
.endif

.equ EPLL_MDIV,				0x60
.equ EPLL_PDIV,				0x6
.equ EPLL_SDIV,				0x2

.equ VPLL_MDIV,				0x6c
.equ VPLL_PDIV,				0x6
.equ VPLL_SDIV,				0x3

/* Set AFC value */
.equ AFC_ON,				0x00000000
.equ AFC_OFF,				0x10000010

/* CLK_DIV0 */
.equ APLL_RATIO,			0
.equ A2M_RATIO,				4
.equ HCLK_MSYS_RATIO,		8
.equ PCLK_MSYS_RATIO,		12
.equ HCLK_DSYS_RATIO,		16
.equ PCLK_DSYS_RATIO,		20
.equ HCLK_PSYS_RATIO,		24
.equ PCLK_PSYS_RATIO,		28

.equ CLK_DIV0_MASK,			0x7fffffff

.equ APLL_VAL,				((1<<31)|(APLL_MDIV<<16)|(APLL_PDIV<<8)|(APLL_SDIV))
.equ MPLL_VAL,				((1<<31)|(MPLL_MDIV<<16)|(MPLL_PDIV<<8)|(MPLL_SDIV))
.equ EPLL_VAL,				((1<<31)|(EPLL_MDIV<<16)|(EPLL_PDIV<<8)|(EPLL_SDIV))
.equ VPLL_VAL,				((1<<31)|(VPLL_MDIV<<16)|(VPLL_PDIV<<8)|(VPLL_SDIV))

.ifdef CONFIG_CLK_533_133_100_100
	.equ CLK_DIV0_VAL,		((0<<APLL_RATIO)|(3<<A2M_RATIO)|(3<<HCLK_MSYS_RATIO)|(1<<PCLK_MSYS_RATIO)|(3<<HCLK_DSYS_RATIO)|(1<<PCLK_DSYS_RATIO)|(3<<HCLK_PSYS_RATIO)|(1<<PCLK_PSYS_RATIO))
.endif

.ifdef CONFIG_CLK_667_166_166_133
	.equ CLK_DIV0_VAL,		((0<<APLL_RATIO)|(3<<A2M_RATIO)|(3<<HCLK_MSYS_RATIO)|(1<<PCLK_MSYS_RATIO)|(3<<HCLK_DSYS_RATIO)|(1<<PCLK_DSYS_RATIO)|(4<<HCLK_PSYS_RATIO)|(1<<PCLK_PSYS_RATIO))
.endif

.ifdef CONFIG_CLK_800_200_166_133
	.equ CLK_DIV0_VAL,		((0<<APLL_RATIO)|(3<<A2M_RATIO)|(3<<HCLK_MSYS_RATIO)|(1<<PCLK_MSYS_RATIO)|(3<<HCLK_DSYS_RATIO)|(1<<PCLK_DSYS_RATIO)|(4<<HCLK_PSYS_RATIO)|(1<<PCLK_PSYS_RATIO))
.endif

.ifdef CONFIG_CLK_1000_200_166_133
	.equ CLK_DIV0_VAL,		((0<<APLL_RATIO)|(4<<A2M_RATIO)|(4<<HCLK_MSYS_RATIO)|(1<<PCLK_MSYS_RATIO)|(3<<HCLK_DSYS_RATIO)|(1<<PCLK_DSYS_RATIO)|(4<<HCLK_PSYS_RATIO)|(1<<PCLK_PSYS_RATIO))
.endif

.equ CLK_DIV1_VAL,			((1<<16)|(1<<12)|(1<<8)|(1<<4))
.equ CLK_DIV2_VAL,			(1<<0)

/*
 * Clock & Power Controller for s5pc110
 */
.equ ELFIN_CLOCK_POWER_BASE,		0xE0100000
.equ RST_STAT_OFFSET,				0xa000

.equ IO_RET_REL,		((1 << 31) | (1 << 29) | (1 << 28))

.equ APLL_LOCK_OFFSET,		0x00
.equ MPLL_LOCK_OFFSET,		0x08
.equ EPLL_LOCK_OFFSET,		0x10
.equ VPLL_LOCK_OFFSET,		0x20
.equ APLL_CON0_OFFSET,		0x100
.equ APLL_CON1_OFFSET,		0x104
.equ MPLL_CON_OFFSET,		0x108
.equ EPLL_CON_OFFSET,		0x110
.equ VPLL_CON_OFFSET,		0x120

.equ CLK_SRC0_OFFSET,		0x200
.equ CLK_SRC1_OFFSET,		0x204
.equ CLK_SRC2_OFFSET,		0x208
.equ CLK_SRC3_OFFSET,		0x20c
.equ CLK_SRC4_OFFSET,		0x210
.equ CLK_SRC5_OFFSET,		0x214
.equ CLK_SRC6_OFFSET,		0x218
.equ CLK_SRC_MASK0_OFFSET,	0x280
.equ CLK_SRC_MASK1_OFFSET,	0x284

.equ CLK_DIV0_OFFSET,		0x300
.equ CLK_DIV1_OFFSET,		0x304
.equ CLK_DIV2_OFFSET,		0x308
.equ CLK_DIV3_OFFSET,		0x30c
.equ CLK_DIV4_OFFSET,		0x310
.equ CLK_DIV5_OFFSET,		0x314
.equ CLK_DIV6_OFFSET,		0x318
.equ CLK_DIV7_OFFSET,		0x31c

.equ CLK_GATE_IP0_OFFSET,	0x460
.equ CLK_GATE_IP1_OFFSET,	0x464
.equ CLK_GATE_IP2_OFFSET,	0x468
.equ CLK_GATE_IP3_OFFSET,	0x46c
.equ CLK_GATE_IP4_OFFSET,	0x470
.equ CLK_GATE_BLOCK_OFFSET,	0x480

.equ CLK_OUT_OFFSET,		0x500
.equ CLK_DIV_STAT0_OFFSET,	0x1000
.equ CLK_DIV_STAT1_OFFSET,	0x1004
.equ CLK_MUX_STAT0_OFFSET,	0x1100
.equ CLK_MUX_STAT1_OFFSET,	0x1104
.equ SW_RST_OFFSET,		0x2000
.equ ONEDRAM_CFG_OFFSET,	0x6208
.equ OTHERS_OFFSET,		0xe000

.equ MP1_0DRV_SR_OFFSET, 		0x3CC
.equ MP1_1DRV_SR_OFFSET, 		0x3EC
.equ MP1_2DRV_SR_OFFSET, 		0x40C
.equ MP1_3DRV_SR_OFFSET, 		0x42C
.equ MP1_4DRV_SR_OFFSET, 		0x44C
.equ MP1_5DRV_SR_OFFSET, 		0x46C
.equ MP1_6DRV_SR_OFFSET, 		0x48C
.equ MP1_7DRV_SR_OFFSET, 		0x4AC
.equ MP1_8DRV_SR_OFFSET, 		0x4CC

.equ MP2_0DRV_SR_OFFSET,		0x4EC
.equ MP2_1DRV_SR_OFFSET, 		0x50C
.equ MP2_2DRV_SR_OFFSET, 		0x52C
.equ MP2_3DRV_SR_OFFSET, 		0x54C
.equ MP2_4DRV_SR_OFFSET, 		0x56C
.equ MP2_5DRV_SR_OFFSET, 		0x58C
.equ MP2_6DRV_SR_OFFSET, 		0x5AC
.equ MP2_7DRV_SR_OFFSET, 		0x5CC
.equ MP2_8DRV_SR_OFFSET, 		0x5EC

.ifdef	CONFIG_CLK_533_133_100_100

.ifdef	CONFIG_SMDKC110AC
	.equ DMC0_TIMINGA_REF,		0x40e
	.equ DMC0_TIMING_ROW,		0x10233206
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E100222

	.equ DMC1_TIMINGA_REF,		0x40e
	.equ DMC1_TIMING_ROW,		0x10233206
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E100222
.endif	@;CONFIG_SMDKC110AC

.ifdef	CONFIG_SMDKC110B
	.equ DMC0_TIMINGA_REF,		0x40e
	.equ DMC0_TIMING_ROW,		0x10233206
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E100222

	.equ DMC1_TIMINGA_REF,		0x40e
	.equ DMC1_TIMING_ROW,		0x10233206
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E100222
.endif	@;CONFIG_SMDKC110B

.ifdef	CONFIG_SMDKC110D
	.equ DMC0_TIMINGA_REF,		0x40e
	.equ DMC0_TIMING_ROW,		0x10233206
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E100222

	.equ DMC1_TIMINGA_REF,		0x40e
	.equ DMC1_TIMING_ROW,		0x10233206
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E100222
.endif	@;CONFIG_SMDKC110D

.ifdef	CONFIG_SMDKC110H
	.equ DMC0_TIMINGA_REF,		0x40e
	.equ DMC0_TIMING_ROW,		0x10233206
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ	DMC0_TIMING_PWR,	0x0E100222

	.equ DMC1_TIMINGA_REF,		0x40e
	.equ DMC1_TIMING_ROW,		0x10233206
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ	DMC1_TIMING_PWR,	0x0E100222
.endif	@;CONFIG_SMDKC110H
.ifdef	CONFIG_SMDKV210
	.equ DMC0_TIMINGA_REF,		0x40e
	.equ DMC0_TIMING_ROW,		0x10233206
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E100222

	.equ DMC1_TIMINGA_REF,		0x40e
	.equ DMC1_TIMING_ROW,		0x10233206
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E100222
.endif	@;CONFIG_SMDKV210
.endif	@;CONFIG_CLK_533_133_100_100

.ifdef	CONFIG_CLK_800_200_166_133

.ifdef	CONFIG_SMDKC110AC
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F81222
	.equ DMC1_MEMCONFIG_1,		0x50F81222
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110AC

.ifdef	CONFIG_SMDKC110B
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F01322
	.equ DMC1_MEMCONFIG_1,		0x50F01322
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110B

.ifdef	CONFIG_SMDKC110D
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F01322
	.equ DMC1_MEMCONFIG_1,		0x50F01322
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110D

.ifdef	CONFIG_SMDKC110H
	.equ DMC0_MEMCONFIG_0,		0x30F81312
	.equ DMC0_MEMCONFIG_1,		0x40F81312
	.equ DMC0_TIMINGA_REF,		0x00000618
	.equ DMC0_TIMING_ROW,		0x11344309
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E190222

	.equ DMC1_MEMCONTROL,		0x00202100
	.equ DMC1_MEMCONFIG_0,		0x40F81312
	.equ DMC1_MEMCONFIG_1,		0x50F81312
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110H
.ifdef	CONFIG_SMDKV210
	.equ DMC0_MEMCONFIG_0,		0x20E01323
	.equ DMC0_MEMCONFIG_1,		0x40F01323
	.equ DMC0_TIMINGA_REF,		0x00000618
	.equ DMC0_TIMING_ROW,		0x28233287
	.equ DMC0_TIMING_DATA,		0x23240304
	.equ DMC0_TIMING_PWR,		0x09C80232

	.equ DMC1_MEMCONTROL,		0x00202400
	.equ DMC1_MEMCONFIG_0,		0x40C01323
	.equ DMC1_MEMCONFIG_1,		0x00E01323
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x28233289
	.equ DMC1_TIMING_DATA,		0x23240304
	.equ DMC1_TIMING_PWR,		0x08280232
.endif	@;CONFIG_SMDKV210
.endif	@;CONFIG_CLK_800_200_166_133

.ifdef	CONFIG_CLK_1000_200_166_133

.ifdef	CONFIG_SMDKC110AC
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F81222
	.equ DMC1_MEMCONFIG_1,		0x50F81222
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110AC

.ifdef	CONFIG_SMDKC110B
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F01322
	.equ DMC1_MEMCONFIG_1,		0x50F01322
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110B

.ifdef	CONFIG_SMDKC110D
	.equ DMC0_MEMCONFIG_0,		0x30F82222
	.equ DMC0_MEMCONFIG_1,		0x40F82222
	.equ DMC0_TIMINGA_REF,		0x0000050E
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E140222

	.equ DMC1_MEMCONTROL,		0x00212100
	.equ DMC1_MEMCONFIG_0,		0x40F01322
	.equ DMC1_MEMCONFIG_1,		0x50F01322
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110D

.ifdef	CONFIG_SMDKC110H
	.equ DMC0_MEMCONFIG_0,		0x30F81312
	.equ DMC0_MEMCONFIG_1,		0x40F81312
	.equ DMC0_TIMINGA_REF,		0x00000618
	.equ DMC0_TIMING_ROW,		0x11344309
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ DMC0_TIMING_PWR,		0x0E190222

	.equ DMC1_MEMCONTROL,		0x00202100
	.equ DMC1_MEMCONFIG_0,		0x40F81312
	.equ DMC1_MEMCONFIG_1,		0x50F81312
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ DMC1_TIMING_PWR,		0x0E190222
.endif	@;CONFIG_SMDKC110H
.ifdef	CONFIG_SMDKV210
	.equ DMC0_MEMCONFIG_0,		0x20E01323
	.equ DMC0_MEMCONFIG_1,		0x40F01323
	.equ DMC0_TIMINGA_REF,		0x00000618
	.equ DMC0_TIMING_ROW,		0x28233287
	.equ DMC0_TIMING_DATA,		0x23240304
	.equ DMC0_TIMING_PWR,		0x09C80232

	.equ DMC1_MEMCONTROL,		0x00202400
	.equ DMC1_MEMCONFIG_0,		0x40C01323
	.equ DMC1_MEMCONFIG_1,		0x00E01323
	.equ DMC1_TIMINGA_REF,		0x00000618
	.equ DMC1_TIMING_ROW,		0x28233289
	.equ DMC1_TIMING_DATA,		0x23240304
	.equ DMC1_TIMING_PWR,		0x08280232
.endif	@;CONFIG_SMDKV210
.endif	@;CONFIG_CLK_1000_200_166_133

.ifdef	CONFIG_CLK_667_166_166_133
	.equ DMC0_TIMINGA_REF,		0x50e
	.equ DMC0_TIMING_ROW,		0x14233287
	.equ DMC0_TIMING_DATA,		0x12130005
	.equ	DMC0_TIMING_PWR,	0x0E140222

	.equ DMC1_TIMINGA_REF,		0x618
	.equ DMC1_TIMING_ROW,		0x11344309
	.equ DMC1_TIMING_DATA,		0x12130005
	.equ	DMC1_TIMING_PWR,	0x0E190222
.endif

/*
 * GPIO
 */
.equ ELFIN_GPIO_BASE,		0xE0200000

.equ GPA0CON_OFFSET,		0x000
.equ GPA0DAT_OFFSET,		0x004
.equ GPA0PUD_OFFSET,		0x008
.equ GPA0DRV_SR_OFFSET,		0x00C
.equ GPA0CONPDN_OFFSET,		0x010
.equ GPA0PUDPDN_OFFSET,		0x014

.equ GPA1CON_OFFSET,		0x020
.equ GPA1DAT_OFFSET,		0x024
.equ GPA1PUD_OFFSET,		0x028
.equ GPA1DRV_SR_OFFSET,		0x02C
.equ GPA1CONPDN_OFFSET,		0x030
.equ GPA1PUDPDN_OFFSET,		0x034

.equ GPJ1CON_OFFSET,		0x260
.equ GPJ1DAT_OFFSET,		0x264
.equ GPJ1PUD_OFFSET,		0x268
.equ GPJ1DRV_SR_OFFSET,		0x26C
.equ GPJ1CONPDN_OFFSET,		0x270
.equ GPJ1PUDPDN_OFFSET,		0x274

.equ GPJ4CON_OFFSET,		0x2C0
.equ GPJ4DAT_OFFSET,		0x2C4
.equ GPJ4PUD_OFFSET,		0x2C8
.equ GPJ4DRV_SR_OFFSET,		0x2CC
.equ GPJ4CONPDN_OFFSET,		0x2D0
.equ GPJ4PUDPDN_OFFSET,		0x2D4

.equ MP01CON_OFFSET,            0x2E0
.equ MP01DAT_OFFSET,            0x2E4
.equ MP01PUD_OFFSET,            0x2E8
.equ MP01DRV_SR_OFFSET,         0x2EC
.equ MP01CONPDN_OFFSET,         0x2E0
.equ MP01PUDPDN_OFFSET,         0x2E4

.equ MP03CON_OFFSET,            0x320
.equ MP03DAT_OFFSET,            0x324
.equ MP03PUD_OFFSET,            0x328
.equ MP03DRV_SR_OFFSET,         0x32C
.equ MP03CONPDN_OFFSET,         0x330
.equ MP03PUDPDN_OFFSET,         0x334

.equ MP06CON_OFFSET,            0x380
.equ MP06DAT_OFFSET,            0x384
.equ MP06PUD_OFFSET,            0x388
.equ MP06DRV_SR_OFFSET,         0x38C
.equ MP06CONPDN_OFFSET,         0x390
.equ MP06PUDPDN_OFFSET,         0x394

.equ MP07CON_OFFSET,            0x3A0
.equ MP07DAT_OFFSET,            0x3A4
.equ MP07PUD_OFFSET,            0x3A8
.equ MP07DRV_SR_OFFSET,         0x3AC
.equ MP07CONPDN_OFFSET,         0x3B0
.equ MP07PUDPDN_OFFSET,         0x3B4

/*
 * Bus Matrix
 */
.equ ELFIN_MEM_SYS_CFG,		0x7e00f120

/*
 * Memory controller
 */
.equ ELFIN_SROM_BASE,		0xE8000000

/*
 * SDRAM Controller
 */
.equ APB_DMC_0_BASE,		0xF0000000
.equ APB_DMC_1_BASE,		0xF1400000
.equ ASYNC_MSYS_DMC0_BASE,	0xF1E00000
.equ DMC_CONCONTROL,		0x00
.equ DMC_MEMCONTROL,		0x04
.equ DMC_MEMCONFIG0,		0x08
.equ DMC_MEMCONFIG1,		0x0C
.equ DMC_DIRECTCMD,		0x10
.equ DMC_PRECHCONFIG,		0x14
.equ DMC_PHYCONTROL0,		0x18
.equ DMC_PHYCONTROL1,		0x1C
.equ DMC_RESERVED ,		0x20
.equ DMC_PWRDNCONFIG,		0x28
.equ DMC_TIMINGAREF,		0x30
.equ DMC_TIMINGROW,		0x34
.equ DMC_TIMINGDATA,		0x38
.equ DMC_TIMINGPOWER,		0x3C
.equ DMC_PHYSTATUS,		0x40
.equ DMC_CHIP0STATUS,		0x48
.equ DMC_CHIP1STATUS,		0x4C
.equ DMC_AREFSTATUS,		0x50
.equ DMC_MRSTATUS,		0x54
.equ DMC_PHYTEST0,		0x58
.equ DMC_PHYTEST1,		0x5C
.equ DMC_QOSCONTROL0,		0x60
.equ DMC_QOSCONFIG0,		0x64
.equ DMC_QOSCONTROL1,		0x68
.equ DMC_QOSCONFIG1,		0x6C
.equ DMC_QOSCONTROL2,		0x70
.equ DMC_QOSCONFIG2,		0x74
.equ DMC_QOSCONTROL3,		0x78
.equ DMC_QOSCONFIG3,		0x7C
.equ DMC_QOSCONTROL4,		0x80
.equ DMC_QOSCONFIG4,		0x84
.equ DMC_QOSCONTROL5,		0x88
.equ DMC_QOSCONFIG5,		0x8C
.equ DMC_QOSCONTROL6,		0x90
.equ DMC_QOSCONFIG6,		0x94
.equ DMC_QOSCONTROL7,		0x98
.equ DMC_QOSCONFIG7,		0x9C
.equ DMC_QOSCONTROL8,		0xA0
.equ DMC_QOSCONFIG8,		0xA4
.equ DMC_QOSCONTROL9,		0xA8
.equ DMC_QOSCONFIG9,		0xAC
.equ DMC_QOSCONTROL10,		0xB0
.equ DMC_QOSCONFIG10,		0xB4
.equ DMC_QOSCONTROL11,		0xB8
.equ DMC_QOSCONFIG11,		0xBC
.equ DMC_QOSCONTROL12,		0xC0
.equ DMC_QOSCONFIG12,		0xC4
.equ DMC_QOSCONTROL13,		0xC8
.equ DMC_QOSCONFIG13,		0xCC
.equ DMC_QOSCONTROL14,		0xD0
.equ DMC_QOSCONFIG14,		0xD4
.equ DMC_QOSCONTROL15,		0xD8
.equ DMC_QOSCONFIG15,		0xDC

/*
 * OneNAND Controller
 */
.equ ELFIN_ONENAND_BASE,	0xB0000000
.equ ELFIN_ONENANDCON_BASE,			0xB0600000
.equ ONENAND_IF_CTRL_OFFSET,			0x100
.equ ONENAND_IF_CMD_OFFSET,			0x104
.equ ONENAND_IF_ASYNC_TIMING_CTRL_OFFSET,	0x108
.equ ONENAND_IF_STATUS_OFFSET,			0x10C
.equ DMA_SRC_ADDR_OFFSET,			0x400
.equ DMA_SRC_CFG_OFFSET,			0x404
.equ DMA_DST_ADDR_OFFSET,			0x408
.equ DMA_DST_CFG_OFFSET,			0x40C
.equ DMA_TRANS_SIZE_OFFSET,			0x414
.equ DMA_TRANS_CMD_OFFSET,			0x418
.equ DMA_TRANS_STATUS_OFFSET,			0x41C
.equ DMA_TRANS_DIR_OFFSET,			0x420
.equ SQC_SAO_OFFSET,				0x600
.equ SQC_CMD_OFFSET,				0x608
.equ SQC_STATUS_OFFSET,				0x60C
.equ SQC_CAO_OFFSET,				0x610
.equ SQC_REG_CTRL_OFFSET,			0x614
.equ SQC_REG_VAL_OFFSET,			0x618
.equ SQC_BRPAO0_OFFSET,				0x620
.equ SQC_BRPAO1_OFFSET,				0x624
.equ INTC_SQC_CLR_OFFSET,			0x1000
.equ INTC_DMA_CLR_OFFSET,			0x1004
.equ INTC_ONENAND_CLR_OFFSET,			0x1008
.equ INTC_SQC_MASK_OFFSET,			0x1020
.equ INTC_DMA_MASK_OFFSET,			0x1024
.equ INTC_ONENAND_MASK_OFFSET,			0x1028
.equ INTC_SQC_PEND_OFFSET,			0x1040
.equ INTC_DMA_PEND_OFFSET,			0x1044
.equ INTC_ONENAND_PEND_OFFSET,			0x1048
.equ INTC_SQC_STATUS_OFFSET,			0x1060
.equ INTC_DMA_STATUS_OFFSET,			0x1064
.equ INTC_ONENAND_STATUS_OFFSET,		0x1068

@; Config OneNANDController Interface Control Register
.equ MUX,		0x0	@; OneNAND type select, 0: Mux type, 1: Demux type
.equ GCE,		0x0	@; Gate Clock Enable, 0:Disable, 1:Enable
.equ RPE,		0x1	@; Read Prefetch Enable, 0:Read Prefetch Disable, 1:ReadPrefetch Enable
.equ RM,		0x1	@; Read Mode, 0:Async Read, 1:Sync Read
.equ BRWL,		0x7	@; Burst Read Write Latency, 3:3CLK, 4:4CLK, 5:5CLK, 6:6CLK, 7:7CLK
.equ BL,		0x0	@; Burst Length, 0:Continuous, 1:4Burst, 2:8Burst, 3:16Burst, 4:32Burst, 5:1024Burst
.equ HF,		0x1	@; High Frequency, 0:High Frequency Disable(66MHz under), 1:HF enable(over 66MHz)
.equ WM,		0x1	@; Write Mode, 0:Async Write, 1:Sync Write
@;.equ ONENAND_IF_CTRL_REG_VAL,	((MUX<<31)|(GCE<<26)|(RPE<<17)|(RM<<15)|(BRWL<<12)|(BL<<9)|(HF<<2)|(WM<<1))

.ifdef SYNC_16BURST_83M
.equ ONENAND_IF_CTRL_REG_VAL,		0x2F006
.else
.equ ONENAND_IF_CTRL_REG_VAL,		0x40E0
.endif	@;SYNC_16BURST_83M

.equ PS_HOLD_CONTROL_OFFSET,		0xe81c

/* INFORM register */
.equ INF_REG_BASE,	0xE010F000
.equ INF_REG0_OFFSET,	0x00
.equ INF_REG1_OFFSET,	0x04
.equ INF_REG2_OFFSET,	0x08
.equ INF_REG3_OFFSET,	0x0c
.equ INF_REG4_OFFSET,	0x10
.equ INF_REG5_OFFSET,	0x14
.equ INF_REG6_OFFSET,	0x18
.equ INF_REG7_OFFSET,	0x1c

/*
 * Watchdog timer
 */
.equ ELFIN_WATCHDOG_BASE,	0xE2700000
.equ WTCON_OFFSET,		0x00
.equ WTDAT_OFFSET,		0x08
.equ WTCNT_OFFSET,		0x0C

/*
 * UART
 */
.equ ELFIN_UART_BASE,		0XE2900000

.ifdef	CONFIG_CLK_533_133_100_100
	.equ UART_UBRDIV_VAL,	26
	.equ UART_UDIVSLOT_VAL,	0x0808
.else
	.equ UART_UBRDIV_VAL,	34
	.equ UART_UDIVSLOT_VAL,	0xDDDD
.endif

.equ ELFIN_UART0_OFFSET,	0x0000
.equ ELFIN_UART1_OFFSET,	0x0400
.equ ELFIN_UART2_OFFSET,	0x0800
.equ ELFIN_UART3_OFFSET,	0x0c00

.equ ELFIN_UART_CONSOLE_BASE,	(ELFIN_UART_BASE + ELFIN_UART0_OFFSET)

.equ ULCON_OFFSET,		0x00
.equ UCON_OFFSET,		0x04
.equ UFCON_OFFSET,		0x08
.equ UMCON_OFFSET,		0x0C
.equ UTRSTAT_OFFSET,		0x10
.equ UERSTAT_OFFSET,		0x14
.equ UFSTAT_OFFSET,		0x18
.equ UMSTAT_OFFSET,		0x1C
.equ UTXH_OFFSET,		0x20
.equ URXH_OFFSET,		0x24
.equ UBRDIV_OFFSET,		0x28
.equ UDIVSLOT_OFFSET,		0x2C
.equ UINTP_OFFSET,		0x30
.equ UINTSP_OFFSET,		0x34
.equ UINTM_OFFSET,		0x38
.equ UART_ERR_MASK,		0xF

/*
 * Access Controller (TZPC)
 */
.equ ELFIN_TZPC0_BASE,		0xF1500000
.equ ELFIN_TZPC1_BASE,		0xFAD00000
.equ ELFIN_TZPC2_BASE,		0xE0600000
.equ ELFIN_TZPC3_BASE,		0xE1C00000

.equ TZPC_DECPROT0SET_OFFSET,	0x804
.equ TZPC_DECPROT1SET_OFFSET,	0x810
.equ TZPC_DECPROT2SET_OFFSET,	0x81C
.equ TZPC_DECPROT3SET_OFFSET,   0x828

.equ OneNAND_CS0_Base,		0xB0000000
.equ OneNAND_CS2_Base,		0x0A000000
.equ xNBL2_BASE,		0x33000000
