/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.google.android.gles_jni.EGLContextImpl;
import com.google.android.gles_jni.EGLDisplayImpl;
import com.google.android.gles_jni.EGLSurfaceImpl;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLImpl
implements EGL10 {
    private EGLContextImpl mContext = new EGLContextImpl(-1L);
    private EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1L);
    private EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1L);

    @Override
    public native boolean eglInitialize(EGLDisplay var1, int[] var2);

    @Override
    public native boolean eglQueryContext(EGLDisplay var1, EGLContext var2, int var3, int[] var4);

    @Override
    public native boolean eglQuerySurface(EGLDisplay var1, EGLSurface var2, int var3, int[] var4);

    @Override
    public native boolean eglReleaseThread();

    @Override
    public native boolean eglChooseConfig(EGLDisplay var1, int[] var2, EGLConfig[] var3, int var4, int[] var5);

    @Override
    public native boolean eglGetConfigAttrib(EGLDisplay var1, EGLConfig var2, int var3, int[] var4);

    @Override
    public native boolean eglGetConfigs(EGLDisplay var1, EGLConfig[] var2, int var3, int[] var4);

    @Override
    public native int eglGetError();

    @Override
    public native boolean eglDestroyContext(EGLDisplay var1, EGLContext var2);

    @Override
    public native boolean eglDestroySurface(EGLDisplay var1, EGLSurface var2);

    @Override
    public native boolean eglMakeCurrent(EGLDisplay var1, EGLSurface var2, EGLSurface var3, EGLContext var4);

    @Override
    public native String eglQueryString(EGLDisplay var1, int var2);

    @Override
    public native boolean eglSwapBuffers(EGLDisplay var1, EGLSurface var2);

    @Override
    public native boolean eglTerminate(EGLDisplay var1);

    @Override
    public native boolean eglCopyBuffers(EGLDisplay var1, EGLSurface var2, Object var3);

    @Override
    public native boolean eglWaitGL();

    @Override
    public native boolean eglWaitNative(int var1, Object var2);

    public static native int getInitCount(EGLDisplay var0);

    @Override
    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        long eglContextId = this._eglCreateContext(display, config, share_context, attrib_list);
        if (eglContextId == 0L) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return new EGLContextImpl(eglContextId);
    }

    @Override
    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        long eglSurfaceId = this._eglCreatePbufferSurface(display, config, attrib_list);
        if (eglSurfaceId == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    @Override
    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        EGLSurfaceImpl sur = new EGLSurfaceImpl();
        this._eglCreatePixmapSurface(sur, display, config, native_pixmap, attrib_list);
        if (sur.mEGLSurface == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return sur;
    }

    @Override
    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        long eglSurfaceId;
        Surface sur = null;
        if (native_window instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)native_window;
            sur = surfaceView.getHolder().getSurface();
        } else if (native_window instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)native_window;
            sur = holder.getSurface();
        } else if (native_window instanceof Surface) {
            sur = (Surface)native_window;
        }
        if (sur != null) {
            eglSurfaceId = this._eglCreateWindowSurface(display, config, sur, attrib_list);
        } else if (native_window instanceof SurfaceTexture) {
            eglSurfaceId = this._eglCreateWindowSurfaceTexture(display, config, native_window, attrib_list);
        } else {
            throw new UnsupportedOperationException("eglCreateWindowSurface() can only be called with an instance of Surface, SurfaceView, SurfaceHolder or SurfaceTexture at the moment.");
        }
        if (eglSurfaceId == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    @Override
    public synchronized EGLDisplay eglGetDisplay(Object native_display) {
        long value = this._eglGetDisplay(native_display);
        if (value == 0L) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    @Override
    public synchronized EGLContext eglGetCurrentContext() {
        long value = this._eglGetCurrentContext();
        if (value == 0L) {
            return EGL10.EGL_NO_CONTEXT;
        }
        if (this.mContext.mEGLContext != value) {
            this.mContext = new EGLContextImpl(value);
        }
        return this.mContext;
    }

    @Override
    public synchronized EGLDisplay eglGetCurrentDisplay() {
        long value = this._eglGetCurrentDisplay();
        if (value == 0L) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    @Override
    public synchronized EGLSurface eglGetCurrentSurface(int readdraw) {
        long value = this._eglGetCurrentSurface(readdraw);
        if (value == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        if (this.mSurface.mEGLSurface != value) {
            this.mSurface = new EGLSurfaceImpl(value);
        }
        return this.mSurface;
    }

    private native long _eglCreateContext(EGLDisplay var1, EGLConfig var2, EGLContext var3, int[] var4);

    private native long _eglCreatePbufferSurface(EGLDisplay var1, EGLConfig var2, int[] var3);

    private native void _eglCreatePixmapSurface(EGLSurface var1, EGLDisplay var2, EGLConfig var3, Object var4, int[] var5);

    private native long _eglCreateWindowSurface(EGLDisplay var1, EGLConfig var2, Object var3, int[] var4);

    private native long _eglCreateWindowSurfaceTexture(EGLDisplay var1, EGLConfig var2, Object var3, int[] var4);

    private native long _eglGetDisplay(Object var1);

    private native long _eglGetCurrentContext();

    private native long _eglGetCurrentDisplay();

    private native long _eglGetCurrentSurface(int var1);

    private static native void _nativeClassInit();

    static {
        EGLImpl._nativeClassInit();
    }
}

