/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.TimeInterpolator;

class Ease {
    private static final float DOMAIN = 1.0f;
    private static final float DURATION = 1.0f;
    private static final float START = 0.0f;

    Ease() {
    }

    static class Sine {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return -1.0f * (float)Math.cos((double)(input / 1.0f) * 1.5707963267948966) + 1.0f + 0.0f;
            }
        };
        public static final TimeInterpolator easeOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f * (float)Math.sin((double)(input / 1.0f) * 1.5707963267948966) + 0.0f;
            }
        };
        public static final TimeInterpolator easeInOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return -0.5f * ((float)Math.cos(Math.PI * (double)input / 1.0) - 1.0f) + 0.0f;
            }
        };

        Sine() {
        }
    }

    static class Quint {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input * input * input + 0.0f;
            }
        };
        public static final TimeInterpolator easeOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return 1.0f * (input * input * input * input * input + 1.0f) + 0.0f;
            }
        };
        public static final TimeInterpolator easeInOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input * input * input + 0.0f : 0.5f * ((input -= 2.0f) * input * input * input * input + 2.0f) + 0.0f;
            }
        };

        Quint() {
        }
    }

    static class Quart {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input * input + 0.0f;
            }
        };
        public static final TimeInterpolator easeOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return -1.0f * (input * input * input * input - 1.0f) + 0.0f;
            }
        };
        public static final TimeInterpolator easeInOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input * input + 0.0f : -0.5f * ((input -= 2.0f) * input * input * input - 2.0f) + 0.0f;
            }
        };

        Quart() {
        }
    }

    static class Quad {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input + 0.0f;
            }
        };
        public static final TimeInterpolator easeOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return -1.0f * (input /= 1.0f) * (input - 2.0f) + 0.0f;
            }
        };
        public static final TimeInterpolator easeInOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input + 0.0f : -0.5f * ((input -= 1.0f) * (input - 2.0f) - 1.0f) + 0.0f;
            }
        };

        Quad() {
        }
    }

    static class Cubic {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return 1.0f * (input /= 1.0f) * input * input + 0.0f;
            }
        };
        public static final TimeInterpolator easeOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                input = input / 1.0f - 1.0f;
                return 1.0f * (input * input * input + 1.0f) + 0.0f;
            }
        };
        public static final TimeInterpolator easeInOut = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                float f;
                input /= 0.5f;
                return f < 1.0f ? 0.5f * input * input * input + 0.0f : 0.5f * ((input -= 2.0f) * input * input + 2.0f) + 0.0f;
            }
        };

        Cubic() {
        }
    }

    static class Linear {
        public static final TimeInterpolator easeNone = new TimeInterpolator(){

            @Override
            public float getInterpolation(float input) {
                return input;
            }
        };

        Linear() {
        }
    }
}

