/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

public class FaceUnlockView
extends RelativeLayout {
    private static final String TAG = "FaceUnlockView";

    public FaceUnlockView(Context context) {
        this(context, null);
    }

    public FaceUnlockView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int viewWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int viewHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        int chosenSize = Math.min(viewWidth, viewHeight);
        int newWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(chosenSize, Integer.MIN_VALUE);
        int newHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(chosenSize, Integer.MIN_VALUE);
        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec);
    }
}

