/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.LruCache;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Locale;

public class SpellChecker
implements SpellCheckerSession.SpellCheckerSessionListener {
    private static final String TAG = SpellChecker.class.getSimpleName();
    private static final boolean DBG = false;
    public static final int MAX_NUMBER_OF_WORDS = 50;
    public static final int AVERAGE_WORD_LENGTH = 7;
    public static final int WORD_ITERATOR_INTERVAL = 350;
    private static final int SPELL_PAUSE_DURATION = 400;
    private static final int MIN_SENTENCE_LENGTH = 50;
    private static final int USE_SPAN_RANGE = -1;
    private final TextView mTextView;
    SpellCheckerSession mSpellCheckerSession;
    private boolean mIsSentenceSpellCheckSupported;
    final int mCookie;
    private int[] mIds;
    private SpellCheckSpan[] mSpellCheckSpans;
    private int mLength;
    private SpellParser[] mSpellParsers = new SpellParser[0];
    private int mSpanSequenceCounter = 0;
    private Locale mCurrentLocale;
    private WordIterator mWordIterator;
    private TextServicesManager mTextServicesManager;
    private Runnable mSpellRunnable;
    private static final int SUGGESTION_SPAN_CACHE_SIZE = 10;
    private final LruCache<Long, SuggestionSpan> mSuggestionSpanCache = new LruCache(10);

    public SpellChecker(TextView textView) {
        this.mTextView = textView;
        boolean size = true;
        this.mIds = ArrayUtils.newUnpaddedIntArray(1);
        this.mSpellCheckSpans = new SpellCheckSpan[this.mIds.length];
        this.setLocale(this.mTextView.getSpellCheckerLocale());
        this.mCookie = this.hashCode();
    }

    private void resetSession() {
        this.closeSession();
        this.mTextServicesManager = (TextServicesManager)this.mTextView.getContext().getSystemService("textservices");
        if (!this.mTextServicesManager.isSpellCheckerEnabled() || this.mCurrentLocale == null || this.mTextServicesManager.getCurrentSpellCheckerSubtype(true) == null) {
            this.mSpellCheckerSession = null;
        } else {
            this.mSpellCheckerSession = this.mTextServicesManager.newSpellCheckerSession(null, this.mCurrentLocale, this, false);
            this.mIsSentenceSpellCheckSupported = true;
        }
        for (int i = 0; i < this.mLength; ++i) {
            this.mIds[i] = -1;
        }
        this.mLength = 0;
        this.mTextView.removeMisspelledSpans((Editable)this.mTextView.getText());
        this.mSuggestionSpanCache.evictAll();
    }

    private void setLocale(Locale locale) {
        this.mCurrentLocale = locale;
        this.resetSession();
        if (locale != null) {
            this.mWordIterator = new WordIterator(locale);
        }
        this.mTextView.onLocaleChanged();
    }

    private boolean isSessionActive() {
        return this.mSpellCheckerSession != null;
    }

    public void closeSession() {
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            this.mSpellParsers[i].stop();
        }
        if (this.mSpellRunnable != null) {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
    }

    private int nextSpellCheckSpanIndex() {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mIds[i] >= 0) continue;
            return i;
        }
        this.mIds = GrowingArrayUtils.append(this.mIds, this.mLength, 0);
        this.mSpellCheckSpans = GrowingArrayUtils.append(this.mSpellCheckSpans, this.mLength, new SpellCheckSpan());
        ++this.mLength;
        return this.mLength - 1;
    }

    private void addSpellCheckSpan(Editable editable, int start, int end) {
        int index = this.nextSpellCheckSpanIndex();
        SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[index];
        editable.setSpan(spellCheckSpan, start, end, 33);
        spellCheckSpan.setSpellCheckInProgress(false);
        ++this.mSpanSequenceCounter;
    }

    public void onSpellCheckSpanRemoved(SpellCheckSpan spellCheckSpan) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mSpellCheckSpans[i] != spellCheckSpan) continue;
            this.mIds[i] = -1;
            return;
        }
    }

    public void onSelectionChanged() {
        this.spellCheck();
    }

    public void spellCheck(int start, int end) {
        SpellParser spellParser;
        Locale locale = this.mTextView.getSpellCheckerLocale();
        boolean isSessionActive = this.isSessionActive();
        if (locale == null || this.mCurrentLocale == null || !this.mCurrentLocale.equals(locale)) {
            this.setLocale(locale);
            start = 0;
            end = this.mTextView.getText().length();
        } else {
            boolean spellCheckerActivated = this.mTextServicesManager.isSpellCheckerEnabled();
            if (isSessionActive != spellCheckerActivated) {
                this.resetSession();
            }
        }
        if (!isSessionActive) {
            return;
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            spellParser = this.mSpellParsers[i];
            if (!spellParser.isFinished()) continue;
            spellParser.parse(start, end);
            return;
        }
        SpellParser[] newSpellParsers = new SpellParser[length + 1];
        System.arraycopy(this.mSpellParsers, 0, newSpellParsers, 0, length);
        this.mSpellParsers = newSpellParsers;
        this.mSpellParsers[length] = spellParser = new SpellParser();
        spellParser.parse(start, end);
    }

    private void spellCheck() {
        if (this.mSpellCheckerSession == null) {
            return;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int selectionStart = Selection.getSelectionStart(editable);
        int selectionEnd = Selection.getSelectionEnd(editable);
        TextInfo[] textInfos = new TextInfo[this.mLength];
        int textInfosCount = 0;
        for (int i = 0; i < this.mLength; ++i) {
            boolean isEditing;
            boolean apostrophe;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[i];
            if (this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
            int start = editable.getSpanStart(spellCheckSpan);
            int end = editable.getSpanEnd(spellCheckSpan);
            boolean bl = apostrophe = selectionStart == end + 1 && editable.charAt(end) == '\'';
            if (this.mIsSentenceSpellCheckSupported) {
                isEditing = !apostrophe && (selectionEnd <= start || selectionStart > end);
            } else {
                boolean bl2 = isEditing = !apostrophe && (selectionEnd < start || selectionStart > end);
            }
            if (start < 0 || end <= start || !isEditing) continue;
            spellCheckSpan.setSpellCheckInProgress(true);
            TextInfo textInfo = new TextInfo(editable, start, end, this.mCookie, this.mIds[i]);
            textInfos[textInfosCount++] = textInfo;
        }
        if (textInfosCount > 0) {
            if (textInfosCount < textInfos.length) {
                TextInfo[] textInfosCopy = new TextInfo[textInfosCount];
                System.arraycopy(textInfos, 0, textInfosCopy, 0, textInfosCount);
                textInfos = textInfosCopy;
            }
            if (this.mIsSentenceSpellCheckSupported) {
                this.mSpellCheckerSession.getSentenceSuggestions(textInfos, 5);
            } else {
                this.mSpellCheckerSession.getSuggestions(textInfos, 5, false);
            }
        }
    }

    private SpellCheckSpan onGetSuggestionsInternal(SuggestionsInfo suggestionsInfo, int offset, int length) {
        if (suggestionsInfo == null || suggestionsInfo.getCookie() != this.mCookie) {
            return null;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int sequenceNumber = suggestionsInfo.getSequence();
        for (int k = 0; k < this.mLength; ++k) {
            if (sequenceNumber != this.mIds[k]) continue;
            int attributes = suggestionsInfo.getSuggestionsAttributes();
            boolean isInDictionary = (attributes & 1) > 0;
            boolean looksLikeTypo = (attributes & 2) > 0;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[k];
            if (!isInDictionary && looksLikeTypo) {
                this.createMisspelledSuggestionSpan(editable, suggestionsInfo, spellCheckSpan, offset, length);
            } else if (this.mIsSentenceSpellCheckSupported) {
                Long key;
                SuggestionSpan tempSuggestionSpan;
                int end;
                int start;
                int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
                int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
                if (offset != -1 && length != -1) {
                    start = spellCheckSpanStart + offset;
                    end = start + length;
                } else {
                    start = spellCheckSpanStart;
                    end = spellCheckSpanEnd;
                }
                if (spellCheckSpanStart >= 0 && spellCheckSpanEnd > spellCheckSpanStart && end > start && (tempSuggestionSpan = this.mSuggestionSpanCache.get(key = Long.valueOf(TextUtils.packRangeInLong(start, end)))) != null) {
                    editable.removeSpan(tempSuggestionSpan);
                    this.mSuggestionSpanCache.remove(key);
                }
            }
            return spellCheckSpan;
        }
        return null;
    }

    @Override
    public void onGetSuggestions(SuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SpellCheckSpan spellCheckSpan = this.onGetSuggestionsInternal(results[i], -1, -1);
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    @Override
    public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SentenceSuggestionsInfo ssi = results[i];
            if (ssi == null) continue;
            SpellCheckSpan spellCheckSpan = null;
            for (int j = 0; j < ssi.getSuggestionsCount(); ++j) {
                SuggestionsInfo suggestionsInfo = ssi.getSuggestionsInfoAt(j);
                if (suggestionsInfo == null) continue;
                int offset = ssi.getOffsetAt(j);
                int length = ssi.getLengthAt(j);
                SpellCheckSpan scs = this.onGetSuggestionsInternal(suggestionsInfo, offset, length);
                if (spellCheckSpan != null || scs == null) continue;
                spellCheckSpan = scs;
            }
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    private void scheduleNewSpellCheck() {
        if (this.mSpellRunnable == null) {
            this.mSpellRunnable = new Runnable(){

                @Override
                public void run() {
                    int length = SpellChecker.this.mSpellParsers.length;
                    for (int i = 0; i < length; ++i) {
                        SpellParser spellParser = SpellChecker.this.mSpellParsers[i];
                        if (spellParser.isFinished()) continue;
                        spellParser.parse();
                        break;
                    }
                }
            };
        } else {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
        this.mTextView.postDelayed(this.mSpellRunnable, 400L);
    }

    private void createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan, int offset, int length) {
        String[] suggestions;
        int end;
        int start;
        int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
        int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
        if (spellCheckSpanStart < 0 || spellCheckSpanEnd <= spellCheckSpanStart) {
            return;
        }
        if (offset != -1 && length != -1) {
            start = spellCheckSpanStart + offset;
            end = start + length;
        } else {
            start = spellCheckSpanStart;
            end = spellCheckSpanEnd;
        }
        int suggestionsCount = suggestionsInfo.getSuggestionsCount();
        if (suggestionsCount > 0) {
            suggestions = new String[suggestionsCount];
            for (int i = 0; i < suggestionsCount; ++i) {
                suggestions[i] = suggestionsInfo.getSuggestionAt(i);
            }
        } else {
            suggestions = ArrayUtils.emptyArray(String.class);
        }
        SuggestionSpan suggestionSpan = new SuggestionSpan(this.mTextView.getContext(), suggestions, 3);
        if (this.mIsSentenceSpellCheckSupported) {
            Long key = TextUtils.packRangeInLong(start, end);
            SuggestionSpan tempSuggestionSpan = this.mSuggestionSpanCache.get(key);
            if (tempSuggestionSpan != null) {
                editable.removeSpan(tempSuggestionSpan);
            }
            this.mSuggestionSpanCache.put(key, suggestionSpan);
        }
        editable.setSpan(suggestionSpan, start, end, 33);
        this.mTextView.invalidateRegion(start, end, false);
    }

    public static boolean haveWordBoundariesChanged(Editable editable, int start, int end, int spanStart, int spanEnd) {
        boolean haveWordBoundariesChanged;
        if (spanEnd != start && spanStart != end) {
            haveWordBoundariesChanged = true;
        } else if (spanEnd == start && start < editable.length()) {
            int codePoint = Character.codePointAt(editable, start);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else if (spanStart == end && end > 0) {
            int codePoint = Character.codePointBefore(editable, end);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else {
            haveWordBoundariesChanged = false;
        }
        return haveWordBoundariesChanged;
    }

    private class SpellParser {
        private Object mRange = new Object();

        private SpellParser() {
        }

        public void parse(int start, int end) {
            int parseEnd;
            int max = SpellChecker.this.mTextView.length();
            if (end > max) {
                Log.w(TAG, "Parse invalid region, from " + start + " to " + end);
                parseEnd = max;
            } else {
                parseEnd = end;
            }
            if (parseEnd > start) {
                this.setRangeSpan((Editable)SpellChecker.this.mTextView.getText(), start, parseEnd);
                this.parse();
            }
        }

        public boolean isFinished() {
            return ((Editable)SpellChecker.this.mTextView.getText()).getSpanStart(this.mRange) < 0;
        }

        public void stop() {
            this.removeRangeSpan((Editable)SpellChecker.this.mTextView.getText());
        }

        private void setRangeSpan(Editable editable, int start, int end) {
            editable.setSpan(this.mRange, start, end, 33);
        }

        private void removeRangeSpan(Editable editable) {
            editable.removeSpan(this.mRange);
        }

        public void parse() {
            int wordEnd;
            Editable editable = (Editable)SpellChecker.this.mTextView.getText();
            int start = SpellChecker.this.mIsSentenceSpellCheckSupported ? Math.max(0, editable.getSpanStart(this.mRange) - 50) : editable.getSpanStart(this.mRange);
            int end = editable.getSpanEnd(this.mRange);
            int wordIteratorWindowEnd = Math.min(end, start + 350);
            SpellChecker.this.mWordIterator.setCharSequence(editable, start, wordIteratorWindowEnd);
            int wordStart = SpellChecker.this.mWordIterator.preceding(start);
            if (wordStart == -1) {
                wordEnd = SpellChecker.this.mWordIterator.following(start);
                if (wordEnd != -1) {
                    wordStart = SpellChecker.this.mWordIterator.getBeginning(wordEnd);
                }
            } else {
                wordEnd = SpellChecker.this.mWordIterator.getEnd(wordStart);
            }
            if (wordEnd == -1) {
                this.removeRangeSpan(editable);
                return;
            }
            SpellCheckSpan[] spellCheckSpans = editable.getSpans(start - 1, end + 1, SpellCheckSpan.class);
            SuggestionSpan[] suggestionSpans = editable.getSpans(start - 1, end + 1, SuggestionSpan.class);
            int wordCount = 0;
            boolean scheduleOtherSpellCheck = false;
            if (SpellChecker.this.mIsSentenceSpellCheckSupported) {
                int spellCheckEnd;
                boolean correct;
                if (wordIteratorWindowEnd < end) {
                    scheduleOtherSpellCheck = true;
                }
                boolean bl = correct = (spellCheckEnd = SpellChecker.this.mWordIterator.preceding(wordIteratorWindowEnd)) != -1;
                if (correct) {
                    spellCheckEnd = SpellChecker.this.mWordIterator.getEnd(spellCheckEnd);
                    boolean bl2 = correct = spellCheckEnd != -1;
                }
                if (!correct) {
                    this.removeRangeSpan(editable);
                    return;
                }
                int spellCheckStart = wordStart;
                boolean createSpellCheckSpan = true;
                for (int i = 0; i < SpellChecker.this.mLength; ++i) {
                    SpellCheckSpan spellCheckSpan = SpellChecker.this.mSpellCheckSpans[i];
                    if (SpellChecker.this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
                    int spanStart = editable.getSpanStart(spellCheckSpan);
                    int spanEnd = editable.getSpanEnd(spellCheckSpan);
                    if (spanEnd < spellCheckStart || spellCheckEnd < spanStart) continue;
                    if (spanStart <= spellCheckStart && spellCheckEnd <= spanEnd) {
                        createSpellCheckSpan = false;
                        break;
                    }
                    editable.removeSpan(spellCheckSpan);
                    spellCheckStart = Math.min(spanStart, spellCheckStart);
                    spellCheckEnd = Math.max(spanEnd, spellCheckEnd);
                }
                if (spellCheckEnd >= start) {
                    if (spellCheckEnd <= spellCheckStart) {
                        Log.w(TAG, "Trying to spellcheck invalid region, from " + start + " to " + end);
                    } else if (createSpellCheckSpan) {
                        SpellChecker.this.addSpellCheckSpan(editable, spellCheckStart, spellCheckEnd);
                    }
                }
                wordStart = spellCheckEnd;
            } else {
                while (wordStart <= end) {
                    if (wordEnd >= start && wordEnd > wordStart) {
                        int i;
                        if (wordCount >= 50) {
                            scheduleOtherSpellCheck = true;
                            break;
                        }
                        if (wordStart < start && wordEnd > start) {
                            this.removeSpansAt(editable, start, spellCheckSpans);
                            this.removeSpansAt(editable, start, suggestionSpans);
                        }
                        if (wordStart < end && wordEnd > end) {
                            this.removeSpansAt(editable, end, spellCheckSpans);
                            this.removeSpansAt(editable, end, suggestionSpans);
                        }
                        boolean createSpellCheckSpan = true;
                        if (wordEnd == start) {
                            for (i = 0; i < spellCheckSpans.length; ++i) {
                                int spanEnd = editable.getSpanEnd(spellCheckSpans[i]);
                                if (spanEnd != start) continue;
                                createSpellCheckSpan = false;
                                break;
                            }
                        }
                        if (wordStart == end) {
                            for (i = 0; i < spellCheckSpans.length; ++i) {
                                int spanStart = editable.getSpanStart(spellCheckSpans[i]);
                                if (spanStart != end) continue;
                                createSpellCheckSpan = false;
                                break;
                            }
                        }
                        if (createSpellCheckSpan) {
                            SpellChecker.this.addSpellCheckSpan(editable, wordStart, wordEnd);
                        }
                        ++wordCount;
                    }
                    int originalWordEnd = wordEnd;
                    wordEnd = SpellChecker.this.mWordIterator.following(wordEnd);
                    if (wordIteratorWindowEnd < end && (wordEnd == -1 || wordEnd >= wordIteratorWindowEnd)) {
                        wordIteratorWindowEnd = Math.min(end, originalWordEnd + 350);
                        SpellChecker.this.mWordIterator.setCharSequence(editable, originalWordEnd, wordIteratorWindowEnd);
                        wordEnd = SpellChecker.this.mWordIterator.following(originalWordEnd);
                    }
                    if (wordEnd != -1 && (wordStart = SpellChecker.this.mWordIterator.getBeginning(wordEnd)) != -1) continue;
                    break;
                }
            }
            if (scheduleOtherSpellCheck && wordStart <= end) {
                this.setRangeSpan(editable, wordStart, end);
            } else {
                this.removeRangeSpan(editable);
            }
            SpellChecker.this.spellCheck();
        }

        private <T> void removeSpansAt(Editable editable, int offset, T[] spans) {
            for (T span : spans) {
                int end;
                int start = editable.getSpanStart(span);
                if (start > offset || (end = editable.getSpanEnd(span)) < offset) continue;
                editable.removeSpan(span);
            }
        }
    }
}

