/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Pools;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup {
    public static final int TRUE = -1;
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_TOP = 6;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_VERTICAL = 15;
    public static final int START_OF = 16;
    public static final int END_OF = 17;
    public static final int ALIGN_START = 18;
    public static final int ALIGN_END = 19;
    public static final int ALIGN_PARENT_START = 20;
    public static final int ALIGN_PARENT_END = 21;
    private static final int VERB_COUNT = 22;
    private static final int[] RULES_VERTICAL = new int[]{2, 3, 4, 6, 8};
    private static final int[] RULES_HORIZONTAL = new int[]{0, 1, 5, 7, 16, 17, 18, 19};
    private static final int VALUE_NOT_SET = Integer.MIN_VALUE;
    private View mBaselineView = null;
    private boolean mHasBaselineAlignedChild;
    private int mGravity = 0x800033;
    private final Rect mContentBounds = new Rect();
    private final Rect mSelfBounds = new Rect();
    private int mIgnoreGravity;
    private SortedSet<View> mTopToBottomLeftToRightSet = null;
    private boolean mDirtyHierarchy;
    private View[] mSortedHorizontalChildren;
    private View[] mSortedVerticalChildren;
    private final DependencyGraph mGraph = new DependencyGraph();
    private boolean mAllowBrokenMeasureSpecs = false;
    private boolean mMeasureVerticalWithPaddingMargin = false;
    private static final int DEFAULT_WIDTH = 65536;

    public RelativeLayout(Context context) {
        this(context, null);
    }

    public RelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initFromAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.queryCompatibilityModes(context);
    }

    private void initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RelativeLayout, defStyleAttr, defStyleRes);
        this.mIgnoreGravity = a.getResourceId(1, -1);
        this.mGravity = a.getInt(0, this.mGravity);
        a.recycle();
    }

    private void queryCompatibilityModes(Context context) {
        int version = context.getApplicationInfo().targetSdkVersion;
        this.mAllowBrokenMeasureSpecs = version <= 17;
        this.mMeasureVerticalWithPaddingMargin = version >= 18;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int viewId) {
        this.mIgnoreGravity = viewId;
    }

    public int getGravity() {
        return this.mGravity;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    @Override
    public int getBaseline() {
        return this.mBaselineView != null ? this.mBaselineView.getBaseline() : super.getBaseline();
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    private void sortChildren() {
        int count = this.getChildCount();
        if (this.mSortedVerticalChildren == null || this.mSortedVerticalChildren.length != count) {
            this.mSortedVerticalChildren = new View[count];
        }
        if (this.mSortedHorizontalChildren == null || this.mSortedHorizontalChildren.length != count) {
            this.mSortedHorizontalChildren = new View[count];
        }
        DependencyGraph graph = this.mGraph;
        graph.clear();
        for (int i = 0; i < count; ++i) {
            graph.add(this.getChildAt(i));
        }
        graph.getSortedViews(this.mSortedVerticalChildren, RULES_VERTICAL);
        graph.getSortedViews(this.mSortedHorizontalChildren, RULES_HORIZONTAL);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] rules;
        LayoutParams params;
        View child;
        int i;
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            this.sortChildren();
        }
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (widthMode == 0x40000000) {
            width = myWidth;
        }
        if (heightMode == 0x40000000) {
            height = myHeight;
        }
        this.mHasBaselineAlignedChild = false;
        View ignore = null;
        int gravity = this.mGravity & 0x800007;
        boolean horizontalGravity = gravity != 0x800003 && gravity != 0;
        gravity = this.mGravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean offsetHorizontalAxis = false;
        boolean offsetVerticalAxis = false;
        if ((horizontalGravity || verticalGravity) && this.mIgnoreGravity != -1) {
            ignore = this.findViewById(this.mIgnoreGravity);
        }
        boolean isWrapContentWidth = widthMode != 0x40000000;
        boolean isWrapContentHeight = heightMode != 0x40000000;
        int layoutDirection = this.getLayoutDirection();
        if (this.isLayoutRtl() && myWidth == -1) {
            myWidth = 65536;
        }
        for (View child2 : this.mSortedHorizontalChildren) {
            if (child2.getVisibility() == 8) continue;
            LayoutParams params2 = (LayoutParams)child2.getLayoutParams();
            int[] rules2 = params2.getRules(layoutDirection);
            this.applyHorizontalSizeRules(params2, myWidth, rules2);
            this.measureChildHorizontal(child2, params2, myWidth, myHeight);
            if (!this.positionChildHorizontal(child2, params2, myWidth, isWrapContentWidth)) continue;
            offsetHorizontalAxis = true;
        }
        View[] views = this.mSortedVerticalChildren;
        int count = views.length;
        int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        for (i = 0; i < count; ++i) {
            child = views[i];
            if (child.getVisibility() == 8) continue;
            params = (LayoutParams)child.getLayoutParams();
            this.applyVerticalSizeRules(params, myHeight);
            this.measureChild(child, params, myWidth, myHeight);
            if (this.positionChildVertical(child, params, myHeight, isWrapContentHeight)) {
                offsetVerticalAxis = true;
            }
            if (isWrapContentWidth) {
                width = this.isLayoutRtl() ? (targetSdkVersion < 19 ? Math.max(width, myWidth - params.mLeft) : Math.max(width, myWidth - params.mLeft - params.leftMargin)) : (targetSdkVersion < 19 ? Math.max(width, params.mRight) : Math.max(width, params.mRight + params.rightMargin));
            }
            if (isWrapContentHeight) {
                height = targetSdkVersion < 19 ? Math.max(height, params.mBottom) : Math.max(height, params.mBottom + params.bottomMargin);
            }
            if (child != ignore || verticalGravity) {
                left = Math.min(left, params.mLeft - params.leftMargin);
                top = Math.min(top, params.mTop - params.topMargin);
            }
            if (child == ignore && !horizontalGravity) continue;
            right = Math.max(right, params.mRight + params.rightMargin);
            bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
        }
        if (this.mHasBaselineAlignedChild) {
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                params = (LayoutParams)child.getLayoutParams();
                this.alignBaseline(child, params);
                if (child != ignore || verticalGravity) {
                    left = Math.min(left, params.mLeft - params.leftMargin);
                    top = Math.min(top, params.mTop - params.topMargin);
                }
                if (child == ignore && !horizontalGravity) continue;
                right = Math.max(right, params.mRight + params.rightMargin);
                bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
            }
        }
        if (isWrapContentWidth) {
            width += this.mPaddingRight;
            if (this.mLayoutParams != null && this.mLayoutParams.width >= 0) {
                width = Math.max(width, this.mLayoutParams.width);
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
            if (offsetHorizontalAxis) {
                for (i = 0; i < count; ++i) {
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[14] != 0) {
                        RelativeLayout.centerHorizontal(child, params, width);
                        continue;
                    }
                    if (rules[11] == 0) continue;
                    int childWidth = child.getMeasuredWidth();
                    params.mLeft = width - this.mPaddingRight - childWidth;
                    params.mRight = params.mLeft + childWidth;
                }
            }
        }
        if (isWrapContentHeight) {
            height += this.mPaddingBottom;
            if (this.mLayoutParams != null && this.mLayoutParams.height >= 0) {
                height = Math.max(height, this.mLayoutParams.height);
            }
            height = Math.max(height, this.getSuggestedMinimumHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
            if (offsetVerticalAxis) {
                for (i = 0; i < count; ++i) {
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[15] != 0) {
                        RelativeLayout.centerVertical(child, params, height);
                        continue;
                    }
                    if (rules[12] == 0) continue;
                    int childHeight = child.getMeasuredHeight();
                    params.mTop = height - this.mPaddingBottom - childHeight;
                    params.mBottom = params.mTop + childHeight;
                }
            }
        }
        if (horizontalGravity || verticalGravity) {
            Rect selfBounds = this.mSelfBounds;
            selfBounds.set(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
            Rect contentBounds = this.mContentBounds;
            Gravity.apply(this.mGravity, right - left, bottom - top, selfBounds, contentBounds, layoutDirection);
            int horizontalOffset = contentBounds.left - left;
            int verticalOffset = contentBounds.top - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i2 = 0; i2 < count; ++i2) {
                    View child3 = this.getChildAt(i2);
                    if (child3.getVisibility() == 8 || child3 == ignore) continue;
                    LayoutParams params3 = (LayoutParams)child3.getLayoutParams();
                    if (horizontalGravity) {
                        params3.mLeft += horizontalOffset;
                        params3.mRight += horizontalOffset;
                    }
                    if (!verticalGravity) continue;
                    params3.mTop += verticalOffset;
                    params3.mBottom += verticalOffset;
                }
            }
        }
        if (this.isLayoutRtl()) {
            int offsetWidth = myWidth - width;
            for (int i3 = 0; i3 < count; ++i3) {
                View child4 = this.getChildAt(i3);
                if (child4.getVisibility() == 8) continue;
                LayoutParams params4 = (LayoutParams)child4.getLayoutParams();
                params4.mLeft -= offsetWidth;
                params4.mRight -= offsetWidth;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private void alignBaseline(View child, LayoutParams params) {
        LayoutParams anchorParams;
        int layoutDirection = this.getLayoutDirection();
        int[] rules = params.getRules(layoutDirection);
        int anchorBaseline = this.getRelatedViewBaseline(rules, 4);
        if (anchorBaseline != -1 && (anchorParams = this.getRelatedViewParams(rules, 4)) != null) {
            int offset = anchorParams.mTop + anchorBaseline;
            int baseline = child.getBaseline();
            if (baseline != -1) {
                offset -= baseline;
            }
            int height = params.mBottom - params.mTop;
            params.mTop = offset;
            params.mBottom = params.mTop + height;
        }
        if (this.mBaselineView == null) {
            this.mBaselineView = child;
        } else {
            LayoutParams lp = (LayoutParams)this.mBaselineView.getLayoutParams();
            if (params.mTop < lp.mTop || params.mTop == lp.mTop && params.mLeft < lp.mLeft) {
                this.mBaselineView = child;
            }
        }
    }

    private void measureChild(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, this.mPaddingTop, this.mPaddingBottom, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private void measureChildHorizontal(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int maxHeight = myHeight;
        if (this.mMeasureVerticalWithPaddingMargin) {
            maxHeight = Math.max(0, myHeight - this.mPaddingTop - this.mPaddingBottom - params.topMargin - params.bottomMargin);
        }
        int childHeightMeasureSpec = myHeight < 0 && !this.mAllowBrokenMeasureSpecs ? (params.height >= 0 ? View.MeasureSpec.makeMeasureSpec(params.height, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0)) : (params.width == -1 ? View.MeasureSpec.makeMeasureSpec(maxHeight, 0x40000000) : View.MeasureSpec.makeMeasureSpec(maxHeight, Integer.MIN_VALUE));
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private int getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int startPadding, int endPadding, int mySize) {
        int childSpecMode = 0;
        int childSpecSize = 0;
        if (mySize < 0 && !this.mAllowBrokenMeasureSpecs) {
            if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
                childSpecSize = Math.max(0, childEnd - childStart);
                childSpecMode = 0x40000000;
            } else if (childSize >= 0) {
                childSpecSize = childSize;
                childSpecMode = 0x40000000;
            } else {
                childSpecSize = 0;
                childSpecMode = 0;
            }
            return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
        }
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart == Integer.MIN_VALUE) {
            tempStart = startPadding + startMargin;
        }
        if (tempEnd == Integer.MIN_VALUE) {
            tempEnd = mySize - endPadding - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize == -2) {
            if (maxAvailable >= 0) {
                childSpecMode = Integer.MIN_VALUE;
                childSpecSize = maxAvailable;
            } else {
                childSpecMode = 0;
                childSpecSize = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    private boolean positionChildHorizontal(View child, LayoutParams params, int myWidth, boolean wrapContent) {
        int layoutDirection = this.getLayoutDirection();
        int[] rules = params.getRules(layoutDirection);
        if (params.mLeft == Integer.MIN_VALUE && params.mRight != Integer.MIN_VALUE) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft != Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft == Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[14] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerHorizontal(child, params, myWidth);
                } else {
                    params.mLeft = this.mPaddingLeft + params.leftMargin;
                    params.mRight = params.mLeft + child.getMeasuredWidth();
                }
                return true;
            }
            if (this.isLayoutRtl()) {
                params.mRight = myWidth - this.mPaddingRight - params.rightMargin;
                params.mLeft = params.mRight - child.getMeasuredWidth();
            } else {
                params.mLeft = this.mPaddingLeft + params.leftMargin;
                params.mRight = params.mLeft + child.getMeasuredWidth();
            }
        }
        return rules[21] != 0;
    }

    private boolean positionChildVertical(View child, LayoutParams params, int myHeight, boolean wrapContent) {
        int[] rules = params.getRules();
        if (params.mTop == Integer.MIN_VALUE && params.mBottom != Integer.MIN_VALUE) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop != Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop == Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[15] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerVertical(child, params, myHeight);
                } else {
                    params.mTop = this.mPaddingTop + params.topMargin;
                    params.mBottom = params.mTop + child.getMeasuredHeight();
                }
                return true;
            }
            params.mTop = this.mPaddingTop + params.topMargin;
            params.mBottom = params.mTop + child.getMeasuredHeight();
        }
        return rules[12] != 0;
    }

    private void applyHorizontalSizeRules(LayoutParams childParams, int myWidth, int[] rules) {
        childParams.mLeft = Integer.MIN_VALUE;
        childParams.mRight = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (childParams.alignWithParent && rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (childParams.alignWithParent && rules[1] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (childParams.alignWithParent && rules[5] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (childParams.alignWithParent && rules[7] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        if (0 != rules[9]) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        if (0 != rules[11] && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
    }

    private void applyVerticalSizeRules(LayoutParams childParams, int myHeight) {
        int[] rules = childParams.getRules();
        childParams.mTop = Integer.MIN_VALUE;
        childParams.mBottom = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (childParams.alignWithParent && rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (childParams.alignWithParent && rules[3] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (childParams.alignWithParent && rules[6] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 8);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (childParams.alignWithParent && rules[8] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (0 != rules[10]) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        if (0 != rules[12] && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (rules[4] != 0) {
            this.mHasBaselineAlignedChild = true;
        }
    }

    private View getRelatedView(int[] rules, int relation) {
        int id2 = rules[relation];
        if (id2 != 0) {
            DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(id2);
            if (node == null) {
                return null;
            }
            View v = node.view;
            while (v.getVisibility() == 8) {
                rules = ((LayoutParams)v.getLayoutParams()).getRules(v.getLayoutDirection());
                node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(rules[relation]);
                if (node == null) {
                    return null;
                }
                v = node.view;
            }
            return v;
        }
        return null;
    }

    private LayoutParams getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    private int getRelatedViewBaseline(int[] rules, int relation) {
        View v = this.getRelatedView(rules, relation);
        if (v != null) {
            return v.getBaseline();
        }
        return -1;
    }

    private static void centerHorizontal(View child, LayoutParams params, int myWidth) {
        int childWidth = child.getMeasuredWidth();
        int left = (myWidth - childWidth) / 2;
        params.mLeft = left;
        params.mRight = left + childWidth;
    }

    private static void centerVertical(View child, LayoutParams params, int myHeight) {
        int childHeight = child.getMeasuredHeight();
        int top = (myHeight - childHeight) / 2;
        params.mTop = top;
        params.mBottom = top + childHeight;
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams st = (LayoutParams)child.getLayoutParams();
            child.layout(st.mLeft, st.mTop, st.mRight, st.mBottom);
        }
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mTopToBottomLeftToRightSet == null) {
            this.mTopToBottomLeftToRightSet = new TreeSet<View>(new TopToBottomLeftToRightComparator());
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mTopToBottomLeftToRightSet.add(this.getChildAt(i));
        }
        for (View view : this.mTopToBottomLeftToRightSet) {
            if (view.getVisibility() != 0 || !view.dispatchPopulateAccessibilityEvent(event)) continue;
            this.mTopToBottomLeftToRightSet.clear();
            return true;
        }
        this.mTopToBottomLeftToRightSet.clear();
        return false;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(RelativeLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(RelativeLayout.class.getName());
    }

    private static class DependencyGraph {
        private ArrayList<Node> mNodes = new ArrayList();
        private SparseArray<Node> mKeyNodes = new SparseArray();
        private ArrayDeque<Node> mRoots = new ArrayDeque();

        private DependencyGraph() {
        }

        void clear() {
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (int i = 0; i < count; ++i) {
                nodes.get(i).release();
            }
            nodes.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        void add(View view) {
            int id2 = view.getId();
            Node node = Node.acquire(view);
            if (id2 != -1) {
                this.mKeyNodes.put(id2, node);
            }
            this.mNodes.add(node);
        }

        void getSortedViews(View[] sorted, int ... rules) {
            Node node;
            ArrayDeque<Node> roots = this.findRoots(rules);
            int index = 0;
            while ((node = roots.pollLast()) != null) {
                View view = node.view;
                int key = view.getId();
                sorted[index++] = view;
                ArrayMap<Node, DependencyGraph> dependents = node.dependents;
                int count = dependents.size();
                for (int i = 0; i < count; ++i) {
                    Node dependent = dependents.keyAt(i);
                    SparseArray<Node> dependencies = dependent.dependencies;
                    dependencies.remove(key);
                    if (dependencies.size() != 0) continue;
                    roots.add(dependent);
                }
            }
            if (index < sorted.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        private ArrayDeque<Node> findRoots(int[] rulesFilter) {
            Node node;
            int i;
            SparseArray<Node> keyNodes = this.mKeyNodes;
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                node.dependents.clear();
                node.dependencies.clear();
            }
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                LayoutParams layoutParams = (LayoutParams)node.view.getLayoutParams();
                int[] rules = layoutParams.mRules;
                int rulesCount = rulesFilter.length;
                for (int j = 0; j < rulesCount; ++j) {
                    Node dependency;
                    int rule = rules[rulesFilter[j]];
                    if (rule <= 0 || (dependency = keyNodes.get(rule)) == null || dependency == node) continue;
                    dependency.dependents.put(node, this);
                    node.dependencies.put(rule, dependency);
                }
            }
            ArrayDeque<Node> roots = this.mRoots;
            roots.clear();
            for (int i2 = 0; i2 < count; ++i2) {
                Node node2 = nodes.get(i2);
                if (node2.dependencies.size() != 0) continue;
                roots.addLast(node2);
            }
            return roots;
        }

        static class Node {
            View view;
            final ArrayMap<Node, DependencyGraph> dependents = new ArrayMap();
            final SparseArray<Node> dependencies = new SparseArray();
            private static final int POOL_LIMIT = 100;
            private static final Pools.SynchronizedPool<Node> sPool = new Pools.SynchronizedPool(100);

            Node() {
            }

            static Node acquire(View view) {
                Node node = sPool.acquire();
                if (node == null) {
                    node = new Node();
                }
                node.view = view;
                return node;
            }

            void release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout", resolveId=true, indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf"), @ViewDebug.IntToString(from=18, to="alignStart"), @ViewDebug.IntToString(from=19, to="alignEnd"), @ViewDebug.IntToString(from=20, to="alignParentStart"), @ViewDebug.IntToString(from=21, to="alignParentEnd"), @ViewDebug.IntToString(from=16, to="startOf"), @ViewDebug.IntToString(from=17, to="endOf")}, mapping={@ViewDebug.IntToString(from=-1, to="true"), @ViewDebug.IntToString(from=0, to="false/NO_ID")})
        private int[] mRules = new int[22];
        private int[] mInitialRules = new int[22];
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        private boolean mRulesChanged = false;
        private boolean mIsRtlCompatibilityMode = false;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean alignWithParent;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.RelativeLayout_Layout);
            int targetSdkVersion = c.getApplicationInfo().targetSdkVersion;
            this.mIsRtlCompatibilityMode = targetSdkVersion < 17 || !c.getApplicationInfo().hasRtlSupport();
            int[] rules = this.mRules;
            int[] initialRules = this.mInitialRules;
            int N = a.getIndexCount();
            block25: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (attr2) {
                    case 16: {
                        this.alignWithParent = a.getBoolean(attr2, false);
                        continue block25;
                    }
                    case 0: {
                        rules[0] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 1: {
                        rules[1] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 2: {
                        rules[2] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 3: {
                        rules[3] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 4: {
                        rules[4] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 5: {
                        rules[5] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 6: {
                        rules[6] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 7: {
                        rules[7] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 8: {
                        rules[8] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 9: {
                        rules[9] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 10: {
                        rules[10] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 11: {
                        rules[11] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 12: {
                        rules[12] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 13: {
                        rules[13] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 14: {
                        rules[14] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 15: {
                        rules[15] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 17: {
                        rules[16] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 18: {
                        rules[17] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 19: {
                        rules[18] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 20: {
                        rules[19] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 21: {
                        rules[20] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 22: {
                        rules[21] = a.getBoolean(attr2, false) ? -1 : 0;
                    }
                }
            }
            this.mRulesChanged = true;
            System.arraycopy((int[])rules, (int)0, (int[])initialRules, (int)0, (int)22);
            a.recycle();
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.mIsRtlCompatibilityMode = source.mIsRtlCompatibilityMode;
            this.mRulesChanged = source.mRulesChanged;
            this.alignWithParent = source.alignWithParent;
            System.arraycopy((int[])source.mRules, (int)0, (int[])this.mRules, (int)0, (int)22);
            System.arraycopy((int[])source.mInitialRules, (int)0, (int[])this.mInitialRules, (int)0, (int)22);
        }

        @Override
        public String debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public void addRule(int verb) {
            this.mRules[verb] = -1;
            this.mInitialRules[verb] = -1;
            this.mRulesChanged = true;
        }

        public void addRule(int verb, int anchor) {
            this.mRules[verb] = anchor;
            this.mInitialRules[verb] = anchor;
            this.mRulesChanged = true;
        }

        public void removeRule(int verb) {
            this.mRules[verb] = 0;
            this.mInitialRules[verb] = 0;
            this.mRulesChanged = true;
        }

        private boolean hasRelativeRules() {
            return this.mInitialRules[16] != 0 || this.mInitialRules[17] != 0 || this.mInitialRules[18] != 0 || this.mInitialRules[19] != 0 || this.mInitialRules[20] != 0 || this.mInitialRules[21] != 0;
        }

        private void resolveRules(int layoutDirection) {
            boolean isLayoutRtl = layoutDirection == 1;
            System.arraycopy((int[])this.mInitialRules, (int)0, (int[])this.mRules, (int)0, (int)22);
            if (this.mIsRtlCompatibilityMode) {
                if (this.mRules[18] != 0) {
                    if (this.mRules[5] == 0) {
                        this.mRules[5] = this.mRules[18];
                    }
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    if (this.mRules[7] == 0) {
                        this.mRules[7] = this.mRules[19];
                    }
                    this.mRules[19] = 0;
                }
                if (this.mRules[16] != 0) {
                    if (this.mRules[0] == 0) {
                        this.mRules[0] = this.mRules[16];
                    }
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    if (this.mRules[1] == 0) {
                        this.mRules[1] = this.mRules[17];
                    }
                    this.mRules[17] = 0;
                }
                if (this.mRules[20] != 0) {
                    if (this.mRules[9] == 0) {
                        this.mRules[9] = this.mRules[20];
                    }
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    if (this.mRules[11] == 0) {
                        this.mRules[11] = this.mRules[21];
                    }
                    this.mRules[21] = 0;
                }
            } else {
                if (!(this.mRules[18] == 0 && this.mRules[19] == 0 || this.mRules[5] == 0 && this.mRules[7] == 0)) {
                    this.mRules[5] = 0;
                    this.mRules[7] = 0;
                }
                if (this.mRules[18] != 0) {
                    this.mRules[isLayoutRtl ? 7 : 5] = this.mRules[18];
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    this.mRules[isLayoutRtl ? 5 : 7] = this.mRules[19];
                    this.mRules[19] = 0;
                }
                if (!(this.mRules[16] == 0 && this.mRules[17] == 0 || this.mRules[0] == 0 && this.mRules[1] == 0)) {
                    this.mRules[0] = 0;
                    this.mRules[1] = 0;
                }
                if (this.mRules[16] != 0) {
                    this.mRules[isLayoutRtl ? 1 : 0] = this.mRules[16];
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    this.mRules[isLayoutRtl ? 0 : 1] = this.mRules[17];
                    this.mRules[17] = 0;
                }
                if (!(this.mRules[20] == 0 && this.mRules[21] == 0 || this.mRules[9] == 0 && this.mRules[11] == 0)) {
                    this.mRules[9] = 0;
                    this.mRules[11] = 0;
                }
                if (this.mRules[20] != 0) {
                    this.mRules[isLayoutRtl ? 11 : 9] = this.mRules[20];
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    this.mRules[isLayoutRtl ? 9 : 11] = this.mRules[21];
                    this.mRules[21] = 0;
                }
            }
            this.mRulesChanged = false;
        }

        public int[] getRules(int layoutDirection) {
            if (this.hasRelativeRules() && (this.mRulesChanged || layoutDirection != this.getLayoutDirection())) {
                this.resolveRules(layoutDirection);
                if (layoutDirection != this.getLayoutDirection()) {
                    this.setLayoutDirection(layoutDirection);
                }
            }
            return this.mRules;
        }

        public int[] getRules() {
            return this.mRules;
        }

        @Override
        public void resolveLayoutDirection(int layoutDirection) {
            boolean isLayoutRtl = this.isLayoutRtl();
            if (this.hasRelativeRules() && layoutDirection != this.getLayoutDirection()) {
                this.resolveRules(layoutDirection);
            }
            super.resolveLayoutDirection(layoutDirection);
        }
    }

    private class TopToBottomLeftToRightComparator
    implements Comparator<View> {
        private TopToBottomLeftToRightComparator() {
        }

        @Override
        public int compare(View first, View second) {
            int topDifference = first.getTop() - second.getTop();
            if (topDifference != 0) {
                return topDifference;
            }
            int leftDifference = first.getLeft() - second.getLeft();
            if (leftDifference != 0) {
                return leftDifference;
            }
            int heightDiference = first.getHeight() - second.getHeight();
            if (heightDiference != 0) {
                return heightDiference;
            }
            int widthDiference = first.getWidth() - second.getWidth();
            if (widthDiference != 0) {
                return widthDiference;
            }
            return 0;
        }
    }
}

