/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.StateSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.EdgeEffect;
import android.widget.EditText;
import android.widget.FastScroller;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import android.widget.PopupWindow;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsListView
extends AdapterView<ListAdapter>
implements TextWatcher,
ViewTreeObserver.OnGlobalLayoutListener,
Filter.FilterListener,
ViewTreeObserver.OnTouchModeChangeListener,
RemoteViewsAdapter.RemoteAdapterConnectionCallback {
    private static final String TAG = "AbsListView";
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    static final int TOUCH_MODE_REST = -1;
    static final int TOUCH_MODE_DOWN = 0;
    static final int TOUCH_MODE_TAP = 1;
    static final int TOUCH_MODE_DONE_WAITING = 2;
    static final int TOUCH_MODE_SCROLL = 3;
    static final int TOUCH_MODE_FLING = 4;
    static final int TOUCH_MODE_OVERSCROLL = 5;
    static final int TOUCH_MODE_OVERFLING = 6;
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_FORCE_TOP = 1;
    static final int LAYOUT_SET_SELECTION = 2;
    static final int LAYOUT_FORCE_BOTTOM = 3;
    static final int LAYOUT_SPECIFIC = 4;
    static final int LAYOUT_SYNC = 5;
    static final int LAYOUT_MOVE_SELECTION = 6;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    private final Thread mOwnerThread;
    int mChoiceMode = 0;
    ActionMode mChoiceActionMode;
    MultiChoiceModeWrapper mMultiChoiceModeCallback;
    int mCheckedItemCount;
    SparseBooleanArray mCheckStates;
    LongSparseArray<Integer> mCheckedIdStates;
    int mLayoutMode = 0;
    AdapterDataSetObserver mDataSetObserver;
    ListAdapter mAdapter;
    private RemoteViewsAdapter mRemoteAdapter;
    boolean mAdapterHasStableIds;
    private boolean mDeferNotifyDataSetChanged = false;
    boolean mDrawSelectorOnTop = false;
    Drawable mSelector;
    int mSelectorPosition = -1;
    Rect mSelectorRect = new Rect();
    final RecycleBin mRecycler = new RecycleBin();
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    Rect mListPadding = new Rect();
    int mWidthMeasureSpec = 0;
    View mScrollUp;
    View mScrollDown;
    boolean mCachingStarted;
    boolean mCachingActive;
    int mMotionPosition;
    int mMotionViewOriginalTop;
    int mMotionViewNewTop;
    int mMotionX;
    int mMotionY;
    int mTouchMode = -1;
    int mLastY;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    AbsPositionScroller mPositionScroller;
    int mSelectedTop = 0;
    boolean mStackFromBottom;
    boolean mScrollingCacheEnabled;
    boolean mFastScrollEnabled;
    boolean mFastScrollAlwaysVisible;
    private OnScrollListener mOnScrollListener;
    PopupWindow mPopup;
    EditText mTextFilter;
    private boolean mSmoothScrollbarEnabled = true;
    private boolean mTextFilterEnabled;
    private boolean mFiltered;
    private Rect mTouchFrame;
    int mResurrectToPosition = -1;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    int mOverscrollMax;
    static final int OVERSCROLL_LIMIT_DIVISOR = 3;
    private static final int CHECK_POSITION_SEARCH_DISTANCE = 20;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode = -1;
    private static final boolean PROFILE_SCROLLING = false;
    private boolean mScrollProfilingStarted = false;
    private static final boolean PROFILE_FLINGING = false;
    private boolean mFlingProfilingStarted = false;
    private StrictMode.Span mScrollStrictSpan = null;
    private StrictMode.Span mFlingStrictSpan = null;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private PerformClick mPerformClick;
    private Runnable mTouchModeReset;
    private int mTranscriptMode;
    private int mCacheColorHint;
    private boolean mIsChildViewEnabled;
    private int mLastScrollState = 0;
    private FastScroller mFastScroll;
    private int mFastScrollStyle;
    private boolean mGlobalLayoutListenerAddedFilter;
    private int mTouchSlop;
    private float mDensityScale;
    private InputConnection mDefInputConnection;
    private InputConnectionWrapper mPublicInputConnection;
    private Runnable mClearScrollingCache;
    Runnable mPositionScrollAfterLayout;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private float mVelocityScale = 1.0f;
    final boolean[] mIsScrap = new boolean[1];
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedYOffset = 0;
    private boolean mPopupHidden;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    int mOverscrollDistance;
    int mOverflingDistance;
    private EdgeEffect mEdgeGlowTop;
    private EdgeEffect mEdgeGlowBottom;
    private int mFirstPositionDistanceGuess;
    private int mLastPositionDistanceGuess;
    private int mDirection = 0;
    private boolean mForceTranscriptScroll;
    private int mGlowPaddingLeft;
    private int mGlowPaddingRight;
    private ListItemAccessibilityDelegate mAccessibilityDelegate;
    private int mLastAccessibilityScrollEventFromIndex;
    private int mLastAccessibilityScrollEventToIndex;
    private int mLastHandledItemCount;
    static final Interpolator sLinearInterpolator = new LinearInterpolator();
    private SavedState mPendingSync;
    private boolean mIsDetaching;

    public AbsListView(Context context) {
        super(context);
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        this.setVerticalScrollBarEnabled(true);
        TypedArray a = context.obtainStyledAttributes(R.styleable.View);
        this.initializeScrollbarsInternal(a);
        a.recycle();
    }

    public AbsListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842858);
    }

    public AbsListView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AbsListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsListView, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setSelector(d);
        }
        this.mDrawSelectorOnTop = a.getBoolean(1, false);
        boolean stackFromBottom = a.getBoolean(2, false);
        this.setStackFromBottom(stackFromBottom);
        boolean scrollingCacheEnabled = a.getBoolean(3, true);
        this.setScrollingCacheEnabled(scrollingCacheEnabled);
        boolean useTextFilter = a.getBoolean(4, false);
        this.setTextFilterEnabled(useTextFilter);
        int transcriptMode = a.getInt(5, 0);
        this.setTranscriptMode(transcriptMode);
        int color2 = a.getColor(6, 0);
        this.setCacheColorHint(color2);
        boolean enableFastScroll = a.getBoolean(8, false);
        this.setFastScrollEnabled(enableFastScroll);
        int fastScrollStyle = a.getResourceId(11, 0);
        this.setFastScrollStyle(fastScrollStyle);
        boolean smoothScrollbar = a.getBoolean(9, true);
        this.setSmoothScrollbarEnabled(smoothScrollbar);
        this.setChoiceMode(a.getInt(7, 0));
        this.setFastScrollAlwaysVisible(a.getBoolean(10, false));
        a.recycle();
    }

    private void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mDensityScale = this.getContext().getResources().getDisplayMetrics().density;
    }

    @Override
    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(mode);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (adapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public void setItemChecked(int position, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            if (this.mMultiChoiceModeCallback == null || !this.mMultiChoiceModeCallback.hasWrappedCallback()) {
                throw new IllegalStateException("AbsListView: attempted to start selection mode for CHOICE_MODE_MULTIPLE_MODAL but no choice mode callback was supplied. Call setMultiChoiceModeListener to set a callback.");
            }
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            if (oldValue != value) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds;
            boolean bl = updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    @Override
    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean checked = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, checked);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (checked) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = checked ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, checked);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean checked;
                boolean bl = checked = !this.mCheckStates.get(position, false);
                if (checked) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    private void updateOnScreenCheckedViews() {
        int firstPos = this.mFirstPosition;
        int count = this.getChildCount();
        boolean useActivated = this.getContext().getApplicationInfo().targetSdkVersion >= 11;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
                continue;
            }
            if (!useActivated) continue;
            child.setActivated(this.mCheckStates.get(position));
        }
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray(0);
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray(0);
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    private boolean contentFits() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (childCount != this.mItemCount) {
            return false;
        }
        return this.getChildAt(0).getTop() >= this.mListPadding.top && this.getChildAt(childCount - 1).getBottom() <= this.getHeight() - this.mListPadding.bottom;
    }

    public void setFastScrollEnabled(final boolean enabled) {
        if (this.mFastScrollEnabled != enabled) {
            this.mFastScrollEnabled = enabled;
            if (this.isOwnerThread()) {
                this.setFastScrollerEnabledUiThread(enabled);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        AbsListView.this.setFastScrollerEnabledUiThread(enabled);
                    }
                });
            }
        }
    }

    private void setFastScrollerEnabledUiThread(boolean enabled) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setEnabled(enabled);
        } else if (enabled) {
            this.mFastScroll = new FastScroller(this, this.mFastScrollStyle);
            this.mFastScroll.setEnabled(true);
        }
        this.resolvePadding();
        if (this.mFastScroll != null) {
            this.mFastScroll.updateLayout();
        }
    }

    public void setFastScrollStyle(int styleResId) {
        if (this.mFastScroll == null) {
            this.mFastScrollStyle = styleResId;
        } else {
            this.mFastScroll.setStyle(styleResId);
        }
    }

    public void setFastScrollAlwaysVisible(final boolean alwaysShow) {
        if (this.mFastScrollAlwaysVisible != alwaysShow) {
            if (alwaysShow && !this.mFastScrollEnabled) {
                this.setFastScrollEnabled(true);
            }
            this.mFastScrollAlwaysVisible = alwaysShow;
            if (this.isOwnerThread()) {
                this.setFastScrollerAlwaysVisibleUiThread(alwaysShow);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        AbsListView.this.setFastScrollerAlwaysVisibleUiThread(alwaysShow);
                    }
                });
            }
        }
    }

    private void setFastScrollerAlwaysVisibleUiThread(boolean alwaysShow) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setAlwaysShow(alwaysShow);
        }
    }

    private boolean isOwnerThread() {
        return this.mOwnerThread == Thread.currentThread();
    }

    public boolean isFastScrollAlwaysVisible() {
        if (this.mFastScroll == null) {
            return this.mFastScrollEnabled && this.mFastScrollAlwaysVisible;
        }
        return this.mFastScroll.isEnabled() && this.mFastScroll.isAlwaysShowEnabled();
    }

    @Override
    public int getVerticalScrollbarWidth() {
        if (this.mFastScroll != null && this.mFastScroll.isEnabled()) {
            return Math.max(super.getVerticalScrollbarWidth(), this.mFastScroll.getWidth());
        }
        return super.getVerticalScrollbarWidth();
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        if (this.mFastScroll == null) {
            return this.mFastScrollEnabled;
        }
        return this.mFastScroll.isEnabled();
    }

    @Override
    public void setVerticalScrollbarPosition(int position) {
        super.setVerticalScrollbarPosition(position);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(position);
        }
    }

    @Override
    public void setScrollBarStyle(int style2) {
        super.setScrollBarStyle(style2);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollBarStyle(style2);
        }
    }

    @Override
    protected boolean isVerticalScrollBarHidden() {
        return this.isFastScrollEnabled();
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    void invokeOnItemScrollListener() {
        if (this.mFastScroll != null) {
            this.mFastScroll.onScroll(this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (eventType == 4096) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int lastVisiblePosition = this.getLastVisiblePosition();
            if (this.mLastAccessibilityScrollEventFromIndex == firstVisiblePosition && this.mLastAccessibilityScrollEventToIndex == lastVisiblePosition) {
                return;
            }
            this.mLastAccessibilityScrollEventFromIndex = firstVisiblePosition;
            this.mLastAccessibilityScrollEventToIndex = lastVisiblePosition;
        }
        super.sendAccessibilityEvent(eventType);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(AbsListView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(AbsListView.class.getName());
        if (this.isEnabled()) {
            if (this.canScrollUp()) {
                info.addAction(8192);
                info.setScrollable(true);
            }
            if (this.canScrollDown()) {
                info.addAction(4096);
                info.setScrollable(true);
            }
        }
    }

    int getSelectionModeForAccessibility() {
        int choiceMode = this.getChoiceMode();
        switch (choiceMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        switch (action) {
            case 4096: {
                if (this.isEnabled() && this.getLastVisiblePosition() < this.getCount() - 1) {
                    int viewportHeight = this.getHeight() - this.mListPadding.top - this.mListPadding.bottom;
                    this.smoothScrollBy(viewportHeight, 200);
                    return true;
                }
                return false;
            }
            case 8192: {
                if (this.isEnabled() && this.mFirstPosition > 0) {
                    int viewportHeight = this.getHeight() - this.mListPadding.top - this.mListPadding.bottom;
                    this.smoothScrollBy(-viewportHeight, 200);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public View findViewByAccessibilityIdTraversal(int accessibilityId) {
        if (accessibilityId == this.getAccessibilityViewId()) {
            return this;
        }
        if (this.mDataChanged) {
            return null;
        }
        return super.findViewByAccessibilityIdTraversal(accessibilityId);
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    public void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled && !enabled) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = enabled;
    }

    public void setTextFilterEnabled(boolean textFilterEnabled) {
        this.mTextFilterEnabled = textFilterEnabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isTextFilterEnabled() {
        return this.mTextFilterEnabled;
    }

    @Override
    public void getFocusedRect(Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(this.getContext().getDrawable(17301602));
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    public void setStackFromBottom(boolean stackFromBottom) {
        if (this.mStackFromBottom != stackFromBottom) {
            this.mStackFromBottom = stackFromBottom;
            this.requestLayoutIfNecessary();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Editable filterText;
        EditText textFilter;
        long selectedId;
        this.dismissPopup();
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.mPendingSync != null) {
            ss.selectedId = this.mPendingSync.selectedId;
            ss.firstId = this.mPendingSync.firstId;
            ss.viewTop = this.mPendingSync.viewTop;
            ss.position = this.mPendingSync.position;
            ss.height = this.mPendingSync.height;
            ss.filter = this.mPendingSync.filter;
            ss.inActionMode = this.mPendingSync.inActionMode;
            ss.checkedItemCount = this.mPendingSync.checkedItemCount;
            ss.checkState = this.mPendingSync.checkState;
            ss.checkIdState = this.mPendingSync.checkIdState;
            return ss;
        }
        boolean haveChildren = this.getChildCount() > 0 && this.mItemCount > 0;
        ss.selectedId = selectedId = this.getSelectedItemId();
        ss.height = this.getHeight();
        if (selectedId >= 0L) {
            ss.viewTop = this.mSelectedTop;
            ss.position = this.getSelectedItemPosition();
            ss.firstId = -1L;
        } else if (haveChildren && this.mFirstPosition > 0) {
            View v = this.getChildAt(0);
            ss.viewTop = v.getTop();
            int firstPos = this.mFirstPosition;
            if (firstPos >= this.mItemCount) {
                firstPos = this.mItemCount - 1;
            }
            ss.position = firstPos;
            ss.firstId = this.mAdapter.getItemId(firstPos);
        } else {
            ss.viewTop = 0;
            ss.firstId = -1L;
            ss.position = 0;
        }
        ss.filter = null;
        if (this.mFiltered && (textFilter = this.mTextFilter) != null && (filterText = textFilter.getText()) != null) {
            ss.filter = filterText.toString();
        }
        boolean bl = ss.inActionMode = this.mChoiceMode == 3 && this.mChoiceActionMode != null;
        if (this.mCheckStates != null) {
            ss.checkState = this.mCheckStates.clone();
        }
        if (this.mCheckedIdStates != null) {
            LongSparseArray<Integer> idState = new LongSparseArray<Integer>();
            int count = this.mCheckedIdStates.size();
            for (int i = 0; i < count; ++i) {
                idState.put(this.mCheckedIdStates.keyAt(i), this.mCheckedIdStates.valueAt(i));
            }
            ss.checkIdState = idState;
        }
        ss.checkedItemCount = this.mCheckedItemCount;
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.saveRemoteViewsCache();
        }
        return ss;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDataChanged = true;
        this.mSyncHeight = ss.height;
        if (ss.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncRowId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 0;
        } else if (ss.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mPendingSync = ss;
            this.mSyncRowId = ss.firstId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 1;
        }
        this.setFilterText(ss.filter);
        if (ss.checkState != null) {
            this.mCheckStates = ss.checkState;
        }
        if (ss.checkIdState != null) {
            this.mCheckedIdStates = ss.checkIdState;
        }
        this.mCheckedItemCount = ss.checkedItemCount;
        if (ss.inActionMode && this.mChoiceMode == 3 && this.mMultiChoiceModeCallback != null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        this.requestLayout();
    }

    private boolean acceptFilter() {
        return this.mTextFilterEnabled && this.getAdapter() instanceof Filterable && ((Filterable)this.getAdapter()).getFilter() != null;
    }

    public void setFilterText(String filterText) {
        if (this.mTextFilterEnabled && !TextUtils.isEmpty(filterText)) {
            this.createTextFilter(false);
            this.mTextFilter.setText(filterText);
            this.mTextFilter.setSelection(filterText.length());
            if (this.mAdapter instanceof Filterable) {
                if (this.mPopup == null) {
                    Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                    f.filter(filterText);
                }
                this.mFiltered = true;
                this.mDataSetObserver.clearSavedState();
            }
        }
    }

    public CharSequence getTextFilter() {
        if (this.mTextFilterEnabled && this.mTextFilter != null) {
            return this.mTextFilter.getText();
        }
        return null;
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.isAttachedToWindow() && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mPositionScrollAfterLayout = null;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedTop = 0;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    extent += top * 100 / height;
                }
                view = this.getChildAt(count - 1);
                int bottom = view.getBottom();
                height = view.getHeight();
                if (height > 0) {
                    extent -= (bottom - this.getHeight()) * 100 / height;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected int computeVerticalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    return Math.max(firstPosition * 100 - top * 100 / height + (int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    @Override
    protected int computeVerticalScrollRange() {
        int result;
        if (this.mSmoothScrollbarEnabled) {
            result = Math.max(this.mItemCount * 100, 0);
            if (this.mScrollY != 0) {
                result += Math.abs((int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f));
            }
        } else {
            result = this.mItemCount;
        }
        return result;
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getTopFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int top = this.getChildAt(0).getTop();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return top < this.mPaddingTop ? (float)(-(top - this.mPaddingTop)) / fadeLength : fadeEdge;
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getBottomFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition + count - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int bottom = this.getChildAt(count - 1).getBottom();
        int height = this.getHeight();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return bottom > height - this.mPaddingBottom ? (float)(bottom - height + this.mPaddingBottom) / fadeLength : fadeEdge;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.mPaddingLeft;
        listPadding.top = this.mSelectionTopPadding + this.mPaddingTop;
        listPadding.right = this.mSelectionRightPadding + this.mPaddingRight;
        listPadding.bottom = this.mSelectionBottomPadding + this.mPaddingBottom;
        if (this.mTranscriptMode == 1) {
            int childCount = this.getChildCount();
            int listBottom = this.getHeight() - this.getPaddingBottom();
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
            this.mForceTranscriptScroll = this.mFirstPosition + childCount >= this.mLastHandledItemCount && lastBottom <= listBottom;
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        int childCount = this.getChildCount();
        if (changed) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
        this.mOverscrollMax = (b - t) / 3;
        if (this.mFastScroll != null) {
            this.mFastScroll.onItemCountChanged(this.getChildCount(), this.mItemCount);
        }
    }

    @Override
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (changed) {
            boolean visible;
            boolean bl = visible = this.getWindowVisibility() == 0;
            if (this.mFiltered && visible && this.mPopup != null && this.mPopup.isShowing()) {
                this.positionPopup();
            }
        }
        return changed;
    }

    protected void layoutChildren() {
    }

    View getAccessibilityFocusedChild(View focusedView) {
        ViewParent viewParent;
        for (viewParent = focusedView.getParent(); viewParent instanceof View && viewParent != this; viewParent = viewParent.getParent()) {
            focusedView = (View)((Object)viewParent);
        }
        if (!(viewParent instanceof View)) {
            return null;
        }
        return focusedView;
    }

    void updateScrollIndicators() {
        if (this.mScrollUp != null) {
            this.mScrollUp.setVisibility(this.canScrollUp() ? 0 : 4);
        }
        if (this.mScrollDown != null) {
            this.mScrollDown.setVisibility(this.canScrollDown() ? 0 : 4);
        }
    }

    private boolean canScrollUp() {
        boolean canScrollUp;
        boolean bl = canScrollUp = this.mFirstPosition > 0;
        if (!canScrollUp && this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            canScrollUp = child.getTop() < this.mListPadding.top;
        }
        return canScrollUp;
    }

    private boolean canScrollDown() {
        boolean canScrollDown;
        int count = this.getChildCount();
        boolean bl = canScrollDown = this.mFirstPosition + count < this.mItemCount;
        if (!canScrollDown && count > 0) {
            View child = this.getChildAt(count - 1);
            canScrollDown = child.getBottom() > this.mBottom - this.mListPadding.bottom;
        }
        return canScrollDown;
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    View obtainView(int position, boolean[] isScrap) {
        Trace.traceBegin(8L, "obtainView");
        isScrap[0] = false;
        View transientView = this.mRecycler.getTransientStateView(position);
        if (transientView != null) {
            View updatedView;
            LayoutParams params = (LayoutParams)transientView.getLayoutParams();
            if (params.viewType == this.mAdapter.getItemViewType(position) && (updatedView = this.mAdapter.getView(position, transientView, this)) != transientView) {
                this.setItemViewLayoutParams(updatedView, position);
                this.mRecycler.addScrapView(updatedView, position);
            }
            isScrap[0] = true;
            return transientView;
        }
        View scrapView = this.mRecycler.getScrapView(position);
        View child = this.mAdapter.getView(position, scrapView, this);
        if (scrapView != null) {
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView, position);
            } else {
                isScrap[0] = true;
                child.dispatchFinishTemporaryDetach();
            }
        }
        if (this.mCacheColorHint != 0) {
            child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
        }
        if (child.getImportantForAccessibility() == 0) {
            child.setImportantForAccessibility(1);
        }
        this.setItemViewLayoutParams(child, position);
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAccessibilityDelegate == null) {
                this.mAccessibilityDelegate = new ListItemAccessibilityDelegate();
            }
            if (child.getAccessibilityDelegate() == null) {
                child.setAccessibilityDelegate(this.mAccessibilityDelegate);
            }
        }
        Trace.traceEnd(8L);
        return child;
    }

    private void setItemViewLayoutParams(View child, int position) {
        ViewGroup.LayoutParams vlp = child.getLayoutParams();
        LayoutParams lp = vlp == null ? (LayoutParams)this.generateDefaultLayoutParams() : (!this.checkLayoutParams(vlp) ? (LayoutParams)this.generateLayoutParams(vlp) : (LayoutParams)vlp);
        if (this.mAdapterHasStableIds) {
            lp.itemId = this.mAdapter.getItemId(position);
        }
        lp.viewType = this.mAdapter.getItemViewType(position);
        child.setLayoutParams(lp);
    }

    public void onInitializeAccessibilityNodeInfoForItem(View view, int position, AccessibilityNodeInfo info) {
        ListAdapter adapter = (ListAdapter)this.getAdapter();
        if (position == -1 || adapter == null) {
            return;
        }
        if (!this.isEnabled() || !adapter.isEnabled(position)) {
            info.setEnabled(false);
            return;
        }
        if (position == this.getSelectedItemPosition()) {
            info.setSelected(true);
            info.addAction(8);
        } else {
            info.addAction(4);
        }
        if (this.isClickable()) {
            info.addAction(16);
            info.setClickable(true);
        }
        if (this.isLongClickable()) {
            info.addAction(32);
            info.setLongClickable(true);
        }
    }

    void positionSelectorLikeTouch(int position, View sel, float x, float y) {
        this.positionSelectorLikeFocus(position, sel);
        if (this.mSelector != null && position != -1) {
            this.mSelector.setHotspot(x, y);
        }
    }

    void positionSelectorLikeFocus(int position, View sel) {
        boolean manageState;
        Drawable selector = this.mSelector;
        boolean bl = manageState = selector != null && this.mSelectorPosition != position && position != -1;
        if (manageState) {
            selector.setVisible(false, false);
        }
        this.positionSelector(position, sel);
        if (manageState) {
            Rect bounds = this.mSelectorRect;
            float x = bounds.exactCenterX();
            float y = bounds.exactCenterY();
            selector.setVisible(this.getVisibility() == 0, false);
            selector.setHotspot(x, y);
        }
    }

    void positionSelector(int position, View sel) {
        if (position != -1) {
            this.mSelectorPosition = position;
        }
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        if (sel instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)((Object)sel)).adjustListItemSelectionBounds(selectorRect);
        }
        selectorRect.left -= this.mSelectionLeftPadding;
        selectorRect.top -= this.mSelectionTopPadding;
        selectorRect.right += this.mSelectionRightPadding;
        selectorRect.bottom += this.mSelectionBottomPadding;
        Drawable selector = this.mSelector;
        if (selector != null) {
            selector.setBounds(selectorRect);
        }
        boolean isChildViewEnabled = this.mIsChildViewEnabled;
        if (sel.isEnabled() != isChildViewEnabled) {
            boolean bl = this.mIsChildViewEnabled = !isChildViewEnabled;
            if (this.getSelectedItemPosition() != -1) {
                this.refreshDrawableState();
            }
        }
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop;
        boolean clipToPadding;
        int saveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            this.mGroupFlags &= 0xFFFFFFDD;
        }
        if (!(drawSelectorOnTop = this.mDrawSelectorOnTop)) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
            this.mGroupFlags |= 0x22;
        }
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return (this.mGroupFlags & 0x22) != 34;
    }

    @Override
    protected int getLeftPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingLeft;
    }

    @Override
    protected int getTopPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingTop;
    }

    @Override
    protected int getRightPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingRight;
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingBottom;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
        if (this.mFastScroll != null) {
            this.mFastScroll.onSizeChanged(w, h, oldw, oldh);
        }
    }

    boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    boolean shouldShowSelector() {
        return !this.isInTouchMode() || this.touchModeDrawsInPressedState() && this.isPressed();
    }

    private void drawSelector(Canvas canvas) {
        if (!this.mSelectorRect.isEmpty()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    public void setSelector(int resID) {
        this.setSelector(this.getContext().getDrawable(resID));
    }

    public void setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback(this);
        this.updateSelectorState();
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    void keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable selector = this.mSelector;
        Rect selectorRect = this.mSelectorRect;
        if (selector != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !selectorRect.isEmpty()) {
            View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (v != null) {
                if (v.hasFocusable()) {
                    return;
                }
                v.setPressed(true);
            }
            this.setPressed(true);
            boolean longClickable = this.isLongClickable();
            Drawable d = selector.getCurrent();
            if (d != null && d instanceof TransitionDrawable) {
                if (longClickable) {
                    ((TransitionDrawable)d).startTransition(ViewConfiguration.getLongPressTimeout());
                } else {
                    ((TransitionDrawable)d).resetTransition();
                }
            }
            if (longClickable && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress();
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    public void setScrollIndicators(View up, View down) {
        this.mScrollUp = up;
        this.mScrollDown = down;
    }

    void updateSelectorState() {
        if (this.mSelector != null) {
            if (this.shouldShowSelector()) {
                this.mSelector.setState(this.getDrawableState());
            } else {
                this.mSelector.setState(StateSet.NOTHING);
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(extraSpace);
        }
        int enabledState = ENABLED_STATE_SET[0];
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        int enabledPos = -1;
        for (int i = state.length - 1; i >= 0; --i) {
            if (state[i] != enabledState) continue;
            enabledPos = i;
            break;
        }
        if (enabledPos >= 0) {
            System.arraycopy((int[])state, (int)(enabledPos + 1), (int[])state, (int)enabledPos, (int)(state.length - enabledPos - 1));
        }
        return state;
    }

    @Override
    public boolean verifyDrawable(Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelector != null) {
            this.mSelector.jumpToCurrentState();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.addOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null && !this.mGlobalLayoutListenerAddedFilter) {
            treeObserver.addOnGlobalLayoutListener(this);
        }
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDetaching = true;
        this.dismissPopup();
        this.mRecycler.clear();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.removeOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null) {
            treeObserver.removeOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = false;
        }
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mClearScrollingCache != null) {
            this.removeCallbacks(this.mClearScrollingCache);
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset.run();
        }
        this.mIsDetaching = false;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
            this.dismissPopup();
            if (touchMode == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else {
            if (this.mFiltered && !this.mPopupHidden) {
                this.showPopup();
            }
            if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
                if (touchMode == 1) {
                    this.resurrectSelection();
                } else {
                    this.hideSelector();
                    this.mLayoutMode = 0;
                    this.layoutChildren();
                }
            }
        }
        this.mLastTouchMode = touchMode;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(this.getVerticalScrollbarPosition());
        }
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    @Override
    public void onCancelPendingInputEvents() {
        super.onCancelPendingInputEvents();
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
        if (this.mPendingCheckForKeyLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForKeyLongPress);
        }
    }

    boolean performLongPress(View child, int longPressPosition, long longPressId) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild(this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    @Override
    public boolean showContextMenu(float x, float y, int metaState) {
        int position = this.pointToPosition((int)x, (int)y);
        if (position != -1) {
            long id2 = this.mAdapter.getItemId(position);
            View child = this.getChildAt(position - this.mFirstPosition);
            if (child != null) {
                this.mContextMenuInfo = this.createContextMenuInfo(child, position, id2);
                return super.showContextMenuForChild(this);
            }
        }
        return super.showContextMenu(x, y, metaState);
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListener != null) {
                handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.mFirstPosition), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (KeyEvent.isConfirmKey(keyCode)) {
            if (!this.isEnabled()) {
                return true;
            }
            if (this.isClickable() && this.isPressed() && this.mSelectedPosition >= 0 && this.mAdapter != null && this.mSelectedPosition < this.mAdapter.getCount()) {
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public long pointToRowId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    private boolean startScrollIfNeeded(int x, int y, MotionEvent vtev) {
        boolean overscroll;
        int deltaY = y - this.mMotionY;
        int distance = Math.abs(deltaY);
        boolean bl = overscroll = this.mScrollY != 0;
        if ((overscroll || distance > this.mTouchSlop) && (this.getNestedScrollAxes() & 2) == 0) {
            this.createScrollingCache();
            if (overscroll) {
                this.mTouchMode = 5;
                this.mMotionCorrection = 0;
            } else {
                this.mTouchMode = 3;
                this.mMotionCorrection = deltaY > 0 ? this.mTouchSlop : -this.mTouchSlop;
            }
            this.removeCallbacks(this.mPendingCheckForLongPress);
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            this.scrollIfNeeded(x, y, vtev);
            return true;
        }
        return false;
    }

    private void scrollIfNeeded(int x, int y, MotionEvent vtev) {
        int rawDeltaY = y - this.mMotionY;
        int scrollOffsetCorrection = 0;
        int scrollConsumedCorrection = 0;
        if (this.mLastY == Integer.MIN_VALUE) {
            rawDeltaY -= this.mMotionCorrection;
        }
        if (this.dispatchNestedPreScroll(0, this.mLastY != Integer.MIN_VALUE ? this.mLastY - y : -rawDeltaY, this.mScrollConsumed, this.mScrollOffset)) {
            rawDeltaY += this.mScrollConsumed[1];
            scrollOffsetCorrection = -this.mScrollOffset[1];
            scrollConsumedCorrection = this.mScrollConsumed[1];
            if (vtev != null) {
                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                this.mNestedYOffset += this.mScrollOffset[1];
            }
        }
        int deltaY = rawDeltaY;
        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY + scrollConsumedCorrection : deltaY;
        int lastYCorrection = 0;
        if (this.mTouchMode == 3) {
            if (this.mScrollStrictSpan == null) {
                this.mScrollStrictSpan = StrictMode.enterCriticalSpan("AbsListView-scroll");
            }
            if (y != this.mLastY) {
                ViewParent parent;
                if ((this.mGroupFlags & 0x80000) == 0 && Math.abs(rawDeltaY) > this.mTouchSlop && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                int motionIndex = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                int motionViewPrevTop = 0;
                View motionView = this.getChildAt(motionIndex);
                if (motionView != null) {
                    motionViewPrevTop = motionView.getTop();
                }
                boolean atEdge = false;
                if (incrementalDeltaY != 0) {
                    atEdge = this.trackMotionScroll(deltaY, incrementalDeltaY);
                }
                if ((motionView = this.getChildAt(motionIndex)) != null) {
                    int motionViewRealTop = motionView.getTop();
                    if (atEdge) {
                        int overscroll = -incrementalDeltaY - (motionViewRealTop - motionViewPrevTop);
                        if (this.dispatchNestedScroll(0, overscroll - incrementalDeltaY, 0, overscroll, this.mScrollOffset)) {
                            lastYCorrection -= this.mScrollOffset[1];
                            if (vtev != null) {
                                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                                this.mNestedYOffset += this.mScrollOffset[1];
                            }
                        } else {
                            int overscrollMode;
                            boolean atOverscrollEdge = this.overScrollBy(0, overscroll, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                            if (atOverscrollEdge && this.mVelocityTracker != null) {
                                this.mVelocityTracker.clear();
                            }
                            if ((overscrollMode = this.getOverScrollMode()) == 0 || overscrollMode == 1 && !this.contentFits()) {
                                if (!atOverscrollEdge) {
                                    this.mDirection = 0;
                                    this.mTouchMode = 5;
                                }
                                if (incrementalDeltaY > 0) {
                                    this.mEdgeGlowTop.onPull((float)(-overscroll) / (float)this.getHeight(), (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowBottom.isFinished()) {
                                        this.mEdgeGlowBottom.onRelease();
                                    }
                                    this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                                } else if (incrementalDeltaY < 0) {
                                    this.mEdgeGlowBottom.onPull((float)overscroll / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowTop.isFinished()) {
                                        this.mEdgeGlowTop.onRelease();
                                    }
                                    this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                                }
                            }
                        }
                    }
                    this.mMotionY = y + lastYCorrection + scrollOffsetCorrection;
                }
                this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            }
        } else if (this.mTouchMode == 5 && y != this.mLastY) {
            int newDirection;
            int oldScroll = this.mScrollY;
            int newScroll = oldScroll - incrementalDeltaY;
            int n = newDirection = y > this.mLastY ? 1 : -1;
            if (this.mDirection == 0) {
                this.mDirection = newDirection;
            }
            int overScrollDistance = -incrementalDeltaY;
            if (newScroll < 0 && oldScroll >= 0 || newScroll > 0 && oldScroll <= 0) {
                overScrollDistance = -oldScroll;
                incrementalDeltaY += overScrollDistance;
            } else {
                incrementalDeltaY = 0;
            }
            if (overScrollDistance != 0) {
                this.overScrollBy(0, overScrollDistance, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                int overscrollMode = this.getOverScrollMode();
                if (overscrollMode == 0 || overscrollMode == 1 && !this.contentFits()) {
                    if (rawDeltaY > 0) {
                        this.mEdgeGlowTop.onPull((float)overScrollDistance / (float)this.getHeight(), (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                        this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                    } else if (rawDeltaY < 0) {
                        this.mEdgeGlowBottom.onPull((float)overScrollDistance / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                        this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                    }
                }
            }
            if (incrementalDeltaY != 0) {
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentIfNeeded();
                }
                this.trackMotionScroll(incrementalDeltaY, incrementalDeltaY);
                this.mTouchMode = 3;
                int motionPosition = this.findClosestMotionRow(y);
                this.mMotionCorrection = 0;
                View motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = motionView != null ? motionView.getTop() : 0;
                this.mMotionY = y + scrollOffsetCorrection;
                this.mMotionPosition = motionPosition;
            }
            this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            this.mDirection = newDirection;
        }
    }

    @Override
    public void onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode) {
            this.hideSelector();
            if (this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
        } else {
            int touchMode = this.mTouchMode;
            if (touchMode == 5 || touchMode == 6) {
                if (this.mFlingRunnable != null) {
                    this.mFlingRunnable.endFling();
                }
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        boolean intercepted;
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        this.startNestedScroll(2);
        if (this.mFastScroll != null && (intercepted = this.mFastScroll.onTouchEvent(ev))) {
            return true;
        }
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain(ev);
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                this.onTouchDown(ev);
                break;
            }
            case 2: {
                this.onTouchMove(ev, vtev);
                break;
            }
            case 1: {
                this.onTouchUp(ev);
                break;
            }
            case 3: {
                this.onTouchCancel();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int x = this.mMotionX;
                int y = this.mMotionY;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View child = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = child.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                int id2 = ev.getPointerId(index);
                int x = (int)ev.getX(index);
                int y = (int)ev.getY(index);
                this.mMotionCorrection = 0;
                this.mActivePointerId = id2;
                this.mMotionX = x;
                this.mMotionY = y;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View child = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = child.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
                break;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void onTouchDown(MotionEvent ev) {
        this.mActivePointerId = ev.getPointerId(0);
        if (this.mTouchMode == 6) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.mTouchMode = 5;
            this.mMotionX = (int)ev.getX();
            this.mLastY = this.mMotionY = (int)ev.getY();
            this.mMotionCorrection = 0;
            this.mDirection = 0;
        } else {
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            int motionPosition = this.pointToPosition(x, y);
            if (!this.mDataChanged) {
                if (this.mTouchMode == 4) {
                    this.createScrollingCache();
                    this.mTouchMode = 3;
                    this.mMotionCorrection = 0;
                    motionPosition = this.findMotionRow(y);
                    this.mFlingRunnable.flywheelTouch();
                } else if (motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                    this.mTouchMode = 0;
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap();
                    }
                    this.mPendingCheckForTap.x = ev.getX();
                    this.mPendingCheckForTap.y = ev.getY();
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                }
            }
            if (motionPosition >= 0) {
                View v = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = v.getTop();
            }
            this.mMotionX = x;
            this.mMotionY = y;
            this.mMotionPosition = motionPosition;
            this.mLastY = Integer.MIN_VALUE;
        }
        if (this.mTouchMode == 0 && this.mMotionPosition != -1 && this.performButtonActionOnTouchDown(ev)) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    private void onTouchMove(MotionEvent ev, MotionEvent vtev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            pointerIndex = 0;
            this.mActivePointerId = ev.getPointerId(pointerIndex);
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        int y = (int)ev.getY(pointerIndex);
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                float x;
                if (this.startScrollIfNeeded((int)ev.getX(pointerIndex), y, vtev) || this.pointInView(x = ev.getX(pointerIndex), y, this.mTouchSlop)) break;
                this.setPressed(false);
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (motionView != null) {
                    motionView.setPressed(false);
                }
                this.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                this.mTouchMode = 2;
                this.updateSelectorState();
                break;
            }
            case 3: 
            case 5: {
                this.scrollIfNeeded((int)ev.getX(pointerIndex), y, vtev);
            }
        }
    }

    private void onTouchUp(MotionEvent ev) {
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                int motionPosition = this.mMotionPosition;
                final View child = this.getChildAt(motionPosition - this.mFirstPosition);
                if (child != null) {
                    float x;
                    boolean inList;
                    if (this.mTouchMode != 0) {
                        child.setPressed(false);
                    }
                    boolean bl = inList = (x = ev.getX()) > (float)this.mListPadding.left && x < (float)(this.getWidth() - this.mListPadding.right);
                    if (inList && !child.hasFocusable()) {
                        if (this.mPerformClick == null) {
                            this.mPerformClick = new PerformClick();
                        }
                        final PerformClick performClick = this.mPerformClick;
                        performClick.mClickMotionPosition = motionPosition;
                        performClick.rememberWindowAttachCount();
                        this.mResurrectToPosition = motionPosition;
                        if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                            this.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                            this.mLayoutMode = 0;
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                this.mTouchMode = 1;
                                this.setSelectedPositionInt(this.mMotionPosition);
                                this.layoutChildren();
                                child.setPressed(true);
                                this.positionSelector(this.mMotionPosition, child);
                                this.setPressed(true);
                                if (this.mSelector != null) {
                                    Drawable d = this.mSelector.getCurrent();
                                    if (d != null && d instanceof TransitionDrawable) {
                                        ((TransitionDrawable)d).resetTransition();
                                    }
                                    this.mSelector.setHotspot(x, ev.getY());
                                }
                                if (this.mTouchModeReset != null) {
                                    this.removeCallbacks(this.mTouchModeReset);
                                }
                                this.mTouchModeReset = new Runnable(){

                                    @Override
                                    public void run() {
                                        AbsListView.this.mTouchModeReset = null;
                                        AbsListView.this.mTouchMode = -1;
                                        child.setPressed(false);
                                        AbsListView.this.setPressed(false);
                                        if (!AbsListView.this.mDataChanged && !AbsListView.this.mIsDetaching && AbsListView.this.isAttachedToWindow()) {
                                            performClick.run();
                                        }
                                    }
                                };
                                this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                            } else {
                                this.mTouchMode = -1;
                                this.updateSelectorState();
                            }
                            return;
                        }
                        if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                            performClick.run();
                        }
                    }
                }
                this.mTouchMode = -1;
                this.updateSelectorState();
                break;
            }
            case 3: {
                int childCount = this.getChildCount();
                if (childCount > 0) {
                    boolean flingVelocity;
                    int firstChildTop = this.getChildAt(0).getTop();
                    int lastChildBottom = this.getChildAt(childCount - 1).getBottom();
                    int contentTop = this.mListPadding.top;
                    int contentBottom = this.getHeight() - this.mListPadding.bottom;
                    if (this.mFirstPosition == 0 && firstChildTop >= contentTop && this.mFirstPosition + childCount < this.mItemCount && lastChildBottom <= this.getHeight() - contentBottom) {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int initialVelocity = (int)(velocityTracker.getYVelocity(this.mActivePointerId) * this.mVelocityScale);
                    boolean bl = flingVelocity = Math.abs(initialVelocity) > this.mMinimumVelocity;
                    if (!(!flingVelocity || this.mFirstPosition == 0 && firstChildTop == contentTop - this.mOverscrollDistance || this.mFirstPosition + childCount == this.mItemCount && lastChildBottom == contentBottom + this.mOverscrollDistance)) {
                        if (!this.dispatchNestedPreFling(0.0f, -initialVelocity)) {
                            if (this.mFlingRunnable == null) {
                                this.mFlingRunnable = new FlingRunnable();
                            }
                            this.reportScrollStateChange(2);
                            this.mFlingRunnable.start(-initialVelocity);
                            this.dispatchNestedFling(0.0f, -initialVelocity, true);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    this.mTouchMode = -1;
                    this.reportScrollStateChange(0);
                    if (this.mFlingRunnable != null) {
                        this.mFlingRunnable.endFling();
                    }
                    if (this.mPositionScroller != null) {
                        this.mPositionScroller.stop();
                    }
                    if (!flingVelocity || this.dispatchNestedPreFling(0.0f, -initialVelocity)) break;
                    this.dispatchNestedFling(0.0f, -initialVelocity, false);
                    break;
                }
                this.mTouchMode = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable();
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                this.reportScrollStateChange(2);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.mFlingRunnable.startOverfling(-initialVelocity);
                    break;
                }
                this.mFlingRunnable.startSpringback();
            }
        }
        this.setPressed(false);
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.invalidate();
        this.removeCallbacks(this.mPendingCheckForLongPress);
        this.recycleVelocityTracker();
        this.mActivePointerId = -1;
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    private void onTouchCancel() {
        switch (this.mTouchMode) {
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable();
                }
                this.mFlingRunnable.startSpringback();
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (motionView != null) {
                    motionView.setPressed(false);
                }
                this.clearScrollingCache();
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.recycleVelocityTracker();
            }
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.mActivePointerId = -1;
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.mScrollY != scrollY) {
            this.onScrollChanged(this.mScrollX, scrollY, this.mScrollX, this.mScrollY);
            this.mScrollY = scrollY;
            this.invalidateParentIfNeeded();
            this.awakenScrollBars();
        }
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    int delta;
                    float vscroll;
                    if (this.mTouchMode != -1 || (vscroll = event.getAxisValue(9)) == 0.0f || this.trackMotionScroll(delta = (int)(vscroll * this.getVerticalScrollFactor()), delta)) break;
                    return true;
                }
            }
        }
        return super.onGenericMotionEvent(event);
    }

    public void fling(int velocityY) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.reportScrollStateChange(2);
        this.mFlingRunnable.start(velocityY);
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(2);
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int oldTop;
        int motionIndex = this.getChildCount() / 2;
        View motionView = this.getChildAt(motionIndex);
        int n = oldTop = motionView != null ? motionView.getTop() : 0;
        if (motionView == null || this.trackMotionScroll(-dyUnconsumed, -dyUnconsumed)) {
            int myUnconsumed = dyUnconsumed;
            int myConsumed = 0;
            if (motionView != null) {
                myConsumed = motionView.getTop() - oldTop;
                myUnconsumed -= myConsumed;
            }
            this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null);
        }
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        int childCount = this.getChildCount();
        if (!consumed && childCount > 0 && this.canScrollList((int)velocityY) && Math.abs(velocityY) > (float)this.mMinimumVelocity) {
            this.reportScrollStateChange(2);
            if (this.mFlingRunnable == null) {
                this.mFlingRunnable = new FlingRunnable();
            }
            if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
                this.mFlingRunnable.start((int)velocityY);
            }
            return true;
        }
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int width;
            int restoreCount;
            int scrollY = this.mScrollY;
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                int edgeY = Math.min(0, scrollY + this.mFirstPositionDistanceGuess);
                canvas.translate(0.0f, edgeY);
                this.mEdgeGlowTop.setSize(width, this.getHeight());
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                int height = this.getHeight();
                int edgeX = -width;
                int edgeY = Math.max(height, scrollY + this.mLastPositionDistanceGuess);
                canvas.translate(edgeX, edgeY);
                canvas.rotate(180.0f, width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    public void setOverScrollEffectPadding(int leftPadding, int rightPadding) {
        this.mGlowPaddingLeft = leftPadding;
        this.mGlowPaddingRight = rightPadding;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    @Override
    public boolean onInterceptHoverEvent(MotionEvent event) {
        if (this.mFastScroll != null && this.mFastScroll.onInterceptHoverEvent(event)) {
            return true;
        }
        return super.onInterceptHoverEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int actionMasked = ev.getActionMasked();
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        if (this.mFastScroll != null && this.mFastScroll.onInterceptTouchEvent(ev)) {
            return true;
        }
        switch (actionMasked) {
            case 0: {
                int touchMode = this.mTouchMode;
                if (touchMode == 6 || touchMode == 5) {
                    this.mMotionCorrection = 0;
                    return true;
                }
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                int motionPosition = this.findMotionRow(y);
                if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                this.startNestedScroll(2);
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        if (pointerIndex == -1) {
                            pointerIndex = 0;
                            this.mActivePointerId = ev.getPointerId(pointerIndex);
                        }
                        int y = (int)ev.getY(pointerIndex);
                        this.initVelocityTrackerIfNotExists();
                        this.mVelocityTracker.addMovement(ev);
                        if (!this.startScrollIfNeeded((int)ev.getX(pointerIndex), y, null)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return false;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mMotionX = (int)ev.getX(newPointerIndex);
            this.mMotionY = (int)ev.getY(newPointerIndex);
            this.mMotionCorrection = 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
        }
    }

    void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    public void setFriction(float friction) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.mFlingRunnable.mScroller.setFriction(friction);
    }

    public void setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    AbsPositionScroller createPositionScroller() {
        return new PositionScroller();
    }

    public void smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    public void smoothScrollToPositionFromTop(int position, int offset, int duration) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, duration);
    }

    public void smoothScrollToPositionFromTop(int position, int offset) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, offset);
    }

    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    public void smoothScrollBy(int distance, int duration) {
        this.smoothScrollBy(distance, duration, false);
    }

    void smoothScrollBy(int distance, int duration, boolean linear) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        int firstPos = this.mFirstPosition;
        int childCount = this.getChildCount();
        int lastPos = firstPos + childCount;
        int topLimit = this.getPaddingTop();
        int bottomLimit = this.getHeight() - this.getPaddingBottom();
        if (distance == 0 || this.mItemCount == 0 || childCount == 0 || firstPos == 0 && this.getChildAt(0).getTop() == topLimit && distance < 0 || lastPos == this.mItemCount && this.getChildAt(childCount - 1).getBottom() == bottomLimit && distance > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
        } else {
            this.reportScrollStateChange(2);
            this.mFlingRunnable.startScroll(distance, duration, linear);
        }
    }

    void smoothScrollByOffset(int position) {
        View child;
        int index = -1;
        if (position < 0) {
            index = this.getFirstVisiblePosition();
        } else if (position > 0) {
            index = this.getLastVisiblePosition();
        }
        if (index > -1 && (child = this.getChildAt(index - this.getFirstVisiblePosition())) != null) {
            Rect visibleRect = new Rect();
            if (child.getGlobalVisibleRect(visibleRect)) {
                int childRectArea = child.getWidth() * child.getHeight();
                int visibleRectArea = visibleRect.width() * visibleRect.height();
                float visibleArea = (float)visibleRectArea / (float)childRectArea;
                float visibleThreshold = 0.75f;
                if (position < 0 && visibleArea < 0.75f) {
                    ++index;
                } else if (position > 0 && visibleArea < 0.75f) {
                    --index;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), index + position)));
        }
    }

    private void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted && !this.isHardwareAccelerated()) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingActive = true;
            this.mCachingStarted = true;
        }
    }

    private void clearScrollingCache() {
        if (!this.isHardwareAccelerated()) {
            if (this.mClearScrollingCache == null) {
                this.mClearScrollingCache = new Runnable(){

                    @Override
                    public void run() {
                        if (AbsListView.this.mCachingStarted) {
                            AbsListView.this.mCachingActive = false;
                            AbsListView.this.mCachingStarted = false;
                            AbsListView.this.setChildrenDrawnWithCacheEnabled(false);
                            if ((AbsListView.this.mPersistentDrawingCache & 2) == 0) {
                                AbsListView.this.setChildrenDrawingCacheEnabled(false);
                            }
                            if (!AbsListView.this.isAlwaysDrawnWithCacheEnabled()) {
                                AbsListView.this.invalidate();
                            }
                        }
                    }
                };
            }
            this.post(this.mClearScrollingCache);
        }
    }

    public void scrollListBy(int y) {
        this.trackMotionScroll(-y, -y);
    }

    public boolean canScrollList(int direction) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return false;
        }
        int firstPosition = this.mFirstPosition;
        Rect listPadding = this.mListPadding;
        if (direction > 0) {
            int lastBottom = this.getChildAt(childCount - 1).getBottom();
            int lastPosition = firstPosition + childCount;
            return lastPosition < this.mItemCount || lastBottom > this.getHeight() - listPadding.bottom;
        }
        int firstTop = this.getChildAt(0).getTop();
        return firstPosition > 0 || firstTop < listPadding.top;
    }

    boolean trackMotionScroll(int deltaY, int incrementalDeltaY) {
        int childIndex;
        int absIncrementalDeltaY;
        int i;
        boolean cannotScrollUp;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstTop = this.getChildAt(0).getTop();
        int lastBottom = this.getChildAt(childCount - 1).getBottom();
        Rect listPadding = this.mListPadding;
        int effectivePaddingTop = 0;
        int effectivePaddingBottom = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            effectivePaddingTop = listPadding.top;
            effectivePaddingBottom = listPadding.bottom;
        }
        int spaceAbove = effectivePaddingTop - firstTop;
        int end = this.getHeight() - effectivePaddingBottom;
        int spaceBelow = lastBottom - end;
        int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        deltaY = deltaY < 0 ? Math.max(-(height - 1), deltaY) : Math.min(height - 1, deltaY);
        incrementalDeltaY = incrementalDeltaY < 0 ? Math.max(-(height - 1), incrementalDeltaY) : Math.min(height - 1, incrementalDeltaY);
        int firstPosition = this.mFirstPosition;
        this.mFirstPositionDistanceGuess = firstPosition == 0 ? firstTop - listPadding.top : (this.mFirstPositionDistanceGuess += incrementalDeltaY);
        this.mLastPositionDistanceGuess = firstPosition + childCount == this.mItemCount ? lastBottom + listPadding.bottom : (this.mLastPositionDistanceGuess += incrementalDeltaY);
        boolean cannotScrollDown = firstPosition == 0 && firstTop >= listPadding.top && incrementalDeltaY >= 0;
        boolean bl = cannotScrollUp = firstPosition + childCount == this.mItemCount && lastBottom <= this.getHeight() - listPadding.bottom && incrementalDeltaY <= 0;
        if (cannotScrollDown || cannotScrollUp) {
            return incrementalDeltaY != 0;
        }
        boolean down = incrementalDeltaY < 0;
        boolean inTouchMode = this.isInTouchMode();
        if (inTouchMode) {
            this.hideSelector();
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            View child;
            int top = -incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                top += listPadding.top;
            }
            for (i = 0; i < childCount && (child = this.getChildAt(i)).getBottom() < top; ++i) {
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                if (child.isAccessibilityFocused()) {
                    child.clearAccessibilityFocus();
                }
                this.mRecycler.addScrapView(child, position);
            }
        } else {
            View child;
            int bottom = this.getHeight() - incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                bottom -= listPadding.bottom;
            }
            for (i = childCount - 1; i >= 0 && (child = this.getChildAt(i)).getTop() > bottom; --i) {
                start = i;
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                if (child.isAccessibilityFocused()) {
                    child.clearAccessibilityFocus();
                }
                this.mRecycler.addScrapView(child, position);
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + deltaY;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
            this.mRecycler.removeSkippedScrap();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.offsetChildrenTopAndBottom(incrementalDeltaY);
        if (down) {
            this.mFirstPosition += count;
        }
        if (spaceAbove < (absIncrementalDeltaY = Math.abs(incrementalDeltaY)) || spaceBelow < absIncrementalDeltaY) {
            this.fillGap(down);
        }
        if (!inTouchMode && this.mSelectedPosition != -1) {
            childIndex = this.mSelectedPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(childIndex));
            }
        } else if (this.mSelectorPosition != -1) {
            childIndex = this.mSelectorPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(-1, this.getChildAt(childIndex));
            }
        } else {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        return false;
    }

    int getHeaderViewsCount() {
        return 0;
    }

    int getFooterViewsCount() {
        return 0;
    }

    abstract void fillGap(boolean var1);

    void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedTop = 0;
        }
    }

    int reconcileSelectedPosition() {
        int position = this.mSelectedPosition;
        if (position < 0) {
            position = this.mResurrectToPosition;
        }
        position = Math.max(0, position);
        position = Math.min(position, this.mItemCount - 1);
        return position;
    }

    abstract int findMotionRow(int var1);

    int findClosestMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionRow = this.findMotionRow(y);
        return motionRow != -1 ? motionRow : this.mFirstPosition + childCount - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    abstract void setSelectionInt(int var1);

    boolean resurrectSelection() {
        int selectedPos;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int selectedTop = 0;
        int childrenTop = this.mListPadding.top;
        int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
        int firstPosition = this.mFirstPosition;
        int toPosition = this.mResurrectToPosition;
        boolean down = true;
        if (toPosition >= firstPosition && toPosition < firstPosition + childCount) {
            selectedPos = toPosition;
            View selected = this.getChildAt(selectedPos - this.mFirstPosition);
            selectedTop = selected.getTop();
            int selectedBottom = selected.getBottom();
            if (selectedTop < childrenTop) {
                selectedTop = childrenTop + this.getVerticalFadingEdgeLength();
            } else if (selectedBottom > childrenBottom) {
                selectedTop = childrenBottom - selected.getMeasuredHeight() - this.getVerticalFadingEdgeLength();
            }
        } else if (toPosition < firstPosition) {
            selectedPos = firstPosition;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                if (i == 0) {
                    selectedTop = top;
                    if (firstPosition > 0 || top < childrenTop) {
                        childrenTop += this.getVerticalFadingEdgeLength();
                    }
                }
                if (top < childrenTop) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        } else {
            int itemCount = this.mItemCount;
            down = false;
            selectedPos = firstPosition + childCount - 1;
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                int bottom = v.getBottom();
                if (i == childCount - 1) {
                    selectedTop = top;
                    if (firstPosition + childCount < itemCount || bottom > childrenBottom) {
                        childrenBottom -= this.getVerticalFadingEdgeLength();
                    }
                }
                if (bottom > childrenBottom) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.removeCallbacks(this.mFlingRunnable);
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.mTouchMode = -1;
        this.clearScrollingCache();
        this.mSpecificTop = selectedTop;
        selectedPos = this.lookForSelectablePosition(selectedPos, down);
        if (selectedPos >= firstPosition && selectedPos <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.updateSelectorState();
            this.setSelectionInt(selectedPos);
            this.invokeOnItemScrollListener();
        } else {
            selectedPos = -1;
        }
        this.reportScrollStateChange(0);
        return selectedPos >= 0;
    }

    void confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        boolean checkedCountChanged = false;
        for (int checkedIndex = 0; checkedIndex < this.mCheckedIdStates.size(); ++checkedIndex) {
            int lastPos;
            long lastPosId;
            long id2 = this.mCheckedIdStates.keyAt(checkedIndex);
            if (id2 != (lastPosId = this.mAdapter.getItemId(lastPos = this.mCheckedIdStates.valueAt(checkedIndex).intValue()))) {
                int start = Math.max(0, lastPos - 20);
                int end = Math.min(lastPos + 20, this.mItemCount);
                boolean found = false;
                for (int searchPos = start; searchPos < end; ++searchPos) {
                    long searchId = this.mAdapter.getItemId(searchPos);
                    if (id2 != searchId) continue;
                    found = true;
                    this.mCheckStates.put(searchPos, true);
                    this.mCheckedIdStates.setValueAt(checkedIndex, searchPos);
                    break;
                }
                if (found) continue;
                this.mCheckedIdStates.delete(id2);
                --checkedIndex;
                --this.mCheckedItemCount;
                checkedCountChanged = true;
                if (this.mChoiceActionMode == null || this.mMultiChoiceModeCallback == null) continue;
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, lastPos, id2, false);
                continue;
            }
            this.mCheckStates.put(lastPos, true);
        }
        if (checkedCountChanged && this.mChoiceActionMode != null) {
            this.mChoiceActionMode.invalidate();
        }
    }

    @Override
    protected void handleDataChanged() {
        int count = this.mItemCount;
        int lastHandledItemCount = this.mLastHandledItemCount;
        this.mLastHandledItemCount = this.mItemCount;
        if (this.mChoiceMode != 0 && this.mAdapter != null && this.mAdapter.hasStableIds()) {
            this.confirmCheckedPositionsById();
        }
        this.mRecycler.clearTransientStateViews();
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                this.mPendingSync = null;
                if (this.mTranscriptMode == 2) {
                    this.mLayoutMode = 3;
                    return;
                }
                if (this.mTranscriptMode == 1) {
                    int lastBottom;
                    if (this.mForceTranscriptScroll) {
                        this.mForceTranscriptScroll = false;
                        this.mLayoutMode = 3;
                        return;
                    }
                    int childCount = this.getChildCount();
                    int listBottom = this.getHeight() - this.getPaddingBottom();
                    View lastChild = this.getChildAt(childCount - 1);
                    int n = lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
                    if (this.mFirstPosition + childCount >= lastHandledItemCount && lastBottom <= listBottom) {
                        this.mLayoutMode = 3;
                        return;
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                            return;
                        }
                        newPos = this.findSyncPosition();
                        if (newPos < 0 || (selectablePos = this.lookForSelectablePosition(newPos, true)) != newPos) break;
                        this.mSyncPosition = newPos;
                        this.mLayoutMode = this.mSyncHeight == (long)this.getHeight() ? 5 : 2;
                        this.setNextSelectedPositionInt(newPos);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    @Override
    protected void onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                if (this.mPopup == null || !this.mPopup.isShowing()) break;
                this.dismissPopup();
                break;
            }
            case 0: {
                if (!this.mFiltered || this.mPopup == null || this.mPopup.isShowing()) break;
                this.showPopup();
            }
        }
        this.mPopupHidden = hint == 4;
    }

    private void dismissPopup() {
        if (this.mPopup != null) {
            this.mPopup.dismiss();
        }
    }

    private void showPopup() {
        if (this.getWindowVisibility() == 0) {
            this.createTextFilter(true);
            this.positionPopup();
            this.checkFocus();
        }
    }

    private void positionPopup() {
        int screenHeight = this.getResources().getDisplayMetrics().heightPixels;
        int[] xy = new int[2];
        this.getLocationOnScreen(xy);
        int bottomGap = screenHeight - xy[1] - this.getHeight() + (int)(this.mDensityScale * 20.0f);
        if (!this.mPopup.isShowing()) {
            this.mPopup.showAtLocation(this, 81, xy[0], bottomGap);
        } else {
            this.mPopup.update(xy[0], bottomGap, -1, -1);
        }
    }

    static int getDistance(Rect source, Rect dest, int direction) {
        int dY;
        int dX;
        int sY;
        int sX;
        switch (direction) {
            case 66: {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 130: {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                dY = dest.top;
                break;
            }
            case 17: {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 33: {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                dY = dest.bottom;
                break;
            }
            case 1: 
            case 2: {
                sX = source.right + source.width() / 2;
                sY = source.top + source.height() / 2;
                dX = dest.left + dest.width() / 2;
                dY = dest.top + dest.height() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
        }
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    @Override
    protected boolean isInFilterMode() {
        return this.mFiltered;
    }

    boolean sendToTextFilter(int keyCode, int count, KeyEvent event) {
        if (!this.acceptFilter()) {
            return false;
        }
        boolean handled = false;
        boolean okToSend = true;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: {
                okToSend = false;
                break;
            }
            case 4: {
                if (this.mFiltered && this.mPopup != null && this.mPopup.isShowing()) {
                    if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                        KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                        if (state != null) {
                            state.startTracking(event, this);
                        }
                        handled = true;
                    } else if (event.getAction() == 1 && event.isTracking() && !event.isCanceled()) {
                        handled = true;
                        this.mTextFilter.setText("");
                    }
                }
                okToSend = false;
                break;
            }
            case 62: {
                okToSend = this.mFiltered;
            }
        }
        if (okToSend) {
            this.createTextFilter(true);
            KeyEvent forwardEvent = event;
            if (forwardEvent.getRepeatCount() > 0) {
                forwardEvent = KeyEvent.changeTimeRepeat(event, event.getEventTime(), 0);
            }
            int action = event.getAction();
            switch (action) {
                case 0: {
                    handled = this.mTextFilter.onKeyDown(keyCode, forwardEvent);
                    break;
                }
                case 1: {
                    handled = this.mTextFilter.onKeyUp(keyCode, forwardEvent);
                    break;
                }
                case 2: {
                    handled = this.mTextFilter.onKeyMultiple(keyCode, count, event);
                }
            }
        }
        return handled;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.isTextFilterEnabled()) {
            if (this.mPublicInputConnection == null) {
                this.mDefInputConnection = new BaseInputConnection(this, false);
                this.mPublicInputConnection = new InputConnectionWrapper(outAttrs);
            }
            outAttrs.inputType = 177;
            outAttrs.imeOptions = 6;
            return this.mPublicInputConnection;
        }
        return null;
    }

    @Override
    public boolean checkInputConnectionProxy(View view) {
        return view == this.mTextFilter;
    }

    private void createTextFilter(boolean animateEntrance) {
        if (this.mPopup == null) {
            PopupWindow p = new PopupWindow(this.getContext());
            p.setFocusable(false);
            p.setTouchable(false);
            p.setInputMethodMode(2);
            p.setContentView(this.getTextFilterInput());
            p.setWidth(-2);
            p.setHeight(-2);
            p.setBackgroundDrawable(null);
            this.mPopup = p;
            this.getViewTreeObserver().addOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = true;
        }
        if (animateEntrance) {
            this.mPopup.setAnimationStyle(16974553);
        } else {
            this.mPopup.setAnimationStyle(16974554);
        }
    }

    private EditText getTextFilterInput() {
        if (this.mTextFilter == null) {
            LayoutInflater layoutInflater = LayoutInflater.from(this.getContext());
            this.mTextFilter = (EditText)layoutInflater.inflate(17367269, null);
            this.mTextFilter.setRawInputType(177);
            this.mTextFilter.setImeOptions(0x10000000);
            this.mTextFilter.addTextChangedListener(this);
        }
        return this.mTextFilter;
    }

    public void clearTextFilter() {
        if (this.mFiltered) {
            this.getTextFilterInput().setText("");
            this.mFiltered = false;
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.dismissPopup();
            }
        }
    }

    public boolean hasTextFilter() {
        return this.mFiltered;
    }

    @Override
    public void onGlobalLayout() {
        if (this.isShown()) {
            if (this.mFiltered && this.mPopup != null && !this.mPopup.isShowing() && !this.mPopupHidden) {
                this.showPopup();
            }
        } else if (this.mPopup != null && this.mPopup.isShowing()) {
            this.dismissPopup();
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isTextFilterEnabled()) {
            this.createTextFilter(true);
            int length = s.length();
            boolean showing = this.mPopup.isShowing();
            if (!showing && length > 0) {
                this.showPopup();
                this.mFiltered = true;
            } else if (showing && length == 0) {
                this.dismissPopup();
                this.mFiltered = false;
            }
            if (this.mAdapter instanceof Filterable) {
                Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                if (f != null) {
                    f.filter(s, this);
                } else {
                    throw new IllegalStateException("You cannot call onTextChanged with a non filterable adapter");
                }
            }
        }
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    @Override
    public void onFilterComplete(int count) {
        if (this.mSelectedPosition < 0 && count > 0) {
            this.mResurrectToPosition = -1;
            this.resurrectSelection();
        }
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2, 0);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    @Override
    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public void setCacheColorHint(int color2) {
        if (color2 != this.mCacheColorHint) {
            this.mCacheColorHint = color2;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color2);
            }
            this.mRecycler.setCacheColorHint(color2);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    public void reclaimViews(List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp == null || !this.mRecycler.shouldRecycleViewType(lp.viewType)) continue;
            views.add(child);
            child.setAccessibilityDelegate(null);
            if (listener == null) continue;
            listener.onMovedToScrapHeap(child);
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    private void finishGlows() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    public void setRemoteViewsAdapter(Intent intent) {
        Intent.FilterComparison fcOld;
        Intent.FilterComparison fcNew;
        if (this.mRemoteAdapter != null && (fcNew = new Intent.FilterComparison(intent)).equals(fcOld = new Intent.FilterComparison(this.mRemoteAdapter.getRemoteViewsServiceIntent()))) {
            return;
        }
        this.mDeferNotifyDataSetChanged = false;
        this.mRemoteAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
        if (this.mRemoteAdapter.isDataReady()) {
            this.setAdapter(this.mRemoteAdapter);
        }
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setRemoteViewsOnClickHandler(handler);
        }
    }

    @Override
    public void deferNotifyDataSetChanged() {
        this.mDeferNotifyDataSetChanged = true;
    }

    @Override
    public boolean onRemoteAdapterConnected() {
        if (this.mRemoteAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteAdapter);
            if (this.mDeferNotifyDataSetChanged) {
                this.mRemoteAdapter.notifyDataSetChanged();
                this.mDeferNotifyDataSetChanged = false;
            }
            return false;
        }
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.superNotifyDataSetChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onRemoteAdapterDisconnected() {
    }

    void setVisibleRangeHint(int start, int end) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setVisibleRangeHint(start, end);
        }
    }

    public void setRecyclerListener(RecyclerListener listener) {
        this.mRecycler.mRecyclerListener = listener;
    }

    int getHeightForPosition(int position) {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int childCount = this.getChildCount();
        int index = position - firstVisiblePosition;
        if (index >= 0 && index < childCount) {
            View view = this.getChildAt(index);
            return view.getHeight();
        }
        View view = this.obtainView(position, this.mIsScrap);
        view.measure(this.mWidthMeasureSpec, 0);
        int height = view.getMeasuredHeight();
        this.mRecycler.addScrapView(view, position);
        return height;
    }

    public void setSelectionFromTop(int position, int y) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((position = this.lookForSelectablePosition(position, true)) >= 0) {
                this.setNextSelectedPositionInt(position);
            }
        } else {
            this.mResurrectToPosition = position;
        }
        if (position >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mListPadding.top + y;
            if (this.mNeedSync) {
                this.mSyncPosition = position;
                this.mSyncRowId = this.mAdapter.getItemId(position);
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.requestLayout();
        }
    }

    class PositionScroller
    extends AbsPositionScroller
    implements Runnable {
        private static final int SCROLL_DURATION = 200;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_UP_POS = 2;
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_UP_BOUND = 4;
        private static final int MOVE_OFFSET = 5;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private final int mExtraScroll;
        private int mOffsetFromTop;

        PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get(AbsListView.this.mContext).getScaledFadingEdgeLength();
        }

        @Override
        public void start(final int position) {
            int viewTravelCount;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(position);
                    }
                };
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                viewTravelCount = firstPos - clampedPosition + 1;
                this.mMode = 2;
            } else if (clampedPosition > lastPos) {
                viewTravelCount = clampedPosition - lastPos + 1;
                this.mMode = 1;
            } else {
                this.scrollToVisible(clampedPosition, -1, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void start(final int position, final int boundPosition) {
            int viewTravelCount;
            this.stop();
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(position, boundPosition);
                    }
                };
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - clampedPosition + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (clampedPosition > lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = clampedPosition - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                this.scrollToVisible(clampedPosition, boundPosition, 200);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void startWithOffset(int position, int offset) {
            this.startWithOffset(position, offset, 200);
        }

        @Override
        public void startWithOffset(final int position, int offset, final int duration) {
            int viewTravelCount;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                final int postOffset = offset;
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.startWithOffset(position, postOffset, duration);
                    }
                };
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            this.mTargetPos = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            this.mOffsetFromTop = offset += AbsListView.this.getPaddingTop();
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            if (this.mTargetPos < firstPos) {
                viewTravelCount = firstPos - this.mTargetPos;
            } else if (this.mTargetPos > lastPos) {
                viewTravelCount = this.mTargetPos - lastPos;
            } else {
                int targetTop = AbsListView.this.getChildAt(this.mTargetPos - firstPos).getTop();
                AbsListView.this.smoothScrollBy(targetTop - offset, duration, true);
                return;
            }
            float screenTravelCount = (float)viewTravelCount / (float)childCount;
            this.mScrollDuration = screenTravelCount < 1.0f ? duration : (int)((float)duration / screenTravelCount);
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        private void scrollToVisible(int targetPos, int boundPos, int duration) {
            int firstPos = AbsListView.this.mFirstPosition;
            int childCount = AbsListView.this.getChildCount();
            int lastPos = firstPos + childCount - 1;
            int paddedTop = AbsListView.this.mListPadding.top;
            int paddedBottom = AbsListView.this.getHeight() - AbsListView.this.mListPadding.bottom;
            if (targetPos < firstPos || targetPos > lastPos) {
                Log.w(AbsListView.TAG, "scrollToVisible called with targetPos " + targetPos + " not visible [" + firstPos + ", " + lastPos + "]");
            }
            if (boundPos < firstPos || boundPos > lastPos) {
                boundPos = -1;
            }
            View targetChild = AbsListView.this.getChildAt(targetPos - firstPos);
            int targetTop = targetChild.getTop();
            int targetBottom = targetChild.getBottom();
            int scrollBy = 0;
            if (targetBottom > paddedBottom) {
                scrollBy = targetBottom - paddedBottom;
            }
            if (targetTop < paddedTop) {
                scrollBy = targetTop - paddedTop;
            }
            if (scrollBy == 0) {
                return;
            }
            if (boundPos >= 0) {
                View boundChild = AbsListView.this.getChildAt(boundPos - firstPos);
                int boundTop = boundChild.getTop();
                int boundBottom = boundChild.getBottom();
                int absScroll = Math.abs(scrollBy);
                if (scrollBy < 0 && boundBottom + absScroll > paddedBottom) {
                    scrollBy = Math.max(0, boundBottom - paddedBottom);
                } else if (scrollBy > 0 && boundTop - absScroll < paddedTop) {
                    scrollBy = Math.min(0, boundTop - paddedTop);
                }
            }
            AbsListView.this.smoothScrollBy(scrollBy, duration);
        }

        @Override
        public void stop() {
            AbsListView.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            int listHeight = AbsListView.this.getHeight();
            int firstPos = AbsListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = lastPos < AbsListView.this.mItemCount - 1 ? Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll) : AbsListView.this.mListPadding.bottom;
                    int scrollBy = lastViewHeight - lastViewPixelsShowing + extraScroll;
                    AbsListView.this.smoothScrollBy(scrollBy, this.mScrollDuration, true);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    AbsListView.this.postOnAnimation(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = AbsListView.this.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= AbsListView.this.mItemCount) {
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View nextView = AbsListView.this.getChildAt(1);
                    int nextViewHeight = nextView.getHeight();
                    int nextViewTop = nextView.getTop();
                    int extraScroll = Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll);
                    if (nextPos < this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(Math.max(0, nextViewHeight + nextViewTop - extraScroll), this.mScrollDuration, true);
                        this.mLastSeenPos = nextPos;
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    if (nextViewTop <= extraScroll) break;
                    AbsListView.this.smoothScrollBy(nextViewTop - extraScroll, this.mScrollDuration, true);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View firstView = AbsListView.this.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewTop = firstView.getTop();
                    int extraScroll = firstPos > 0 ? Math.max(this.mExtraScroll, AbsListView.this.mListPadding.top) : AbsListView.this.mListPadding.top;
                    AbsListView.this.smoothScrollBy(firstViewTop - extraScroll, this.mScrollDuration, true);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    AbsListView.this.postOnAnimation(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = Math.max(AbsListView.this.mListPadding.top, this.mExtraScroll);
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(-(lastViewPixelsShowing - extraScroll), this.mScrollDuration, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    int bottom = listHeight - extraScroll;
                    int lastViewBottom = lastViewTop + lastViewHeight;
                    if (bottom <= lastViewBottom) break;
                    AbsListView.this.smoothScrollBy(-(bottom - lastViewBottom), this.mScrollDuration, true);
                    break;
                }
                case 5: {
                    if (this.mLastSeenPos == firstPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    this.mLastSeenPos = firstPos;
                    int childCount = AbsListView.this.getChildCount();
                    int position = this.mTargetPos;
                    int lastPos = firstPos + childCount - 1;
                    int viewTravelCount = 0;
                    if (position < firstPos) {
                        viewTravelCount = firstPos - position + 1;
                    } else if (position > lastPos) {
                        viewTravelCount = position - lastPos;
                    }
                    float screenTravelCount = (float)viewTravelCount / (float)childCount;
                    float modifier = Math.min(Math.abs(screenTravelCount), 1.0f);
                    if (position < firstPos) {
                        int distance = (int)((float)(-AbsListView.this.getHeight()) * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsListView.this.smoothScrollBy(distance, duration, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    if (position > lastPos) {
                        int distance = (int)((float)AbsListView.this.getHeight() * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsListView.this.smoothScrollBy(distance, duration, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    int targetTop = AbsListView.this.getChildAt(position - firstPos).getTop();
                    int distance = targetTop - this.mOffsetFromTop;
                    int duration = (int)((float)this.mScrollDuration * ((float)Math.abs(distance) / (float)AbsListView.this.getHeight()));
                    AbsListView.this.smoothScrollBy(distance, duration, true);
                    break;
                }
            }
        }
    }

    static abstract class AbsPositionScroller {
        AbsPositionScroller() {
        }

        public abstract void start(int var1);

        public abstract void start(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2, int var3);

        public abstract void stop();
    }

    class RecycleBin {
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;
        private ArrayList<View> mSkippedScrap;
        private SparseArray<View> mTransientStateViews;
        private LongSparseArray<View> mTransientStateViewsById;

        RecycleBin() {
        }

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new ArrayList();
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        public void markChildrenDirty() {
            int i;
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i2 = 0; i2 < scrapCount; ++i2) {
                    scrap.get(i2).forceLayout();
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int count = this.mTransientStateViews.size();
                for (i = 0; i < count; ++i) {
                    this.mTransientStateViews.valueAt(i).forceLayout();
                }
            }
            if (this.mTransientStateViewsById != null) {
                int count = this.mTransientStateViewsById.size();
                for (i = 0; i < count; ++i) {
                    this.mTransientStateViewsById.valueAt(i).forceLayout();
                }
            }
        }

        public boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                this.clearScrap(scrap);
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    this.clearScrap(scrap);
                }
            }
            this.clearTransientStateViews();
        }

        void fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            for (int i = 0; i < childCount; ++i) {
                View child = AbsListView.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp == null || lp.viewType == -2) continue;
                activeViews[i] = child;
            }
        }

        View getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        View getTransientStateView(int position) {
            int index;
            if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds && this.mTransientStateViewsById != null) {
                long id2 = AbsListView.this.mAdapter.getItemId(position);
                View result = this.mTransientStateViewsById.get(id2);
                this.mTransientStateViewsById.remove(id2);
                return result;
            }
            if (this.mTransientStateViews != null && (index = this.mTransientStateViews.indexOfKey(position)) >= 0) {
                View result = this.mTransientStateViews.valueAt(index);
                this.mTransientStateViews.removeAt(index);
                return result;
            }
            return null;
        }

        void clearTransientStateViews() {
            LongSparseArray<View> viewsById;
            SparseArray<View> viewsByPos = this.mTransientStateViews;
            if (viewsByPos != null) {
                int N = viewsByPos.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsByPos.valueAt(i), false);
                }
                viewsByPos.clear();
            }
            if ((viewsById = this.mTransientStateViewsById) != null) {
                int N = viewsById.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsById.valueAt(i), false);
                }
                viewsById.clear();
            }
        }

        View getScrapView(int position) {
            if (this.mViewTypeCount == 1) {
                return this.retrieveFromScrap(this.mCurrentScrap, position);
            }
            int whichScrap = AbsListView.this.mAdapter.getItemViewType(position);
            if (whichScrap >= 0 && whichScrap < this.mScrapViews.length) {
                return this.retrieveFromScrap(this.mScrapViews[whichScrap], position);
            }
            return null;
        }

        void addScrapView(View scrap, int position) {
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            lp.scrappedFromPosition = position;
            int viewType = lp.viewType;
            if (!this.shouldRecycleViewType(viewType)) {
                return;
            }
            scrap.dispatchStartTemporaryDetach();
            AbsListView.this.notifyViewAccessibilityStateChangedIfNeeded(1);
            boolean scrapHasTransientState = scrap.hasTransientState();
            if (scrapHasTransientState) {
                if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds) {
                    if (this.mTransientStateViewsById == null) {
                        this.mTransientStateViewsById = new LongSparseArray();
                    }
                    this.mTransientStateViewsById.put(lp.itemId, scrap);
                } else if (!AbsListView.this.mDataChanged) {
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArray();
                    }
                    this.mTransientStateViews.put(position, scrap);
                } else {
                    if (this.mSkippedScrap == null) {
                        this.mSkippedScrap = new ArrayList();
                    }
                    this.mSkippedScrap.add(scrap);
                }
            } else {
                if (this.mViewTypeCount == 1) {
                    this.mCurrentScrap.add(scrap);
                } else {
                    this.mScrapViews[viewType].add(scrap);
                }
                if (this.mRecyclerListener != null) {
                    this.mRecyclerListener.onMovedToScrapHeap(scrap);
                }
            }
        }

        void removeSkippedScrap() {
            if (this.mSkippedScrap == null) {
                return;
            }
            int count = this.mSkippedScrap.size();
            for (int i = 0; i < count; ++i) {
                this.removeDetachedView(this.mSkippedScrap.get(i), false);
            }
            this.mSkippedScrap.clear();
        }

        void scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                View victim = activeViews[i];
                if (victim == null) continue;
                LayoutParams lp = (LayoutParams)victim.getLayoutParams();
                int whichScrap = lp.viewType;
                activeViews[i] = null;
                if (victim.hasTransientState()) {
                    victim.dispatchStartTemporaryDetach();
                    if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds) {
                        if (this.mTransientStateViewsById == null) {
                            this.mTransientStateViewsById = new LongSparseArray();
                        }
                        long id2 = AbsListView.this.mAdapter.getItemId(this.mFirstActivePosition + i);
                        this.mTransientStateViewsById.put(id2, victim);
                        continue;
                    }
                    if (!AbsListView.this.mDataChanged) {
                        if (this.mTransientStateViews == null) {
                            this.mTransientStateViews = new SparseArray();
                        }
                        this.mTransientStateViews.put(this.mFirstActivePosition + i, victim);
                        continue;
                    }
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim, false);
                    continue;
                }
                if (!this.shouldRecycleViewType(whichScrap)) {
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim, false);
                    continue;
                }
                if (multipleScraps) {
                    scrapViews = this.mScrapViews[whichScrap];
                }
                victim.dispatchStartTemporaryDetach();
                lp.scrappedFromPosition = this.mFirstActivePosition + i;
                scrapViews.add(victim);
                if (!hasListener) continue;
                this.mRecyclerListener.onMovedToScrapHeap(victim);
            }
            this.pruneScrapViews();
        }

        private void pruneScrapViews() {
            LongSparseArray<View> transViewsById;
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                int extras = size - maxViews;
                --size;
                for (int j = 0; j < extras; ++j) {
                    this.removeDetachedView(scrapPile.remove(size--), false);
                }
            }
            SparseArray<View> transViewsByPos = this.mTransientStateViews;
            if (transViewsByPos != null) {
                for (int i = 0; i < transViewsByPos.size(); ++i) {
                    View v = transViewsByPos.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v, false);
                    transViewsByPos.removeAt(i);
                    --i;
                }
            }
            if ((transViewsById = this.mTransientStateViewsById) != null) {
                for (int i = 0; i < transViewsById.size(); ++i) {
                    View v = transViewsById.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v, false);
                    transViewsById.removeAt(i);
                    --i;
                }
            }
        }

        void reclaimScrapViews(List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                for (int i = 0; i < viewTypeCount; ++i) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                }
            }
        }

        void setCacheColorHint(int color2) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    scrap.get(i).setDrawingCacheBackgroundColor(color2);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).setDrawingCacheBackgroundColor(color2);
                    }
                }
            }
            for (View victim : this.mActiveViews) {
                if (victim == null) continue;
                victim.setDrawingCacheBackgroundColor(color2);
            }
        }

        private View retrieveFromScrap(ArrayList<View> scrapViews, int position) {
            int size = scrapViews.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    View view = scrapViews.get(i);
                    LayoutParams params = (LayoutParams)view.getLayoutParams();
                    if (AbsListView.this.mAdapterHasStableIds) {
                        long id2 = AbsListView.this.mAdapter.getItemId(position);
                        if (id2 != params.itemId) continue;
                        return scrapViews.remove(i);
                    }
                    if (params.scrappedFromPosition != position) continue;
                    View scrap = scrapViews.remove(i);
                    this.clearAccessibilityFromScrap(scrap);
                    return scrap;
                }
                View scrap = scrapViews.remove(size - 1);
                this.clearAccessibilityFromScrap(scrap);
                return scrap;
            }
            return null;
        }

        private void clearScrap(ArrayList<View> scrap) {
            int scrapCount = scrap.size();
            for (int j = 0; j < scrapCount; ++j) {
                this.removeDetachedView(scrap.remove(scrapCount - 1 - j), false);
            }
        }

        private void clearAccessibilityFromScrap(View view) {
            if (view.isAccessibilityFocused()) {
                view.clearAccessibilityFocus();
            }
            view.setAccessibilityDelegate(null);
        }

        private void removeDetachedView(View child, boolean animate) {
            child.setAccessibilityDelegate(null);
            AbsListView.this.removeDetachedView(child, animate);
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(category="list", mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        int viewType;
        @ViewDebug.ExportedProperty(category="list")
        boolean recycledHeaderFooter;
        @ViewDebug.ExportedProperty(category="list")
        boolean forceAdd;
        int scrappedFromPosition;
        long itemId = -1L;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, int viewType) {
            super(w, h);
            this.viewType = viewType;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        private MultiChoiceModeListener mWrapped;

        MultiChoiceModeWrapper() {
        }

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }

        public boolean hasWrappedCallback() {
            return this.mWrapped != null;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            if (this.mWrapped.onCreateActionMode(mode, menu2)) {
                AbsListView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            AbsListView.this.mChoiceActionMode = null;
            AbsListView.this.clearChoices();
            AbsListView.this.mDataChanged = true;
            AbsListView.this.rememberSyncState();
            AbsListView.this.requestLayout();
            AbsListView.this.setLongClickable(true);
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (AbsListView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }

    class AdapterDataSetObserver
    extends AdapterView.AdapterDataSetObserver {
        AdapterDataSetObserver() {
            super(AbsListView.this);
        }

        @Override
        public void onChanged() {
            super.onChanged();
            if (AbsListView.this.mFastScroll != null) {
                AbsListView.this.mFastScroll.onSectionsChanged();
            }
        }

        @Override
        public void onInvalidated() {
            super.onInvalidated();
            if (AbsListView.this.mFastScroll != null) {
                AbsListView.this.mFastScroll.onSectionsChanged();
            }
        }
    }

    private class InputConnectionWrapper
    implements InputConnection {
        private final EditorInfo mOutAttrs;
        private InputConnection mTarget;

        public InputConnectionWrapper(EditorInfo outAttrs) {
            this.mOutAttrs = outAttrs;
        }

        private InputConnection getTarget() {
            if (this.mTarget == null) {
                this.mTarget = AbsListView.this.getTextFilterInput().onCreateInputConnection(this.mOutAttrs);
            }
            return this.mTarget;
        }

        @Override
        public boolean reportFullscreenMode(boolean enabled) {
            return AbsListView.this.mDefInputConnection.reportFullscreenMode(enabled);
        }

        @Override
        public boolean performEditorAction(int editorAction) {
            if (editorAction == 6) {
                InputMethodManager imm = (InputMethodManager)AbsListView.this.getContext().getSystemService("input_method");
                if (imm != null) {
                    imm.hideSoftInputFromWindow(AbsListView.this.getWindowToken(), 0);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean sendKeyEvent(KeyEvent event) {
            return AbsListView.this.mDefInputConnection.sendKeyEvent(event);
        }

        @Override
        public CharSequence getTextBeforeCursor(int n, int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextBeforeCursor(n, flags);
        }

        @Override
        public CharSequence getTextAfterCursor(int n, int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextAfterCursor(n, flags);
        }

        @Override
        public CharSequence getSelectedText(int flags) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getSelectedText(flags);
        }

        @Override
        public int getCursorCapsMode(int reqModes) {
            if (this.mTarget == null) {
                return 16384;
            }
            return this.mTarget.getCursorCapsMode(reqModes);
        }

        @Override
        public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
            return this.getTarget().getExtractedText(request, flags);
        }

        @Override
        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            return this.getTarget().deleteSurroundingText(beforeLength, afterLength);
        }

        @Override
        public boolean setComposingText(CharSequence text, int newCursorPosition) {
            return this.getTarget().setComposingText(text, newCursorPosition);
        }

        @Override
        public boolean setComposingRegion(int start, int end) {
            return this.getTarget().setComposingRegion(start, end);
        }

        @Override
        public boolean finishComposingText() {
            return this.mTarget == null || this.mTarget.finishComposingText();
        }

        @Override
        public boolean commitText(CharSequence text, int newCursorPosition) {
            return this.getTarget().commitText(text, newCursorPosition);
        }

        @Override
        public boolean commitCompletion(CompletionInfo text) {
            return this.getTarget().commitCompletion(text);
        }

        @Override
        public boolean commitCorrection(CorrectionInfo correctionInfo) {
            return this.getTarget().commitCorrection(correctionInfo);
        }

        @Override
        public boolean setSelection(int start, int end) {
            return this.getTarget().setSelection(start, end);
        }

        @Override
        public boolean performContextMenuAction(int id2) {
            return this.getTarget().performContextMenuAction(id2);
        }

        @Override
        public boolean beginBatchEdit() {
            return this.getTarget().beginBatchEdit();
        }

        @Override
        public boolean endBatchEdit() {
            return this.getTarget().endBatchEdit();
        }

        @Override
        public boolean clearMetaKeyStates(int states) {
            return this.getTarget().clearMetaKeyStates(states);
        }

        @Override
        public boolean performPrivateCommand(String action, Bundle data) {
            return this.getTarget().performPrivateCommand(action, data);
        }

        @Override
        public boolean requestCursorUpdates(int cursorUpdateMode) {
            return this.getTarget().requestCursorUpdates(cursorUpdateMode);
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mLastFlingY;
        private final Runnable mCheckFlywheel = new Runnable(){

            @Override
            public void run() {
                int activeId = AbsListView.this.mActivePointerId;
                VelocityTracker vt = AbsListView.this.mVelocityTracker;
                OverScroller scroller = FlingRunnable.this.mScroller;
                if (vt == null || activeId == -1) {
                    return;
                }
                vt.computeCurrentVelocity(1000, AbsListView.this.mMaximumVelocity);
                float yvel = -vt.getYVelocity(activeId);
                if (Math.abs(yvel) >= (float)AbsListView.this.mMinimumVelocity && scroller.isScrollingInDirection(0.0f, yvel)) {
                    AbsListView.this.postDelayed(this, 40L);
                } else {
                    FlingRunnable.this.endFling();
                    AbsListView.this.mTouchMode = 3;
                    AbsListView.this.reportScrollStateChange(1);
                }
            }
        };
        private static final int FLYWHEEL_TIMEOUT = 40;

        FlingRunnable() {
            this.mScroller = new OverScroller(AbsListView.this.getContext());
        }

        void start(int initialVelocity) {
            int initialY;
            this.mLastFlingY = initialY = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.postOnAnimation(this);
            if (AbsListView.this.mFlingStrictSpan == null) {
                AbsListView.this.mFlingStrictSpan = StrictMode.enterCriticalSpan("AbsListView-fling");
            }
        }

        void startSpringback() {
            if (this.mScroller.springBack(0, AbsListView.this.mScrollY, 0, 0, 0, 0)) {
                AbsListView.this.mTouchMode = 6;
                AbsListView.this.invalidate();
                AbsListView.this.postOnAnimation(this);
            } else {
                AbsListView.this.mTouchMode = -1;
                AbsListView.this.reportScrollStateChange(0);
            }
        }

        void startOverfling(int initialVelocity) {
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, AbsListView.this.mScrollY, 0, initialVelocity, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, AbsListView.this.getHeight());
            AbsListView.this.mTouchMode = 6;
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        void edgeReached(int delta) {
            this.mScroller.notifyVerticalEdgeReached(AbsListView.this.mScrollY, 0, AbsListView.this.mOverflingDistance);
            int overscrollMode = AbsListView.this.getOverScrollMode();
            if (overscrollMode == 0 || overscrollMode == 1 && !AbsListView.this.contentFits()) {
                AbsListView.this.mTouchMode = 6;
                int vel = (int)this.mScroller.getCurrVelocity();
                if (delta > 0) {
                    AbsListView.this.mEdgeGlowTop.onAbsorb(vel);
                } else {
                    AbsListView.this.mEdgeGlowBottom.onAbsorb(vel);
                }
            } else {
                AbsListView.this.mTouchMode = -1;
                if (AbsListView.this.mPositionScroller != null) {
                    AbsListView.this.mPositionScroller.stop();
                }
            }
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        void startScroll(int distance, int duration, boolean linear) {
            int initialY;
            this.mLastFlingY = initialY = distance < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(linear ? sLinearInterpolator : null);
            this.mScroller.startScroll(0, initialY, 0, distance, duration);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.postOnAnimation(this);
        }

        void endFling() {
            AbsListView.this.mTouchMode = -1;
            AbsListView.this.removeCallbacks(this);
            AbsListView.this.removeCallbacks(this.mCheckFlywheel);
            AbsListView.this.reportScrollStateChange(0);
            AbsListView.this.clearScrollingCache();
            this.mScroller.abortAnimation();
            if (AbsListView.this.mFlingStrictSpan != null) {
                AbsListView.this.mFlingStrictSpan.finish();
                AbsListView.this.mFlingStrictSpan = null;
            }
        }

        void flywheelTouch() {
            AbsListView.this.postDelayed(this.mCheckFlywheel, 40L);
        }

        @Override
        public void run() {
            switch (AbsListView.this.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) {
                        return;
                    }
                }
                case 4: {
                    boolean atEdge;
                    boolean atEnd;
                    if (AbsListView.this.mDataChanged) {
                        AbsListView.this.layoutChildren();
                    }
                    if (AbsListView.this.mItemCount == 0 || AbsListView.this.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller scroller = this.mScroller;
                    boolean more = scroller.computeScrollOffset();
                    int y = scroller.getCurrY();
                    int delta = this.mLastFlingY - y;
                    if (delta > 0) {
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition;
                        View firstView = AbsListView.this.getChildAt(0);
                        AbsListView.this.mMotionViewOriginalTop = firstView.getTop();
                        delta = Math.min(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1, delta);
                    } else {
                        int offsetToLast = AbsListView.this.getChildCount() - 1;
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition + offsetToLast;
                        View lastView = AbsListView.this.getChildAt(offsetToLast);
                        AbsListView.this.mMotionViewOriginalTop = lastView.getTop();
                        delta = Math.max(-(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1), delta);
                    }
                    View motionView = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                    int oldTop = 0;
                    if (motionView != null) {
                        oldTop = motionView.getTop();
                    }
                    boolean bl = atEnd = (atEdge = AbsListView.this.trackMotionScroll(delta, delta)) && delta != 0;
                    if (atEnd) {
                        if (motionView != null) {
                            int overshoot = -(delta - (motionView.getTop() - oldTop));
                            AbsListView.this.overScrollBy(0, overshoot, 0, AbsListView.this.mScrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false);
                        }
                        if (!more) break;
                        this.edgeReached(delta);
                        break;
                    }
                    if (more && !atEnd) {
                        if (atEdge) {
                            AbsListView.this.invalidate();
                        }
                        this.mLastFlingY = y;
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
                case 6: {
                    OverScroller scroller = this.mScroller;
                    if (scroller.computeScrollOffset()) {
                        int scrollY = AbsListView.this.mScrollY;
                        int currY = scroller.getCurrY();
                        int deltaY = currY - scrollY;
                        if (AbsListView.this.overScrollBy(0, deltaY, 0, scrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false)) {
                            boolean crossUp;
                            boolean crossDown = scrollY <= 0 && currY > 0;
                            boolean bl = crossUp = scrollY >= 0 && currY < 0;
                            if (crossDown || crossUp) {
                                int velocity = (int)scroller.getCurrVelocity();
                                if (crossUp) {
                                    velocity = -velocity;
                                }
                                scroller.abortAnimation();
                                this.start(velocity);
                                break;
                            }
                            this.startSpringback();
                            break;
                        }
                        AbsListView.this.invalidate();
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
            }
        }
    }

    private final class CheckForTap
    implements Runnable {
        float x;
        float y;

        private CheckForTap() {
        }

        @Override
        public void run() {
            if (AbsListView.this.mTouchMode == 0) {
                AbsListView.this.mTouchMode = 1;
                View child = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                if (child != null && !child.hasFocusable()) {
                    AbsListView.this.mLayoutMode = 0;
                    if (!AbsListView.this.mDataChanged) {
                        child.setPressed(true);
                        AbsListView.this.setPressed(true);
                        AbsListView.this.layoutChildren();
                        AbsListView.this.positionSelector(AbsListView.this.mMotionPosition, child);
                        AbsListView.this.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = AbsListView.this.isLongClickable();
                        if (AbsListView.this.mSelector != null) {
                            Drawable d = AbsListView.this.mSelector.getCurrent();
                            if (d != null && d instanceof TransitionDrawable) {
                                if (longClickable) {
                                    ((TransitionDrawable)d).startTransition(longPressTimeout);
                                } else {
                                    ((TransitionDrawable)d).resetTransition();
                                }
                            }
                            AbsListView.this.mSelector.setHotspot(this.x, this.y);
                        }
                        if (longClickable) {
                            if (AbsListView.this.mPendingCheckForLongPress == null) {
                                AbsListView.this.mPendingCheckForLongPress = new CheckForLongPress();
                            }
                            AbsListView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                            AbsListView.this.postDelayed(AbsListView.this.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            AbsListView.this.mTouchMode = 2;
                        }
                    } else {
                        AbsListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForKeyLongPress() {
        }

        @Override
        public void run() {
            if (AbsListView.this.isPressed() && AbsListView.this.mSelectedPosition >= 0) {
                int index = AbsListView.this.mSelectedPosition - AbsListView.this.mFirstPosition;
                View v = AbsListView.this.getChildAt(index);
                if (!AbsListView.this.mDataChanged) {
                    boolean handled = false;
                    if (this.sameWindow()) {
                        handled = AbsListView.this.performLongPress(v, AbsListView.this.mSelectedPosition, AbsListView.this.mSelectedRowId);
                    }
                    if (handled) {
                        AbsListView.this.setPressed(false);
                        v.setPressed(false);
                    }
                } else {
                    AbsListView.this.setPressed(false);
                    if (v != null) {
                        v.setPressed(false);
                    }
                }
            }
        }
    }

    private class CheckForLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            int motionPosition = AbsListView.this.mMotionPosition;
            View child = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition);
            if (child != null) {
                int longPressPosition = AbsListView.this.mMotionPosition;
                long longPressId = AbsListView.this.mAdapter.getItemId(AbsListView.this.mMotionPosition);
                boolean handled = false;
                if (this.sameWindow() && !AbsListView.this.mDataChanged) {
                    handled = AbsListView.this.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    AbsListView.this.mTouchMode = -1;
                    AbsListView.this.setPressed(false);
                    child.setPressed(false);
                } else {
                    AbsListView.this.mTouchMode = 2;
                }
            }
        }
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformClick() {
        }

        @Override
        public void run() {
            View view;
            if (AbsListView.this.mDataChanged) {
                return;
            }
            ListAdapter adapter = AbsListView.this.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && AbsListView.this.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow() && (view = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition)) != null) {
                AbsListView.this.performItemClick(view, motionPosition, adapter.getItemId(motionPosition));
            }
        }
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }

    class ListItemAccessibilityDelegate
    extends View.AccessibilityDelegate {
        ListItemAccessibilityDelegate() {
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(View host) {
            if (AbsListView.this.mDataChanged) {
                return null;
            }
            return super.createAccessibilityNodeInfo(host);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            int position = AbsListView.this.getPositionForView(host);
            AbsListView.this.onInitializeAccessibilityNodeInfoForItem(host, position, info);
        }

        @Override
        public boolean performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            int position = AbsListView.this.getPositionForView(host);
            ListAdapter adapter = (ListAdapter)AbsListView.this.getAdapter();
            if (position == -1 || adapter == null) {
                return false;
            }
            if (!AbsListView.this.isEnabled() || !adapter.isEnabled(position)) {
                return false;
            }
            long id2 = AbsListView.this.getItemIdAtPosition(position);
            switch (action) {
                case 8: {
                    if (AbsListView.this.getSelectedItemPosition() == position) {
                        AbsListView.this.setSelection(-1);
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (AbsListView.this.getSelectedItemPosition() != position) {
                        AbsListView.this.setSelection(position);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    if (AbsListView.this.isClickable()) {
                        return AbsListView.this.performItemClick(host, position, id2);
                    }
                    return false;
                }
                case 32: {
                    if (AbsListView.this.isLongClickable()) {
                        return AbsListView.this.performLongPress(host, position, id2);
                    }
                    return false;
                }
            }
            return false;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        long selectedId;
        long firstId;
        int viewTop;
        int position;
        int height;
        String filter;
        boolean inActionMode;
        int checkedItemCount;
        SparseBooleanArray checkState;
        LongSparseArray<Integer> checkIdState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.selectedId = in.readLong();
            this.firstId = in.readLong();
            this.viewTop = in.readInt();
            this.position = in.readInt();
            this.height = in.readInt();
            this.filter = in.readString();
            this.inActionMode = in.readByte() != 0;
            this.checkedItemCount = in.readInt();
            this.checkState = in.readSparseBooleanArray();
            int N = in.readInt();
            if (N > 0) {
                this.checkIdState = new LongSparseArray();
                for (int i = 0; i < N; ++i) {
                    long key = in.readLong();
                    int value = in.readInt();
                    this.checkIdState.put(key, value);
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeLong(this.firstId);
            out.writeInt(this.viewTop);
            out.writeInt(this.position);
            out.writeInt(this.height);
            out.writeString(this.filter);
            out.writeByte((byte)(this.inActionMode ? 1 : 0));
            out.writeInt(this.checkedItemCount);
            out.writeSparseBooleanArray(this.checkState);
            int N = this.checkIdState != null ? this.checkIdState.size() : 0;
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                out.writeLong(this.checkIdState.keyAt(i));
                out.writeInt(this.checkIdState.valueAt(i));
            }
        }

        public String toString() {
            return "AbsListView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewTop=" + this.viewTop + " position=" + this.position + " height=" + this.height + " filter=" + this.filter + " checkState=" + this.checkState + "}";
        }
    }

    public static interface SelectionBoundsAdjuster {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsListView var1, int var2);

        public void onScroll(AbsListView var1, int var2, int var3, int var4);
    }
}

