/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import java.util.HashMap;

public class WindowId
implements Parcelable {
    private final IWindowId mToken;
    public static final Parcelable.Creator<WindowId> CREATOR = new Parcelable.Creator<WindowId>(){

        @Override
        public WindowId createFromParcel(Parcel in) {
            IBinder target = in.readStrongBinder();
            return target != null ? new WindowId(target) : null;
        }

        public WindowId[] newArray(int size) {
            return new WindowId[size];
        }
    };

    public boolean isFocused() {
        try {
            return this.mToken.isFocused();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFocusObserver(FocusObserver observer) {
        HashMap<IBinder, WindowId> hashMap = observer.mRegistrations;
        synchronized (hashMap) {
            if (observer.mRegistrations.containsKey(this.mToken.asBinder())) {
                throw new IllegalStateException("Focus observer already registered with input token");
            }
            observer.mRegistrations.put(this.mToken.asBinder(), this);
            try {
                this.mToken.registerFocusObserver(observer.mIObserver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFocusObserver(FocusObserver observer) {
        HashMap<IBinder, WindowId> hashMap = observer.mRegistrations;
        synchronized (hashMap) {
            if (observer.mRegistrations.remove(this.mToken.asBinder()) == null) {
                throw new IllegalStateException("Focus observer not registered with input token");
            }
            try {
                this.mToken.unregisterFocusObserver(observer.mIObserver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof WindowId) {
            return this.mToken.asBinder().equals(((WindowId)otherObj).mToken.asBinder());
        }
        return false;
    }

    public int hashCode() {
        return this.mToken.asBinder().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("IntentSender{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(": ");
        sb.append(this.mToken != null ? this.mToken.asBinder() : null);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeStrongBinder(this.mToken.asBinder());
    }

    public IWindowId getTarget() {
        return this.mToken;
    }

    public WindowId(IWindowId target) {
        this.mToken = target;
    }

    public WindowId(IBinder target) {
        this.mToken = IWindowId.Stub.asInterface(target);
    }

    public static abstract class FocusObserver {
        final IWindowFocusObserver.Stub mIObserver = new IWindowFocusObserver.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusGained(IBinder inputToken) {
                WindowId token;
                HashMap<IBinder, WindowId> hashMap = FocusObserver.this.mRegistrations;
                synchronized (hashMap) {
                    token = FocusObserver.this.mRegistrations.get(inputToken);
                }
                if (FocusObserver.this.mHandler != null) {
                    FocusObserver.this.mHandler.sendMessage(FocusObserver.this.mHandler.obtainMessage(1, token));
                } else {
                    FocusObserver.this.onFocusGained(token);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(IBinder inputToken) {
                WindowId token;
                HashMap<IBinder, WindowId> hashMap = FocusObserver.this.mRegistrations;
                synchronized (hashMap) {
                    token = FocusObserver.this.mRegistrations.get(inputToken);
                }
                if (FocusObserver.this.mHandler != null) {
                    FocusObserver.this.mHandler.sendMessage(FocusObserver.this.mHandler.obtainMessage(2, token));
                } else {
                    FocusObserver.this.onFocusLost(token);
                }
            }
        };
        final HashMap<IBinder, WindowId> mRegistrations = new HashMap();
        final Handler mHandler = new H();

        public abstract void onFocusGained(WindowId var1);

        public abstract void onFocusLost(WindowId var1);

        class H
        extends Handler {
            H() {
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        FocusObserver.this.onFocusGained((WindowId)msg.obj);
                        break;
                    }
                    case 2: {
                        FocusObserver.this.onFocusLost((WindowId)msg.obj);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        }
    }
}

