/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import dalvik.system.CloseGuard;

public class SurfaceControl {
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    long mNativeObject;
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int BUILT_IN_DISPLAY_ID_MAIN = 0;
    public static final int BUILT_IN_DISPLAY_ID_HDMI = 1;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;

    private static native long nativeCreate(SurfaceSession var0, String var1, int var2, int var3, int var4, int var5) throws Surface.OutOfResourcesException;

    private static native void nativeRelease(long var0);

    private static native void nativeDestroy(long var0);

    private static native Bitmap nativeScreenshot(IBinder var0, Rect var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8);

    private static native void nativeScreenshot(IBinder var0, Surface var1, Rect var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    private static native void nativeOpenTransaction();

    private static native void nativeCloseTransaction();

    private static native void nativeSetAnimationTransaction();

    private static native void nativeSetLayer(long var0, int var2);

    private static native void nativeSetPosition(long var0, float var2, float var3);

    private static native void nativeSetSize(long var0, int var2, int var3);

    private static native void nativeSetTransparentRegionHint(long var0, Region var2);

    private static native void nativeSetAlpha(long var0, float var2);

    private static native void nativeSetMatrix(long var0, float var2, float var3, float var4, float var5);

    private static native void nativeSetFlags(long var0, int var2, int var3);

    private static native void nativeSetWindowCrop(long var0, int var2, int var3, int var4, int var5);

    private static native void nativeSetLayerStack(long var0, int var2);

    private static native boolean nativeClearContentFrameStats(long var0);

    private static native boolean nativeGetContentFrameStats(long var0, WindowContentFrameStats var2);

    private static native boolean nativeClearAnimationFrameStats();

    private static native boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats var0);

    private static native IBinder nativeGetBuiltInDisplay(int var0);

    private static native IBinder nativeCreateDisplay(String var0, boolean var1);

    private static native void nativeDestroyDisplay(IBinder var0);

    private static native void nativeSetDisplaySurface(IBinder var0, long var1);

    private static native void nativeSetDisplayLayerStack(IBinder var0, int var1);

    private static native void nativeSetDisplayProjection(IBinder var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native void nativeSetDisplaySize(IBinder var0, int var1, int var2);

    private static native PhysicalDisplayInfo[] nativeGetDisplayConfigs(IBinder var0);

    private static native int nativeGetActiveConfig(IBinder var0);

    private static native boolean nativeSetActiveConfig(IBinder var0, int var1);

    private static native void nativeSetDisplayPowerMode(IBinder var0, int var1);

    public SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags) throws Surface.OutOfResourcesException {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((flags & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + name, new Throwable());
        }
        this.mName = name;
        this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags);
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")";
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    public static void openTransaction() {
        SurfaceControl.nativeOpenTransaction();
    }

    public static void closeTransaction() {
        SurfaceControl.nativeCloseTransaction();
    }

    public static void setAnimationTransaction() {
        SurfaceControl.nativeSetAnimationTransaction();
    }

    public void setLayer(int zorder) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayer(this.mNativeObject, zorder);
    }

    public void setPosition(float x, float y) {
        this.checkNotReleased();
        SurfaceControl.nativeSetPosition(this.mNativeObject, x, y);
    }

    public void setSize(int w, int h) {
        this.checkNotReleased();
        SurfaceControl.nativeSetSize(this.mNativeObject, w, h);
    }

    public void hide() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 1, 1);
    }

    public void show() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 1);
    }

    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, region);
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    public void setAlpha(float alpha) {
        this.checkNotReleased();
        SurfaceControl.nativeSetAlpha(this.mNativeObject, alpha);
    }

    public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        this.checkNotReleased();
        SurfaceControl.nativeSetMatrix(this.mNativeObject, dsdx, dtdx, dsdy, dtdy);
    }

    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        if (crop != null) {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
        } else {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, 0, 0, 0, 0);
        }
    }

    public void setLayerStack(int layerStack) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayerStack(this.mNativeObject, layerStack);
    }

    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        if (isOpaque) {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 2, 2);
        } else {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 2);
        }
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static PhysicalDisplayInfo[] getDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(displayToken);
    }

    public static int getActiveConfig(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(displayToken);
    }

    public static boolean setActiveConfig(IBinder displayToken, int id2) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveConfig(displayToken, id2);
    }

    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (layerStackRect == null) {
            throw new IllegalArgumentException("layerStackRect must not be null");
        }
        if (displayRect == null) {
            throw new IllegalArgumentException("displayRect must not be null");
        }
        SurfaceControl.nativeSetDisplayProjection(displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
    }

    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayLayerStack(displayToken, layerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (surface != null) {
            Object object = surface.mLock;
            synchronized (object) {
                SurfaceControl.nativeSetDisplaySurface(displayToken, surface.mNativeObject);
            }
        } else {
            SurfaceControl.nativeSetDisplaySurface(displayToken, 0L);
        }
    }

    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        SurfaceControl.nativeSetDisplaySize(displayToken, width, height);
    }

    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static IBinder getBuiltInDisplay(int builtInDisplayId) {
        return SurfaceControl.nativeGetBuiltInDisplay(builtInDisplayId);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, minLayer, maxLayer, false, useIdentityTransform);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, 0, 0, true, false);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, new Rect(), 0, 0, 0, 0, true, false);
    }

    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation);
    }

    public static Bitmap screenshot(int width, int height) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, new Rect(), width, height, 0, 0, true, false, 0);
    }

    private static void screenshot(IBinder display, Surface consumer, Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean allLayers, boolean useIdentityTransform) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        SurfaceControl.nativeScreenshot(display, consumer, sourceCrop, width, height, minLayer, maxLayer, allLayers, useIdentityTransform);
    }

    public static final class PhysicalDisplayInfo {
        public int width;
        public int height;
        public float refreshRate;
        public float density;
        public float xDpi;
        public float yDpi;
        public boolean secure;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;

        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo other) {
            this.copyFrom(other);
        }

        public boolean equals(Object o) {
            return o instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)o);
        }

        public boolean equals(PhysicalDisplayInfo other) {
            return other != null && this.width == other.width && this.height == other.height && this.refreshRate == other.refreshRate && this.density == other.density && this.xDpi == other.xDpi && this.yDpi == other.yDpi && this.secure == other.secure && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(PhysicalDisplayInfo other) {
            this.width = other.width;
            this.height = other.height;
            this.refreshRate = other.refreshRate;
            this.density = other.density;
            this.xDpi = other.xDpi;
            this.yDpi = other.yDpi;
            this.secure = other.secure;
            this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, " + "density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + ", appVsyncOffset " + this.appVsyncOffsetNanos + ", bufferDeadline " + this.presentationDeadlineNanos + "}";
        }
    }
}

