/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class DebugUtils {
    public static boolean isObjectSelected(Object object) {
        boolean match = false;
        String s = System.getenv("ANDROID_OBJECT_FILTER");
        if (s != null && s.length() > 0) {
            String[] selectors = s.split("@");
            if (object.getClass().getSimpleName().matches(selectors[0])) {
                for (int i = 1; i < selectors.length; ++i) {
                    String[] pair = selectors[i].split("=");
                    Class<?> klass = object.getClass();
                    try {
                        Method declaredMethod = null;
                        Class<?> parent = klass;
                        do {
                            declaredMethod = parent.getDeclaredMethod("get" + pair[0].substring(0, 1).toUpperCase(Locale.ROOT) + pair[0].substring(1), null);
                        } while ((parent = klass.getSuperclass()) != null && declaredMethod == null);
                        if (declaredMethod == null) continue;
                        Object value = declaredMethod.invoke(object, (Object[])null);
                        match |= (value != null ? value.toString() : "null").matches(pair[1]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return match;
    }

    public static void buildShortClassTag(Object cls, StringBuilder out) {
        if (cls == null) {
            out.append("null");
        } else {
            int end;
            String simpleName = cls.getClass().getSimpleName();
            if ((simpleName == null || simpleName.isEmpty()) && (end = (simpleName = cls.getClass().getName()).lastIndexOf(46)) > 0) {
                simpleName = simpleName.substring(end + 1);
            }
            out.append(simpleName);
            out.append('{');
            out.append(Integer.toHexString(System.identityHashCode(cls)));
        }
    }
}

