/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.BaseKeyListener;
import android.view.KeyEvent;
import android.view.View;

public abstract class NumberKeyListener
extends BaseKeyListener
implements InputFilter {
    protected abstract char[] getAcceptedChars();

    protected int lookup(KeyEvent event, Spannable content) {
        return event.getMatch(this.getAcceptedChars(), NumberKeyListener.getMetaState((CharSequence)content, event));
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        int i;
        char[] accept = this.getAcceptedChars();
        boolean filter = false;
        for (i = start; i < end && NumberKeyListener.ok(accept, source.charAt(i)); ++i) {
        }
        if (i == end) {
            return null;
        }
        if (end - start == 1) {
            return "";
        }
        SpannableStringBuilder filtered = new SpannableStringBuilder(source, start, end);
        i -= start;
        int len = (end -= start) - start;
        for (int j = end - 1; j >= i; --j) {
            if (NumberKeyListener.ok(accept, source.charAt(j))) continue;
            filtered.delete(j, j + 1);
        }
        return filtered;
    }

    protected static boolean ok(char[] accept, char c) {
        for (int i = accept.length - 1; i >= 0; --i) {
            if (accept[i] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        int repeatCount;
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        if (selStart < 0 || selEnd < 0) {
            selEnd = 0;
            selStart = 0;
            Selection.setSelection(content, 0);
        }
        int i = event != null ? this.lookup(event, content) : 0;
        int n = repeatCount = event != null ? event.getRepeatCount() : 0;
        if (repeatCount == 0) {
            if (i != 0) {
                if (selStart != selEnd) {
                    Selection.setSelection(content, selEnd);
                }
                content.replace(selStart, selEnd, String.valueOf((char)i));
                NumberKeyListener.adjustMetaAfterKeypress(content);
                return true;
            }
        } else if (i == 48 && repeatCount == 1 && selStart == selEnd && selEnd > 0 && content.charAt(selStart - 1) == '0') {
            content.replace(selStart - 1, selEnd, String.valueOf('+'));
            NumberKeyListener.adjustMetaAfterKeypress(content);
            return true;
        }
        NumberKeyListener.adjustMetaAfterKeypress(content);
        return super.onKeyDown(view, content, keyCode, event);
    }
}

