/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.TextKeyListener;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

public abstract class BaseKeyListener
extends MetaKeyKeyListener
implements KeyListener {
    static final Object OLD_SEL_START = new NoCopySpan.Concrete();

    public boolean backspace(View view, Editable content, int keyCode, KeyEvent event) {
        return this.backspaceOrForwardDelete(view, content, keyCode, event, false);
    }

    public boolean forwardDelete(View view, Editable content, int keyCode, KeyEvent event) {
        return this.backspaceOrForwardDelete(view, content, keyCode, event, true);
    }

    private boolean backspaceOrForwardDelete(View view, Editable content, int keyCode, KeyEvent event, boolean isForwardDelete) {
        int end;
        if (!KeyEvent.metaStateHasNoModifiers(event.getMetaState() & 0xFFFFFF0C)) {
            return false;
        }
        if (this.deleteSelection(view, content)) {
            return true;
        }
        if (BaseKeyListener.getMetaState(content, 2, event) == 1 && this.deleteLine(view, content)) {
            return true;
        }
        int start = Selection.getSelectionEnd(content);
        if (start != (end = isForwardDelete || event.isShiftPressed() || BaseKeyListener.getMetaState((CharSequence)content, 1) == 1 ? TextUtils.getOffsetAfter(content, start) : TextUtils.getOffsetBefore(content, start))) {
            content.delete(Math.min(start, end), Math.max(start, end));
            return true;
        }
        return false;
    }

    private boolean deleteSelection(View view, Editable content) {
        int selectionStart = Selection.getSelectionStart(content);
        int selectionEnd = Selection.getSelectionEnd(content);
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        if (selectionStart != selectionEnd) {
            content.delete(selectionStart, selectionEnd);
            return true;
        }
        return false;
    }

    private boolean deleteLine(View view, Editable content) {
        Layout layout2;
        if (view instanceof TextView && (layout2 = ((TextView)view).getLayout()) != null) {
            int line = layout2.getLineForOffset(Selection.getSelectionStart(content));
            int start = layout2.getLineStart(line);
            int end = layout2.getLineEnd(line);
            if (end != start) {
                content.delete(start, end);
                return true;
            }
        }
        return false;
    }

    static int makeTextContentType(TextKeyListener.Capitalize caps, boolean autoText) {
        int contentType = 1;
        switch (caps) {
            case CHARACTERS: {
                contentType |= 0x1000;
                break;
            }
            case WORDS: {
                contentType |= 0x2000;
                break;
            }
            case SENTENCES: {
                contentType |= 0x4000;
            }
        }
        if (autoText) {
            contentType |= 0x8000;
        }
        return contentType;
    }

    @Override
    public boolean onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        boolean handled;
        switch (keyCode) {
            case 67: {
                handled = this.backspace(view, content, keyCode, event);
                break;
            }
            case 112: {
                handled = this.forwardDelete(view, content, keyCode, event);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled) {
            BaseKeyListener.adjustMetaAfterKeypress(content);
        }
        return super.onKeyDown(view, content, keyCode, event);
    }

    @Override
    public boolean onKeyOther(View view, Editable content, KeyEvent event) {
        String text;
        if (event.getAction() != 2 || event.getKeyCode() != 0) {
            return false;
        }
        int selectionStart = Selection.getSelectionStart(content);
        int selectionEnd = Selection.getSelectionEnd(content);
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        if ((text = event.getCharacters()) == null) {
            return false;
        }
        content.replace(selectionStart, selectionEnd, text);
        return true;
    }
}

