/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.net.NetworkUtils;

public final class Formatter {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    public static String formatFileSize(Context context, long number) {
        return Formatter.formatFileSize(context, number, false);
    }

    public static String formatShortFileSize(Context context, long number) {
        return Formatter.formatFileSize(context, number, true);
    }

    private static String formatFileSize(Context context, long number, boolean shorter) {
        if (context == null) {
            return "";
        }
        float result = number;
        int suffix = 17039467;
        if (result > 900.0f) {
            suffix = 17039468;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039469;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039470;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039471;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039472;
            result /= 1024.0f;
        }
        String value = result < 1.0f ? String.format("%.2f", Float.valueOf(result)) : (result < 10.0f ? (shorter ? String.format("%.1f", Float.valueOf(result)) : String.format("%.2f", Float.valueOf(result))) : (result < 100.0f ? (shorter ? String.format("%.0f", Float.valueOf(result)) : String.format("%.2f", Float.valueOf(result))) : String.format("%.0f", Float.valueOf(result))));
        return context.getResources().getString(17039473, value, context.getString(suffix));
    }

    @Deprecated
    public static String formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    public static String formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        if (days >= 2) {
            return context.getString(17039474, days += (hours + 12) / 24);
        }
        if (days > 0) {
            if (hours == 1) {
                return context.getString(17039476, days, hours);
            }
            return context.getString(17039475, days, hours);
        }
        if (hours >= 2) {
            return context.getString(17039477, hours += (minutes + 30) / 60);
        }
        if (hours > 0) {
            if (minutes == 1) {
                return context.getString(17039479, hours, minutes);
            }
            return context.getString(17039478, hours, minutes);
        }
        if (minutes >= 2) {
            return context.getString(17039480, minutes += (seconds + 30) / 60);
        }
        if (minutes > 0) {
            if (seconds == 1) {
                return context.getString(17039482, minutes, seconds);
            }
            return context.getString(17039481, minutes, seconds);
        }
        if (seconds == 1) {
            return context.getString(17039484, seconds);
        }
        return context.getString(17039483, seconds);
    }
}

