/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.CountryDetector;
import android.net.Uri;
import android.os.SystemProperties;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.ShortNumberUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberUtils {
    public static final char PAUSE = ',';
    public static final char WAIT = ';';
    public static final char WILD = 'N';
    private static final String CLIR_ON = "*31#";
    private static final String CLIR_OFF = "#31#";
    public static final int TOA_International = 145;
    public static final int TOA_Unknown = 129;
    static final String LOG_TAG = "PhoneNumberUtils";
    private static final boolean DBG = false;
    private static final Pattern GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_JAPAN = 2;
    private static final String[] NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "MP", "KN", "LC", "VC", "TT", "TC", "VI"};
    private static final int NANP_STATE_DIGIT = 1;
    private static final int NANP_STATE_PLUS = 2;
    private static final int NANP_STATE_ONE = 3;
    private static final int NANP_STATE_DASH = 4;
    static final int MIN_MATCH = 7;
    private static final SparseIntArray KEYPAD_MAP = new SparseIntArray();
    private static final char PLUS_SIGN_CHAR = '+';
    private static final String PLUS_SIGN_STRING = "+";
    private static final String NANP_IDP_STRING = "011";
    private static final int NANP_LENGTH = 10;
    private static final boolean[] COUNTRY_CALLING_CALL;
    private static final int CCC_LENGTH;

    public static boolean isISODigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean is12Key(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#';
    }

    public static final boolean isDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N';
    }

    public static final boolean isReallyDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+';
    }

    public static final boolean isNonSeparator(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N' || c == ';' || c == ',';
    }

    public static final boolean isStartsPostDial(char c) {
        return c == ',' || c == ';';
    }

    private static boolean isPause(char c) {
        return c == 'p' || c == 'P';
    }

    private static boolean isToneWait(char c) {
        return c == 'w' || c == 'W';
    }

    private static boolean isSeparator(char ch) {
        return !(PhoneNumberUtils.isDialable(ch) || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberFromIntent(Intent intent, Context context) {
        String number = null;
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme.equals("tel") || scheme.equals("sip")) {
            return uri.getSchemeSpecificPart();
        }
        if (context == null) {
            return null;
        }
        String type = intent.resolveType(context);
        String phoneColumn = null;
        String authority = uri.getAuthority();
        if ("contacts".equals(authority)) {
            phoneColumn = "number";
        } else if ("com.android.contacts".equals(authority)) {
            phoneColumn = "data1";
        }
        Cursor c = context.getContentResolver().query(uri, new String[]{phoneColumn}, null, null, null);
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    number = c.getString(c.getColumnIndex(phoneColumn));
                }
            }
            finally {
                c.close();
            }
        }
        return number;
    }

    public static String extractNetworkPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (c == '+') {
                String prefix = ret.toString();
                if (prefix.length() != 0 && !prefix.equals(CLIR_ON) && !prefix.equals(CLIR_OFF)) continue;
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    public static String extractNetworkPortionAlt(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        boolean haveSeenPlus = false;
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (c == '+') {
                if (haveSeenPlus) continue;
                haveSeenPlus = true;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    public static String stripSeparators(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String convertAndStrip(String phoneNumber) {
        return PhoneNumberUtils.stripSeparators(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
    }

    public static String convertPreDial(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (PhoneNumberUtils.isPause(c)) {
                c = ',';
            } else if (PhoneNumberUtils.isToneWait(c)) {
                c = ';';
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static int minPositive(int a, int b) {
        if (a >= 0 && b >= 0) {
            return a < b ? a : b;
        }
        if (a >= 0) {
            return a;
        }
        if (b >= 0) {
            return b;
        }
        return -1;
    }

    private static void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static int indexOfLastNetworkChar(String a) {
        int wIndex;
        int origLength = a.length();
        int pIndex = a.indexOf(44);
        int trimIndex = PhoneNumberUtils.minPositive(pIndex, wIndex = a.indexOf(59));
        if (trimIndex < 0) {
            return origLength - 1;
        }
        return trimIndex - 1;
    }

    public static String extractPostDialPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int trimIndex = PhoneNumberUtils.indexOfLastNetworkChar(phoneNumber);
        int s = phoneNumber.length();
        for (int i = trimIndex + 1; i < s; ++i) {
            char c = phoneNumber.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static boolean compare(String a, String b) {
        return PhoneNumberUtils.compare(a, b, false);
    }

    public static boolean compare(Context context, String a, String b) {
        boolean useStrict = context.getResources().getBoolean(17956909);
        return PhoneNumberUtils.compare(a, b, useStrict);
    }

    public static boolean compare(String a, String b, boolean useStrictComparation) {
        return useStrictComparation ? PhoneNumberUtils.compareStrictly(a, b) : PhoneNumberUtils.compareLoosely(a, b);
    }

    public static boolean compareLoosely(String a, String b) {
        int numNonDialableCharsInA = 0;
        int numNonDialableCharsInB = 0;
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 || b.length() == 0) {
            return false;
        }
        int ia = PhoneNumberUtils.indexOfLastNetworkChar(a);
        int ib = PhoneNumberUtils.indexOfLastNetworkChar(b);
        int matched = 0;
        while (ia >= 0 && ib >= 0) {
            char cb;
            boolean skipCmp = false;
            char ca = a.charAt(ia);
            if (!PhoneNumberUtils.isDialable(ca)) {
                --ia;
                skipCmp = true;
                ++numNonDialableCharsInA;
            }
            if (!PhoneNumberUtils.isDialable(cb = b.charAt(ib))) {
                --ib;
                skipCmp = true;
                ++numNonDialableCharsInB;
            }
            if (skipCmp) continue;
            if (cb != ca && ca != 'N' && cb != 'N') break;
            --ia;
            --ib;
            ++matched;
        }
        if (matched < 7) {
            int effectiveBLen;
            int effectiveALen = a.length() - numNonDialableCharsInA;
            return effectiveALen == (effectiveBLen = b.length() - numNonDialableCharsInB) && effectiveALen == matched;
        }
        if (matched >= 7 && (ia < 0 || ib < 0)) {
            return true;
        }
        if (PhoneNumberUtils.matchIntlPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefix(b, ib + 1)) {
            return true;
        }
        if (PhoneNumberUtils.matchTrunkPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(b, ib + 1)) {
            return true;
        }
        return PhoneNumberUtils.matchTrunkPrefix(b, ib + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(a, ia + 1);
    }

    public static boolean compareStrictly(String a, String b) {
        return PhoneNumberUtils.compareStrictly(a, b, true);
    }

    public static boolean compareStrictly(String a, String b, boolean acceptInvalidCCCPrefix) {
        char chA;
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 && b.length() == 0) {
            return false;
        }
        int forwardIndexA = 0;
        int forwardIndexB = 0;
        CountryCallingCodeAndNewIndex cccA = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(a, acceptInvalidCCCPrefix);
        CountryCallingCodeAndNewIndex cccB = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(b, acceptInvalidCCCPrefix);
        boolean bothHasCountryCallingCode = false;
        boolean okToIgnorePrefix = true;
        boolean trunkPrefixIsOmittedA = false;
        boolean trunkPrefixIsOmittedB = false;
        if (cccA != null && cccB != null) {
            if (cccA.countryCallingCode != cccB.countryCallingCode) {
                return false;
            }
            okToIgnorePrefix = false;
            bothHasCountryCallingCode = true;
            forwardIndexA = cccA.newIndex;
            forwardIndexB = cccB.newIndex;
        } else if (cccA == null && cccB == null) {
            okToIgnorePrefix = false;
        } else {
            int tmp;
            if (cccA != null) {
                forwardIndexA = cccA.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexA = tmp;
                    trunkPrefixIsOmittedA = true;
                }
            }
            if (cccB != null) {
                forwardIndexB = cccB.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexB = tmp;
                    trunkPrefixIsOmittedB = true;
                }
            }
        }
        int backwardIndexA = a.length() - 1;
        int backwardIndexB = b.length() - 1;
        while (backwardIndexA >= forwardIndexA && backwardIndexB >= forwardIndexB) {
            boolean skip_compare = false;
            chA = a.charAt(backwardIndexA);
            char chB = b.charAt(backwardIndexB);
            if (PhoneNumberUtils.isSeparator(chA)) {
                --backwardIndexA;
                skip_compare = true;
            }
            if (PhoneNumberUtils.isSeparator(chB)) {
                --backwardIndexB;
                skip_compare = true;
            }
            if (skip_compare) continue;
            if (chA != chB) {
                return false;
            }
            --backwardIndexA;
            --backwardIndexB;
        }
        if (okToIgnorePrefix) {
            if (trunkPrefixIsOmittedA && forwardIndexA <= backwardIndexA || !PhoneNumberUtils.checkPrefixIsIgnorable(a, forwardIndexA, backwardIndexA)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
            if (trunkPrefixIsOmittedB && forwardIndexB <= backwardIndexB || !PhoneNumberUtils.checkPrefixIsIgnorable(b, forwardIndexA, backwardIndexB)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
        } else {
            boolean maybeNamp;
            boolean bl = maybeNamp = !bothHasCountryCallingCode;
            while (backwardIndexA >= forwardIndexA) {
                chA = a.charAt(backwardIndexA);
                if (PhoneNumberUtils.isDialable(chA)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chA) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexA;
            }
            while (backwardIndexB >= forwardIndexB) {
                char chB = b.charAt(backwardIndexB);
                if (PhoneNumberUtils.isDialable(chB)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chB) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexB;
            }
        }
        return true;
    }

    public static String toCallerIDMinMatch(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        return PhoneNumberUtils.internalGetStrippedReversed(np, 7);
    }

    public static String getStrippedReversed(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        if (np == null) {
            return null;
        }
        return PhoneNumberUtils.internalGetStrippedReversed(np, np.length());
    }

    private static String internalGetStrippedReversed(String np, int numDigits) {
        if (np == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(numDigits);
        int length = np.length();
        int s = length;
        for (int i = length - 1; i >= 0 && s - i <= numDigits; --i) {
            char c = np.charAt(i);
            ret.append(c);
        }
        return ret.toString();
    }

    public static String stringFromStringAndTOA(String s, int TOA) {
        if (s == null) {
            return null;
        }
        if (TOA == 145 && s.length() > 0 && s.charAt(0) != '+') {
            return PLUS_SIGN_STRING + s;
        }
        return s;
    }

    public static int toaFromString(String s) {
        if (s != null && s.length() > 0 && s.charAt(0) == '+') {
            return 145;
        }
        return 129;
    }

    public static String calledPartyBCDToString(byte[] bytes, int offset, int length) {
        boolean prependPlus = false;
        StringBuilder ret = new StringBuilder(1 + length * 2);
        if (length < 2) {
            return "";
        }
        if ((bytes[offset] & 0xF0) == 144) {
            prependPlus = true;
        }
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset + 1, length - 1);
        if (prependPlus && ret.length() == 0) {
            return "";
        }
        if (prependPlus) {
            String retString = ret.toString();
            Pattern p = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$");
            Matcher m = p.matcher(retString);
            if (m.matches()) {
                if ("".equals(m.group(2))) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(3));
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                    ret.append(PLUS_SIGN_STRING);
                } else {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append(PLUS_SIGN_STRING);
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                }
            } else {
                p = Pattern.compile("(^[#*])(.*)([#*])(.*)");
                m = p.matcher(retString);
                if (m.matches()) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append(PLUS_SIGN_STRING);
                    ret.append(m.group(4));
                } else {
                    ret = new StringBuilder();
                    ret.append('+');
                    ret.append(retString);
                }
            }
        }
        return ret.toString();
    }

    private static void internalCalledPartyBCDFragmentToString(StringBuilder sb, byte[] bytes, int offset, int length) {
        for (int i = offset; i < length + offset; ++i) {
            char c = PhoneNumberUtils.bcdToChar((byte)(bytes[i] & 0xF));
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
            byte b = (byte)(bytes[i] >> 4 & 0xF);
            if (b == 15 && i + 1 == length + offset) break;
            c = PhoneNumberUtils.bcdToChar(b);
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
        }
    }

    public static String calledPartyBCDFragmentToString(byte[] bytes, int offset, int length) {
        StringBuilder ret = new StringBuilder(length * 2);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset, length);
        return ret.toString();
    }

    private static char bcdToChar(byte b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        switch (b) {
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return ',';
            }
            case 13: {
                return 'N';
            }
        }
        return '\u0000';
    }

    private static int charToBCD(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '*') {
            return 10;
        }
        if (c == '#') {
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == 'N') {
            return 13;
        }
        throw new RuntimeException("invalid char for BCD " + c);
    }

    public static boolean isWellFormedSmsAddress(String address) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(address);
        return !networkPortion.equals(PLUS_SIGN_STRING) && !TextUtils.isEmpty(networkPortion) && PhoneNumberUtils.isDialable(networkPortion);
    }

    public static boolean isGlobalPhoneNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        Matcher match = GLOBAL_PHONE_NUMBER_PATTERN.matcher(phoneNumber);
        return match.matches();
    }

    private static boolean isDialable(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isDialable(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonSeparator(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isNonSeparator(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] networkPortionToCalledPartyBCD(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, false);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, true);
    }

    public static byte[] numberToCalledPartyBCD(String number) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(number, false);
    }

    private static byte[] numberToCalledPartyBCDHelper(String number, boolean includeLength) {
        boolean hasPlus;
        int numberLenReal;
        int numberLenEffective = numberLenReal = number.length();
        boolean bl = hasPlus = number.indexOf(43) != -1;
        if (hasPlus) {
            --numberLenEffective;
        }
        if (numberLenEffective == 0) {
            return null;
        }
        int resultLen = (numberLenEffective + 1) / 2;
        int extraBytes = 1;
        if (includeLength) {
            ++extraBytes;
        }
        byte[] result = new byte[resultLen += extraBytes];
        int digitCount = 0;
        for (int i = 0; i < numberLenReal; ++i) {
            char c = number.charAt(i);
            if (c == '+') continue;
            int shift = digitCount & true ? 4 : 0;
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | (byte)((PhoneNumberUtils.charToBCD(c) & 0xF) << shift));
            ++digitCount;
        }
        if (digitCount & true) {
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | 0xF0);
        }
        int offset = 0;
        if (includeLength) {
            result[offset++] = (byte)(resultLen - 1);
        }
        result[offset] = (byte)(hasPlus ? 145 : 129);
        return result;
    }

    public static String formatNumber(String source) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault()));
        return text.toString();
    }

    public static String formatNumber(String source, int defaultFormattingType) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, defaultFormattingType);
        return text.toString();
    }

    public static int getFormatTypeForLocale(Locale locale) {
        String country = locale.getCountry();
        return PhoneNumberUtils.getFormatTypeFromCountryCode(country);
    }

    public static void formatNumber(Editable text, int defaultFormattingType) {
        int formatType = defaultFormattingType;
        if (text.length() > 2 && text.charAt(0) == '+') {
            formatType = text.charAt(1) == '1' ? 1 : (text.length() >= 3 && text.charAt(1) == '8' && text.charAt(2) == '1' ? 2 : 0);
        }
        switch (formatType) {
            case 1: {
                PhoneNumberUtils.formatNanpNumber(text);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(text);
                return;
            }
            case 0: {
                PhoneNumberUtils.removeDashes(text);
                return;
            }
        }
    }

    public static void formatNanpNumber(Editable text) {
        int i;
        int length = text.length();
        if (length > "+1-nnn-nnn-nnnn".length()) {
            return;
        }
        if (length <= 5) {
            return;
        }
        CharSequence saved = text.subSequence(0, length);
        PhoneNumberUtils.removeDashes(text);
        length = text.length();
        int[] dashPositions = new int[3];
        int numDashes = 0;
        int state = 1;
        int numDigits = 0;
        block6: for (i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '1': {
                    if (numDigits == 0 || state == 2) {
                        state = 3;
                        continue block6;
                    }
                }
                case '0': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 2) {
                        text.replace(0, length, saved);
                        return;
                    }
                    if (state == 3) {
                        dashPositions[numDashes++] = i;
                    } else if (state != 4 && (numDigits == 3 || numDigits == 6)) {
                        dashPositions[numDashes++] = i;
                    }
                    state = 1;
                    ++numDigits;
                    continue block6;
                }
                case '-': {
                    state = 4;
                    continue block6;
                }
                case '+': {
                    if (i == 0) {
                        state = 2;
                        continue block6;
                    }
                }
                default: {
                    text.replace(0, length, saved);
                    return;
                }
            }
        }
        if (numDigits == 7) {
            --numDashes;
        }
        for (i = 0; i < numDashes; ++i) {
            int pos = dashPositions[i];
            text.replace(pos + i, pos + i, "-");
        }
        for (int len = text.length(); len > 0 && text.charAt(len - 1) == '-'; --len) {
            text.delete(len - 1, len);
        }
    }

    public static void formatJapaneseNumber(Editable text) {
        JapanesePhoneNumberFormatter.format(text);
    }

    private static void removeDashes(Editable text) {
        int p = 0;
        while (p < text.length()) {
            if (text.charAt(p) == '-') {
                text.delete(p, p + 1);
                continue;
            }
            ++p;
        }
    }

    public static String formatNumberToE164(String phoneNumber, String defaultCountryIso) {
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        String result = null;
        try {
            Phonenumber.PhoneNumber pn = util.parse(phoneNumber, defaultCountryIso);
            if (util.isValidNumber(pn)) {
                result = util.format(pn, PhoneNumberUtil.PhoneNumberFormat.E164);
            }
        }
        catch (NumberParseException e) {
            // empty catch block
        }
        return result;
    }

    public static String formatNumber(String phoneNumber, String defaultCountryIso) {
        if (phoneNumber.startsWith("#") || phoneNumber.startsWith("*")) {
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        String result = null;
        try {
            Phonenumber.PhoneNumber pn = util.parseAndKeepRawInput(phoneNumber, defaultCountryIso);
            result = util.formatInOriginalFormat(pn, defaultCountryIso);
        }
        catch (NumberParseException e) {
            // empty catch block
        }
        return result;
    }

    public static String formatNumber(String phoneNumber, String phoneNumberE164, String defaultCountryIso) {
        String result;
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            if (PhoneNumberUtils.isDialable(phoneNumber.charAt(i))) continue;
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        if (phoneNumberE164 != null && phoneNumberE164.length() >= 2 && phoneNumberE164.charAt(0) == '+') {
            try {
                Phonenumber.PhoneNumber pn = util.parse(phoneNumberE164, "ZZ");
                String regionCode = util.getRegionCodeForNumber(pn);
                if (!TextUtils.isEmpty(regionCode) && PhoneNumberUtils.normalizeNumber(phoneNumber).indexOf(phoneNumberE164.substring(1)) <= 0) {
                    defaultCountryIso = regionCode;
                }
            }
            catch (NumberParseException e) {
                // empty catch block
            }
        }
        return (result = PhoneNumberUtils.formatNumber(phoneNumber, defaultCountryIso)) != null ? result : phoneNumber;
    }

    public static String normalizeNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                sb.append(digit);
                continue;
            }
            if (i == 0 && c == '+') {
                sb.append(c);
                continue;
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
            return PhoneNumberUtils.normalizeNumber(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
        }
        return sb.toString();
    }

    public static String replaceUnicodeDigits(String number) {
        StringBuilder normalizedDigits = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                normalizedDigits.append(digit);
                continue;
            }
            normalizedDigits.append(c);
        }
        return normalizedDigits.toString();
    }

    public static boolean isEmergencyNumber(String number) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    public static boolean isEmergencyNumber(long subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, true);
    }

    public static boolean isPotentialEmergencyNumber(String number) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    public static boolean isPotentialEmergencyNumber(long subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, false);
    }

    private static boolean isEmergencyNumberInternal(String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, useExactMatch);
    }

    private static boolean isEmergencyNumberInternal(long subId, String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, null, useExactMatch);
    }

    public static boolean isEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    public static boolean isEmergencyNumber(long subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, true);
    }

    public static boolean isPotentialEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    public static boolean isPotentialEmergencyNumber(long subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, false);
    }

    private static boolean isEmergencyNumberInternal(String number, String defaultCountryIso, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso, useExactMatch);
    }

    private static boolean isEmergencyNumberInternal(long subId, String number, String defaultCountryIso, boolean useExactMatch) {
        if (number == null) {
            return false;
        }
        if (PhoneNumberUtils.isUriNumber(number)) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        String numbers = "";
        int slotId = SubscriptionManager.getSlotId(subId);
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        numbers = SystemProperties.get(ecclist);
        if (TextUtils.isEmpty(numbers)) {
            numbers = SystemProperties.get("ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty(numbers)) {
            for (String emergencyNum : numbers.split(",")) {
                if (!(useExactMatch || "BR".equalsIgnoreCase(defaultCountryIso) ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
                return true;
            }
            return false;
        }
        Rlog.d(LOG_TAG, "System property doesn't provide any emergency numbers. Use embedded logic for determining ones.");
        if (defaultCountryIso != null) {
            ShortNumberUtil util = new ShortNumberUtil();
            if (useExactMatch) {
                return util.isEmergencyNumber(number, defaultCountryIso);
            }
            return util.connectsToEmergencyNumber(number, defaultCountryIso);
        }
        if (useExactMatch) {
            return number.equals("112") || number.equals("911");
        }
        return number.startsWith("112") || number.startsWith("911");
    }

    public static boolean isLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    public static boolean isLocalEmergencyNumber(Context context, long subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, true);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isPotentialLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, long subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, false);
    }

    private static boolean isLocalEmergencyNumberInternal(String number, Context context, boolean useExactMatch) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, context, useExactMatch);
    }

    private static boolean isLocalEmergencyNumberInternal(long subId, String number, Context context, boolean useExactMatch) {
        String countryIso;
        CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
        if (detector != null && detector.detectCountry() != null) {
            countryIso = detector.detectCountry().getCountryIso();
        } else {
            Locale locale = context.getResources().getConfiguration().locale;
            countryIso = locale.getCountry();
            Rlog.w(LOG_TAG, "No CountryDetector; falling back to countryIso based on locale: " + countryIso);
        }
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, countryIso, useExactMatch);
    }

    public static boolean isVoiceMailNumber(String number) {
        return PhoneNumberUtils.isVoiceMailNumber(SubscriptionManager.getDefaultSubId(), number);
    }

    public static boolean isVoiceMailNumber(long subId, String number) {
        String vmNumber;
        try {
            vmNumber = TelephonyManager.getDefault().getVoiceMailNumber(subId);
        }
        catch (SecurityException ex) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        return !TextUtils.isEmpty(number) && PhoneNumberUtils.compare(number, vmNumber);
    }

    public static String convertKeypadLettersToDigits(String input) {
        if (input == null) {
            return input;
        }
        int len = input.length();
        if (len == 0) {
            return input;
        }
        char[] out = input.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = out[i];
            out[i] = (char)KEYPAD_MAP.get(c, c);
        }
        return new String(out);
    }

    public static String cdmaCheckAndProcessPlusCode(String dialStr) {
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr)) {
            String currIso = SystemProperties.get("gsm.operator.iso-country", "");
            String defaultIso = SystemProperties.get("gsm.sim.operator.iso-country", "");
            if (!TextUtils.isEmpty(currIso) && !TextUtils.isEmpty(defaultIso)) {
                return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, PhoneNumberUtils.getFormatTypeFromCountryCode(currIso), PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso));
            }
        }
        return dialStr;
    }

    public static String cdmaCheckAndProcessPlusCodeForSms(String dialStr) {
        String defaultIso;
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr) && !TextUtils.isEmpty(defaultIso = SystemProperties.get("gsm.sim.operator.iso-country", ""))) {
            int format = PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso);
            return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, format, format);
        }
        return dialStr;
    }

    public static String cdmaCheckAndProcessPlusCodeByNumberFormat(String dialStr, int currFormat, int defaultFormat) {
        boolean useNanp;
        String retStr = dialStr;
        boolean bl = useNanp = currFormat == defaultFormat && currFormat == 1;
        if (dialStr != null && dialStr.lastIndexOf(PLUS_SIGN_STRING) != -1) {
            String postDialStr = null;
            String tempDialStr = dialStr;
            retStr = null;
            do {
                String networkDialStr = useNanp ? PhoneNumberUtils.extractNetworkPortion(tempDialStr) : PhoneNumberUtils.extractNetworkPortionAlt(tempDialStr);
                if (!TextUtils.isEmpty(networkDialStr = PhoneNumberUtils.processPlusCode(networkDialStr, useNanp))) {
                    retStr = retStr == null ? networkDialStr : retStr.concat(networkDialStr);
                } else {
                    Rlog.e("checkAndProcessPlusCode: null newDialStr", networkDialStr);
                    return dialStr;
                }
                postDialStr = PhoneNumberUtils.extractPostDialPortion(tempDialStr);
                if (TextUtils.isEmpty(postDialStr)) continue;
                int dialableIndex = PhoneNumberUtils.findDialableIndexFromPostDialStr(postDialStr);
                if (dialableIndex >= 1) {
                    retStr = PhoneNumberUtils.appendPwCharBackToOrigDialStr(dialableIndex, retStr, postDialStr);
                    tempDialStr = postDialStr.substring(dialableIndex);
                    continue;
                }
                if (dialableIndex < 0) {
                    postDialStr = "";
                }
                Rlog.e("wrong postDialStr=", postDialStr);
            } while (!TextUtils.isEmpty(postDialStr) && !TextUtils.isEmpty(tempDialStr));
        }
        return retStr;
    }

    private static String getCurrentIdp(boolean useNanp) {
        String ps = SystemProperties.get("gsm.operator.idpstring", useNanp ? NANP_IDP_STRING : PLUS_SIGN_STRING);
        return ps;
    }

    private static boolean isTwoToNine(char c) {
        return c >= '2' && c <= '9';
    }

    private static int getFormatTypeFromCountryCode(String country) {
        int length = NANP_COUNTRIES.length;
        for (int i = 0; i < length; ++i) {
            if (NANP_COUNTRIES[i].compareToIgnoreCase(country) != 0) continue;
            return 1;
        }
        if ("jp".compareToIgnoreCase(country) == 0) {
            return 2;
        }
        return 0;
    }

    public static boolean isNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            if (dialStr.length() == 10 && PhoneNumberUtils.isTwoToNine(dialStr.charAt(0)) && PhoneNumberUtils.isTwoToNine(dialStr.charAt(3))) {
                retVal = true;
                for (int i = 1; i < 10; ++i) {
                    char c = dialStr.charAt(i);
                    if (PhoneNumberUtils.isISODigit(c)) continue;
                    retVal = false;
                    break;
                }
            }
        } else {
            Rlog.e("isNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    private static boolean isOneNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            String newDialStr = dialStr.substring(1);
            if (dialStr.charAt(0) == '1' && PhoneNumberUtils.isNanp(newDialStr)) {
                retVal = true;
            }
        } else {
            Rlog.e("isOneNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    public static boolean isUriNumber(String number) {
        return number != null && (number.contains("@") || number.contains("%40"));
    }

    public static String getUsernameFromUriNumber(String number) {
        int delimiterIndex = number.indexOf(64);
        if (delimiterIndex < 0) {
            delimiterIndex = number.indexOf("%40");
        }
        if (delimiterIndex < 0) {
            Rlog.w(LOG_TAG, "getUsernameFromUriNumber: no delimiter found in SIP addr '" + number + "'");
            delimiterIndex = number.length();
        }
        return number.substring(0, delimiterIndex);
    }

    private static String processPlusCode(String networkDialStr, boolean useNanp) {
        String retStr = networkDialStr;
        if (networkDialStr != null && networkDialStr.charAt(0) == '+' && networkDialStr.length() > 1) {
            String newStr = networkDialStr.substring(1);
            retStr = useNanp && PhoneNumberUtils.isOneNanp(newStr) ? newStr : networkDialStr.replaceFirst("[+]", PhoneNumberUtils.getCurrentIdp(useNanp));
        }
        return retStr;
    }

    private static int findDialableIndexFromPostDialStr(String postDialStr) {
        for (int index = 0; index < postDialStr.length(); ++index) {
            char c = postDialStr.charAt(index);
            if (!PhoneNumberUtils.isReallyDialable(c)) continue;
            return index;
        }
        return -1;
    }

    private static String appendPwCharBackToOrigDialStr(int dialableIndex, String origStr, String dialStr) {
        String retStr;
        if (dialableIndex == 1) {
            StringBuilder ret = new StringBuilder(origStr);
            ret = ret.append(dialStr.charAt(0));
            retStr = ret.toString();
        } else {
            String nonDigitStr = dialStr.substring(0, dialableIndex);
            retStr = origStr.concat(nonDigitStr);
        }
        return retStr;
    }

    private static boolean matchIntlPrefix(String a, int len) {
        int state = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        return state == 1 || state == 3 || state == 5;
    }

    private static boolean matchIntlPrefixAndCC(String a, int len) {
        int state = 0;
        block7: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        state = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++state;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        return state == 6 || state == 7 || state == 8;
    }

    private static boolean matchTrunkPrefix(String a, int len) {
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            if (c == '0' && !found) {
                found = true;
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            return false;
        }
        return found;
    }

    private static boolean isCountryCallingCode(int countryCallingCodeCandidate) {
        return countryCallingCodeCandidate > 0 && countryCallingCodeCandidate < CCC_LENGTH && COUNTRY_CALLING_CALL[countryCallingCodeCandidate];
    }

    private static int tryGetISODigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        return -1;
    }

    private static CountryCallingCodeAndNewIndex tryGetCountryCallingCodeAndNewIndex(String str, boolean acceptThailandCase) {
        int state = 0;
        int ccc = 0;
        int length = str.length();
        block8: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '+') {
                        state = 1;
                        continue block8;
                    }
                    if (ch == '0') {
                        state = 2;
                        continue block8;
                    }
                    if (ch == '1') {
                        if (acceptThailandCase) {
                            state = 8;
                            continue block8;
                        }
                        return null;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 2: {
                    if (ch == '0') {
                        state = 3;
                        continue block8;
                    }
                    if (ch == '1') {
                        state = 4;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 4: {
                    if (ch == '1') {
                        state = 5;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    int ret = PhoneNumberUtils.tryGetISODigit(ch);
                    if (ret > 0) {
                        if ((ccc = ccc * 10 + ret) >= 100 || PhoneNumberUtils.isCountryCallingCode(ccc)) {
                            return new CountryCallingCodeAndNewIndex(ccc, i + 1);
                        }
                        if (state == 1 || state == 3 || state == 5) {
                            state = 6;
                            continue block8;
                        }
                        ++state;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 8: {
                    if (ch == '6') {
                        state = 9;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 9: {
                    if (ch == '6') {
                        return new CountryCallingCodeAndNewIndex(66, i + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static int tryGetTrunkPrefixOmittedIndex(String str, int currentIndex) {
        int length = str.length();
        for (int i = currentIndex; i < length; ++i) {
            char ch = str.charAt(i);
            if (PhoneNumberUtils.tryGetISODigit(ch) >= 0) {
                return i + 1;
            }
            if (!PhoneNumberUtils.isDialable(ch)) continue;
            return -1;
        }
        return -1;
    }

    private static boolean checkPrefixIsIgnorable(String str, int forwardIndex, int backwardIndex) {
        boolean trunk_prefix_was_read = false;
        while (backwardIndex >= forwardIndex) {
            if (PhoneNumberUtils.tryGetISODigit(str.charAt(backwardIndex)) >= 0) {
                if (trunk_prefix_was_read) {
                    return false;
                }
                trunk_prefix_was_read = true;
            } else if (PhoneNumberUtils.isDialable(str.charAt(backwardIndex))) {
                return false;
            }
            --backwardIndex;
        }
        return true;
    }

    private static long getDefaultVoiceSubId() {
        return SubscriptionManager.getDefaultVoiceSubId();
    }

    static {
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
        COUNTRY_CALLING_CALL = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, true, false, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, false};
        CCC_LENGTH = COUNTRY_CALLING_CALL.length;
    }

    private static class CountryCallingCodeAndNewIndex {
        public final int countryCallingCode;
        public final int newIndex;

        public CountryCallingCodeAndNewIndex(int countryCode, int newIndex) {
            this.countryCallingCode = countryCode;
            this.newIndex = newIndex;
        }
    }
}

