/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionService;
import com.android.internal.telecom.IConnectionService;
import java.util.HashMap;
import java.util.Map;

public class RemoteConnectionManager {
    private final Map<ComponentName, RemoteConnectionService> mRemoteConnectionServices = new HashMap<ComponentName, RemoteConnectionService>();
    private final ConnectionService mOurConnectionServiceImpl;

    public RemoteConnectionManager(ConnectionService ourConnectionServiceImpl) {
        this.mOurConnectionServiceImpl = ourConnectionServiceImpl;
    }

    void addConnectionService(ComponentName componentName, IConnectionService outgoingConnectionServiceRpc) {
        if (!this.mRemoteConnectionServices.containsKey(componentName)) {
            try {
                RemoteConnectionService remoteConnectionService = new RemoteConnectionService(outgoingConnectionServiceRpc, this.mOurConnectionServiceImpl);
                this.mRemoteConnectionServices.put(componentName, remoteConnectionService);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public RemoteConnection createRemoteConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request, boolean isIncoming) {
        PhoneAccountHandle accountHandle = request.getAccountHandle();
        if (accountHandle == null) {
            throw new IllegalArgumentException("accountHandle must be specified.");
        }
        ComponentName componentName = request.getAccountHandle().getComponentName();
        if (!this.mRemoteConnectionServices.containsKey(componentName)) {
            throw new UnsupportedOperationException("accountHandle not supported: " + componentName);
        }
        RemoteConnectionService remoteService = this.mRemoteConnectionServices.get(componentName);
        if (remoteService != null) {
            return remoteService.createRemoteConnection(connectionManagerPhoneAccount, request, isIncoming);
        }
        return null;
    }

    public void conferenceRemoteConnections(RemoteConnection a, RemoteConnection b) {
        if (a.getConnectionService() == b.getConnectionService()) {
            try {
                a.getConnectionService().conference(a.getId(), b.getId());
            }
            catch (RemoteException remoteException) {}
        } else {
            Log.w(this, "Request to conference incompatible remote connections (%s,%s) (%s,%s)", a.getConnectionService(), a.getId(), b.getConnectionService(), b.getId());
        }
    }
}

