/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Connection;
import android.telecom.PhoneAccountHandle;
import android.telecom.PhoneCapabilities;
import java.util.ArrayList;
import java.util.List;

public final class ParcelableConference
implements Parcelable {
    private PhoneAccountHandle mPhoneAccount;
    private int mState;
    private int mCapabilities;
    private List<String> mConnectionIds;
    public static final Parcelable.Creator<ParcelableConference> CREATOR = new Parcelable.Creator<ParcelableConference>(){

        @Override
        public ParcelableConference createFromParcel(Parcel source) {
            ClassLoader classLoader = ParcelableConference.class.getClassLoader();
            PhoneAccountHandle phoneAccount = (PhoneAccountHandle)source.readParcelable(classLoader);
            int state = source.readInt();
            int capabilities = source.readInt();
            ArrayList<String> connectionIds = new ArrayList<String>(2);
            source.readList(connectionIds, classLoader);
            return new ParcelableConference(phoneAccount, state, capabilities, connectionIds);
        }

        public ParcelableConference[] newArray(int size) {
            return new ParcelableConference[size];
        }
    };

    public ParcelableConference(PhoneAccountHandle phoneAccount, int state, int capabilities, List<String> connectionIds) {
        this.mPhoneAccount = phoneAccount;
        this.mState = state;
        this.mCapabilities = capabilities;
        this.mConnectionIds = connectionIds;
    }

    public String toString() {
        return new StringBuffer().append("account: ").append(this.mPhoneAccount).append(", state: ").append(Connection.stateToString(this.mState)).append(", capabilities: ").append(PhoneCapabilities.toString(this.mCapabilities)).append(", children: ").append(this.mConnectionIds).toString();
    }

    public PhoneAccountHandle getPhoneAccount() {
        return this.mPhoneAccount;
    }

    public int getState() {
        return this.mState;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public List<String> getConnectionIds() {
        return this.mConnectionIds;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeParcelable(this.mPhoneAccount, 0);
        destination.writeInt(this.mState);
        destination.writeInt(this.mCapabilities);
        destination.writeList(this.mConnectionIds);
    }
}

